//=============================================================================
// main.js v1.7.0
//=============================================================================

const scriptUrls = [
    "js/libs/pixi.js",
    "js/libs/pako.min.js",
    "js/libs/localforage.min.js",
    "js/libs/effekseer.min.js",
    "js/libs/vorbisdecoder.js",
    "js/rmmz_core.js",
    "js/rmmz_managers.js",
    "js/rmmz_objects.js",
    // "js/rmmz_scenes.js",
    "js/rmmz_scenes_base.js",
    "js/rmmz_scenes_boot.js",
    "js/rmmz_scenes_title.js",
    "js/rmmz_scenes_message.js",
    "js/rmmz_scenes_map.js",
    "js/rmmz_scenes_menubase.js",
    "js/rmmz_scenes_menu.js",
    "js/rmmz_scenes_formation.js",
    "js/rmmz_scenes_itembase.js",
    "js/rmmz_scenes_item.js",
    "js/rmmz_scenes_skill.js",
    "js/rmmz_scenes_equip.js",
    "js/rmmz_scenes_status.js",
    "js/rmmz_scenes_state.js",
    "js/rmmz_scenes_options.js",
    "js/rmmz_scenes_file.js",
    "js/rmmz_scenes_save.js",
    "js/rmmz_scenes_load.js",
    "js/rmmz_scenes_gameend.js",
    "js/rmmz_scenes_shop.js",
    "js/rmmz_scenes_name.js",
    "js/rmmz_scenes_debug.js",
    "js/rmmz_scenes_battle.js",
    "js/rmmz_scenes_gameover.js",
    "js/rmmz_scenes_messagelog.js",
    "js/rmmz_sprites.js",
    //"js/rmmz_windows.js",
    "js/rmmz_windows_base.js",
    "js/rmmz_windows_scrollable.js",
    "js/rmmz_windows_selectable.js",
    "js/rmmz_windows_command.js",
    "js/rmmz_windows_horzcommand.js",
    "js/rmmz_windows_help.js",
    "js/rmmz_windows_gold.js",
    "js/rmmz_windows_statusbase.js",
    "js/rmmz_windows_menucommand.js",
    "js/rmmz_windows_menustatus.js",
    "js/rmmz_windows_actorlist.js",
    "js/rmmz_windows_menuactor.js",
    "js/rmmz_windows_itemcategory.js",
    "js/rmmz_windows_itemlist.js",
    "js/rmmz_windows_skilltype.js",
    "js/rmmz_windows_skillstatus.js",
    "js/rmmz_windows_skilllist.js",
    "js/rmmz_windows_statelist.js",
    "js/rmmz_windows_equipstatus.js",
    "js/rmmz_windows_equipcommand.js",
    "js/rmmz_windows_equipslot.js",
    "js/rmmz_windows_equipitem.js",
    "js/rmmz_windows_status.js",
    "js/rmmz_windows_statusparams.js",
    "js/rmmz_windows_statusequip.js",
    "js/rmmz_windows_options.js",
    "js/rmmz_windows_messagelog.js",
    "js/rmmz_windows_savefilelist.js",
    "js/rmmz_windows_shopcommand.js",
    "js/rmmz_windows_shopbuy.js",
    "js/rmmz_windows_shopsell.js",
    "js/rmmz_windows_shopnumber.js",
    "js/rmmz_windows_shopstatus.js",
    "js/rmmz_windows_nameedit.js",
    "js/rmmz_windows_nameinput.js",
    "js/rmmz_windows_namebox.js",
    "js/rmmz_windows_choicelist.js",
    "js/rmmz_windows_numberinput.js",
    "js/rmmz_windows_eventitem.js",
    "js/rmmz_windows_message.js",
    "js/rmmz_windows_scrolltext.js",
    "js/rmmz_windows_mapname.js",
    "js/rmmz_windows_battlelog.js",
    "js/rmmz_windows_partycommand.js",
    "js/rmmz_windows_actorcommand.js",
    "js/rmmz_windows_battlestatus.js",
    "js/rmmz_windows_battleactor.js",
    "js/rmmz_windows_battleenemy.js",
    "js/rmmz_windows_battleskill.js",
    "js/rmmz_windows_battleitem.js",
    "js/rmmz_windows_titlecommand.js",
    "js/rmmz_windows_gameend.js",
    "js/rmmz_windows_debugrange.js",
    "js/rmmz_windows_debugedit.js",
    "js/plugins.js"
];
const effekseerWasmUrl = "js/libs/effekseer.wasm";

PauseBgm = function()
{
    if(!$gameTemp)
    {
        return;
    }
    $gameTemp._isPause = true;

    bgmv = AudioManager._bgmVolume;
    bgsv = AudioManager._bgsVolume;
    mev = AudioManager._meVolume;
    sev = AudioManager._seVolume;

    AudioManager.bgmVolume = 0;
    AudioManager.bgsVolume = 0;
    AudioManager.meVolume = 0;
    AudioManager.seVolume = 0;
};

ResumeBgm = function()
{
    if(!$gameTemp)
        {
            return;
        }
    $gameTemp._isPause = false;
    if(bgmv)
    {
        AudioManager.bgmVolume = bgmv;
        AudioManager.bgsVolume = bgsv;
        AudioManager.meVolume = mev;
        AudioManager.seVolume = sev;
    }
};

class Main {
    constructor() {
        this.xhrSucceeded = false;
        this.loadCount = 0;
        this.error = null;
    }

    run() {
        this.showLoadingSpinner();
        this.testXhr();
        this.hookNwjsClose();
        this.loadMainScripts();
    }

    showLoadingSpinner() {
        const loadingSpinner = document.createElement("div");
        const loadingSpinnerImage = document.createElement("div");
        loadingSpinner.id = "loadingSpinner";
        loadingSpinnerImage.id = "loadingSpinnerImage";
        loadingSpinner.appendChild(loadingSpinnerImage);
        document.body.appendChild(loadingSpinner);
    }

    eraseLoadingSpinner() {
        const loadingSpinner = document.getElementById("loadingSpinner");
        const loadingSpinnerImage = document.getElementById("loadingSpinnerImage");

        if(loadingSpinnerImage)
        {
            loadingSpinner.removeChild(loadingSpinnerImage);
        }

        if (loadingSpinner) {
            document.body.removeChild(loadingSpinner);
        }
    }

    testXhr() {
        const xhr = new XMLHttpRequest();
        xhr.open("GET", document.currentScript.src);
        xhr.onload = () => (this.xhrSucceeded = true);
        xhr.send();
    }

    hookNwjsClose() {
        // [Note] When closing the window, the NW.js process sometimes does
        //   not terminate properly. This code is a workaround for that.
        if (typeof nw === "object") {
            nw.Window.get().on("close", () => nw.App.quit());
        }
    }

    loadMainScripts() {
        for (const url of scriptUrls) {
            const script = document.createElement("script");
            script.type = "text/javascript";
            script.src = url;
            script.async = false;
            script.defer = true;
            script.onload = this.onScriptLoad.bind(this);
            script.onerror = this.onScriptError.bind(this);
            script._url = url;
            document.body.appendChild(script);
        }
        this.numScripts = scriptUrls.length;
        window.addEventListener("load", this.onWindowLoad.bind(this));
        window.addEventListener("error", this.onWindowError.bind(this));
    }

    onScriptLoad() {
        if (++this.loadCount === this.numScripts) {
            PluginManager.setup($plugins);
        }
    }

    onScriptError(e) {
        this.printError("Failed to load", e.target._url);
    }

    printError(name, message) {
        this.eraseLoadingSpinner();
        if (!document.getElementById("errorPrinter")) {
            const errorPrinter = document.createElement("div");
            errorPrinter.id = "errorPrinter";
            errorPrinter.innerHTML = this.makeErrorHtml(name, message);
            document.body.appendChild(errorPrinter);
        }
    }

    makeErrorHtml(name, message) {
        const nameDiv = document.createElement("div");
        const messageDiv = document.createElement("div");
        nameDiv.id = "errorName";
        messageDiv.id = "errorMessage";
        nameDiv.innerHTML = name;
        messageDiv.innerHTML = message;
        return nameDiv.outerHTML + messageDiv.outerHTML;
    }

    onWindowLoad() {
        if (!this.xhrSucceeded) {
            const message = "Your browser does not allow to read local files.";
            this.printError("Error", message);
        } else if (this.isPathRandomized()) {
            const message = "Please move the Game.app to a different folder.";
            this.printError("Error", message);
        } else if (this.error) {
            this.printError(this.error.name, this.error.message);
        } else {
            this.initEffekseerRuntime();
        }
    }

    onWindowError(event) {
        if (!this.error) {
            this.error = event.error;
        }
    }

    isPathRandomized() {
        // [Note] We cannot save the game properly when Gatekeeper Path
        //   Randomization is in effect.
        return (
            typeof process === "object" &&
            process.mainModule.filename.startsWith("/private/var")
        );
    }

    initEffekseerRuntime() {
        const onLoad = this.onEffekseerLoad.bind(this);
        const onError = this.onEffekseerError.bind(this);
        effekseer.initRuntime(effekseerWasmUrl, onLoad, onError);
    }

    onEffekseerLoad() {
        this.eraseLoadingSpinner();
        SceneManager.run(Scene_Boot);
    }

    onEffekseerError() {
        this.printError("Failed to load", effekseerWasmUrl);
    }
}

const main = new Main();
main.run();

//-----------------------------------------------------------------------------
