//=============================================================================
// RPG Maker MZ - AutoAddMapMoveEvent
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc $dataMapPosから自動で移動イベントを作り出します
 * @author カタコトトコトコ
 *
 * @help 
 */

(() => {
    const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);

        if(command === 'moveMap')
        {
            const mapId = Number(args[0]);
            const x = Number(args[1]);
            const y = Number(args[2]);
            const direction = Number(args[3]);
            const fade = 0;
            $gamePlayer.reserveTransfer(mapId, x, y, direction, fade);
            AudioManager.playSe({"name":"Move1","volume":90,"pitch":100,"pan":0});
            $gameMap._interpreter.setWaitMode("transfer");
            return;
        }

        if(command === 'battlestart')
        {
            BattleManager.setup(Number(args[0]), true, false);
            BattleManager.setEventCallback(function(n) {this._branch[this._indent] = n;}.bind(this));
            $gamePlayer.makeEncounterCount();
            SceneManager.push(Scene_Battle);
            return;
        }
    };

    Game_Event.prototype.initialize = function(mapId, eventId, x, y, page) {
        Game_Character.prototype.initialize.call(this);
        this._mapId = mapId;
        this._eventId = eventId;
    
        this._width = 0;
        this._height = 0;
    
        if(page != undefined)
        {
            this._page = page;
            this._pageIndex = 0;
        }
    
        let ev = this.event();
        if(ev != null)
        {
            if( ev.meta.width != undefined )
            {
                this._width = Number(ev.meta.width);
            }
    
            if( ev.meta.height != undefined )
            {
                this._height = Number(ev.meta.height);
            }
        }
    
        if(x == undefined)
        {
            this.locate(ev.x, ev.y);
        }
        else
        {
            this.locate(x, y);
            this._x = x;
            this._y = y;
        }
    
        this.refresh();
    };

    Game_Event.prototype.start = function() {
        var list = this.list();
        if(list == null || list == undefined)
        {
            return;
        }
        if (list.length <= 0) 
        {
            return;
        }
        this._starting = true;
        if (this.isTriggerIn([0,1,2])) {
            this.lock();
        }
    };
    

    Game_Event.prototype.event = function() 
    {
        if(this._mapId == -1)
        {
            return null;
        }
    
        return $dataMap.events[this._eventId];
    };
    
    Game_Event.prototype.page = function() {
    
        if(this._page == null || this._page == undefined)
        {
            return this.event().pages[this._pageIndex];
        }
        return this._page;
    };
    
    Game_Event.prototype.list = function() {
        const page = this.page();
    
        if(page == null || page == undefined)
        {
            return null;
        }
    
        return page.list;
    };

    Game_Event.prototype.refresh = function() {
        if(this._page != null )
        {
            if(this._pageIndex != -1)
            {
                this.setupPage();
                this._pageIndex = -1;
            }
            return;
        }
        var newPageIndex = this._erased ? -1 : this.findProperPageIndex();
        if (this._pageIndex !== newPageIndex) {
            this._pageIndex = newPageIndex;
            this.setupPage();
        }
    };

    Game_Map.prototype.eraseEvent = function(eventId) {
        for(let i = 0; i< this._events.length; ++i)
        {
            let event = this._events[i];
    
            if(!event){continue;}
    
            if(event._eventId == eventId)
            {
                event.erase();
                this._events[i] = null;
            }
        }
    };

    Game_Event.prototype.setTriggerType = function(triggerType)
    {
        this._trigger = triggerType;
    }

    Game_Event.prototype.setCollisionSize = function(x, y)
    {
        this._width = x;
        this._height = y;
    };
    
    Game_Event.prototype.findProperPageIndex = function() {
        const events = this.event();
        if( events == undefined )
        {
            return -1;
        }
        const pages = events.pages;
        for (let i = pages.length - 1; i >= 0; i--) {
            const page = pages[i];
            if (this.meetsConditions(page)) {
                return i;
            }
        }
        return -1;
    };

    Game_Event.prototype.checkEventTriggerTouch = function(x, y) {
        if (!$gameMap.isEventRunning()) {
    
            const px = $gamePlayer._x;
            const py = $gamePlayer._y;
    
            let w = 0;
            let h = 0;
    
            if(this.meta)
            {
                if( this.meta.width != undefined )
                {
                    w = Number(this.meta.width);
                }
        
                if( this.meta.height != undefined )
                {
                    h = Number(this.meta.height);
                }
            }
    
            const isHit = ( (x + w) <= px && (x - w ) >= px) && ( (y + h) <= py && (y - h ) >= py);
    
            if (this._trigger === 2 && isHit) {
                if (!this.isJumping() && this.isNormalPriority()) {
                    this.start();
                }
            }
        }
    };

    Game_Player.prototype.isAlreadyEvent = function(name)
    {
        if(!this._events)
        {
            return false;
        }

        for(let i = 0; i < this._events.length; ++i)
        {
            if(this._events[i] == name)
            {
                return true;
            }
        }
        return false;
    };

    Game_Player.prototype.addAlreadyEvent = function(name)
    {
        if(!this._events)
        {
            this._events = [];
        }

        this._events.push(name);

    }

    Game_Map.prototype.createAutoDoingEvent2 = function(index)
    {
        index = Number(index);

        if(index < 1)
        {
            return;
        }

        
        let posX = 0;
        let posY = 0;
        let dir = 2;

        const page = {
            "conditions":
            {
                "actorId":-1,
                "actorValid":false,
                "itemId":1,
                "itemValid":false,
                "selfSwitchCh":"A",
                "selfSwitchValid":false,
                "switch1Id":1,
                "switch1Valid":false,
                "switch2Id":1,
                "switch2Valid":false,
                "variableId":1,
                "variableValid":false,
                "variableValue":0},
                "directionFix":false,
                "image":{"characterIndex":0,"characterName":"","direction": dir,"pattern":0,"tileId":0},
                "list":[
                    {"code":117,"indent":0,"parameters":[index]}
                    // {"code":111,"indent":0,"parameters":[12,"!$gamePlayer.isAlreadyEvent(\"%1\")".format(name)]},//if
                    // {"code":355,"indent":1,"parameters":["this.pluginCommand(\"%2\", [\"%3\"]);".format(name,"xlsx", name)]},//plugincommand
                    // {"code":0,"indent":1,"parameters":[]},
                    // {"code":111,"indent":1,"parameters":[12,"this._branch[this._indent] == 0"]},//if
                    // {"code":355,"indent":2,"parameters":["$gamePlayer.addAlreadyEvent(\"%1\");".format(name,"xlsx", name)]},//plugincommand
                    // {"code":412,"indent":1,"parameters":[]},//endif
                    // {"code":412,"indent":0,"parameters":[]},//endif
                    // {"code":214,"indent":0,"parameters":[]},{"code":0,"indent":0,"parameters":[]}//delete event
                ],
                "moveFrequency":4,
                "moveRoute":{},
                "moveSpeed":1,
                "moveType":0,
                "priorityType":1,
                "stepAnime":true,
                "through":false,
                "trigger":3,
                "walkAnime":true,
                "isTile":true
            };


        let event = new Game_Event(this._events.length + 1, this._events.length + 1, posX, posY, page);
        
        event.isWarpEvent = true;
        //event.setImage('Monster', 0);

        event.setCollisionSize(1,1);

        this.addEvent(event);
    }

    Game_Map.prototype.createHealEvent = function(x, y)
    {
        let posX = x;
        let posY = y;
        let dir = 2;

        const page = {
            "conditions":
            {
                "actorId":-1,
                "actorValid":false,
                "itemId":1,
                "itemValid":false,
                "selfSwitchCh":"A",
                "selfSwitchValid":false,
                "switch1Id":1,
                "switch1Valid":false,
                "switch2Id":1,
                "switch2Valid":false,
                "variableId":1,
                "variableValid":false,
                "variableValue":0},
                "directionFix":true,
                "image":{"characterIndex":0,"characterName":"","direction": dir,"pattern":0,"tileId":0},
                "list":[
                    {"code":117,"indent":1,"parameters":[2]},//plugincommand
                    {"code":0,"indent":1,"parameters":[]}
                    ],
                "moveFrequency":4,
                "moveRoute":{},
                "moveSpeed":1,
                "moveType":0,
                "priorityType":1,
                "stepAnime":true,
                "through":false,
                "trigger":0,
                "walkAnime":false,
                "isTile":true
            };

        let event = new Game_Event(this._events.length + 1, this._events.length + 1, posX, posY, page);
        
        event.isWarpEvent = true;
        event.setImage('!Crystal', 3);

        event.setCollisionSize(1,1);

        this.addEvent(event);
    }


    Game_Map.prototype.createAutoDoingEvent = function(name)
    {
        let posX = 0;
        let posY = 0;
        let dir = 2;

        const page = {
            "conditions":
            {
                "actorId":-1,
                "actorValid":false,
                "itemId":1,
                "itemValid":false,
                "selfSwitchCh":"A",
                "selfSwitchValid":false,
                "switch1Id":1,
                "switch1Valid":false,
                "switch2Id":1,
                "switch2Valid":false,
                "variableId":1,
                "variableValid":false,
                "variableValue":0},
                "directionFix":false,
                "image":{"characterIndex":0,"characterName":"","direction": dir,"pattern":0,"tileId":0},
                "list":[
                    {"code":111,"indent":0,"parameters":[12,"!$gamePlayer.isAlreadyEvent(\"%1\")".format(name)]},//if
                    {"code":355,"indent":1,"parameters":["$gamePlayer.addAlreadyEvent(\"%1\");this.pluginCommand(\"%2\", [\"%3\"]);".format(name,"xlsx", name)]},//plugincommand
                    {"code":0,"indent":1,"parameters":[]},
                    {"code":412,"indent":0,"parameters":[]},//endif
                    {"code":214,"indent":0,"parameters":[]},{"code":0,"indent":0,"parameters":[]}//delete event
                ],
                "moveFrequency":4,
                "moveRoute":{},
                "moveSpeed":1,
                "moveType":0,
                "priorityType":1,
                "stepAnime":true,
                "through":false,
                "trigger":3,
                "walkAnime":true,
                "isTile":true
            };


        let event = new Game_Event(this._events.length + 1, this._events.length + 1, posX, posY, page);
        
        event.isWarpEvent = true;
        //event.setImage('Monster', 0);

        event.setCollisionSize(1,1);

        this.addEvent(event);
    }
    Game_Map.prototype.hideMiniMap = function()
    {
        for(let i = 0; i < 25; ++i)
        {
            $gameScreen.erasePicture(i + 20 + 1);
        }
    }

    Game_Map.prototype.eraseMiniMap = function()
    {
        this._mapIds = null;
    }

    Game_Map.prototype.updateMiniMap = function()
    {
        if(!this._mapIds){
            return;
        }
        this.hideMiniMap();

        let array = [];
        array[0] = [];
        array[1] = [];
        array[2] = [];
        array[3] = [];
        array[4] = [];

        
        for(let i = 0; i < 5; ++i)
        {
            for(let r = 0; r < 5; ++r)
            {
                array[i][r] = [-1, 0, 0, 0, 0, 0, 0];
            }
        }

        for(let i = 0; i < this._mapIds.length; ++i)
        {
            for(let r = 0; r < $dataSimpleMap.length; ++r)
            {
                const d = $dataSimpleMap[r];
                const mapId = Number(d.mapId);
                if(mapId != this._mapIds[i])
                {
                    continue;
                }

                if(!this._mapAlready[mapId])
                {
                    array[Number(d.x)][Number(d.y)][0] = 0;
                }
                else
                {
                    if(mapId == this._mapId)
                    {
                        array[Number(d.x)][Number(d.y)][2] = 1;
                    }
                    let t = Number(d.t);
                    let b = Number(d.b);
                    let l = Number(d.l);
                    let r = Number(d.r);

                    if(t != -1)
                    {
                        array[Number(d.x)][Number(d.y )- 1][1] = 1;
                        array[Number(d.x)][Number(d.y)][3] = 1;

                    }
                    if(b != -1)
                    {
                        array[Number(d.x)][Number(d.y )+ 1][1] = 1;
                        array[Number(d.x)][Number(d.y)][4] = 1;
                    }
                    if(l != -1)
                    {
                        array[Number(d.x )- 1][Number(d.y)][1] = 1;
                        array[Number(d.x)][Number(d.y)][5] = 1;
                    }
                    if(r != -1)
                    {
                        array[Number(d.x )+ 1][Number(d.y)][1] = 1;
                        array[Number(d.x)][Number(d.y)][6] = 1;
                    }

                    array[Number(d.x)][Number(d.y)][0] = 1;
                }

                break;
            }
        }

        let index = 20 + 1;

        $gameScreen.showPicture(index,"minimap_background",1,2.5 * 44 + 28 + 20, 2.5 * 24 + 28 + 40,400,400,128,0);

        index++;

        for(let i = 0; i < 5; ++i)
        {
            for(let r = 0; r < 5; ++r)
            {
                let v = array[i][r][0];
                let v2 = array[i][r][1];
                let v3 = array[i][r][2];

                let text = '';

                if(array[i][r][3] == 1)
                {
                    text += 't';
                }
                if(array[i][r][4] == 1)
                {
                    text += 'b';
                }
                if(array[i][r][5] == 1)
                {
                    text += 'l';
                }
                if(array[i][r][6] == 1)
                {
                    text += 'r';
                }
                if(v == -1)
                {
                    continue;
                }
                let x = i * 44 + 28 + 20;
                let y = r * 24 + 28 + 40;
                let opacity = 240;
                if(v == 1)
                {

                    {
                        $gameScreen.showPicture(index,"minimap" + text,1,x,y,100,100,opacity,0);
                        index++;

                    }
                    if(v3 == 1)
                    {
                        $gameScreen.showPicture(index,"minimapp",1,x,y,100,100,opacity,0);
                        index++;
                    }
                    continue;
                }
                if(Number(v) == 0 && Number(v2) == 1)
                {
                    $gameScreen.showPicture(index,"minimapq",1,x,y,100,100,opacity,0);
                    index++;
                    continue;
                }

            }
        }
    }

    Game_Map.prototype.drawMiniMap = function(mapIds)
    {
        this._mapIds = mapIds;

        this.updateMiniMap();
    }

    const _Game_Map_setupEvents = Game_Map.prototype.setupEvents;
    Game_Map.prototype.setupEvents = function() {
        _Game_Map_setupEvents.apply(this, arguments);

        const width = this.width();
        const height = this.height();

        const mapId = this._mapId;

        this._mapAlready[this._mapId] = true;

        // const list = $dataMapPos;
        // let array = [];
        // for(let i = 0; i < list.length; ++i )
        // {
        //     const d = list[i];
        //     if(Number(d.mapId) == mapId)
        //     {
        //         array.push(d);
        //     }
        // }

        let isHit = false;

        let enemyIds = [];

        let mapData = null;

        for(let i = 0; i < $dataMapData.length; ++i)
        {
            const d = $dataMapData[i];
            const mapIds = String(d.mapIds).split(',');
            for(let r = 0; r < mapIds.length; ++r)
            {
                if(Number(mapIds[r]) == mapId)
                {
                    isHit = true;
                    mapData = d;
                    break;
                }
            }
            if(isHit)
            {
                this.drawMiniMap(mapIds);

                enemyIds = d.enemySpawnIds.split(',');

                if(mapId == Number(d.bossMapId))
                {
                    const bossEventId = Number(d.bossEventId);
                    if(bossEventId != 13)
                    {
                        this.createAutoDoingEvent2(bossEventId);
                    }
                    isHit = false;
                }

                if(mapId == Number(d.beginMapId))
                {
                    this.createAutoDoingEvent2(d.beginEventId);
                    isHit = false;
                }

                break;
            }
            else
            {
                this.hideMiniMap();
            }
        }

        if(mapData != null)
        {
            if(mapData.bgmName)
            {
                AudioManager.playBgm({"name":mapData.bgmName, "volume":90, "pitch":100, "pan":0});
            }

            if(Number(mapData.bossBeforeMapId) == mapId)
            {
                $gamePlayer.addMapFlagSilent(mapData.warpId + "_BEFORE_BOSS");

                $gameMap.createHealEvent( Number(mapData.healX), Number(mapData.healY) );
            }
        }

        if(isHit && enemyIds.length > 0 && mapData.enemyPictureName)
        {
            let num = Math.floor( Math.random() * 4 );
            for(let i = 0; i < num; ++i)
            {   
                let posX = 0;
                let posY = 0;
                while(true)
                {
                    posX = 3 + Math.ceil(Math.random() * (width - 6 ));
                    posY = 3 + Math.ceil(Math.random() * (height - 6 ));
                    if($gameMap.isAirshipLandOk(posX, posY))
                    {
                        break;
                    }
                }

                const enemyId = enemyIds[ Math.floor(Math.random() * enemyIds.length) ];

                let pluginCommadName = 'battlestart ' + enemyId;
        
                let dir = 2;
        
                const page = {
                    "conditions":
                    {
                        "actorId":-1,
                        "actorValid":false,
                        "itemId":1,
                        "itemValid":false,
                        "selfSwitchCh":"A",
                        "selfSwitchValid":false,
                        "switch1Id":1,
                        "switch1Valid":false,
                        "switch2Id":1,
                        "switch2Valid":false,
                        "variableId":1,
                        "variableValid":false,
                        "variableValue":0},
                        "directionFix":false,
                        "image":{"characterIndex":0,"characterName":"","direction": dir,"pattern":0,"tileId":0},
                        "list":[
                            {"code":214,"indent":0,"parameters":[]},
                            {"code":356,"indent":0,"parameters":[ pluginCommadName ]},
                            {"code":0,"indent":0,"parameters":[]}
                        ],
                        "moveFrequency":4,
                        "moveRoute":{},
                        "moveSpeed":4,
                        "moveType":2,
                        "priorityType":1,
                        "stepAnime":true,
                        "through":false,
                        "trigger":2,
                        "walkAnime":true,
                        "isTile":true
                    };
        
      
                let event = new Game_Event(this._events.length + 1, this._events.length + 1, posX, posY, page);
                
                event.isWarpEvent = true;
        
                event.setImage(mapData.enemyPictureName, mapData.enemyPictureIndex);
            
                event.setCollisionSize(1,1);
        
                this.addEvent(event);
            }
        }

        for(let i = 0; i < $dataSimpleMap.length; ++i)
        {
            const d = $dataSimpleMap[i];
            if(!d.mapId)
            {
                continue;
            }
            if(Number(d.mapId) == mapId)
            {
                if(d.t && Number(d.t) > 0)
                {
                    this.addSimpleWarpEvent(Number(d.t),2);
                }

                if(d.b && Number(d.b) > 0)
                {
                    this.addSimpleWarpEvent(Number(d.b),8);
                }

                if(d.r && Number(d.r) > 0)
                {
                    this.addSimpleWarpEvent(Number(d.r),6);
                }

                if(d.l && Number(d.l) > 0)
                {
                    this.addSimpleWarpEvent(Number(d.l),4);
                }
                break;
            }
        }

        // for(let i = 0; i < array.length; ++i)
        // {
        //     const d = array[i];

        //     if(d.warpId)
        //     {
        //         let d2 = null;
        //         for(let z = 0; z < list.length; ++z)
        //         {
        //             const d3 = list[z];
        //             if(d.warpId == d3.id)
        //             {
        //                 d2 = d3;
        //                 break;
        //             }
        //         }
    
        //         if(d2 == null)
        //         {
        //             $gameMessage.add('%1=>\n%2は\n見つかりませんでした！バグです！'.format(d.id, d.warpId));
        //         }
        //         else
        //         {
        //             this.addWarpEvent(d,d2);
        //         }
        //     }
        // }

        this._commonEvents = this.parallelCommonEvents().map(function(commonEvent) {
            return new Game_CommonEvent(commonEvent.id);
        });
        this.refreshTileEvents();
    };

    Game_Map.prototype.addEvent = function(event){
        this._events.push(event);
    };

    Game_Map.prototype.addSimpleWarpEvent = function(targetMapId, direction)
    {
        let pd = 2;
        
        const width = this.width();
        const height = this.height();

        let gx = Math.floor(width / 2);
        let gy = Math.floor(height / 2);
        const gMapId = targetMapId;
        let size = 0;
        switch(Number(direction))
        {
            case 2:
                pd = 8;
                gy = height - 2;
                size = width;
                sx = 1;
                sy = 0;
                break;
            case 4:
                pd = 4;
                gx = width - 2;
                size = height;
                sx = 0;
                sy = 1;
                break;
            case 6:
                pd = 6;
                gx = 1;
                size = height;
                sx = width - 1;
                sy = 1;
                break;
            case 8:
                pd = 2;
                gy = 1;
                size = width;
                sx = 1;
                sy = height - 1;
                break;
        }
        for(let i = 0; i < size - 2; ++i)
        {   
            let posX = sx;
            let posY = sy;

            switch(direction)
            {
                case 2:
                case 8:
                    posX += i;
                    break;
                case 4:
                case 6:
                    posY += i;
                    break;
            }
            if(!$gameMap.isAirshipLandOk(posX, posY))
            {
                continue;
            }
            
            let pluginCommadName = 'moveMap ' + gMapId + ' ' + gx + ' ' + gy + ' ' + pd;
    


            let dir = pd;
    
            const page = {
                "conditions":
                {
                    "actorId":-1,
                    "actorValid":false,
                    "itemId":1,
                    "itemValid":false,
                    "selfSwitchCh":"A",
                    "selfSwitchValid":false,
                    "switch1Id":1,
                    "switch1Valid":false,
                    "switch2Id":1,
                    "switch2Valid":false,
                    "variableId":1,
                    "variableValid":false,
                    "variableValue":0},
                    "directionFix":true,
                    "image":{"characterIndex":0,"characterName":"","direction": dir,"pattern":0,"tileId":0},
                    "list":[{"code":356,"indent":0,"parameters":[ pluginCommadName ]},{"code":0,"indent":0,"parameters":[]}],
                    "moveFrequency":3,
                    "moveRoute":{},
                    "moveSpeed":3,
                    "moveType":0,
                    "priorityType":0,
                    "stepAnime":true,
                    "through":true,
                    "trigger":1,
                    "walkAnime":true,
                    "isTile":true
                };
    
  
            let event = new Game_Event(this._events.length + 1, this._events.length + 1, posX, posY, page);
            
            event.isWarpEvent = true;
    
            event.setImage('cursor', 0);
        
            event.setCollisionSize(1,1);
    
            this.addEvent(event);
        }
    };

    Game_Map.prototype.addWarpEvent = function(mapPos1, mapPos2)
    {
        let pd = 2;
        let gx = Number(mapPos2.x);
        let gy = Number(mapPos2.y);
        let gMapId = Number(mapPos2.mapId);
        switch(Number(mapPos2.direction))
        {
            case 2:
                pd = 8;
                gy -= 1;
                break;
            case 4:
                pd = 6;
                gx += 1;
                break;
            case 6:
                pd = 4;
                gx -= 1;
                break;
            case 8:
                pd = 2;
                gy += 1;
                break;
        }
        for(let i = 0; i < mapPos1.size; ++i)
        {    
            let pluginCommadName = 'moveMap ' + gMapId + ' ' + gx + ' ' + gy + ' ' + pd;
    
            // if(baseMapId == 6)
            // {
            //     pluginCommadName = 'selectMap';
            // }
    
            let dir = mapPos1.direction;
    
            const page = {
                "conditions":
                {
                    "actorId":-1,
                    "actorValid":false,
                    "itemId":1,
                    "itemValid":false,
                    "selfSwitchCh":"A",
                    "selfSwitchValid":false,
                    "switch1Id":1,
                    "switch1Valid":false,
                    "switch2Id":1,
                    "switch2Valid":false,
                    "variableId":1,
                    "variableValid":false,
                    "variableValue":0},
                    "directionFix":true,
                    "image":{"characterIndex":0,"characterName":"","direction": dir,"pattern":0,"tileId":0},
                    "list":[{"code":356,"indent":0,"parameters":[ pluginCommadName ]},{"code":0,"indent":0,"parameters":[]}],
                    "moveFrequency":3,
                    "moveRoute":{},
                    "moveSpeed":3,
                    "moveType":0,
                    "priorityType":0,
                    "stepAnime":true,
                    "through":true,
                    "trigger":1,
                    "walkAnime":true,
                    "isTile":true
                };
    
            let posX = Number(mapPos1.x);
            let posY = Number(mapPos1.y);
            let size = Number(mapPos1.size);
            switch(Number(mapPos1.direction))
            {
                case 2:
                case 8:
                    posX += Math.floor(size / 2) - i;
                    break;
                case 4:
                case 6:
                    posX += Math.floor(size / 2) - i;
                    break;
                default:
                    console.log("Error! %1".format(mapPos1.direction) );
                    break;
            }

            let event = new Game_Event(this._events.length + 1, this._events.length + 1, posX, posY, page);
            
            event.isWarpEvent = true;
    
            event.setImage('cursor', 0);
        
            event.setCollisionSize(1,1);
    
            this.addEvent(event);
        }
    };

    Game_Message.prototype.isBusy = function() {
        var v= (
            this.hasText() ||
            this.isChoice() ||
            this.isNumberInput() ||
            this.isItemChoice() ||
            this._isChoice
        );
        return v;
    };

    Game_Player.prototype.showWarpMapList = function()
    {
        const rect = new Rectangle(48, 0, 280, 624);
        let list = new Window_WarpMapList(rect);
        SceneManager._scene._windowWarpMapList = list;

        SceneManager._scene.addChild(list);
        list.activate();
        list.select(0);
        $gameMessage._isChoice = true;

        list.setHandler("ok", this.onWarpEnter.bind(this));
        list.setHandler("cancel", this.onWarpCancel.bind(this));
    };

    Game_Player.prototype.showFriendList = function(interpreter)
    {
        const rect = new Rectangle(0, 64, 280, 64 * 8);
        let list = new Window_FriendList(rect);
        SceneManager._scene._windowFriendList = list;

        SceneManager._scene.addChild(list);
        list.activate();
        list.select(0);
        $gameMessage._isChoice = true;

        list.setHandler("ok", this.onSelectFriend.bind(this));
        list.setHandler("cancel", this.onCancelFriend.bind(this));

        interpreter.setWaitMode('message');
    };

    Game_Player.prototype.onSelectFriend = function()
    {
        $gameTemp._targetFriend = -1;
        var actorId = SceneManager._scene._windowFriendList.item()[1];
        if(actorId > 0)
        {
            $gameTemp._targetFriend = actorId;
        }

        SceneManager._scene.removeChild(SceneManager._scene._windowFriendList);
        $gameMessage._isChoice = false;
    }

    Game_Player.prototype.checkFriend = function(interpreter)
    {
        var actorId = $gameTemp._targetFriend;
        let actor = $gameActors.actor(actorId);
        if(!actor.extendCount)
        {
            actor.extendCount = 0;
        }

        interpreter._isLevelUp = false;


        if(actor.extendCount >= 3)
        {
            $gameMessage.add( actor.name() + "はもう強化できないようだ。");
            return;
        }

        if(actor.extendCount == 0)
        {
            const item = $dataItems[2];
            if($gameParty.numItems(item) > 0)
            {
                $gameParty.loseItem(item, 1);
            }
            else
            {
                $gameMessage.add( item.name + "が必要です" );
                return;
            }
        }
        else if(actor.extendCount == 1)
        {
            if($gameParty.isTrial())
            {
                $gameMessage.add( "体験版はここまでです！" );
                return;
            }

            const item = $dataItems[3];
            if($gameParty.numItems(item) > 0)
            {
                $gameParty.loseItem(item, 1);
            }
            else
            {
               
                $gameMessage.add( item.name + "が必要です" );
                return;
            }
        }
        else if(actor.extendCount == 2)
        {
            const item = $dataItems[4];
            if($gameParty.numItems(item) > 0)
            {
                $gameParty.loseItem(item, 1);
            }
            else
            {
                //$gameMessage.add( item.name + "が必要です" );
                $gameMessage.add( actor.name() + "は最大まで強化しました" );
                return;
            }
        }

        actor.extendCount++;

        interpreter._isLevelUp = true;
    }

    Game_Player.prototype.checkFriend2 = function(interpreter)
    {
        if(interpreter._isLevelUp)
        {
            var actorId = $gameTemp._targetFriend;

            let actor = $gameActors.actor(actorId);
            var name = $dataActors[actorId].meta.enemyimage;
            const path = name + "_sex" + ( actor.extendCount + 1 );
            interpreter.setupXlsx( path, $gameTroop._interpreter.eventId());
        }
    }

    Game_Player.prototype.checkFriend3 = function(interpreter)
    {
        if(interpreter._isLevelUp)
        {
            var actorId = $gameTemp._targetFriend;

            let actor = $gameActors.actor(actorId);
            //var name = $dataActors[actorId].meta.enemyimage;
            //actor.extendCount;

            if(actor._exParam == undefined)
            {
                actor._exParam = 1;
            }
            else
            {
                actor._exParam++;
            }


            let index = actor._exParam;

            let array = actor.actor().meta.adskills.split(',');

            if( index == 1 )
            {
                actor.learnSkill( Number(array[0]) );
            }
            if( index == 2 )
            {
                actor.learnSkill( Number(array[1]) );
            }
            else
            {
                $gameMessage.add( actor.name() + "のステータスが少し上がった！");
            }
        }
    }

    Game_Player.prototype.addMapFlagSilent = function(idText)
    {
        if(!this._mapFlags)
        {
            this._mapFlags = [];
        }

        if(this.isMapFlag(idText))
        {
            return;
        }

        this._mapFlags.push(idText);
    }

    Game_Player.prototype.addMapFlag = function(idText, it)
    {
        if(!this._mapFlags)
        {
            this._mapFlags = [];
        }

        if(this.isMapFlag(idText))
        {
            return;
        }

        this._mapFlags.push(idText);

        for(let i = 0; i < $dataWarpList.length; ++i)
        {
            if($dataWarpList[i].warpId == idText)
            {
                $gameMessage.add($dataWarpList[i].name + "に行けるようになった！");
                it.setWaitMode("message");
                break;
            }
        }
    }

    Game_Player.prototype.isMapFlag = function(idText)
    {
        if(!this._mapFlags)
        {
            return false;
        }

        for(let i = 0; i < this._mapFlags.length; ++i)
        {
            if(this._mapFlags[i] == idText)
            {
                return true;
            }
        }
        return false;
    }

    //$dataMapPosから該当するMapIDを検索してそこへ移動
    Game_Player.prototype.moveMapWithIndex = function(index) 
    {
        {
            const d = $dataWarpList[index];
            const mapId = Number(d.warpMapId);
            const x = Number(d.x);
            const y = Number(d.y);
            const direction = d.direction ? Number(d.direction) : 2;
            const fade = 0;
            $gamePlayer.reserveTransfer(mapId, x, y, direction, fade);
            AudioManager.playSe({"name":"Move1","volume":90,"pitch":100,"pan":0});

            $gamePlayer.showFollowers()
            $gamePlayer.refresh()

            $gameMap._interpreter.setWaitMode("transfer");
            return;
        }
    }

    //$dataMapPosから該当するMapIDを検索してそこへ移動
    Game_Player.prototype.moveMap = function(idText) 
    {
        for(let i = 0; i < $dataMapPos.length; ++i)
        {
            if( $dataMapPos[i].id == idText )
            {
                const d = $dataMapPos[i];
                const mapId = Number(d.mapId);
                const x = Number(d.x);
                const y = Number(d.y);
                const direction = Number(d.direction);
                const fade = 0;
                $gamePlayer.reserveTransfer(mapId, x, y, direction, fade);
                AudioManager.playSe({"name":"Move1","volume":90,"pitch":100,"pan":0});
                $gameMap._interpreter.setWaitMode("transfer");
                return;
            }
        }

        //ここまで来るとIDが見つからないのでバグか漏れです
        $gameMessage.add('座標%1は見つかりませんでした!\nバグです！'.format(idText));
    }



    Game_Player.prototype.onWarpEnter = function()
    {
        const item = SceneManager._scene._windowWarpMapList.item();
        if(!item)
        {
            return;
        }
        if(item[1] == -1 || item[1] == -2)
        {
            if(item[1] == -1)
            {
                SceneManager._scene._windowWarpMapList._page += 1;
            }
            if(item[1] == -2)
            {
                SceneManager._scene._windowWarpMapList._page -= 1;
            }
            SceneManager._scene._windowWarpMapList.activate();
            SceneManager._scene._windowWarpMapList.refresh();
            return;
        }

        if(item[1] != -3)
        {
            $gamePlayer.moveMapWithIndex(item[1]);
        }
        else if(item[1] == -3)
        {
            $gameTemp.reserveCommonEvent(42);
        }
        SceneManager._scene.removeChild(SceneManager._scene._windowWarpMapList);
        $gameMessage._isChoice = false;
    };

    Game_Player.prototype.onWarpCancel = function()
    {
        SceneManager._scene.removeChild(SceneManager._scene._windowWarpMapList);
        $gameMessage._isChoice = false;

        $gameTemp.reserveCommonEvent(42);
    };

    Game_Player.prototype.onCancelFriend = function()
    {
        SceneManager._scene.removeChild(SceneManager._scene._windowFriendList);
        $gameMessage._isChoice = false;
    };

    //-----------------------------------------------------------------------------
    // Window_FriendList
    //
    // The window for selecting a skill on the skill screen.

    function Window_FriendList() {
        this.initialize(...arguments);
    }

    Window_FriendList.prototype = Object.create(Window_Selectable.prototype);
    Window_FriendList.prototype.constructor = Window_SkillList;

    Window_FriendList.prototype.initialize = function(rect) {
        this._page = 0;
        Window_Selectable.prototype.initialize.call(this, rect);

        this._actor = null;
        this._data = [];
        this.refresh();
        this.scrollTo(0, 0);
    };

    Window_FriendList.prototype.maxCols = function() {
        return 1;
    };

    Window_FriendList.prototype.colSpacing = function() {
        return 16;
    };

    Window_FriendList.prototype.maxItems = function() {
        return this._data ? this._data.length : 1;
    };

    Window_FriendList.prototype.item = function() {
        return this.itemAt(this.index());
    };

    Window_FriendList.prototype.itemAt = function(index) {
        return this._data && index >= 0 ? this._data[index] : null;
    };

    Window_FriendList.prototype.isCurrentItemEnabled = function() {
        return this.isEnabled(this._data[this.index()]);
    };

    Window_FriendList.prototype.includes = function(item) {
        return item;
    };

    Window_FriendList.prototype.isEnabled = function(item) {
        return true;
    };

    Window_FriendList.prototype.makeItemList = function() {

        this._data = [];

        let members = $gameParty.allMembers();
        for(var i = 0; i < members.length; i++)
        {
            let d = members[i];
            if(d._actorId == 1)
            {
                continue;
            }

            let name = d.name();

            if(d.extendCount == 1)
            {
                name += ' +1';
            }
            else if(d.exntendCount == 2)
            {
                name += ' +2(MAX)';
            }

            this._data.push( [name, d._actorId] );
        }

        this._data.push( [TextManager.cancel,-3] );
    };

    Window_FriendList.prototype.selectLast = function() {
        const index = this._data.indexOf(this._actor.lastSkill());
        this.forceSelect(index >= 0 ? index : 0);
    };

    Window_FriendList.prototype.drawItem = function(index) {
        const data = this.itemAt(index);
        if (data) {
            const rect = this.itemLineRect(index);
            this.drawText(data[0], rect.x, rect.y, rect.width);
        }
    };

    Window_FriendList.prototype.updateHelp = function() {
        this.setHelpWindowItem(this.item());
    };

    Window_FriendList.prototype.refresh = function() {
        this.makeItemList();
        Window_Selectable.prototype.refresh.call(this);
    };

    //-----------------------------------------------------------------------------
    // Window_WarpMapList
    //
    // The window for selecting a skill on the skill screen.

    function Window_WarpMapList() {
        this.initialize(...arguments);
    }

    Window_WarpMapList.prototype = Object.create(Window_Selectable.prototype);
    Window_WarpMapList.prototype.constructor = Window_SkillList;

    Window_WarpMapList.prototype.initialize = function(rect) {
        this._page = 0;
        Window_Selectable.prototype.initialize.call(this, rect);
        this._actor = null;
        this._data = [];
        this._size = 6;
        this.refresh();
        this.scrollTo(0, 0);
    };

    Window_WarpMapList.prototype.maxCols = function() {
        return 1;
    };

    Window_WarpMapList.prototype.colSpacing = function() {
        return 8;
    };
    Window_WarpMapList.prototype.itemHeight = function() {
        return Window_Scrollable.prototype.itemHeight.call(this) + 8 + 24 - 1 -1;
    };
    Window_WarpMapList.prototype.itemPadding = function() {
        return 4;
    };

    Window_WarpMapList.prototype.rowSpacing = function() {
        return 2;
    };

    Window_WarpMapList.prototype.maxItems = function() {
        return this._data ? this._data.length : 1;
    };

    Window_WarpMapList.prototype.item = function() {
        return this.itemAt(this.index());
    };

    Window_WarpMapList.prototype.itemAt = function(index) {
        return this._data && index >= 0 ? this._data[index] : null;
    };

    Window_WarpMapList.prototype.isCurrentItemEnabled = function() {
        return this.isEnabled(this._data[this.index()]);
    };

    Window_WarpMapList.prototype.includes = function(item) {
        return item;
    };

    Window_WarpMapList.prototype.isEnabled = function(item) {
        return item[1] != -4;
    };

    Window_WarpMapList.prototype.makeItemList = function() {

        this._data = [];

        const size = this._size;

        let data = [];

        for(let i = 0; i < $dataWarpList.length; ++i)
        {
            const d = $dataWarpList[i];

            if(d.trigger == 'TRUE' || $gamePlayer.isMapFlag(d.warpId))
            {
                data.unshift(d);
            }
        }

        if(this._page < 0)
        {
            this._page = Math.ceil(data.length / size) - 1;
        }

        if(this._page * size >= Math.ceil(data.length / size) * size)
        {
            this._page = 0;
        }

        let remain = size;
        let index = this._page * size;
        for(var i = 0; i < size; i++)
        {
            const id = index + i;
            if(data.length <= (id))
            {
                break;
            }
            const d = data[id];
            this._data.push( [d.name, d.id] );
            remain--;
        }

        for(let i = 0; i < remain; ++i)
        {
            this._data.push(["",-4]);
        }

        this._data.push( [TextManager.nextPage ? TextManager.nextPage : "次のページ",-1]);
        this._data.push( [TextManager.previousPage ? TextManager.previousPage : "前のページ",-2] );
        this._data.push( [TextManager.cancel,-3] );
    };

    Window_WarpMapList.prototype.selectLast = function() {
        const index = this._data.indexOf(this._actor.lastSkill());
        this.forceSelect(index >= 0 ? index : 0);
    };

    Window_WarpMapList.prototype.drawItem = function(index) {
        const data = this.itemAt(index);
        if (data) {
            const rect = this.itemLineRect(index);
            this.drawText(data[0], rect.x, rect.y, rect.width);
        }
    };

    Window_WarpMapList.prototype.updateHelp = function() {
        this.setHelpWindowItem(this.item());
    };

    Window_WarpMapList.prototype.refresh = function() {
        this.makeItemList();
        Window_Selectable.prototype.refresh.call(this);
    };


})();
