//=============================================================================
// RPG Maker MZ - MVAnimation
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc　パーティコマンドを増やします
 * @author カタコトトコトコ
 *
 * @help
 */

(() => {


    //-----------------------------------------------------------------------------
    // Window_ConceedCommand
    //
    // The window for selecting whether to fight or escape on the battle screen.

    function Window_ConceedCommand() {
        this.initialize(...arguments);
    }

    Window_ConceedCommand.prototype = Object.create(Window_Command.prototype);
    Window_ConceedCommand.prototype.constructor = Window_ConceedCommand;

    Window_ConceedCommand.prototype.initialize = function(rect) {
        //var y = Graphics.boxHeight - this.windowHeight();
        Window_Command.prototype.initialize.call(this, rect);
        this.openness = 0;
        this.deactivate();
    };

    Window_ConceedCommand.prototype.windowWidth = function() {
        return 240;
    };

    Window_ConceedCommand.prototype.windowHeight = function() {
        return 112;
    };

    Window_ConceedCommand.prototype.numVisibleRows = function() {
        return 2;
    };

    Window_ConceedCommand.prototype.makeCommandList = function() {
        this.addCommand(TextManager.cancel,  'no');
        this.addCommand(TextManager.concede, 'yes');
    };

    Window_ConceedCommand.prototype.setup = function() {
        this.clearCommandList();
        this.makeCommandList();
        this.refresh();
        this.select(0);
        this.activate();
        this.open();
    };

    Scene_Battle.prototype.commandStatus = function() {
        $gameTemp._isAnalyzeMode = false;
        $gameTemp._isAlly = true;
        SceneManager.push(Scene_Status);
    };

    Scene_Battle.prototype.commandTerrain = function() {
        this.battleBookAlly2();
        //SceneManager.push(Scene_Status);
    };

    Scene_Battle.prototype.commandConcede = function() {
        this._partyCommandWindow.close();
        this._partyCommandWindow.deselect();
        this._isConceedCheck = true;
        this._conceedCommandWindow.setup();
    };

    Scene_Battle.prototype.commandConceedYes = function()
    {
        this._conceedCommandWindow.close();
        this._conceedCommandWindow.deselect();
        BattleManager.endBattle(2);
        this._isConceedCheck = false;
    };
    
    Scene_Battle.prototype.commandConceedNo = function()
    {
        this._conceedCommandWindow.close();
        this._conceedCommandWindow.deselect();
        this._partyCommandWindow.setup();
        this._isConceedCheck = false;
    };

    Scene_Battle.prototype.partyCommandWindowRect = function() {
        const ww = 192;
        const wh = this.windowAreaHeight() + 48 + 24 ;
        const wx = Graphics.boxWidth - ww;
        const wy = Graphics.boxHeight - wh;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Battle.prototype.createConceedCommandWindow = function(){
        const rect = this.partyCommandWindowRect();
        this._conceedCommandWindow = new Window_ConceedCommand(rect);
        this._conceedCommandWindow.setHandler('no', this.commandConceedNo.bind(this));
        this._conceedCommandWindow.setHandler('yes', this.commandConceedYes.bind(this));
        this._conceedCommandWindow.setHandler('cancel', this.commandConceedNo.bind(this));
    
        this.addWindow(this._conceedCommandWindow);
    };

    Scene_Battle.prototype.createPartyCommandWindow = function() {
        const rect = this.partyCommandWindowRect();
        this._partyCommandWindow = new Window_PartyCommand(rect);
        this._partyCommandWindow.setHandler('fight',  this.commandFight.bind(this));
        this._partyCommandWindow.setHandler('status', this.commandStatus.bind(this));
        this._partyCommandWindow.setHandler('escape', this.commandEscape.bind(this));
        this._partyCommandWindow.setHandler('terrain', this.commandTerrain.bind(this));
        this._partyCommandWindow.setHandler('concede', this.commandConcede.bind(this));
        this._partyCommandWindow.setHandler("formation", this.commandFormation.bind(this));

        this._partyCommandWindow.deselect();
        this.addWindow(this._partyCommandWindow);
    };

    const Scene_Battle_CreateAllWindows = Scene_Battle.prototype.createAllWindows;
    Scene_Battle.prototype.createAllWindows = function() {
        Scene_Battle_CreateAllWindows.call(this);

        this.createConceedCommandWindow();
    };

    Window_PartyCommand.prototype.makeCommandList = function() {
        this.addCommand(TextManager.fight, "fight");
        this.addCommand(TextManager.checkStatus, "status", !$gameSwitches.value(20));

        this.addCommand(TextManager.formation, "formation");

        if(BattleManager.canEscape())
        {
            this.addCommand(TextManager.escape, "escape", );
        }
        else
        {
            this.addCommand(TextManager.concede, "concede", $gameTroop.troop().id != 6);
        }

        //this.addCommand(TextManager.checkTerrain, "terrain");
    };
    
    BattleManager.getTurnCount = function()
    {
        return this._turnCount;
    }

})();
