//=============================================================================
// RPG Maker MZ - ContinueCheck
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 敗北してもゲームオーバーにならずにコンティニューします。
 * @author カタコトトコトコ
 *
 * @help 
 */

(() => {

    BattleManager.updateBattleEnd = function() {
        if (this.isBattleTest()) {
            AudioManager.stopBgm();
            SceneManager.exit();
        } else if (!this._escaped && $gameParty.isAllDead()) {
            //if (this._canLose) {
                $gameParty.onBattleEnd();
                $gameTroop.onBattleEnd();
                $gameTemp.changeBattlebackDone();
                $gameParty.reviveBattleMembers();
                this.replayBgmAndBgs();
                SceneManager.pop();
            //}
            //ゲームオーバーを無しに
            //else {
            //     SceneManager.goto(Scene_Gameover);
            // }
        } else {
            this.replayBgmAndBgs();
            SceneManager.pop();
        }
        this._phase = "";
    };

    BattleManager.continueBattle = function()
    {
        //バトルシーン中限定
        let scene = SceneManager._scene;
    
        this.setup($gameTroop._troopId, false, false);
    
        scene.initialize();
    
        scene.create();
        scene.start();
    
        BattleManager.startBattle();
    
        //scene.forceCreateBattleHud()
    }

    BattleManager.endBattle = function(result) {
        this._phase = "battleEnd";
        this.cancelActorInput();
        this._inputting = false;
        let isReturnHome = false;

        if(result == 1)
        {
            if(!this._escaped)
            {
                result = 2;
                isReturnHome = true;
            }
        }
        if (this._eventCallback) {
            this._eventCallback(result);
        }
        if(isReturnHome)
        {
            $gameTemp.clearCommonEventReservation();
            BattleManager.returnHome();
            return;
        }
        if (result === 0) {
            $gameSystem.onBattleWin();
        } else if (this._escaped) {
            $gameSystem.onBattleEscape();
        }
        else if(result == 2)
        {
            if(this._isBoss)
            {
                this.onContinue();
            }
            else if(this._isDefeatEvent)
            {
                //負けイベ
                this._isDefeatEvent = false;
                //this._isBoss = false;
            }
            else
            {
                $gameTemp.clearCommonEventReservation();
                BattleManager.returnHome();
                return;
            }
        }

        $gameTemp.clearCommonEventReservation();
    };

    BattleManager.returnHome = function()
    {
        $gameTemp.reserveCommonEvent(1);
        /*
        const mapId = 2;
        const x = 11;
        const y = 6;
        const direction = 2;
        $gamePlayer.reserveTransfer(mapId, x, y,direction);
        this._isBoss = false;
        this._isDefeatEvent = false;
        */
    };

    BattleManager.setBossMode = function()
    {
        this._isBoss = true;
    };

    BattleManager.setBossModeEnd = function()
    {
        this._isBoss = false;
    };

    BattleManager.onContinue = function(){

        $gameParty.onBattleEnd();
        $gameTroop.onBattleEnd();
        $gameTemp.changeBattlebackDone();
        SceneManager._scene._cancelButton2.visible = false;
        this._phase = "continue";
         $gameMessage.add("コンティニューする？");
         $gameTroop._interpreter.setupChoices([["そのまま再戦","メニューを開いて再戦","拠点へ戻る"],-1,0,0,0]);
         $gameTroop._interpreter.setWaitMode('message');
    };

    BattleManager.updateNextBattle = function()
    {
        $gameParty.members().forEach(function(actor) {
            actor.recoverAll();
        });
        //console.log($dataMap.battleback1Name + " " + $dataMap.battlerback2Name);
        //$gameMap.changeBattleback($dataMap.battleback1Name, $dataMap.battlerback2Name);
        this.continueBattle();
    };

    BattleManager.updateContinue = function(){
        let interpreter = $gameTroop._interpreter;
        switch (interpreter._branch[interpreter._indent]) 
        {
            case 0: 
                this._phase = "nextBattle";
                break;
            case 1:
                $gameParty.members().forEach(function(actor) {
                    actor.recoverAll();
                 });
                SceneManager.push(Scene_Menu);
                $gameTemp._isAnalyzeMode = false;
                this._phase = "nextBattle";
                break;
            case 2:
                $gameParty.members().forEach(function(actor) {
                    actor.recoverAll();
                });
                this.abort();
                this.returnHome();
                break;
            default:
                return;
                break;
        }
    };


    BattleManager.update = function() {
        if(this.isBusy()){return;}
        if(this.updateEvent()) {return;}
        switch (this._phase)
        {
        case 'start':
            this.startInput();
            break;
        case 'turn':
            this.updateTurn();
            break;
        case 'action':
            this.updateAction();
            break;
        case 'turnEnd':
            this.updateTurnEnd();
            this._turnCount++;
            break;
        case 'battleEnd':
            this.updateBattleEnd();
            break;
        case 'continue':
            this.updateContinue();
            break;
        case 'nextBattle':
            this.updateNextBattle();
            break;
        default:
            $gameTroop.updateInterpreter();
        }
    };
})();
