//=============================================================================
// RPG Maker MZ - UUtilFunc
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 汎用関数群
 * @author カタコトトコトコ
 *
 * @help 
 */

(() => {
    TextManager.getter = function(method) {
        return {
            get: function() {
                for(let i = 0; i < $dataTexts.length; ++i)
                {
                    if($dataTexts[i].id == method)
                    {
                        return $dataTexts[i].jp;
                    }
                }
                console.log("error TextManager " + method);
                return "";
            },
            configurable: true
        };
    };

    Object.defineProperties(TextManager, {
        checkStatus:TextManager.getter('checkStatus'),
        checkTerrain:TextManager.getter('checkTerrain'),
        concede:TextManager.getter('concede'),
        nextPage:TextManager.getter('nextPage'),
        previousPage:TextManager.getter('previousPage'),
        learnBook:TextManager.getter('learnBook'),
        magic:TextManager.getter('magic'),
        turn:TextManager.getter('turn'),
        action:TextManager.getter('action'),
        passive:TextManager.getter('passive'),
        additionalEffect:TextManager.getter('additionalEffect'),
        maxhp:TextManager.getter('maxhp'),
        maxmp:TextManager.getter('maxmp'),
        maxtp:TextManager.getter('maxtp'),
        atk:TextManager.getter('atk'),
        def:TextManager.getter('def'),
        matk:TextManager.getter('matk'),
        mdef:TextManager.getter('mdef'),
        spd:TextManager.getter('spd'),
        luk:TextManager.getter('luk'),
        hit:TextManager.getter('hit'),
        agi:TextManager.getter('agi'),
        recovery:TextManager.getter('recovery'),
        addState:TextManager.getter('addState'),
        needCount:TextManager.getter('needCount'),
        hasCount:TextManager.getter('hasCount'),
        concede:TextManager.getter('concede'),
        physicalSkill:TextManager.getter('physicalSkill'),
        magicSkill:TextManager.getter('magicSkill'),
        assistSkill:TextManager.getter('assistSkill'),
        healSkill:TextManager.getter('healSkill'),
        none:TextManager.getter('none'),
        healPower:TextManager.getter('healPower'),
        power:TextManager.getter('power'),
        target:TextManager.getter('target'),
        dead:TextManager.getter('dead'),
        protect:TextManager.getter('protect'),
        regist:TextManager.getter('regist'),
        credits:TextManager.getter('credits'),
        laungage:TextManager.getter('laungage'),
        dropItem:TextManager.getter('dropItem'),
        checkStatus:TextManager.getter('checkStatus'),
        hpCost:TextManager.getter('hpCost'),
        countAttack:TextManager.getter('countAttack'),
        joinParty:TextManager.getter('joinParty'),
        returnHome:TextManager.getter('returnHome'),
        materialName:TextManager.getter('materialName'),
        elementName:TextManager.getter('elementName'),
        allElement:TextManager.getter('allElement'),
        fireElement:TextManager.getter('fireElement'),
        iceElement:TextManager.getter('iceElement'),
        thunderElement:TextManager.getter('thunderElement'),
        waterElement:TextManager.getter('waterElement'),
        soilElement:TextManager.getter('soilElement'),
        windElement:TextManager.getter('windElement'),
        holyElement:TextManager.getter('holyElement'),
        darkElement:TextManager.getter('darkElement'),
        noneElement:TextManager.getter('noneElement'),
        noneTS:TextManager.getter('noneTS'),
        oneEnemyTS:TextManager.getter('oneEnemyTS'),
        allEnemyTS:TextManager.getter('allEnemyTS'),
        oneRandomEnemyTS:TextManager.getter('oneRandomEnemyTS'),
        twoRandomEnemyTS:TextManager.getter('twoRandomEnemyTS'),
        threeRandomEnemyTS:TextManager.getter('threeRandomEnemyTS'),
        fourRandomEnemyTS:TextManager.getter('fourRandomEnemyTS'),
        oneAllyTS:TextManager.getter('oneAllyTS'),
        allAllyTS:TextManager.getter('allAllyTS'),
        oneDeadAllyTS:TextManager.getter('oneDeadAllyTS'),
        allDeadAllyTS:TextManager.getter('allDeadAllyTS'),
        userTS:TextManager.getter('userTS'),
        level:TextManager.getter('level'),
        levelA:TextManager.getter('levelA'),
        hp:TextManager.getter('hp'),
        hpA:TextManager.getter('hpA'),
        mp:TextManager.getter('mp'),
        mpA:TextManager.getter('mpA'),
        tp:TextManager.getter('tp'),
        tpA:TextManager.getter('tpA'),
        exp:TextManager.getter('exp'),
        expA:TextManager.getter('expA'),
        fight:TextManager.getter('fight'),
        escape:TextManager.getter('escape'),
        attack:TextManager.getter('attack'),
        guard:TextManager.getter('guard'),
        item:TextManager.getter('item'),
        skill:TextManager.getter('skill'),
        equip:TextManager.getter('equip'),
        status:TextManager.getter('status'),
        formation:TextManager.getter('formation'),
        save:TextManager.getter('save'),
        load:TextManager.getter('load'),
        gameEnd:TextManager.getter('gameEnd'),
        options:TextManager.getter('options'),
        weapon:TextManager.getter('weapon'),
        armor:TextManager.getter('armor'),
        keyItem:TextManager.getter('keyItem'),
        equip2:TextManager.getter('equip2'),
        optimize:TextManager.getter('optimize'),
        clear:TextManager.getter('clear'),
        newGame:TextManager.getter('newGame'),
        continue_:TextManager.getter('continue_'),
        toTitle:TextManager.getter('toTitle'),
        cancel:TextManager.getter('cancel'),
        buy:TextManager.getter('buy'),
        sell:TextManager.getter('sell'),
        alwaysDash:TextManager.getter('alwaysDash'),
        commandRemember:TextManager.getter('commandRemember'),
        touchUI:TextManager.getter('touchUI'),
        bgmVolume:TextManager.getter('bgmVolume'),
        bgsVolume:TextManager.getter('bgsVolume'),
        meVolume:TextManager.getter('meVolume'),
        seVolume:TextManager.getter('seVolume'),
        possession:TextManager.getter('possession'),
        expTotal:TextManager.getter('expTotal'),
        expNext:TextManager.getter('expNext'),
        saveMessage:TextManager.getter('saveMessage'),
        loadMessage:TextManager.getter('loadMessage'),
        file:TextManager.getter('file'),
        autosave:TextManager.getter('autosave'),
        partyName:TextManager.getter('partyName'),
        emerge:TextManager.getter('emerge'),
        preemptive:TextManager.getter('preemptive'),
        surprise:TextManager.getter('surprise'),
        escapeStart:TextManager.getter('escapeStart'),
        escapeFailure:TextManager.getter('escapeFailure'),
        victory:TextManager.getter('victory'),
        defeat:TextManager.getter('defeat'),
        obtainExp:TextManager.getter('obtainExp'),
        obtainGold:TextManager.getter('obtainGold'),
        obtainItem:TextManager.getter('obtainItem'),
        levelUp:TextManager.getter('levelUp'),
        obtainSkill:TextManager.getter('obtainSkill'),
        useItem:TextManager.getter('useItem'),
        criticalToEnemy:TextManager.getter('criticalToEnemy'),
        criticalToActor:TextManager.getter('criticalToActor'),
        actorDamage:TextManager.getter('actorDamage'),
        actorRecovery:TextManager.getter('actorRecovery'),
        actorGain:TextManager.getter('actorGain'),
        actorLoss:TextManager.getter('actorLoss'),
        actorDrain:TextManager.getter('actorDrain'),
        actorNoDamage:TextManager.getter('actorNoDamage'),
        actorNoHit:TextManager.getter('actorNoHit'),
        enemyDamage:TextManager.getter('enemyDamage'),
        enemyRecovery:TextManager.getter('enemyRecovery'),
        enemyGain:TextManager.getter('enemyGain'),
        enemyLoss:TextManager.getter('enemyLoss'),
        enemyDrain:TextManager.getter('enemyDrain'),
        enemyNoDamage:TextManager.getter('enemyNoDamage'),
        enemyNoHit:TextManager.getter('enemyNoHit'),
        evasion:TextManager.getter('evasion'),
        magicEvasion:TextManager.getter('magicEvasion'),
        magicReflection:TextManager.getter('magicReflection'),
        counterAttack:TextManager.getter('counterAttack'),
        substitute:TextManager.getter('substitute'),
        buffAdd:TextManager.getter('buffAdd'),
        debuffAdd:TextManager.getter('debuffAdd'),
        buffRemove:TextManager.getter('buffRemove'),
        actionFailure:TextManager.getter('actionFailure'),
    });
    
    TextManager.param = function(paramId) {
        switch(paramId)
        {
            case 0:
                return TextManager.hp;
            case 1:
                return TextManager.mp;
            case 2:
                return TextManager.atk;
            case 3:
                return TextManager.def;
            case 4:
                return TextManager.matk;
            case 5:
                return TextManager.mdef;
            case 6:
                return TextManager.spd;
            case 7:
                return TextManager.luk;
            default:
                return 'undefined param %1'.format(paramId);
        }
    };
    
    TextManager.element = function(index)
    {
        switch(index)
        {
            case 0:
                return TextManager.fireElement;
            case 1:
                return TextManager.iceElement;
            case 2:
                return TextManager.thunderElement;
            case 3:
                return TextManager.waterElement;
            case 4:
                return TextManager.soilElement;
            case 5:
                return TextManager.windElement;
            case 6:
                return TextManager.holyElement;
            case 7:
                return TextManager.darkElement;
            default:
                return TextManager.noneElement;
        }
    };
    
    TextManager.targetScope = function(index)
    {
        switch(index)
        {
            default:
                return index;
            case 0:
                return TextManager.noneTS;
            case 1:
                return TextManager.oneEnemyTS;
            case 2:
                return TextManager.allEnemyTS;
            case 3:
                return TextManager.oneRandomEnemyTS;
            case 4:
                return TextManager.twoRandomEnemyTS;
            case 5:
                return TextManager.threeRandomEnemyTS;
            case 6:
                return TextManager.fourRandomEnemyTS;
            case 7:
                return TextManager.oneAllyTS;
            case 8:
                return TextManager.allAllyTS;
            case 9:
                return TextManager.oneAllyTS;
                //scope = '味方単体(戦闘不能含む)';
            case 10:
                return TextManager.allAllyTS;
                //scope = '味方全体(戦闘不能含む)';
            case 11:
                return TextManager.userTS;
            case 12:
                return TextManager.oneAllyTS;
                    //scope = '味方単体(戦闘不能含む)';
            case 13:
                return TextManager.allAllyTS;
                            //scope = '味方単体(戦闘不能含む)';
        }
    };
    
    TextManager.currencyUnit = function()
    {
        return 'EP';
    };
    
    //称号
    TextManager.actorTitle = function(actor)
    {
        switch(ConfigManager.laungage)
        {
            case 2:
                return actor.currentClass().meta.cn;
            case 1:
                return actor.currentClass().meta.en;
            case 0:
            default:
                return actor.currentClass().name.split(':')[0];
        }
    }
    
    TextManager.hpCost = function(value)
    {
        return TextManager.getter("hpCost").format(value);
    };
    
    TextManager.countAttack = function(value)
    {
        return TextManager.getter("countAttack").format(value);
    };
    
    TextManager.joinParty = function(value)
    {
        return TextManager.getter("joinParty").format(value);
    };

})();
