//=============================================================================
// RPG Maker MZ - 
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 
 * @author 
 *
 * @help EventViewerScene2
 */

(() => {
'user strict'

Game_Interpreter.prototype.goSceneEventViewer = function()
{
    SceneManager.push(Scene_EventViewer);
};

//-----------------------------------------------------------------------------
// Window_EventViewerList
//
// The window for selecting an item on the item screen.

function Window_EventViewerList() {
    this.initialize(...arguments);
}

Window_EventViewerList.prototype = Object.create(Window_Selectable.prototype);
Window_EventViewerList.prototype.constructor = Window_EventViewerList;

Window_EventViewerList.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    
    this._data = [];
    this.refresh();
    this.scrollTo(0, 0);
};

Window_EventViewerList.prototype.itemWidth = function() {
    return Math.floor(this.innerWidth / this.maxCols());
};

Window_EventViewerList.prototype.itemHeight = function() {
    return Math.floor(this.innerHeight / this.numVisibleRows());
};

Window_EventViewerList.prototype.maxCols = function() {
    return 3;
};

Window_EventViewerList.prototype.numVisibleRows = function() {
    return 3;
};

Window_EventViewerList.prototype.colSpacing = function() {
    return 3;
};

Window_EventViewerList.prototype.rowSpacing = function() {
    return 3;
};


Window_EventViewerList.prototype.maxItems = function() {
    return 9;
};

Window_EventViewerList.prototype.item = function() {
    return this.itemAt(this.index());
};

Window_EventViewerList.prototype.itemAt = function(index) {
    return this._data && index >= 0 ? this._data[index] : null;
};

Window_EventViewerList.prototype.isCurrentItemEnabled = function() {
    return this.isEnabled(this.item());
};

Window_EventViewerList.prototype.includes = function(item) {
    switch (this._category) {
        case "item":
            return DataManager.isItem(item) && item.itypeId === 1;
        case "weapon":
            return DataManager.isWeapon(item);
        case "armor":
            return DataManager.isArmor(item);
        case "keyItem":
            return DataManager.isItem(item) && item.itypeId === 2;
        default:
            return false;
    }
};

Window_EventViewerList.prototype.drawAllItems = function() {
    const topIndex = this.topIndex();
    for (let i = 0; i < this.maxVisibleItems(); i++) {
        const index = topIndex + i;
        if (index < this.maxItems()) {
            this.drawItemBackground(index);
            this.drawItem(index);
        }
    }
};

Window_EventViewerList.prototype.needsNumber = function() {
    if (this._category === "keyItem") {
        return $dataSystem.optKeyItemsNumber;
    } else {
        return true;
    }
};

Window_EventViewerList.prototype.isEnabled = function(item) {
    return true;
};

Window_EventViewerList.prototype.makeItemList = function() {
    if($gamePlayer._eventPage < 0)
    {
        $gamePlayer._eventPage = 2;//Math.ceil($dataEventList.length / 9.0) - 1;
    }
    else if(($gamePlayer._eventPage * 9 + 1) >= $dataEventList.length)
    {
        $gamePlayer._eventPage = 0;
    }

    this._data = [];

    for(let i = 0; i < 9; ++i)
    {
        this._data.push( $gamePlayer._eventPage * 9 + i );
    }
};

Window_EventViewerList.prototype.selectLast = function() {
    const index = this._data.indexOf($gameParty.lastItem());
    this.forceSelect(index >= 0 ? index : 0);
};

Window_EventViewerList.prototype.select = function(index) {
    this._index = index;

    if( this._headderWindow )
    {
        this._headderWindow.contents.clear();

        const item = this.itemAt(index);
        if(item < $dataEventList.length)
        {
            if(item >= 0)
            {
                    const path = $dataEventList[item].name;
                    // if($gamePlayer.hasFlag(path))
                    // {
                    //     return;
                    // }
                
                this._headderWindow.drawTextEx( path, 0, 0 );

            }
        }
    
        
    

    }

    this.refreshCursor();
    this.callUpdateHelp();
};

Window_EventViewerList.prototype.drawItem = function(index) {
    const item = this.itemAt(index);
    const rect = this.itemRect(index);

    if(item >= $dataEventList.length)
    {
        return;
    }

    if(item < 0)
    {
        return;
    }

    const path = $dataEventList[item].path;
    $gameTemp._eventName = path;



    this.drawText(item + 1, rect.x, rect.y, rect.width);
    //const x =  rect.x + 4;
    const y = rect.y;
    const h = rect.height;
    const w = h * 1110 / 624.0;
    const x = (rect.width - w) / 2 + rect.x;
    //const w = rect.width - 4 - 4;
    //const h = w * 624.0 / 1110;

    if(!$gamePlayer.hasFlag(path))
    {
        return;
    }

    const array = $dataEventList[item].thumb.split(',');
    const dir = $dataEventList[item].dir;
    for(let i = 0; i < array.length; ++i)
    {
        this.drawPicture( 'still/' + dir + '/' + array[i],x, y, w, h);
    }

    // if (item) {
    //     const numberWidth = this.numberWidth();
    //     const rect = this.itemRect(index);
    //     this.changePaintOpacity(this.isEnabled(item));
    //     this.drawItemName(item, rect.x, rect.y, rect.width - numberWidth);
    //     this.drawItemNumber(item, rect.x, rect.y, rect.width);
    //     this.changePaintOpacity(1);
    // }
};

Window_EventViewerList.prototype.update = function() {
    this.processCursorMove();
    this.processHandling();
    this.processTouch();
    this.refresh();


    if (Input.isTriggered("pagedown")) { 
        this.pageDown();
    }

    if (Input.isTriggered("pageup")) {
        this.pageUp();
    }

    Window_Scrollable.prototype.update.call(this);
};

Window_EventViewerList.prototype.numberWidth = function() {
    return this.textWidth("000");
};

Window_EventViewerList.prototype.drawItemNumber = function(item, x, y, width) {
    // if (this.needsNumber()) {
    //     this.drawText(":", x, y, width - this.textWidth("00"), "right");
    //     this.drawText($gameParty.numItems(item), x, y, width, "right");
    // }
};

Window_EventViewerList.prototype.updateHelp = function() {
    this.setHelpWindowItem(this.item());
};

Window_EventViewerList.prototype.refresh = function() {
    this.makeItemList();
    Window_Selectable.prototype.refresh.call(this);
};

Window_EventViewerList.prototype.cursorDown = function(wrap) {
    const index = this.index();
    const maxItems = this.maxItems();
    const maxCols = this.maxCols();
    if (index < maxItems - maxCols || (wrap && maxCols === 1)) {
        this.smoothSelect((index + maxCols) % maxItems);
    }
};

Window_EventViewerList.prototype.cursorUp = function(wrap) {
    const index = Math.max(0, this.index());
    const maxItems = this.maxItems();
    const maxCols = this.maxCols();
    if (index >= maxCols || (wrap && maxCols === 1)) {
        this.smoothSelect((index - maxCols + maxItems) % maxItems);
    }
};

Window_EventViewerList.prototype.cursorRight = function(wrap) {
    const index = this.index();
    const maxItems = this.maxItems();
    const maxCols = this.maxCols();
    const horizontal = this.isHorizontal();

    if((index + 1) % 3 == 0)
    {
        this.pageDown();

        return;
    }

    if (maxCols >= 2 && (index < maxItems - 1 || (wrap && horizontal))) {
        this.smoothSelect((index + 1) % maxItems);
    }
};
Window_EventViewerList.prototype.cursorLeft = function(wrap) {
    const index = Math.max(0, this.index());
    const maxItems = this.maxItems();
    const maxCols = this.maxCols();
    const horizontal = this.isHorizontal();

    if(index % 3 == 0)
    {
        this.pageUp();

        return;
    }

    if (maxCols >= 2 && (index > 0 || (wrap && horizontal))) {
        this.smoothSelect((index - 1 + maxItems) % maxItems);
    }
};
Window_EventViewerList.prototype.pageDown = function()
{
    SoundManager.playCursor();
    $gamePlayer._eventPage++;
    const index = this.index();

    this.smoothSelect(index);
};

Window_EventViewerList.prototype.pageUp = function()
{
    SoundManager.playCursor();
    $gamePlayer._eventPage--;
    const index = this.index();

    this.smoothSelect(index);
};

Window_EventViewerList.prototype.cursorPagedown = function() {
    const index = this.index();
    const maxItems = this.maxItems();
    if (this.topRow() + this.maxPageRows() < this.maxRows()) {
        this.smoothScrollDown(this.maxPageRows());
        this.select(Math.min(index + this.maxPageItems(), maxItems - 1));
    }
};

Window_EventViewerList.prototype.cursorPageup = function() {
    const index = this.index();
    if (this.topRow() > 0) {
        this.smoothScrollUp(this.maxPageRows());
        this.select(Math.max(index - this.maxPageItems(), 0));
    }
};

Window_EventViewerList.prototype.setHelpWindow = function( w ) {
    this._headderWindow = w;
};

Window_Base.prototype.drawPicture = function(name, x, y, w, h) {
    const bitmap = ImageManager.loadPicture(name);
    this.contents.blt(bitmap, 0,0,bitmap.width, bitmap.height, x, y, w, h);
};

//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Scene_EventViewer
//
// The scene class of the menu screen.

function Scene_EventViewer() {
    this.initialize(...arguments);
}

Scene_EventViewer.prototype = Object.create(Scene_Base.prototype);
Scene_EventViewer.prototype.constructor = Scene_EventViewer;

Scene_EventViewer.prototype.initialize = function() {
    Scene_Base.prototype.initialize.call(this);
};

Scene_EventViewer.prototype.helpAreaHeight = function() {
    return 0;
};

Scene_EventViewer.prototype.create = function() {
    Scene_Base.prototype.create.call(this);
    this.createWindowLayer();
    this.createHeadderWindow();
    this.createCommandWindow();
    this.createPageButtons();
    this.createCancelButton();
};

Scene_EventViewer.prototype.start = function() {
    Scene_Base.prototype.start.call(this);
};

Scene_EventViewer.prototype.needsPageButtons = function() {
    return true;
};

Scene_EventViewer.prototype.createCancelButton = function() {
    this._cancelButton = new Sprite_Button("cancel");
    this._cancelButton.x = Graphics.boxWidth - this._cancelButton.width - 4;
    //this._cancelButton.x = Graphics.boxWidth - this._cancelButton.width - 4;
    this._cancelButton.y = this.buttonY() + 48 + 16;
    this.addWindow(this._cancelButton);
};

Scene_EventViewer.prototype.createPageButtons = function() {
    this._pageupButton = new Sprite_Button("pageup");
    this._pageupButton.x = 4;
    this._pageupButton.y = Graphics.boxHeight - 48 - 4;
    //const pageupRight = this._pageupButton.x + this._pageupButton.width;
    this._pagedownButton = new Sprite_Button("pagedown");
    this._pagedownButton.x = (Graphics.boxWidth - Graphics.uiWidth ) + Graphics.uiWidth - this._pagedownButton.width - 4;
    this._pagedownButton.y = Graphics.boxHeight - 48 - 4;
    this.addWindow(this._pageupButton);
    this.addWindow(this._pagedownButton);
    this._pageupButton.setClickHandler(this.previousActor.bind(this));
    this._pagedownButton.setClickHandler(this.nextActor.bind(this));
};

Scene_EventViewer.prototype.createHeadderWindow = function() {
    const commandWindow = new Window_Base(
        new Rectangle(0, 64, Graphics.boxWidth - 128, 120 - 64));

    this.addWindow(commandWindow);

    this._headderWindow = commandWindow;
};

Scene_EventViewer.prototype.createCommandWindow = function() {

    const commandWindow = new Window_EventViewerList(
        new Rectangle(0, 120, Graphics.boxWidth, Graphics.boxHeight - 120 - 48 - 8));
        
    commandWindow.setHelpWindow( this._headderWindow );

    commandWindow.setHandler("cancel", this.popScene.bind(this));
    commandWindow.setHandler("ok", this.onOk.bind(this));
    this.addWindow(commandWindow);
    commandWindow.select(0);
    commandWindow.activate();
    this._commandWindow = commandWindow;

};

Scene_EventViewer.prototype.onOk = function()
{
    let w = this._commandWindow;
    const path = $dataEventList[w.item()].path;
        
    if(!$gamePlayer.hasFlag(path))
    {
        w.playBuzzerSound();

        w.activate();

        return;
    }
    w.playOkSound();

    $gameTemp.reserveCommonEvent(41);
    $gameTemp._beginEventName = path;
    SceneManager._scene.popScene();

    // const path = $dataEventList[this._commandWindow.item()].path;
    // $gameTemp._eventName = path;

    // if($gamePlayer.hasFlag(path))
    // {
    //     //this._commandWindow.onOk();
    //     this._commandWindow.close();
    //     SoundManager.playOk();
    //     this.popScene();
    //     $gameMap._interpreter._waitMode = '';
    // }
    // else
    // {
    //     SoundManager.playBuzzer();
    //     this._commandWindow.activate();
    // }
};

Scene_EventViewer.prototype.nextActor = function() {
    this._commandWindow.pageDown();
};

Scene_EventViewer.prototype.previousActor = function() {
    this._commandWindow.pageUp();
};

Scene_EventViewer.prototype.statusWindowRect = function() {
    const ww = Graphics.boxWidth - this.mainCommandWidth();
    const wh = this.mainAreaHeight();
    const wx = this.isRightInputMode() ? 0 : Graphics.boxWidth - ww;
    const wy = this.mainAreaTop();
    return new Rectangle(wx, wy, ww, wh);
};

Scene_EventViewer.prototype.commandItem = function() {
    SceneManager.push(Scene_Item);
};

Scene_EventViewer.prototype.commandPersonal = function() {
    this._statusWindow.setFormationMode(false);
    this._statusWindow.selectLast();
    this._statusWindow.activate();
    this._statusWindow.setHandler("ok", this.onPersonalOk.bind(this));
    this._statusWindow.setHandler("cancel", this.onPersonalCancel.bind(this));
};

Scene_EventViewer.prototype.commandFormation = function() {
    this._statusWindow.setFormationMode(true);
    this._statusWindow.selectLast();
    this._statusWindow.activate();
    this._statusWindow.setHandler("ok", this.onFormationOk.bind(this));
    this._statusWindow.setHandler("cancel", this.onFormationCancel.bind(this));
};

Scene_EventViewer.prototype.onPersonalCancel = function() {
    this._statusWindow.deselect();
    this._commandWindow.activate();
};

Scene_EventViewer.prototype.onFormationOk = function() {
    const index = this._statusWindow.index();
    const pendingIndex = this._statusWindow.pendingIndex();
    if (pendingIndex >= 0) {
        $gameParty.swapOrder(index, pendingIndex);
        this._statusWindow.setPendingIndex(-1);
        this._statusWindow.redrawItem(index);
    } else {
        this._statusWindow.setPendingIndex(index);
    }
    this._statusWindow.activate();
};

Scene_EventViewer.prototype.onFormationCancel = function() {
    if (this._statusWindow.pendingIndex() >= 0) {
        this._statusWindow.setPendingIndex(-1);
        this._statusWindow.activate();
    } else {
        this._statusWindow.deselect();
        this._commandWindow.activate();
    }
};

})();
