//=============================================================================
// RPG Maker MZ - blank
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 
 * @author 
 *
 * @help TextPicture.js
 */

(() => {
    
Game_Actor.prototype.paramBase = function(paramId) {

    let exParam = 0;
    if( this._exParam != undefined )
    {
        exParam = this._exParam;
    }

    // if(exParam <= 2)
    // {
    //     exParam = 0;
    // }
    // else
    // {
    //     exParam -= 2;
    // }

    if( paramId == 1 )
    {
        return 100 + exParam * 25;
    }

    if(paramId == 6)
    {
        return this.currentClass().params[paramId][1];
    }





    return this.currentClass().params[paramId][1] * this._level + this._level * exParam * 5;
};

// Game_Enemy.prototype.traitObjects = function() {
//     // if( this.enemy().meta.baseTrait )
//     // {
//     //     return Game_Battler.prototype.traitObjects.call(this).concat($dataEnemies[Number(this.enemy().meta.baseTrait)]);
//     // }
//     return Game_Battler.prototype.traitObjects.call(this).concat(this.enemy());
// };

Game_Enemy.prototype.paramBase = function(paramId) {



    let enemy = this.enemy();



    if( enemy.meta.base )
    {
        enemy = $dataEnemies[Number(this.enemy().meta.base)];
    }
    if( paramId == 1 )
        {
            return Math.max( enemy.params[paramId], 100 );
        }
    if(paramId == 6)
    {
        return enemy.params[paramId];
    }
    
    return enemy.params[paramId] * this._level;
};

Game_Enemy.prototype.setup = function(enemyId, x, y) {
    this._enemyId = enemyId;
    this._screenX = x;
    this._screenY = y;

    if( this.enemy().meta.base )
    {
        let value  = $dataEnemies[Number(this.enemy().meta.base)].meta.level;
        let exprate  = $dataEnemies[Number(this.enemy().meta.base)].meta.exprate;
        this._level =  value ? Number(value): 1;
        this._expRate = exprate ? Number(exprate) : 0.2;
    }
    else
    {
        this._level = this.enemy().meta.level ? Number(this.enemy().meta.level) : 1;
        this._expRate = this.enemy().meta.exprate ? Number(this.enemy().meta.exprate) : 0.2;
    }

    this.recoverAll();
};

Game_Enemy.prototype.originalName = function() {
    let text = this.enemy().name;

    /* eslint no-control-regex: 0 */
    text = text.replace(/\\/g, "\x1b");
    text = text.replace(/\x1b\x1b/g, "\\");
    while (text.match(/\x1bV\[(\d+)\]/gi)) {
        text = text.replace(/\x1bV\[(\d+)\]/gi, (_, p1) =>
            $gameVariables.value(parseInt(p1))
        );
    }

    text = text.replace(/\x1bN\[(\d+)\]/gi, (_, p1) =>
    {
        const actor = p1 >= 1 ? $gameActors.actor(p1) : null;
        return actor ? actor.name() : "";
    }
    );
    return text;
};

})();
