//=============================================================================
// RPG Maker MZ - LargeSkillHelpWindow
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc スキル説明ウィンドウが大きくなります
 * @author カタコトトコトコ
 *
 * @help
 */

(() => {

    Scene_Skill.prototype.mainAreaHeight = function() {
        return Graphics.boxHeight - this.buttonAreaHeight();
    };

    Scene_Base.prototype.itemWindowRectBase2 = function()
    {
        const adJustY = 70;
        const wx = -20;
        const wy = 48 + 4;
        const ww = 240 + 20;//Graphics.uiWidth * 0.4 + iconWidth;
        const wh = Graphics.boxHeight - wy - adJustY;
        return new Rectangle(wx, wy, ww, wh);
    }

    Scene_Base.prototype.itemWindowRectBase = function()
    {
        const adJustY = 70;
        const iconWidth = 48 + 24;
        const wx = (Graphics.boxWidth - Graphics.uiWidth - 96) / 2;
        const wy = 48 + 4;
        const ww = Graphics.uiWidth * 0.4 + iconWidth;
        const wh = Graphics.boxHeight - wy - adJustY;
        return new Rectangle(wx, wy, ww, wh);
    }
    Scene_Base.prototype.helpWindowRectBase3 = function()
    {
        const adJustY = 70;
        const wx = 546 - 42;
        const wy = 48 +8;
        const ww = 496;//Graphics.uiWidth * 0.4 + iconWidth;
        const wh = Graphics.boxHeight - wy - adJustY +4;
        return new Rectangle(wx, wy, ww, wh);
    }
    Scene_Base.prototype.helpWindowRectBase = function()
    {
        let rect = this.oneLineWindowRect();
        const adJustY = 23;
        const iconWidth = 48 + 24;
        const wx = Graphics.uiWidth * 0.4 + iconWidth;
        rect.y = 48 + 4 + 64;
        const ww = Graphics.boxWidth - wx - 192;
        
        rect.height = Graphics.boxHeight - rect.y - 70;
        return rect;
    }

    Scene_Base.prototype.helpWindowRectBase2 = function()
    {
        let rect = this.oneLineWindowRect();
        const adJustY = 23;
        const iconWidth = 48 + 24;
        const wx = Graphics.uiWidth * 0.4 + iconWidth;
        //rect.y = 48 + 4 + 64;
        const ww = Graphics.boxWidth - wx - 192;
        
        rect.height = Graphics.boxHeight - rect.y - 70;
        return rect;
    }

    Scene_Skill.prototype.itemWindowRect = function() {
        return this.itemWindowRectBase();
    };

    Scene_State.prototype.helpWindowRect = function() {
        return this.helpWindowRectBase();
    };

    Scene_Battle.prototype.skillWindowRect = function() {
        let rect = this.itemWindowRectBase();
        rect.y += 4;
        rect.x += 12;
        return rect;
    };

    Window_SkillList.prototype.maxCols = function() {
        return 1;
    };

    Window_BattleItem.prototype.maxCols = function() {
        return 1;
    };
})();
