//=============================================================================
// RPG Maker MZ - LoadXlsxDatabase
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc xlsxファイルをデータベースとして読み込みます
 * @author カタコトトコトコ
 *
 * @help 
 */

(() => {

    DataManager._databaseXlsxFiles = [
        { name: "$dataMapPos", src: "MapPos" },
        { name: "$dataSimpleMap", src: "SimpleMap"},
        { name: "$dataWarpList", src: "WarpList"},
        { name: "$dataMapData", src: "MapData"},
        { name: "$dataEventList", src: "EventList"},
        { name: "$dataTexts", src: "Texts"},
    ];

    //データベース読み込み完了時に呼ばれる処理
    const _SceneBoot_OnDatabaseLoaded = Scene_Boot.prototype.onDatabaseLoaded;
    Scene_Boot.prototype.onDatabaseLoaded = function() {
        _SceneBoot_OnDatabaseLoaded.call(this);

        console.log("データベース読み込み完了");

        {
            let array = $dataSkills;
            for(let i = 0; i < array.length; ++i)
            {
                const d = array[i];
                if(!d){continue;}

                if(d.stypeId == 3)
                {
                    $dataSkills[i].occasion = 3;
                    $dataSkills[i].mpCost = 0;
                    $dataSkills[i].tpCost = 0;
                }
                else if(d.stypeId == 2)
                {
                    $dataSkills[i].tpGain = 10;
                    //$dataSkills[i].meta.QuickSkill = true;
                }

                if(d.damage.type == 3)
                {
                    $dataSkills[i].occasion = 0;
                }
                else if(d.damage.type == 1)
                {
                    $dataSkills[i].occasion = 1;
                }
            }
        }

        {
            let array = $dataArmors;
            for(let i = 0; i < array.length; ++i)
            {
                const d = array[i];
                if(!d){continue;}
                
                if(d.etypeId == 5)
                {
                    $dataArmors[i].iconIndex = 144;
                    continue;
                }

                if(d.etypeId != 6)
                {
                    continue;
                }
                
                if(d.traits.length != 1)
                {
                    continue;
                }

                if(d.traits[0].code != 43)
                {
                    continue;
                }

                const skillId = d.traits[0].dataId;

                $dataArmors[i].name = '魔石「' + $dataSkills[skillId].name + '」';

                $dataArmors[i].iconIndex = $dataSkills[skillId].iconIndex;
                $dataArmors[i].meta.iconLevel = $dataSkills[skillId].meta.iconLevel;

                switch($dataSkills[skillId].meta.iconLevel)
                {
                    case 1:
                    $dataArmors[i].price = 300;
                        break;
                    case 2:
                    $dataArmors[i].price = 1500;
                        break;
                    case 3:
                        $dataArmors[i].price = 3000;
                        break;
                    case 4:
                    $dataArmors[i].price = 7500;
                        break;
                    case 5:
                    $dataArmors[i].price = 10000;
                        break;
                    default:
                        $dataArmors[i].price = 100;
                        break;
                }

            }
        }

    };

    DataManager.loadDataFileXlsx = function(name, src)
    {
        let xhr = null;
    
        try { xhr = new ActiveXObject("Microsoft.XMLHTTP"); } catch (e) { xhr = new XMLHttpRequest(); }
        const path = "extdata/" + src + ".dd"; // 読み込む外部ファイル
        window[name] = null;
        xhr.open("GET", path, true);
        xhr.responseType = 'arraybuffer';
        xhr.onreadystatechange = function(){
            //var data = xhr.responseText; // 外部ファイルの内容
            const data = new Uint8Array(xhr.response);
            const f =new Blob([data], {type:"application/octet-stream"});
            const er = new ExcelJs.Reader(f, function (e, xlsx) {
    
                const json = xlsx.toJson();
    
                if(!json.Sheet1)
                {
                    return;
                }
    
                const datum = json.Sheet1;
                console.log('%1.xlsx読み込み完了'.format(src));
                window[name] = datum;
            });
        };
        xhr.send();
    }

    const _DataManager_LoadDatabase = DataManager.loadDatabase;
    DataManager.loadDatabase = function() {
        _DataManager_LoadDatabase.call(this);
        const test = this.isBattleTest() || this.isEventTest();
        const prefix = test ? "Test_" : "";
        for (const databaseFile of this._databaseXlsxFiles) {
            this.loadDataFileXlsx(databaseFile.name, prefix + databaseFile.src);
        }
    };

    const _DataManager_isDatabaseLoaded = DataManager.isDatabaseLoaded;
    DataManager.isDatabaseLoaded = function() {
        var ret = _DataManager_isDatabaseLoaded.call(this);
        if(!ret)
        {
            return false;
        }
        for (const databaseFile of this._databaseXlsxFiles) {
            if (!window[databaseFile.name]) {
                return false;
            }
        }
        return true;
    };
})();
