//=============================================================================
// RPG Maker MZ - MVAnimation
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc スキルに<ismv>があればmvアニメーションになります。
 * @author カタコトトコトコ
 *
 * @help TextPicture.js
 *
 * このプラグインは、テキストをピクチャとして表示するコマンドを提供します。
 *
 * 次の手順で使用してください。
 *   1. プラグインコマンド「テキストピクチャの設定」を呼び出します。
 *   2. 画像を指定せずに「ピクチャの表示」を実行します。
 *
 * @command set
 * @text テキストピクチャの設定
 * @desc ピクチャとして表示するテキストを設定します。
 *       この後、画像を指定せずに「ピクチャの表示」を実行してください。
 *
 * @arg text
 * @type multiline_string
 * @text テキスト
 * @desc ピクチャとして表示するテキストです。
 *       制御文字が使用可能です。
 */

(() => {

    DataManager._databaseFiles = [
        { name: "$dataActors", src: "Actors.json" },
        { name: "$dataClasses", src: "Classes.json" },
        { name: "$dataSkills", src: "Skills.json" },
        { name: "$dataItems", src: "Items.json" },
        { name: "$dataWeapons", src: "Weapons.json" },
        { name: "$dataArmors", src: "Armors.json" },
        { name: "$dataEnemies", src: "Enemies.json" },
        { name: "$dataTroops", src: "Troops.json" },
        { name: "$dataStates", src: "States.json" },
        { name: "$dataAnimations", src: "Animations.json" },
        { name: "$dataAnimationsOld", src: "AnimationsOld.json" },
        { name: "$dataTilesets", src: "Tilesets.json" },
        { name: "$dataCommonEvents", src: "CommonEvents.json" },
        { name: "$dataSystem", src: "System.json" },
        { name: "$dataMapInfos", src: "MapInfos.json" }
    ];

    Window_BattleLog.prototype.startAction = function(subject, action, targets) {
        const item = action.item();
        this.push("performActionStart", subject, action);
        this.push("waitForMovement");
        this.push("performAction", subject, action);
        
        if(item.meta.ismv)
        {
            this.push("showAnimationOld", subject, targets.clone(), item.animationId);
        }
        else
        {
            this.push("showAnimation", subject, targets.clone(), item.animationId);
        }
    
        this.displayAction(subject, item);
    };

    // prettier-ignore
    Game_Temp.prototype.requestAnimation = function(
        targets, animationId, mirror = false
    ) {
        if ($dataAnimations[animationId]) {
            const request = {
                targets: targets,
                animationId: animationId,
                mirror: mirror,
                isOld: false
            };
            this._animationQueue.push(request);
            for (const target of targets) {
                if (target.startAnimation) {
                    target.startAnimation();
                }
            }
        }
    };

    Game_Temp.prototype.requestAnimationOld = function(
        targets, animationId, mirror = false
    ) {
        if ($dataAnimationsOld[animationId]) {
            const request = {
                targets: targets,
                animationId: animationId,
                mirror: mirror,
                isOld: true
            };
            this._animationQueue.push(request);
            for (const target of targets) {
                if (target.startAnimation) {
                    target.startAnimationOld();
                }
            }
        }
    };

    Game_CharacterBase.prototype.startAnimationOld = function() {
        this._animationPlayingOld = true;
    };


    Game_CharacterBase.prototype.endAnimationOld = function() {
        this._animationPlayingOld = false;
    };

    Spriteset_Base.prototype.createAnimationOld = function(request) {
        const animation = $dataAnimationsOld[request.animationId];
        const targets = request.targets;
        const mirror = request.mirror;
        let delay = this.animationBaseDelay();
        const nextDelay = this.animationNextDelay();
        if (this.isAnimationForEach(animation)) {
            for (const target of targets) {
                this.createAnimationSprite([target], animation, mirror, delay);
                delay += nextDelay;
            }
        } else {
            this.createAnimationSprite(targets, animation, mirror, delay);
        }
    };

    Window_BattleLog.prototype.showAnimationOld = function(
        subject, targets, animationId
    ) {
        if (animationId < 0) {
            this.showAttackAnimationOld(subject, targets);
        } else {
            this.showNormalAnimationOld(targets, animationId);
        }
    };

    Window_BattleLog.prototype.showAttackAnimationOld = function(subject, targets) {
        if (subject.isActor()) {
            this.showActorAttackAnimationOld(subject, targets);
        } else {
            this.showEnemyAttackAnimation(subject, targets);
        }
    };


    // prettier-ignore
    Window_BattleLog.prototype.showNormalAnimationOld = function(
        targets, animationId, mirror
    ) {
        const animation = $dataAnimationsOld[animationId];
        if (animation) {
            $gameTemp.requestAnimationOld(targets, animationId, mirror);
        }
    };


    // prettier-ignore
    Window_BattleLog.prototype.showActorAttackAnimationOld = function(
        subject, targets
    ) {
        this.showNormalAnimationOld(targets, subject.attackAnimationId1(), false);
        this.showNormalAnimationOld(targets, subject.attackAnimationId2(), true);
    };


    Spriteset_Base.prototype.removeAnimation = function(sprite) {
        this._animationSprites.remove(sprite);
        this._effectsContainer.removeChild(sprite);
        for (const target of sprite.targetObjects) {
            if (target.endAnimation) {
                target.endAnimation();
            }
            if(target.endAnimationOld)
            {
                target.endAnimationOld();
            }
        }
        sprite.destroy();
    };


    Spriteset_Base.prototype.processAnimationRequests = function() {
        for (;;) {
            const request = $gameTemp.retrieveAnimation();
            if (request) {
                if(request.isOld)
                {
                    this.createAnimationOld(request);
                }
                else
                {
                    this.createAnimation(request);
                }
            } else {
                break;
            }
        }
    };


})();
