//=============================================================================
// RPG Maker MZ - SimpleResult
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc リザルトがシンプルになります
 * @author カタコトトコトコ
 *
 * @help 
 */

(() => {

    BattleManager.processVictory = function() {
        $gameParty.removeBattleStates();
        $gameParty.performVictory();

        $gameParty.onBattleEnd();
        $gameTroop.onBattleEnd();
        $gameTemp.changeBattlebackDone();

        //this.playVictoryMe();
        this.makeRewards();
        this.displayVictoryMessage();
        this.displayRewards();
        this.gainRewards();
        this.endBattle(0);
    };

    BattleManager.displayRewards = function() {

        const width = 400;
        const height = 72;
    
        {
            const rect = new Rectangle(Graphics.width / 2 - width /2, Graphics.boxHeight / 2 - height / 2 - 128, width, height);
            let window = new Window_Base(rect);
            window.openness = 0;
            window.open();
        
            const dw = window.contentsWidth();
        
            window.drawText( "EXP = " + this._rewards.exp ,0, 0, dw / 2, 'center');
            window.drawText( "GOLD = " + this._rewards.gold ,dw / 2, 0, dw / 2, 'center');
        
            SceneManager._scene._resultWindow = window;
    
            SceneManager._scene.addChild(window);
        }
        
        if(this._rewards.items.length > 0)
        {
            let itemArray = [];
    
            const items = this._rewards.items;
    
            for(let i = 0; i < items.length; ++i)
            {
                const item = items[i];
                let isHit = false;
                for(let r = 0; r < itemArray.length; ++r)
                {
                    if(itemArray[r][0] == item)
                    {
                        isHit = true;
                        itemArray[r][1]++;
                        break;
                    }
                }
                if(!isHit)
                {
                    itemArray.push([item, 1]);
                }
            }
    
            const h = (itemArray.length + 1) * 32 + 48;
            const rect = new Rectangle(Graphics.width / 2 - width /2, Graphics.boxHeight / 2 - height / 2, width, h);
            let window = new Window_Base(rect);
            window.openness = 0;
            window.open();
        
            const dw = window.contentsWidth();
            const dh = window.contentsHeight();
        
            window.drawText( TextManager.dropItem,0, 0, dw, 'center');
    
            for(let i = 0; i < itemArray.length; ++i)
            {
    
                const item = itemArray[i][0];
                const count = itemArray[i][1];
    
                window.drawText( item.getName() + ' x' + count,0, (i + 1) * 32, dw, 'center');
            }
    
            SceneManager._scene._dropWindow = window;
    
            SceneManager._scene.addChild(window);
        }
    
        // this.displayExp();
        // this.displayGold();
        //this.displayDropItems();
        $gameMap._interpreter.setWaitMode('message');
    };

})();
