//=============================================================================
// RPG Maker MZ - SKillEffectDescript
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc スキル効果をそれっぽく表示してくれます。
 * @author カタコトトコトコ
 *
 * @help 
 */

(() => {

Window_Base.prototype.drawTextEx2 = function(text, x, y) {
    if (text) {
        const splits = text.split('\n');
        for(let i = 0; i < splits.length; ++i)
        {
            this.drawText(splits[i], this.textPadding(), y + i * 32);
        }
    } 
};

Window_Base.prototype.drawTextEx3 = function(text, x, y, maxWidth, align) {
    if (text) {
        const splits = text.split('\n');
        for(let i = 0; i < splits.length; ++i)
        {
            this.drawTextEx(splits[i], this.textPadding(), y + i * 32,maxWidth, align);
        }
    } 
};

Window_Base.prototype.textPadding = function() {
    return 6;
};

//これ有効にするとバトルログが表示されなかったので消しました
// Window_Base.prototype.drawTextEx = function(text, x, y) {
//     if (text) {
//         var textState = { index: 0, x: x, y: y, left: x };
//         textState.text = this.convertEscapeCharacters(text);
//         textState.height = this.calcTextHeight(textState, false);
//         this.resetFontSettings();
//         while (textState.index < textState.text.length) {
//             this.processCharacter(textState);
//         }
//         return textState.x - x;
//     } else {
//         return 0;
//     }
// };

function getPrice()
{
    if(this.meta.price)
    {
        return Number(this.meta.price);
    }
    return this.price;
}

function getName()
{
    if(this.meta.learnskillid)
    {
        return TextManager.magic() + '「' + $dataSkills[this.meta.learnskillid].getName() + '」';
    }

    const item = this;
    const laungage = ConfigManager.laungage;
    if( laungage == 1 )
    {
        if(item.meta.en)
        {
            return item.meta.en;
        }
    }
    else if(laungage == 2)
    {
        if(item.meta.cn)
        {
            return item.meta.cn;
        }
    }
    else
    {
        return item.name;
    }

    return '';
};

function getIconIndex()
{
    if(this.stypeId)
    {
        return this.iconIndex;
    }

    if(this.atypeId)
    {
        if(this.traits.length > 0)
        {
            if(this.traits[0].code == 43)
            {
                return $dataSkills[this.traits[0].dataId].iconIndex;
            }
        }
        return 144;
    }

    if(this.itypeId)
    {
        if(this.meta.material)
        {
            return 304;
        }
        if(this.meta.learnskillid)
        {
            return 121;
        }
        if(this.consumable)
        {
            return 176;
        }
        else
        {
            return this.iconIndex;
        }
    }
    return 0;
};

function getSkillIconIndex(node)
{
    if(node.stypeId == 3 || node.stypeId == 4){return 0;}//passive

    if(node.stypeId == 2)//magic
    {
        switch(node.damage.type)
        {
            case 0:
                switch(node.scope)
                {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                        return 74;
                    default:
                        return 73;
                }
            case 1:
                break;
            case 3:
                return 72;
        }

        switch(node.damage.elementId)
        {
            default:
            case 0:
            case 1:
                return 78;
            case 2:
                return 64;
            case 3:
                return 65;
            case 4:
                return 66;
            case 5:
                return 67;
            case 6:
                return 68;
            case 7:
                return 69;                                
            case 8:
                return 70;
            case 9:
                return 71;
        }
    }

    switch(node.damage.type)
    {
        case 3:
            return 72;
    }

    switch(node.hitType)
    {
        case 1:
            return 78;
        case 2:
            return 79;
        default:
            return node.iconIndex;
    }
};
    
function getDescriptBase()
{
    switch(ConfigManager.laungage)
    {
        case 2:
            if(this.meta.cn_description)
            {
                return this.meta.cn_description;
            }
        case 1:
            if(this.meta.en_description)
            {
                return this.meta.en_description;
            }
        case 0:
        default:
            return this.description;
    }
};

function isAssistSkill()
{
    return this.stypeId == 3;
}

function isBackSkill()
{
    return this.stypeId == 4;
}

function getDamageRank()
{
    if(isAssistSkill())
    {
        return '';
    }
    return this.meta.damagerank ? this.meta.damagerank : '';
}

Game_Action.prototype.evalDamageFormula = function(target) {
    try {
        const item = this.item();
        const a = this.subject(); // eslint-disable-line no-unused-vars
        const b = target; // eslint-disable-line no-unused-vars
        const v = $gameVariables._data; // eslint-disable-line no-unused-vars
        const sign = [3, 4].includes(item.damage.type) ? -1 : 1;
        //const value = Math.max(eval(item.damage.formula), 0) * sign;
        const value = Math.max(eval(this.getDamageFormula()), 0) * sign;
        return isNaN(value) ? 0 : value;
    } catch (e) {
        return 0;
    }
};

Game_Action.prototype.getDamageFormula = function()
{
    const item = this.item();

    const damageRank = item.getDamageRank();
    if(damageRank == '' || damageRank == undefined)
    {
        return item.damage.formula;
    }

    {
        let rate = 1.0;
        switch(damageRank)
        {
            case 'ss':
                rate = 3.75;
            break;
            case 's+':
                rate = 3.5;
            break;
            case 's':
                rate = 3.25;
            break;
            case 'a+':
                rate = 3.0;
            break;
            case 'a':
                rate = 2.75;
            break;
            case 'b+':
                rate = 2.5;
            break;
            case 'b':
                rate = 2.25;
            break;
            case 'c+':
                rate = 2.0;
            break;
            case 'c':
                rate = 1.75;
            break;
            case 'd+':
                rate = 1.5;
            break;
            case 'd':
                rate = 1.25;
            break;
            case 'base':
                rate = 1;
            break;
            case 'e+':
                rate = 0.75;
            break;
            case 'e':
                rate = 0.5;
            break;
            case 'f':
                rate = 0.25;
            break;
        }

        if(item.damage.type == 3)
        {
            return "(a.luk * 2 + b.luk * 2 ) * "+ rate;
            // //hp回復
            // if(item.hitType == 2)
            // {
            //     //魔法
            //     return "a.mat * 4 * "+ rate;
            // }
            // else
            // {
            //     //物理
            //     return "a.atk * 4 * "+ rate;
            // }
        }
        else
        {
            let atk = 'atk';
            let def = 'def';

            if(item.hitType == 2)
            {
                //魔法
                atk = 'mat';
                def = 'mdf';
            }
            else
            {

            }

            //let ret = "((a." + atk + " * 4 > b." + def + " * 2 ) ? (a."+ atk +" * 4 - b."+def+" * 2 ) : a."+atk+" * 0.75 ) * " + rate + " * b.elementRate("+ elementId +")" ;
            let ret = "((a." + atk + " * 4 > b." + def + " * 2 ) * " + rate + " ? (a."+ atk +" * 4 - b."+def+" * 2 ) * " + rate + " : a."+atk+" * 0.75 )";
            return ret;
        }

    }
}

function getBackSkillDescript()
{
    const scope = TextManager.targetScope(this.scope);

    const traitsEffects = getTraitsSkillEffect(this);

    return '戦闘メンバーにいないとき、ターン終了時に\n' + scope + "に\n" + traitsEffects;
}

function getSkillEffectTextOneLine(item, isAddEffect, battler)
{
    let hitTypeName = '';
    switch(item.hitType)
    {
        case 1:
        hitTypeName = '物理';
        break;
        case 2:
        hitTypeName = '魔法';
        break;
        default:
        break;
    }

    let isHealSkill = false;
    let isDamageSkill = false;
    switch(item.damage.type)
    {
        case 1:
            isDamageSkill = true;
            break;
        case 2:
            break;
        case 3:
            isHealSkill = true;
            break;
        case 5:
            isDamageSkill = true;
            break;
    }

    let elementId = item.damage.elementId - 2;

    // if(battler)
    // {
    //     if( item.stypeId == 2 && battler.isNoElementMagic())
    //     {
    //         elementId = -1;
    //     }
    //     if( item.stypeid == 1 && battler.isNoElementSkill())
    //     {
    //         elementId = -1;
    //     }
    // }

    const elementName = TextManager.element(elementId);

    const scope = TextManager.targetScope(item.scope);

    let effectText = '　' + scope + 'に ';

    let damageRankName = "";
    switch( item.getDamageRank() )
    {
        case 'ss':
        case 's+':
        case 's':
            damageRankName = '極大';
            break;
        case 'a+':
        case 'a':
            damageRankName = '特大';
            break;
        case 'b+':
        case 'b':
            damageRankName = '大';
        case 'c+':
        case 'c':
            damageRankName = '中';
        case 'd+':
        case 'd':
        case 'base':
        case 'e+':
            damageRankName = '小';
            break;
        case 'e':
        case 'f':
            damageRankName = '極小';
            break;
    }

    if(isHealSkill)
    {
        effectText += damageRankName + "回復 "
    }
    else if(isDamageSkill)
    {
        effectText += elementName + "属性の " + damageRankName + hitTypeName + "攻撃 ";
    }

    // if(!isAddEffect)
    // {
    //     effectText += '<' + hitTypeName + '>' + '<' + TextManager.target + ':' + scope + '>' + "\n"
    // }
    
    // effectText += '<' + TextManager.elementName + ':'+ elementName +'>';

    // if(!isAddEffect)
    // {
    //     effectText += '<TP:'+ item.tpCost +'>' + ' <MP:' + item.mpCost +'>\n';
    // }

    // let damageTypeName = '';

    // if(item.damage.type == 3)
    // {
    //     damageTypeName = TextManager.healPower;
    // }
    // else
    // {
    //     damageTypeName = TextManager.power;
    // }

    // let damageRank = item.getDamageRank();

    // if(damagerank = '')
    // {
    //     effectText += '<' + damageTypeName + ':なし>\n';
    // }
    // else
    // {
    //     effectText += '<' + damageTypeName + ':' + damageRank.toUpperCase() + '>\n';
    // }

    // if(item.meta.hpcost)
    // {
    //     effectText += TextManager.hpCost(item.meta.hpcost) + '\n';
    // }

    effectText += getTraitsSkillEffect(item) + ' ';

    {
        if(item.meta.QuickSkill)
        {
            effectText += " ターンを消費しない\n";
        }
        else if(item.speed > 0)
        {
            effectText += " 先制して行動できる\n";
        }
        else if(item.meta.onceskill)
        {
            effectText += " 戦闘中一回のみ\n";
        }
    }

    effectText.split('\n', '');

    return effectText;
}

function getTraitsSkillEffect(item)
{
    let effectText = '';

    const GAIN_HP_CODE_ID = 11;
    const GAIN_MP_CODE_ID = 12;
    const GAIN_TP_CODE_ID = 13;

    const UP_EFFECT_CODE_ID = 31;
    const DOWN_EFFECT_CODE_ID = 32;
    const REMOVE_STATE_CODE_ID = 22;
    const ADD_STATE_CODE_ID = 21;

    let gainHpValue = 0;
    let gainHpPer = 0;

    let gainMpValue = 0;
    let gainMpPer = 0;

    let gainTpValue = 0;
    let gainTpPer = 0;

    const effects = item.effects;

    let upEffects = [0,0,0,0,0,0,0,0,0];

    if(item.repeats > 1)
    {
        effectText += item.repeats + "回攻撃";
    }

    for(let i = 0; i < effects.length; ++i)
    {
        const effect = effects[i];

        const code = effect.code;
        if(code == DOWN_EFFECT_CODE_ID)
        {
            upEffects[effect.dataId]--;
        }

        if(code == UP_EFFECT_CODE_ID)
        {
            upEffects[effect.dataId]++;
        }

        if(code == GAIN_HP_CODE_ID)
        {
            gainHpPer += effect.value1;
            gainHpValue += effect.value2;
        }

        if(code == GAIN_MP_CODE_ID)
        {
            gainMpPer += effect.value1;
            gainMpValue += effect.value2;
        }
        
        if(code == GAIN_TP_CODE_ID)
        {
            gainTpValue += effect.value1;
        }

        if(code == REMOVE_STATE_CODE_ID)
        {
            let targetType = '';
            targetType = $dataStates[effect.dataId].getName();
            effectText += TextManager.recovery.format(targetType) + ' ';
        }

        if(code == ADD_STATE_CODE_ID)
        {
            if(effect.dataId > 0)
            {
                let targetType = '';
                targetType = $dataStates[effect.dataId].getName();
                effectText += TextManager.addState.format(targetType) + ' ';
            }
        }
    }

    if( gainHpPer != 0 )
    {
        effectText += 'HP' + (gainHpPer * 100) + '%回復 ';
    }

    if( gainHpValue != 0 )
    {
        effectText += 'HP' + (gainHpValue) + '回復 ';
    }

    if( gainMpValue != 0 )
    {
        effectText += 'MP' + (gainMpValue) + '回復 ';
    }

    if( gainTpValue != 0 )
    {
        effectText += 'TP' + (gainTpValue) + '回復 ';
    }

    for(let i = 0; i < 7; ++i)
    {
        const v = upEffects[i];
        if(v == 0){continue;}
        switch(i)
        {
            case 0:
                targetType = TextManager.maxhp;
                break;
            case 1:
                targetType = TextManager.maxmp;
                break;
            case 2:
                targetType = TextManager.atk;
                break;
            case 3:
                targetType = TextManager.def;
                break;
            case 4:
                targetType = TextManager.matk;
                break;
            case 5:
                targetType = TextManager.mdef;
                break;
            case 6:
                targetType = TextManager.spd;
                break;
            case 7:
                targetType = TextManager.luk;
                break;
        }

        const icon = v > 0 ? '↑' : '↓';

        for(let r = 0; r < Math.abs(v); ++r)
        {
            targetType += icon;
        }

        effectText += targetType;
    }
    return effectText;
}

function getSkillEffectText(item, isAddEffect, battler)
{
    let hitTypeName = '';
    switch(item.hitType)
    {
        case 1:
        hitTypeName = TextManager.physicalSkill;
        break;
        case 2:
        hitTypeName = TextManager.magicSkill;
        break;
        default:
        hitTypeName = TextManager.assistSkill;
        break;
    }

    switch(item.damage.type)
    {
        case 1:
            break;
        case 2:
            break;
        case 3:
            hitTypeName = TextManager.healSkill;
            break;
    }

    let elementId = item.damage.elementId - 2;

    // if(battler)
    // {
    //     if( item.stypeId == 2 && battler.isNoElementMagic())
    //     {
    //         elementId = -1;
    //     }
    //     if( item.stypeid == 1 && battler.isNoElementSkill())
    //     {
    //         elementId = -1;
    //     }
    // }

    const elementName = TextManager.element(elementId);

    const scope = TextManager.targetScope(item.scope);

    let effectText = '';

    if(!isAddEffect)
    {
        effectText += '<' + hitTypeName + '>' + '<' + TextManager.target + ':' + scope + '>' + "\n"
    }
    
    effectText += '<' + TextManager.elementName + ':'+ elementName +'>';

    if(!isAddEffect)
    {
        let tpCost = item.tpCost;
        if(battler)
        {
            tpCost = battler.skillTpCost(item);
        }

        effectText += '<TP:'+ tpCost +'>' + ' <MP:' + item.mpCost +'>\n';
    }

    let damageTypeName = '';

    if(item.damage.type == 3)
    {
        damageTypeName = TextManager.healPower;
    }
    else
    {
        damageTypeName = TextManager.power;
    }

    let damageRank = item.getDamageRank();

    if(damagerank = '')
    {
        effectText += '<' + damageTypeName + ':なし>\n';
    }
    else
    {
        effectText += '<' + damageTypeName + ':' + damageRank.toUpperCase() + '>\n';
    }

    if(item.meta.hpcost)
    {
        effectText += TextManager.hpCost(item.meta.hpcost) + '\n';
    }

    {
        if(item.speed > 0)
        {
            effectText += "先制して行動できる\n";
        }
    }

    {
        if(item.meta.QuickSkill)
        {
            effectText += "ターンを消費せずに行動\n";
        }
    }

    {
        if(item.meta.removebad)
        {
            effectText += "悪い状態異常を回復\n";
        }
    }

    {
        if(item.meta.onceskill)
        {
            effectText += " 戦闘中一回のみ\n";
        }
    }

    effectText += getTraitsSkillEffect(item) + ' ';

    return effectText;
}

function getTraitsSkillEffect(item)
{
    let effectText = '';

    const GAIN_HP_CODE_ID = 11;
    const GAIN_MP_CODE_ID = 12;
    const GAIN_TP_CODE_ID = 13;

    const UP_EFFECT_CODE_ID = 31;
    const DOWN_EFFECT_CODE_ID = 32;
    const REMOVE_STATE_CODE_ID = 22;
    const ADD_STATE_CODE_ID = 21;

    let gainHpValue = 0;
    let gainHpPer = 0;

    let gainMpValue = 0;
    let gainMpPer = 0;

    let gainTpValue = 0;
    let gainTpPer = 0;

    const effects = item.effects;

    let upEffects = [0,0,0,0,0,0,0,0,0];

    if(item.repeats > 1)
    {
        effectText += item.repeats + "回攻撃";
    }

    for(let i = 0; i < effects.length; ++i)
    {
        const effect = effects[i];

        const code = effect.code;
        if(code == DOWN_EFFECT_CODE_ID)
        {
            upEffects[effect.dataId]--;
        }

        if(code == UP_EFFECT_CODE_ID)
        {
            upEffects[effect.dataId]++;
        }

        if(code == GAIN_HP_CODE_ID)
        {
            gainHpPer += effect.value1;
            gainHpValue += effect.value2;
        }

        if(code == GAIN_MP_CODE_ID)
        {
            gainMpPer += effect.value1;
            gainMpValue += effect.value2;
        }
        
        if(code == GAIN_TP_CODE_ID)
        {
            gainTpValue += effect.value1;
        }

        if(code == REMOVE_STATE_CODE_ID)
        {
            let targetType = '';
            targetType = $dataStates[effect.dataId].getName();
            effectText += TextManager.recovery.format(targetType) + ' ';
        }

        if(code == ADD_STATE_CODE_ID)
        {
            if(effect.dataId > 0)
            {
                let targetType = '';
                targetType = $dataStates[effect.dataId].getName();
                effectText += TextManager.addState.format(targetType) + ' ';
            }
        }
    }

    if( gainHpPer != 0 )
    {
        effectText += 'HP' + (gainHpPer * 100) + '%回復 ';
    }

    if( gainHpValue != 0 )
    {
        effectText += 'HP' + (gainHpValue) + '回復 ';
    }

    if( gainMpValue != 0 )
    {
        effectText += 'MP' + (gainMpValue) + '回復 ';
    }

    if( gainTpValue != 0 )
    {
        effectText += 'TP' + (gainTpValue) + '回復 ';
    }

    let pTextNum = 0;

    effectText += "\n";

    for(let i = 0; i < 7; ++i)
    {
        const v = upEffects[i];
        if(v == 0){continue;}
        switch(i)
        {
            case 0:
                targetType = TextManager.maxhp;
                break;
            case 1:
                targetType = TextManager.maxmp;
                break;
            case 2:
                targetType = TextManager.atk;
                break;
            case 3:
                targetType = TextManager.def;
                break;
            case 4:
                targetType = TextManager.matk;
                break;
            case 5:
                targetType = TextManager.mdef;
                break;
            case 6:
                targetType = TextManager.spd;
                break;
            case 7:
                targetType = TextManager.luk;
                break;
        }

        const icon = v > 0 ? '↑' : '↓';

        for(let r = 0; r < Math.abs(v); ++r)
        {
            targetType += icon;
        }

        effectText += targetType;
        
        pTextNum += 2 + Math.abs(v);
        if(pTextNum >= 16)
        {
            effectText += "\n";
            pTextNum -= 16;
        }
    }
    return effectText;
}

function getDescript2( isShortDescript, battler )
{
    const item = this;
	if(!item){return '';}

    if( $gameSwitches.value(18) )
    {
        return '???';
    }


    if(item.maxTurns && item.minTurns)
    {
        return item.meta.descript ? item.meta.descript : "";
    }

    if(item.stypeId == 0)
    {
        return item.getDescriptBase();
    }

	if(item.itypeId)
	{
        if(item.meta.learnskillid)
        {
            if( isShortDescript )
            {
                return TextManager.learnBook( $dataSkills[Number(item.meta.learnskillid)].getName() );
            }
            else
            {
                return $dataSkills[Number(item.meta.learnskillid)].getDescript();
            }
        }
		return (item.getDescriptBase());
	}

    if(item.wtypeId)//weapon
    {
        return item.getDescriptBase();
    }

	if(item.atypeId)//armor
	{
		let effectText = '';

		const armorData = $dataArmors[item.id];

		const params = armorData.params;

		{
			for(let i = 0; i < params.length; ++i)
			{
				const value = Number(params[i]);
				if(value != 0)
				{
                    if(i == 1)
                    {
	    				effectText += '最大TP,MP' + ( value > 0 ? ('+' + value) : ( value ) ) + ' ';
                    }
                    else
                    {
                        effectText += TextManager.param(i) + ( value > 0 ? ('+' + value) : ( value ) ) + ' ';
                    }
				}
			}
		}

		const elementRate = armorData.meta.elementRate;

		if(elementRate)
		{
			const splits = elementRate.split('_');

            let isHit = true;
            for(let i = 1; i < splits.length; ++i)
            {
                if(splits[0] != splits[i])
                {
                    isHit = false;
                    break;
                }
            }

            if(Number(splits[0]) == 0)
            {
                isHit = false;
            }

            if(isHit)
            {
                const value = Number(splits[0]);
                effectText += TextManager.allElement + TextManager.regist + ( value > 0 ? ('+' + value) : ( value ) ) + ' ';
            }
            else
            {
                for(let i = 0; i < splits.length; ++i)
                {
                    const value = Number(splits[i]);
                    if(value != 0)
                    {
                        effectText += TextManager.element(i) + TextManager.regist + ( value > 0 ? ('+' + value) : ( value ) ) + ' ';
                    }
                }
            }
		}

        {
            let isHit = false;
            const traits = item.traits;
            let names = ' ';
            for(let i = 0; i < traits.length;++i)
            {
                const trait = traits[i];
    
                switch(Number(trait.code))
                {
                    case 43:
                        {
                            return "";//($dataSkills[trait.dataId].getDescript());
                        }
                        break;
                    case 14:
                        if(isHit)
                        {
                            names += ',';
                        }
                        names += ($dataStates[trait.dataId].getName());
                        isHit = true;
                        break;
                }
            }
            if(isHit)
            {
                effectText += names + 'を防ぐ';
            }
        }
		return ( effectText + item.getDescriptBase());
	}

    if(!item.stypeId)
    {
        //ステート
        return item.meta.description;
    }

    if(isShortDescript)
    {
        return getSkillEffectTextOneLine(item, false, battler);
    }

    if(item.isBackSkill())
    {
        return item.getBackSkillDescript();
    }

	if(item.isAssistSkill())
	{
		return item.getDescriptBase();
	}

    let effectText = getSkillEffectText(item, false, battler);

    if(item.meta.SkillCombo && !item.meta.ishidecombo)
    {
        if(item.meta.SkillCombo != item.id)
        {
            effectText += "\n<%1>\n".format(TextManager.additionalEffect);

            effectText += getSkillEffectText($dataSkills[item.meta.SkillCombo], true) + "\n";
        }

    }

    effectText += "\n"+ item.getDescriptBase();

    return effectText;
};

function getDescript( isShortDescript, battler )
{
    const item = this;
	if(!item){return '';}

    if( $gameSwitches.value(18) )
    {
        return '???';
    }


    if(item.maxTurns && item.minTurns)
    {
        return item.meta.descript ? item.meta.descript : "";
    }

    if(item.stypeId == 0)
    {
        return item.getDescriptBase();
    }

	if(item.itypeId)
	{
        if(item.meta.learnskillid)
        {
            if( isShortDescript )
            {
                return TextManager.learnBook( $dataSkills[Number(item.meta.learnskillid)].getName() );
            }
            else
            {
                return $dataSkills[Number(item.meta.learnskillid)].getDescript();
            }
        }
		return (item.getDescriptBase());
	}

    if(item.wtypeId)//weapon
    {
        return item.getDescriptBase();
    }

	if(item.atypeId)//armor
	{
		let effectText = '';

		const armorData = $dataArmors[item.id];

		const params = armorData.params;

		{
			for(let i = 0; i < params.length; ++i)
			{
				const value = Number(params[i]);
				if(value != 0)
				{
					effectText += TextManager.param(i) + ( value > 0 ? ('+' + value) : ( value ) ) + ' ';
				}
			}
		}

		const elementRate = armorData.meta.elementRate;

		if(elementRate)
		{
			const splits = elementRate.split('_');

            let isHit = true;
            for(let i = 1; i < splits.length; ++i)
            {
                if(splits[0] != splits[i])
                {
                    isHit = false;
                    break;
                }
            }

            if(Number(splits[0]) == 0)
            {
                isHit = false;
            }

            if(isHit)
            {
                const value = Number(splits[0]);
                effectText += TextManager.allElement + TextManager.regist + ( value > 0 ? ('+' + value) : ( value ) ) + ' ';
            }
            else
            {
                for(let i = 0; i < splits.length; ++i)
                {
                    const value = Number(splits[i]);
                    if(value != 0)
                    {
                        effectText += TextManager.element(i) + TextManager.regist + ( value > 0 ? ('+' + value) : ( value ) ) + ' ';
                    }
                }
            }
		}

        {
            let isHit = false;
            const traits = item.traits;
            let names = ' ';
            for(let i = 0; i < traits.length;++i)
            {
                const trait = traits[i];
    
                switch(Number(trait.code))
                {
                    case 43:
                        {
                            effectText += "スキル「%1」を使用可能".format($dataSkills[trait.dataId].getName());
                        }
                        break;
                    case 14:
                        if(isHit)
                        {
                            names += ',';
                        }
                        names += ($dataStates[trait.dataId].getName());
                        isHit = true;
                        break;
                }
            }
            if(isHit)
            {
                effectText += names + 'を防ぐ';
            }
        }
		return ( effectText + item.getDescriptBase());
	}

    if(!item.stypeId)
    {
        //ステート
        return item.meta.description;
    }

    if(isShortDescript)
    {
        return getSkillEffectTextOneLine(item, false, battler);
    }

    if(item.isBackSkill())
    {
        return item.getBackSkillDescript();
    }

	if(item.isAssistSkill())
	{
		return item.getDescriptBase();
	}

    let effectText = getSkillEffectText(item, false, battler);

    if(item.meta.SkillCombo && !item.meta.ishidecombo)
    {
        if(item.meta.SkillCombo != item.id)
        {
            effectText += "\n<%1>\n".format(TextManager.additionalEffect);

            effectText += getSkillEffectText($dataSkills[item.meta.SkillCombo], true) + "\n";
        }

    }

    effectText += "\n"+ item.getDescriptBase();

    return effectText;
};

TextManager.learnBook = function(value)
{
    return TextManager.getter("learnBook").format(value);
}

DataManager.loadDataFile = function(name, src) {
    var xhr = new XMLHttpRequest();
    var url = 'data/' + src;
    xhr.open('GET', url);
    xhr.overrideMimeType('application/json');
    xhr.onload = function() {
        if (xhr.status < 400) {
            window[name] = JSON.parse(xhr.responseText);
            DataManager.onLoad(window[name]);

            if(name == '$dataItems')
            {
                let array = window[name];
                for(let i = 0; i < array.length; ++i)
                {
                    if(!array[i]){continue;}
                    array[i].getName= getName;
                    array[i].getPrice = getPrice;
                    array[i].getIconIndex = getIconIndex;
                    array[i].iconIndex = array[i].getIconIndex();
                    array[i].getDescript = getDescript;
                    array[i].getDescriptBase = getDescriptBase;
                }
            }

            if(name == '$dataWeapons')
            {
                const array = window[name];
                for(let i = 0; i < array.length; ++i)
                {
                    if(!array[i]){continue;}
                    array[i].getName= getName;
                    array[i].getPrice = getPrice;
                    array[i].getIconIndex = getIconIndex;
                    array[i].iconIndex = array[i].getIconIndex();

                    array[i].getDescript = getDescript;
                    array[i].getDescriptBase = getDescriptBase;
                }
            }

            if(name == '$dataArmors')
            {

                const array = window[name];

                for(let i = 0; i < array.length; ++i)
                {
                    if(!array[i]){continue;}
                    array[i].getName= getName;
                    array[i].getPrice = getPrice;
                    //array[i].getIconIndex = getIconIndex;
                    //array[i].iconIndex = array[i].getIconIndex();

                    array[i].getDescript = getDescript;
                    array[i].getDescript2 = getDescript2;
                    array[i].getDescriptBase = getDescriptBase;
                }
            }

            if(name == '$dataSkills')
            {
                const array = window[name];


                for(let i = 0; i < array.length; ++i)
                {
                    let node = array[i];
                    if(!node){continue;}
                    array[i].getName= getName;

                    array[i].getDescript = getDescript;
                    array[i].getDescriptBase = getDescriptBase;
                    array[i].getBackSkillDescript = getBackSkillDescript;
                    array[i].isAssistSkill = isAssistSkill;
                    array[i].isBackSkill = isBackSkill;
                    array[i].getDamageRank = getDamageRank;

                    const iconIndex = getSkillIconIndex(node);

                    if(iconIndex != -1)
                    {
                        node.iconIndex = iconIndex;
                    }
                }
            }

            if(name == '$dataClasses')
            {
                //DataManager.loadDatabaseEx();
                {
                    const array = window[name];

                    for(let i = 0; i < array.length; ++i)
                    {
                        if(!array[i]){continue;}
                        array[i].getName= getName;
                    }
                }
            }

            if(name == "$dataStates")
            {
                {
                    const array = window[name];

                    for(let i = 0; i < array.length; ++i)
                    {
                        if(!array[i]){continue;}
                        array[i].getName= getName;
                        array[i].getDescript = getDescript;
                    }
                }
            }

            if(name == "$dataActors")
            {
                {
                    const array = window[name];

                    for(let i = 0; i < array.length; ++i)
                    {
                        if(!array[i]){continue;}
                        array[i].getName= getName;
                    }
                }
            }
            if(name == "$dataEnemies")
            {
                //DataManager.loadDatabaseEx2();
                {
                    const array = window[name];

                    for(let i = 0; i < array.length; ++i)
                    {
                        if(!array[i]){continue;}
                        array[i].getName= getName;
                    }
                }
            }
        }
    };
    xhr.onerror = this._mapLoader || function() {
        DataManager._errorUrl = DataManager._errorUrl || url;
    };
    window[name] = null;
    xhr.send();
};


})();
