//=============================================================================
// RPG Maker MZ - StatusView
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 戦闘中に確認できる見やすいステータスウィンドウ
 * @author カタコトトコトコ
 *
 * @help 
 */

(() => {

var Game_Action_prototype_apply = Game_Action.prototype.apply;
Game_Action.prototype.apply = function(target) {
    Game_Action_prototype_apply.call(this, target);
    this.applyEnemyBookEffect(target);
};

// Game_Action.prototype.applyItemEffect = function(target, effect) {

//     if(this.applyEnemyBookEffect(target))

//     switch (effect.code) {
//         case Game_Action.EFFECT_RECOVER_HP:
//             this.itemEffectRecoverHp(target, effect);
//             break;
//         case Game_Action.EFFECT_RECOVER_MP:
//             this.itemEffectRecoverMp(target, effect);
//             break;
//         case Game_Action.EFFECT_GAIN_TP:
//             this.itemEffectGainTp(target, effect);
//             break;
//         case Game_Action.EFFECT_ADD_STATE:
//             this.itemEffectAddState(target, effect);
//             break;
//         case Game_Action.EFFECT_REMOVE_STATE:
//             this.itemEffectRemoveState(target, effect);
//             break;
//         case Game_Action.EFFECT_ADD_BUFF:
//             this.itemEffectAddBuff(target, effect);
//             break;
//         case Game_Action.EFFECT_ADD_DEBUFF:
//             this.itemEffectAddDebuff(target, effect);
//             break;
//         case Game_Action.EFFECT_REMOVE_BUFF:
//             this.itemEffectRemoveBuff(target, effect);
//             break;
//         case Game_Action.EFFECT_REMOVE_DEBUFF:
//             this.itemEffectRemoveDebuff(target, effect);
//             break;
//         case Game_Action.EFFECT_SPECIAL:
//             this.itemEffectSpecial(target, effect);
//             break;
//         case Game_Action.EFFECT_GROW:
//             this.itemEffectGrow(target, effect);
//             break;
//         case Game_Action.EFFECT_LEARN_SKILL:
//             this.itemEffectLearnSkill(target, effect);
//             break;
//         case Game_Action.EFFECT_COMMON_EVENT:
//             this.itemEffectCommonEvent(target, effect);
//             break;
//     }
// };

Game_Action.prototype.applyEnemyBookEffect = function(target) {
    if (target.isEnemy()) {
        if (this._item.object().meta.checkEnemyStatus) {
        $gameTemp._targetActor = target;
        $gameTemp._isAnalyzeMode = true;
        $gameTemp._isAlly = false;
        SceneManager.push(Scene_Status);
        return true;
        //SceneManager._scene.battleBookEnemy(target);
        }
    }
    return false;
};

// Scene_Battle.prototype.isAnyStatusCheckWindowActive = function()
// {
//     return !(this._statusCheckWindow.isClosed() && this._statusCheckEffectList.isClosed() && this._statusCheckSkillList.isClosed());
// }

// Scene_Battle.prototype.isBusy = function()
// {
//         return this.isFading() || this.isAnyStatusCheckWindowActive();
// };


Scene_Battle.prototype.statusCheckWindowRect = function() {
    const wx = (Graphics.width - Graphics.uiWidth) / 2;
    const wy = this.buttonAreaBottom() + 4;
    const ww = Graphics.uiWidth;
    const wh = Graphics.boxHeight - wy;
    return new Rectangle(wx, wy, ww, wh);
};

Scene_Battle.prototype.battleBookAlly = function()
{
    return;
    this._statusCheckWindow._list = $gameParty.allMembers();
    const battler = this._statusCheckWindow._list[0];
    this._statusCheckWindow._actorIndex = 0;

    this._statusCheckWindow.open();

    this.showPageButton();

    this._statusButton.setEnter(true);
    this._skillsButton.setEnter(false);
    this._stateButton.setEnter(false);
    this._magicButton.setEnter(false);
    this._passiveButton.setEnter(false);

    this._statusCheckWindow.setBattler(battler);
    this._cancelButton.setClickHandler(this.onCancelStatusWindow.bind(this));
};

Scene_Battle.prototype.battleBookEnemy = function(target)
{
    this._statusCheckWindow._enemyList = [];
    this._statusCheckWindow._enemyList.push(target);

    this._statusCheckWindow._allyList = $gameParty.allMembers();

    this._statusCheckWindow._list = this._statusCheckWindow._enemyList;

    this.showPageButton();

    this._cancelButton.show();

    this._allyButton.hide();
    this._enemyButton.show();

    this._statusButton.setEnter(true);
    this._skillsButton.setEnter(false);
    this._stateButton.setEnter(false);
    this._magicButton.setEnter(false);
    this._passiveButton.setEnter(false);

    this._pageupButton.hide();
    this._pagedownButton.hide();

    this._statusCheckWindow._actorIndex2 = 0;

    this._statusCheckWindow._actorIndex = 0;

    this._statusCheckWindow.open();

    this._statusCheckWindow.setBattler(target);
    this._cancelButton.setClickHandler(this.onCancelStatusWindow.bind(this));
};

Scene_Battle.prototype.battleBookAlly2 = function()
{
    this._terrainEffectList.open();
    
    this._cancelButton.setClickHandler(this.onCancelStatusWindow.bind(this));

    this._statusCheckHelpWindow.open();
};

Scene_Battle.prototype.onCancelTerrainEffectWindow = function()
{
    this._terrainEffectList.close();
    this._statusCheckHelpWindow.close();
};

Scene_Battle.prototype.onCancelStatusWindow = function()
{
    this.closeStatusCheckWindow();

    this.closeStatusCheckSkillList();
    
    this.closeStatusCheckEffectList();

    SoundManager.playCancel();

    this.startPartyCommandSelection();

    this._terrainEffectList.close();
    
    this._statusCheckHelpWindow.close();

    this._cancelButton.setClickHandler(null);

    this.hidePageButton();
};

Scene_Battle.prototype.closeStatusCheckWindow = function()
{
    this._statusCheckWindow.close();
    this._statusCheckWindow._enemySprite.bitmap = null;
}

Scene_Battle.prototype.closeStatusCheckSkillList = function()
{
    this._statusCheckHelpWindow.close();

    this._statusCheckSkillList.close();

    this._statusCheckOneLineWindow.close();
}

Scene_Battle.prototype.closeStatusCheckEffectList = function()
{
    this._statusCheckHelpWindow.close();

    this._statusCheckEffectList.close();

    this._statusCheckOneLineWindow.close();
}

// Scene_Battle.prototype.update = function() {
//     const active = this.isActive();
//     $gameTimer.update(active);
//     $gameScreen.update();
//     this.updateVisibility();
//     if (active && !this.isBusy()) {
//         this.updateBattleProcess();
//     }

//     const target = this.updateStatusCheck();

//     if(target != '')
//     {
//         this.closeStatusCheckWindow();
//         this.closeStatusCheckSkillList();
//         this.closeStatusCheckEffectList();

//         this._statusButton.setEnter(false);
//         this._skillsButton.setEnter(false);
//         this._magicButton.setEnter(false);
//         this._passiveButton.setEnter(false);
//         this._stateButton.setEnter(false);

//         SoundManager.playCursor();

//         switch(target)
//         {
//             case 'status':
//                 this._statusCheckWindow.open();
//                 this._statusButton.setEnter(true);
//                 break;
//             case 'skills':
//                 this.createStatusSkillList(1);
//                 this._skillsButton.setEnter(true);
//                 break;
//             case 'magic':
//                 this.createStatusSkillList(2);
//                 this._magicButton.setEnter(true);
//                 break;
//             case 'passive':
//                 this.createStatusSkillList(3);
//                 this._passiveButton.setEnter(true);
//                 break;
//             case 'state':
//                 this.createStatusEffectState();
//                 this._stateButton.setEnter(true);
//                 break;
//         }
//     }

//     Scene_Message.prototype.update.call(this);
// };

Scene_Battle.prototype.nextActor = function() {
    this._statusCheckWindow.pageup();
};

Scene_Battle.prototype.previousActor = function() {
    this._statusCheckWindow.pagedown();
};

Scene_Battle.prototype.updateStatusCheck = function()
{
    let target = '';

    if( this._enemyButton.isVisible() )
    {
        if( Input.isTriggered('enemy') || Input.isTriggered('tab'))
        {   
            this._allyButton.show();
            this._enemyButton.hide();

            this._pageupButton.show();
            this._pagedownButton.show();
    
            this._statusCheckWindow._list = this._statusCheckWindow._allyList;
            this._statusCheckWindow._actorIndex = this._statusCheckWindow._actorIndex2;
    
            const actor = this._statusCheckWindow.currentActor()
            this._statusCheckWindow.setBattler( actor );
    
            //this._statusCheckWindow.refresh();
            this._statusCheckEffectList.setActor( actor );
            this._statusCheckSkillList.setActor( actor );
            this._statusCheckOneLineWindow.setActor( actor) ;
    
            SoundManager.playCursor();
            return '';
        }
    }

    if( this._allyButton.isVisible() )
    {
        if(Input.isTriggered('ally') || Input.isTriggered('tab'))
        {
            this._allyButton.hide();
            this._enemyButton.show();

            this._pageupButton.hide();
            this._pagedownButton.hide();

            this._statusCheckWindow._list = this._statusCheckWindow._enemyList;
            this._statusCheckWindow._actorIndex2 = this._statusCheckWindow._actorIndex;
            this._statusCheckWindow._actorIndex = 0;

            const actor = this._statusCheckWindow.currentActor()
            this._statusCheckWindow.setBattler( actor );

            //this._statusCheckWindow.refresh();
            this._statusCheckEffectList.setActor( actor );
            this._statusCheckSkillList.setActor( actor );
            this._statusCheckOneLineWindow.setActor( actor) ;

            SoundManager.playCursor();
            return '';
        }
    }

    if( Input.isTriggered('status') )
    {
        target = 'status';
        return target;
    }

    if(Input.isTriggered('skills'))
    {
        target = 'skills';
        return target;
    }

    if(Input.isTriggered('passive'))
    {
        target = 'passive';
        return target;
    }

    if(Input.isTriggered('magic'))
    {
        target = 'magic';
        return target;
    }

    if(Input.isTriggered('state'))
    {
        target = 'state';
        return target;
    }

    if(this._statusCheckWindow.isOpen())
    {
        if(Input.isPressed("cancel") || TouchInput.isCancelled())
        {
            this.onCancelStatusWindow();
        }

        if(Input.isTriggered("right"))
        {
            target = 'skills';
            return target;
        }

        if(Input.isTriggered("left"))
        {
            target = 'state';
            return target;
        }
    }

    if(this._statusCheckSkillList)
    {
        if(this._statusCheckSkillList.isOpen())
        {
            switch( this._statusCheckSkillList._stypeId )
            {
            case 1:
            {
                if(Input.isTriggered("right"))
                {
                    target = 'magic';
    
                    return target;
                } 
    
                if(Input.isTriggered("left"))
                {
                    target = 'status';
    
                    return target;
                }
            }
            break;
            case 2:
            {
                if(Input.isTriggered("right"))
                {
                    target = 'passive';
    
                    return target;
                } 
    
                if(Input.isTriggered("left"))
                {
                    target = 'skills';
    
                    return target;
                }
            }
            break;
            case 3:
                {
                    if(Input.isTriggered("right"))
                    {
                        target = 'state';
        
                        return target;
                    } 
        
                    if(Input.isTriggered("left"))
                    {
                        target = 'magic';
        
                        return target;
                    }
                }
                break;
        }



        }
    }
    if(this._statusCheckEffectList)
    {
        if(this._statusCheckEffectList.isOpen())
        {
            if(Input.isTriggered("right"))
            {
                //SoundManager.playCursor();
                // this.closeStatusCheckEffectList();
                // this._statusCheckWindow.open();
                target = 'status';
                return target;
            }

            if(Input.isTriggered("left"))
            {
               // SoundManager.playCursor();
                // this.closeStatusCheckEffectList();
                // this.createStatusSkillList();
                target = 'passive';
                return target;
            }
        }
    }
    return '';
};

Scene_Battle.prototype.createStatusEffectState = function()
{
    this._statusCheckHelpWindow.open();

    this._statusCheckOneLineWindow.setActor( this._statusCheckWindow.currentActor() );
    this._statusCheckOneLineWindow.open();

    this._statusCheckEffectList.setActor( this._statusCheckWindow.currentActor() );
    this._statusCheckEffectList.open();

    this._statusCheckEffectList.activate();
};

Scene_Base.prototype.oneLineWindowRect = function()
{
    let wx = (Graphics.boxWidth - Graphics.uiWidth) / 2 + 206;
    //const wx = (Graphics.boxWidth - Graphics.uiWidth) / 2 + 350;
    const wy = 48 + 4;//this.helpAreaTop();
    const ww = Graphics.boxWidth - wx - (Graphics.boxWidth - Graphics.uiWidth) + 48;
    const wh = 64;//this.helpAreaHeight();
    wx += (Graphics.boxWidth - Graphics.uiWidth) / 2;
    return new Rectangle(wx, wy, ww, wh);
};

Scene_Battle.prototype.statusCheckItemRect = function() {
    let rect = this.itemWindowRectBase();
    rect.x += 4;
    rect.y += 4;
    rect.x += (Graphics.boxWidth - Graphics.uiWidth - 96) / 2;
    return rect;
    rect.x += (1110 - 816) / 2 + 4;
    rect.y += 4;
    return rect;
    const wx = 70 + 120 - 38;
    const wy = 212;
    const ww = Graphics.boxWidth * 0.4;
    const wh = Graphics.boxHeight - this._statusWindow.height + 2;
    return new Rectangle(wx, wy, ww, wh);
};

const Scene_Battle_CreateAllWindows = Scene_Battle.prototype.createAllWindows;
Scene_Battle.prototype.createAllWindows = function() {
    Scene_Battle_CreateAllWindows.call(this);

    // {
    //     const rect = this.statusCheckWindowRect();
    //     this._statusCheckWindow = new Window_EnemyBookStatus(rect);
    //     this.addChild(this._statusCheckWindow);
    //     this._statusCheckWindow.closeFast();
    // }
    // {
    //     const rect = this.helpWindowRectBase();
    //     this._statusCheckHelpWindow = new Window_Help(rect);
    //     this.addWindow(this._statusCheckHelpWindow);
    //     this._statusCheckHelpWindow.closeFast();
    // }
    // {
    //     const rect = this.oneLineWindowRect();
    //     this._statusCheckOneLineWindow = new Window_OneLineStatus(rect);
    //     this.addWindow(this._statusCheckOneLineWindow);
    //     this._statusCheckOneLineWindow.closeFast();
    // }
    // {
    //     const rect = this.statusCheckItemRect();
    //     this._statusCheckSkillList = new Window_StatusSkillList(rect);
    //     this._statusCheckSkillList.setHelpWindow(this._statusCheckHelpWindow);
    //     this._statusCheckSkillList.setHandler("cancel", this.onCancelStatusWindow.bind(this));
    //     this.addChild(this._statusCheckSkillList);
    //     this._statusCheckSkillList.closeFast();
    // }
    // {
    //     const rect = this.statusCheckItemRect();
    //     this._statusCheckEffectList = new Window_EffectStateList(rect);
    //     this._statusCheckEffectList.setHelpWindow(this._statusCheckHelpWindow);
    //     //this._statusCheckSkillList.setHandler("ok", this.onSelectSkill.bind(this));
    //     this._statusCheckEffectList.setHandler("cancel", this.onCancelStatusWindow.bind(this));
    //     this.addChild(this._statusCheckEffectList);
    //     this._statusCheckEffectList.closeFast();
    // }
    // {
    //     const rect = this.statusCheckItemRect();
    //     this._terrainEffectList = new Window_TerrainList(rect);
    //     this._terrainEffectList.setHelpWindow(this._terrainEffectList);
    //     //this._statusCheckSkillList.setHandler("ok", this.onSelectSkill.bind(this));
    //     this._terrainEffectList.setHandler("cancel", this.onCancelStatusWindow.bind(this));
    //     this.addChild(this._terrainEffectList);
    //     this._terrainEffectList.closeFast();
    // }
};

Scene_Battle.prototype.createStatusSkillList = function(stypeId)
{
    this._statusCheckSkillList._stypeId = stypeId;

    this._statusCheckOneLineWindow.setActor( this._statusCheckWindow.currentActor() );
    this._statusCheckHelpWindow.open();
    this._statusCheckOneLineWindow.open();

    this._statusCheckSkillList.setActor( this._statusCheckWindow.currentActor() );
    this._statusCheckSkillList.open();

    this._statusCheckSkillList.activate();
    this._statusCheckSkillList.select(0);
};

Scene_Battle.prototype.onSelectSkill = function()
{
    this._statusCheckSkillList.select( this._statusCheckSkillList.index() );
};

Window_Base.prototype.standardPadding = function() {
    return 18;
};

Window_Base.prototype.textPadding = function() {
    return 6;
};

Window_Base.prototype.drawGauge = function(x, y, width, rate, color1, color2) {
    var fillW = Math.floor(width * rate);
    var gaugeY = y + this.lineHeight() - 8;
    this.contents.fillRect(x, gaugeY, width, 6, ColorManager.gaugeBackColor());
    this.contents.gradientFillRect(x, gaugeY, fillW, 6, color1, color2);
};

Window_Base.prototype.drawCurrentAndMax2 = function(current, max, x, y, width, color1, color2) {
    // var labelWidth = this.textWidth('HP');
    // var valueWidth = this.textWidth('0000000');
    // var slashWidth = this.textWidth('/');
    // var x1 = x + width - valueWidth;
    // var x2 = x1 - slashWidth;
    // var x3 = x2 - valueWidth;
    {
    this.changeTextColor(color1);
    // this.drawText(current, x3, y, valueWidth, 'right');
    // this.changeTextColor(color2);
    // this.drawText('/', x2, y, slashWidth, 'right');
    // this.drawText(max, x1, y, valueWidth, 'right');
    this.drawText(current + '/' + max, x, y,width, 'right');
    }
};


Window_Base.prototype.drawCurrentAndMax = function(current, max, x, y, width, color1, color2) {
    var labelWidth = this.textWidth('HP');
    var valueWidth = this.textWidth('000');
    var slashWidth = this.textWidth('/');
    var x1 = x + width - valueWidth;
    var x2 = x1 - slashWidth;
    var x3 = x2 - valueWidth;
    // if (x3 >= x + labelWidth) {
    // this.changeTextColor(color1);
    // this.drawText(current, x3, y, valueWidth, 'right');
    // this.changeTextColor(color2);
    // this.drawText('/', x2, y, slashWidth, 'right');
    // this.drawText(max, x1, y, valueWidth, 'right');
    // } else {
    this.changeTextColor(color1);
    this.drawText(current, x1, y, valueWidth, 'right');
    //}
};

Window_Base.prototype.drawActorHp = function(actor, x, y, width) {
    width = width || 186;
    var color1 = ColorManager.hpGaugeColor1();
    var color2 = ColorManager.hpGaugeColor2();
    this.drawGauge(x, y, width, actor.hpRate(), color1, color2);
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.hpA, x, y, 44);
    this.drawCurrentAndMax2(actor.hp, actor.mhp, x + 32, y, width - 32 ,
                            ColorManager.hpColor(actor), ColorManager.normalColor());
};

Window_Base.prototype.drawActorMp = function(actor, x, y, width) {
    width = width || 186;
    let color1 = ColorManager.mpGaugeColor1();
    let color2 = ColorManager.mpGaugeColor2();

    if(actor._actorId != 1)
    {
        color1 = ColorManager.ctGaugeColor1();
        
        color2 = ColorManager.ctGaugeColor2();
    }

    this.drawGauge(x, y, width, actor.mpRate(), color1, color2);
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.mpA, x, y, 44);
    this.drawCurrentAndMax(actor.mp, actor.mmp, x, y, width,
                            ColorManager.mpColor(actor), ColorManager.normalColor());
};

Window_Base.prototype.drawActorTp = function(actor, x, y, width) {
    width = width || 96;
    var color1 = ColorManager.tpGaugeColor1();
    var color2 = ColorManager.tpGaugeColor2();
    this.drawGauge(x, y, width, actor.tpRate(), color1, color2);
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.tpA, x, y, 44);
    this.changeTextColor(ColorManager.tpColor(actor));
    this.drawText(actor.tp, x + width - 64, y, 64, 'right');
};

//-----------------------------------------------------------------------------
// Window_TerrainList
//
// The window for selecting a skill on the skill screen.

function Window_TerrainList() {
    this.initialize(...arguments);
}

Window_TerrainList.prototype = Object.create(Window_Selectable.prototype);
Window_TerrainList.prototype.constructor = Window_SkillList;

Window_TerrainList.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    this._actor = null;
    this._data = [];
};

Window_TerrainList.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
        this.scrollTo(0, 0);
    }
};

Window_TerrainList.prototype.maxCols = function() {
    return 1;
};

Window_TerrainList.prototype.colSpacing = function() {
    return 16;
};

Window_TerrainList.prototype.maxItems = function() {
    return this._data ? this._data.length : 1;
};

Window_TerrainList.prototype.item = function() {
    return this.itemAt(this.index());
};

Window_TerrainList.prototype.itemAt = function(index) {
    return this._data && index >= 0 ? this._data[index] : null;
};

Window_TerrainList.prototype.isCurrentItemEnabled = function() {
    return this.isEnabled(this._data[this.index()]);
};

Window_TerrainList.prototype.includes = function(item) {
    return item;
};

Window_TerrainList.prototype.isEnabled = function(item) {
    return this._actor && this._actor.canUse(item);
};

Window_TerrainList.prototype.makeItemList = function() {
    if (this._actor) {
        this._data = this._actor.skills().filter(item => this.includes(item));
        this._data = this._data.sort((function(a,b){
            return a.stypeId > b.stypeId;
        }));
    } else {
        this._data = [];
    }
};

Window_TerrainList.prototype.selectLast = function() {
    const index = this._data.indexOf(this._actor.lastSkill());
    this.forceSelect(index >= 0 ? index : 0);
};

Window_TerrainList.prototype.drawItem = function(index) {
    const skill = this.itemAt(index);
    if (skill) {
        const costWidth = this.costWidth();
        const rect = this.itemLineRect(index);
        this.changePaintOpacity(this.isEnabled(skill));
        this.drawItemName(skill, rect.x, rect.y, rect.width - costWidth);
        this.drawSkillCost(skill, rect.x, rect.y, rect.width);
        this.changePaintOpacity(1);
    }
};

Window_TerrainList.prototype.costWidth = function() {
    return this.textWidth("000");
};

Window_TerrainList.prototype.drawSkillCost = function(skill, x, y, width) {
    if (this._actor.skillTpCost(skill) > 0) {
        this.changeTextColor(ColorManager.tpCostColor());
        this.drawText(this._actor.skillTpCost(skill), x, y, width, "right");
    } else if (this._actor.skillMpCost(skill) > 0) {
        this.changeTextColor(ColorManager.mpCostColor());
        this.drawText(this._actor.skillMpCost(skill), x, y, width, "right");
    }
};

Window_TerrainList.prototype.updateHelp = function() {
    this.setHelpWindowItem(this.item());
};

Window_TerrainList.prototype.refresh = function() {
    this.makeItemList();
    Window_Selectable.prototype.refresh.call(this);
};

//-----------------------------------------------------------------------------
// Window_EffectStateList
//

function Window_EffectStateList() {
    this.initialize(...arguments);
}

Window_EffectStateList.prototype = Object.create(Window_Selectable.prototype);
Window_EffectStateList.prototype.constructor = Window_EffectStateList;

Window_EffectStateList.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    this._actor = null;
    this._data = [];
};

Window_EffectStateList.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
        this.scrollTo(0, 0);
    }
};

Window_EffectStateList.prototype.maxCols = function() {
    return 1;
};

Window_EffectStateList.prototype.colSpacing = function() {
    return 16;
};

Window_EffectStateList.prototype.maxItems = function() {
    return this._data ? this._data.length : 1;
};

Window_EffectStateList.prototype.item = function() {
    return this.itemAt(this.index());
};

Window_EffectStateList.prototype.itemAt = function(index) {
    return this._data && index >= 0 ? this._data[index] : null;
};

Window_EffectStateList.prototype.isCurrentItemEnabled = function() {
    return this.isEnabled(this._data[this.index()]);
};

Window_EffectStateList.prototype.includes = function(item) {
    return item;
};

Window_EffectStateList.prototype.isEnabled = function(item) {
    return this._actor && this._actor.canUse(item);
};

Window_EffectStateList.prototype.makeItemList = function() {
    if (this._actor) {
        this._data = this._actor.states().filter( function(item){ return !item.meta.isHide; } );

    } else {
        this._data = [];
    }
};

Window_EffectStateList.prototype.selectLast = function() {
    const index = this._data.indexOf(this._actor.lastSkill());
    this.forceSelect(index >= 0 ? index : 0);
};

Window_EffectStateList.prototype.drawItem = function(index) {
    const skill = this.itemAt(index);
    if (skill) {
        const rect = this.itemLineRect(index);
        this.changePaintOpacity(this.isEnabled(skill));
        this.drawItemName(skill, rect.x, rect.y, rect.width);
        this.changePaintOpacity(1);
    }
};

Window_EffectStateList.prototype.updateHelp = function() {
    this.setHelpWindowItem(this.item());
};

Window_EffectStateList.prototype.refresh = function() {
    this.makeItemList();
    Window_Selectable.prototype.refresh.call(this);
};

//-----------------------------------------------------------------------------
// Window_StatusSkillList
//
// The window for selecting a skill on the skill screen.

function Window_StatusSkillList() {
    this.initialize(...arguments);
}

Window_StatusSkillList.prototype = Object.create(Window_Selectable.prototype);
Window_StatusSkillList.prototype.constructor = Window_SkillList;

Window_StatusSkillList.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    this._actor = null;
    this._data = [];
    this._stypeId = 1;
};

Window_StatusSkillList.prototype.setActor = function(actor) {
    //if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
        this.scrollTo(0, 0);
    //}
};

Window_StatusSkillList.prototype.maxCols = function() {
    return 1;
};

Window_StatusSkillList.prototype.colSpacing = function() {
    return 16;
};

Window_StatusSkillList.prototype.maxItems = function() {
    return this._data ? this._data.length : 1;
};

Window_StatusSkillList.prototype.item = function() {
    return this.itemAt(this.index());
};

Window_StatusSkillList.prototype.itemAt = function(index) {
    return this._data && index >= 0 ? this._data[index] : null;
};

Window_StatusSkillList.prototype.isCurrentItemEnabled = function() {
    return this.isEnabled(this._data[this.index()]);
};

Window_StatusSkillList.prototype.includes = function(item) {
    return item;
};

Window_StatusSkillList.prototype.isEnabled = function(item) {
    return this._actor && this._actor.canUse(item);
};

Window_StatusSkillList.prototype.makeItemList = function() {
    if (this._actor) {
        
        this._data = this._actor.skills().filter(item => this.includes(item) && item.stypeId == this._stypeId );

        this._data.sort((function(a,b){
            if(a.stypeId > b.stypeId)
            {
                return 1;
            }
            else if(a.stypeId < b.stypeId)
            {
                return -1;
            }
            else
            {
                return 0;
            }
        }));
    } else {
        this._data = [];
    }
};

Window_StatusSkillList.prototype.selectLast = function() {
    const index = this._data.indexOf(this._actor.lastSkill());
    this.forceSelect(index >= 0 ? index : 0);
};

Window_StatusSkillList.prototype.drawItem = function(index) {
    const skill = this.itemAt(index);
    if (skill) {
        const costWidth = this.costWidth();
        const rect = this.itemLineRect(index);
        this.changePaintOpacity(this.isEnabled(skill));
        this.drawItemName(skill, rect.x, rect.y, rect.width - costWidth, this._actor);
        this.drawSkillCost(skill, rect.x, rect.y, rect.width);
        this.changePaintOpacity(1);
    }
};

Window_StatusSkillList.prototype.costWidth = function() {
    return this.textWidth("000");
};

Window_StatusSkillList.prototype.drawSkillCost = function(skill, x, y, width) {
    if (this._actor.skillTpCost(skill) > 0) {
        this.changeTextColor(ColorManager.tpCostColor());
        this.drawText(this._actor.skillTpCost(skill), x, y, width, "right");
    } else if (this._actor.skillMpCost(skill) > 0) {
        this.changeTextColor(ColorManager.mpCostColor());
        this.drawText(this._actor.skillMpCost(skill), x, y, width, "right");
    }
};

Window_StatusSkillList.prototype.updateHelp = function() {
    this.setHelpWindowItem(this.item());
};

Window_StatusSkillList.prototype.refresh = function() {
    this.makeItemList();
    Window_Selectable.prototype.refresh.call(this);
};

//=============================================================================
// Window_OneLineStatus
//=============================================================================
Window_OneLineStatus = function() {
    this.initialize.apply(this, arguments);
};
Window_OneLineStatus.prototype = Object.create(Window_Base.prototype);
Window_OneLineStatus.prototype.constructor = Window_OneLineStatus;

Window_OneLineStatus.prototype.initialize = function(rect) {
    Window_Base.prototype.initialize.call(this, rect);
};

Window_OneLineStatus.prototype.setActor = function(battler)
{
    this.contents.clear();

    if(battler == null)
    {
        return;
    }

    this.drawText(battler.name(), 0, 0, 256);

    if(battler.isActor())
    {
        this.drawActorFace(battler, 160, -64, 128, 128);
    }

    this.drawActorHp(battler, 296, 0, 180);
    //this.drawActorMp(battler, 360 + 220 + 10, 0, 80);
    //this.drawActorTp(battler, 360 + 220 + 10 + 80 + 10, 0, 80);
};

//=============================================================================
// Window_EnemyBookStatus
//=============================================================================

Window_EnemyBookStatus = function() {
    this.initialize.apply(this, arguments);
};

Window_EnemyBookStatus.prototype = Object.create(Window_Base.prototype);
Window_EnemyBookStatus.prototype.constructor = Window_EnemyBookStatus;

Window_EnemyBookStatus.prototype.initialize = function(rect) {
    
    Window_Base.prototype.initialize.call(this, rect);
    this._windowWidth = rect.width;
    this._actorIndex = -1;
    this._enemy = null;
    this._enemySprite = new Sprite();
    this._enemySprite.anchor.x = 0.5;
    this._enemySprite.anchor.y = 0.5;
    this._enemySprite.x = rect.width / 4;
    this._enemySprite.y = rect.width / 4 + this.lineHeight();// + EnemyOffsetY;
    this.addChildToBack(this._enemySprite);

    this.isCheck = false;
    this.refresh();
    // v1.17
    this.isAllEnemies = false;
    // this._cw = 0;
    this._spriteFrameCountAB = 0;
};

Window_EnemyBookStatus.prototype.setup = function() {
    this.setupbacksprite();
    this.show();
    this.open();
};

Window_EnemyBookStatus.prototype.setBattler = function(enemy) {
    //クローズ時や切替時の対策で同じバトラーでも再描画する
    this._enemy = enemy;
    this.refresh();
};

Window_EnemyBookStatus.prototype.currentActor = function()
{
    if(this._actorIndex == -1){return null;}
    return this._list[this._actorIndex];
}

// refresh に移動
// Version 1.11で復活

Window_EnemyBookStatus.prototype.pageup = function()
{
    let statusWindow = SceneManager._scene._statusCheckWindow;
    let statusCheckOneLineWindow = SceneManager._scene._statusCheckOneLineWindow;
    let statusCheckSkillList = SceneManager._scene._statusCheckSkillList;
    let statusCheckEffectList = SceneManager._scene._statusCheckEffectList;
    const members = this._list;
    {
        this._actorIndex++;
        SoundManager.playCursor();

        if( this._actorIndex >= members.length )
        {
            this._actorIndex = 0;
        }
        const enemy = this.currentActor();

        statusWindow.setBattler(enemy);

        statusCheckOneLineWindow.setActor( enemy );
        statusCheckSkillList.setActor( enemy );
        statusCheckEffectList.setActor( enemy );
        this.refresh();
    }

};

Window_EnemyBookStatus.prototype.pagedown = function()
{
    let statusWindow = SceneManager._scene._statusCheckWindow;
    let statusCheckOneLineWindow = SceneManager._scene._statusCheckOneLineWindow;
    let statusCheckSkillList = SceneManager._scene._statusCheckSkillList;
    let statusCheckEffectList = SceneManager._scene._statusCheckEffectList;
    const members = this._list;
    {
        this._actorIndex--;
        SoundManager.playCursor();

        if( this._actorIndex < 0 )
        {
            this._actorIndex = members.length - 1;
        }
        const enemy = this.currentActor();

        statusWindow.setBattler(enemy);

        statusCheckOneLineWindow.setActor( enemy );
        statusCheckSkillList.setActor( enemy );
        statusCheckEffectList.setActor( enemy );
        this.refresh();
    }

};


Window_EnemyBookStatus.prototype.update = function() {
    Window_Base.prototype.update.call(this);

    // let statusWindow = SceneManager._scene._statusCheckWindow;
    // let statusCheckOneLineWindow = SceneManager._scene._statusCheckOneLineWindow;
    // let statusCheckSkillList = SceneManager._scene._statusCheckSkillList;
    // let statusCheckEffectList = SceneManager._scene._statusCheckEffectList;
    // const members = $gameParty.battleMembers();
    if( Input.isTriggered('pageup') )
    {
        this.pageup();
    }
    else if(Input.isTriggered('pagedown'))
    {
        this.pagedown();
    }
};

Window_EnemyBookStatus.prototype.refresh = function() {
    let x = 0, y = 0; 
    this.drawAllContents( this._enemy, x,y);
};

Window_Base.prototype.drawAllContents = function(enemy, x, y, width, height) {
    width = this.contentsWidth() - 24;
    var column1x = x;
    var column2x = width ? x+width / 2 + this.standardPadding()/2 : this.contentsWidth() / 2 + this.standardPadding() / 2;
    var columnWidth = width ? width / 2 - this.standardPadding() : this.contentsWidth() / 2 - this.standardPadding();
    var x = x || 0;
    var y = y || 0;
    var w = columnWidth / 2 - this.standardPadding();
    //var mY = 0;
    var lineHeight = this.lineHeight();

    this.contents.clear();
    if (!enemy) {
        return;
    }

    const name = enemy.battlerName();
    let hue = 0;

    if(enemy.isEnemy())
    {
        hue = enemy.battlerHue();
    }
    
    if(this.isOpening() || this.isOpen())
    {
        let bitmap = ImageManager.loadEnemy(name, hue);
        if(!this._enemySprite)
        {
            this._enemySprite = new Sprite();
            this._enemySprite.anchor.x = 0.5;
            this._enemySprite.anchor.y = 0.5;
            this._enemySprite.x = this.width / 4;
            this._enemySprite.y = this.width / 4 + this.lineHeight();// + EnemyOffsetY;
            this.addChildToBack(this._enemySprite);
        }
        this._enemySprite.bitmap = bitmap;
        this._enemySprite.setHue(hue);
    }

    this.resetTextColor();
    this.drawText(enemy.name(), x, y, 240);

    let level = enemy._level;

    this.drawText( 'Lv ' + level, x + 240 + 12, y, 80);

    x = column2x;

    y += lineHeight;

    if (y != 0) y += this.textPadding();

    let paramCount = 0;

    for (var i = 0; i < 8; i++) {
        if (i == 2) 
        {

            y += lineHeight;
            y += lineHeight;
        }
        if (i == 0 ) {
            this.drawActorHp(enemy, x, y, 220);
            this.drawActorTp(enemy, x + 220 + 10, y,70);
            this.drawActorMp(enemy, x + 220 + 70 + 10 + 10, y, 70);
        } else if (i == 1) {
            continue;
        } else {
            let ax = 0;
            paramCount++;
            if( paramCount % 2 == 0 )
            {
                y -= lineHeight;
                ax = w + 40;
            }
            this.changeTextColor(this.systemColor());
            this.drawText(TextManager.param(i), x + ax, y, w / 2);
            this.resetTextColor();
            const value = Math.round(enemy.param(i));
            this.drawText(value, x + w / 2 + ax, y, w / 2, 'right');

        }
        y += lineHeight;
    }

    y -= lineHeight;

    {
        const ids = [0,1];
        const text = [TextManager.hit, TextManager.agi];
        for(let i = 0; i < ids.length; ++i)
        {
            let ax = 0;
            if( i % 5 == 0 )
            {
                y += lineHeight;
            }
    
            ax = 20 * (i % 4);
            this.changeTextColor(this.systemColor());
    
            const bx = ( (w / 4 + 40 ) * ( i % 4));
    
            this.drawText(text[i], x + ax + bx, y, w / 4);
            this.resetTextColor();
            //倍率が0の時は0
            //倍率が1の時は100
            const rate = Math.round(enemy.xparam(ids[i]) * 100);
            this.drawText(rate + "%", x + w / 4 + ax + bx, y, w / 4 + 8, 'right');
        }
    }

    y += lineHeight;
    this.drawText(TextManager.regist, x, y);
    {
        const ids = [6,7];
        const icon = [77,79];
        for(let i = 0; i < 2; ++i)
        {
            let ax = 0;
            if( i % 4 == 0 )
            {
                y += lineHeight;
            }
    
            ax = 20 * (i % 4);
            this.changeTextColor(this.systemColor());
    
            const bx = ( (w / 4 + 40 ) * ( i % 4));
    
            //this.drawText(TextManager.element(i), x + ax + bx, y, w / 4);
            this.drawIcon(icon[i], x + ax + bx, y, w / 4);
            this.resetTextColor();
            //倍率が0の時は100
            //倍率が1の時は0
            //倍率が2の時は-100
            const rate =  100 - Math.round(enemy.sparam(ids[i]) * 100);

            this.resetTextColor();
            if(rate == 0)
            {
                this.changeTextColor(ColorManager.textColor(8));
            }
            else if(rate > 0)
            {
                this.changeTextColor(ColorManager.textColor(3));
            }
            else
            {
                this.changeTextColor(ColorManager.textColor(2));
            }

            this.drawText(rate + "%", x + w / 4 + ax + bx, y, w / 4 + 8, 'right');
        }
    }


    for(let i = 0; i < 8; ++i)
    {
        let ax = 0;
        if( i % 4 == 0 )
        {
            y += lineHeight;
        }

        ax = 20 * (i % 4);
        this.changeTextColor(this.systemColor());

        const bx = ( (w / 4 + 40 ) * ( i % 4));

        //this.drawText(TextManager.element(i), x + ax + bx, y, w / 4);
        this.drawIcon(64 + i, x + ax + bx, y, w / 4);
        this.resetTextColor();
        //倍率が0の時は100
        //倍率が1の時は0
        //倍率が2の時は-100
        const rate =  100 - Math.round(enemy.elementRate(i + 2) * 100);

        this.resetTextColor();
        if(rate == 0)
        {
            this.changeTextColor(ColorManager.textColor(8));
        }
        else if(rate > 0)
        {
            this.changeTextColor(ColorManager.textColor(3));
        }
        else
        {
            this.changeTextColor(ColorManager.textColor(2));
        }

        this.drawText(rate + "%", x + w / 4 + ax + bx, y, w / 4 + 8, 'right');
    }
    this.resetTextColor();

    var maxY = y;

    //this.drawElement(256, lineHeight * 7,enemy);

    x = column1x;
    y = lineHeight * 6 + this.textPadding();
};

Window_EnemyBookStatus.prototype.findElementIcon = function(elementId) {
    return 0;
};

Window_EnemyBookStatus.prototype.isHideStatus = function(enemy) {
    if (!enemy) return true;
    return false;
    return !(/*$gameSystem.isInEnemyBook(enemy.enemy()) ||*/ (this.isCheck && !HideUnknownStatusInSkill));
};

Window_EnemyBookStatus.prototype.isCurrentStatus = function(enemy) {
    if (!enemy) return false;
    return !this.isAllEnemies && ($gameSystem.isShowCurrentEnemysStatus() || this.isCheck) && !ShowGeneralStatusInSkill;
};

Window_EnemyBookStatus.prototype.drawNoEffectStates = function(x, y, w) {
    var enemy = this._enemy;
    var icons = [];
    var iconWidth = 32;
    var dx = 32;
    for (var i=1,l=$dataStates.length; i<l; i++) {
        var rate = enemy.stateRate(i);
        if ((rate <= 0 || enemy.isStateResist(i))&& $dataStates[i].meta.book !== "no") {
            var icon = $dataStates[i].iconIndex;
            if (icon) icons.push(icon);
        }
    }

    
    this.changeTextColor(this.systemColor());
    this.drawText(NoEffectStateName, x, y, w);

    if (iconWidth * icons.length > w) {
        dx = Math.floor(w / icons.length);
    }
    y+= this.lineHeight();
    
    if (/*$gameSystem.isInEnemyBook(enemy.enemy()) ||*/ (this.isCheck && !HideUnknownStatusInSkill)) {
        for (var i=0,l=icons.length; i<l; i++) {
            this.drawIcon(icons[i], x, y);
            x += dx;
        }
    } else {
        this.resetTextColor();
        this.drawText(UnknownData, x, y);
    }
};


})();
