//=============================================================================
// test.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc エクセルを読み込みます.
 * @author カタコトトコトコ
 * @help
*/
(() => {
	"use strict";

	const pluginName = 'xlsx';
	
	const VARIABLE_ID_INPUT_STRING = 11;

	const CHARA_AO = [
		['ao_awa','b1','base1','awa','n'],
		['ao_bikkuri','b1','base1','awa','n','$bf'],
		['ao_default','b1','base1','default','n'],
		['ao_default2','b1','base1','default','n'],
		['ao_dousiyo','b1','base1','dousiyo','n'],
		['ao_gu','b1','base1','gu','n'],
		['ao_ha','b1','base1','ha','n'],
		['ao_kime','b1','base1','kime','n'],
		['ao_komari','b1','base1','komari','n'],
		['ao_komari2','b1','base1','komari','n'],
		['ao_siruka','b1','base1','tukkomi','n'],
		['ao_tere','b1','base1','komari','$bf'],
		['ao_tukkomi','b1','base1','tukkomi','n','$bf'],
		['ao_tura','b1','base1','tura','n'],
		['ao_uge','b1','base1','uge','n'],
	];

	const CHARA_AKA = 
	[
		['aka_angry1','base1','angry1','n'],
		['aka_angry2','base1','angry2','n'],
		['aka_default','base1','default','n'],
		['aka_human1','base1','human1','n'],
		['aka_smile1','base1','smile1','n'],
	];
	const CHARA_KETER = 
	[
		['keter_default','base1','default'],
		['keter_metozi','base1','metozi'],
		['keter_smile1','base1','smile1'],
		['keter_smile2','base1','smile2'],
		['keter_naki','base1','naki'],
		['keter_naki2','base1','naki2'],
		['keter_naki3','base1','naki3'],
	];
	class XlsxEvent {
		constructor(fileName, interpreter) {
		  this._fileName = fileName;
		  this._interpreter = interpreter;
		  this._xlsxindex = 0;
		  this._isEnd = false;
		  this._xlsxData = null;

		  var xhr = new XMLHttpRequest();
		  var url = "event/%1.dd".format(fileName);
		  xhr.open('GET', url);
		  xhr.overrideMimeType('text/plain; charset=utf-8');

		  let ev = this;

		  xhr.onload = function() {
			  if (xhr.status < 400) {
				ev.renderResult(fileName, xhr.responseText);
			  }
		  };
		  xhr.onerror = DataManager._mapLoader || function() {
			  DataManager._errorUrl = DataManager._errorUrl || url;
		  };
		  //window[name] = null;
		  xhr.send();

		//   try { xhr = new ActiveXObject("Microsoft.XMLHTTP"); } catch (e) { xhr = new XMLHttpRequest(); }
  
		//   const path = "event/%1.xlsx".format(fileName); // 読み込む外部ファイル
  
		//   const xlsxEvent = this;
  
		//   xhr.open("GET", path, true);
		//   xhr.responseType = 'arraybuffer';
		//   xhr.onreadystatechange = function(){
		// 	  //var data = xhr.responseText; // 外部ファイルの内容
		// 	  const data = new Uint8Array(xhr.response);
		// 	  const f =new Blob([data], {type:"application/octet-stream"});
		// 	  const er = new ExcelJs.Reader(f, function (e, xlsx) {
		// 		  xlsxEvent.renderResult(xlsx.getFile().name, xlsx.toJson());
		// 	  });
		//   };
		//   xhr.onload = function()
		//   {
		//   	if(this.status != 200)
		//   	{
		//   		console.log( "loading error " + this.status);
		//   		this._isEnd = true;
		//   	}
		//   }
		//   xhr.send();
		}
  
	  isEnd()
	  {
		  return this._isEnd;
	  }
  
	  isWait()
	  {
		  return this._interpreter.isWait();
	  }
  
	  setWaitMode(mode)
	  {
		  this._interpreter.setWaitMode(mode);
	  }

	  end()
	  {
		const addIndex = 30;

		for(let r = 0; r < 48; ++r)
		{
			$gameScreen.erasePicture(r + addIndex);
		}
		this._isEnd = true;
		this._xlsxData = null;
	  }
  
	  renderResult(name, content) 
	  {
		  this._xlsxData = content.split("\n");
		  this._xlsxindex = 0;
		  this._isEnd = false;
		  $gameTemp._isEventMode = true;
  
		  this.xlsxCheck();
	  }
  
	  isRunning()
	  {
		  return this._isEnd == false;
	  }
  
  
	  xlsxCheck()
	  {
		//   switch(BattleManager._battleResult)
		//   {
		// 	  case 0://victory
		// 	  break;
		// 	  case 1://avort
		// 	  break;
		// 	  case 2://defeat
		// 	  break;
		//   }
  
		  //BattleManager._battleResult = -1;
  
		  const i = this._xlsxindex;
		  const data = this._xlsxData;

		  if(this._isEnd)
		  {
			return true;
		  }

		  if(data == null)
		  {
			  return false;
		  }
  
		  const addIndex = 30;
  
		  if( i >= data.length )
		  {
				for(let r = 0; r < 6 * 8; ++r)
				{
					$gameScreen.erasePicture(r + addIndex);
				}
				this._isEnd = true;
				this._xlsxData = null;
				//this._interpreter.wait(2);
				$gameTemp._isEventMode = false;
			  return true;
		  }
  
		  let isNext = false;
  
		  {
			// console.log(data[i]);
			// console.log(i);
			  const d = data[i].split(",");

			  switch(d[0].replace("\r",""))
			  {
				case 'random':
					{
						let randomArray = [];
						for(let ii = i; ii < data.length; ++ii)
						{
							let vvv = data[ii].split(",")[0];
							if(vvv == 'begin' || vvv == 'begin\r')
							{
								randomArray.push(ii);
							}
						}

						if(randomArray.length > 0)
						{
							this._xlsxindex = randomArray[Math.floor( Math.random() * randomArray.length )] - 1;
						}

						//this._xlsxindex = Number( d[ Math.floor( Math.random( d.length + 1 ) )] ) + 1;
						isNext = true;
						break;
					}
				case 'fadein':
					{
						this._interpreter._childInterpreter = new Game_Interpreter(this._interpreter._depth + 1);
						this._interpreter._childInterpreter.setup($dataCommonEvents[10].list);
					}
					break;
				case 'fadeout':
					{
						this._interpreter._childInterpreter = new Game_Interpreter(this._interpreter._depth + 1);
						this._interpreter._childInterpreter.setup($dataCommonEvents[11].list);
						$gameMessage._log.push({ isEx:true, name:null, text:'暗転'});
					}
					break;
					case 'shake':
						{
							this._interpreter._childInterpreter = new Game_Interpreter(this._interpreter._depth + 1);
							this._interpreter._childInterpreter.setup($dataCommonEvents[12].list);
						}
						break;
					case 'playse':
					{
						AudioManager.playSe({"name":d[1],"volume":90,"pitch":100,"pan":0});
					}
					break;
					case 'stopse':
					{
						AudioManager.stopSe();
					}
					break;
					case 'playbgm':
					{
						AudioManager.playBgm({"name":d[1],"volume":90,"pitch":100,"pan":0});
					}
					case 'playbgs':
					{
						AudioManager.playBgs({"name":d[1], "volume": d[2] ? Number(d[2]) : 90,"pitch": d[3] ? Number(d[4]) : 100,"pan":0});
					}
					break;
					case 'stopbgs':
						{
							AudioManager.stopBgs();
						}
						break;
					case 'stopbgm':
					{
						AudioManager.stopBgm();
					}
					break;
				  case 'nameedit':
					  {
						  {
							  SceneManager.push(Scene_Name);
							  SceneManager.prepareNextScene(Number(d[2]), ConfigManager.laungage == 0 ? 5 : 8);
						  }
					  }
					  break;
					case 'addmapflag':
				        {
				            $gamePlayer.addMapFlag(d[1]);
				        }
				        break;
				    case 'movemap':
				        {
				            $gamePlayer.moveMap(d[1]);
				        }
				        break;
				  case 'settransparent':
					  {
						  $gamePlayer.setTransparent(d[2]);
					  }
				  break;
				  case 'plugin':
					  {
						  const message = d[1];
						  const args = message.split(" ");
						  const command = args.shift();
						  this._interpreter.pluginCommand(command, args);
					  }
				  break;
				  case 'shop':
					  {
						  const p = d[1];
  
						  const args = p.split(',');
  
						  let itemList = [];
  
						  for(let i = 0; i < args.length; ++i)
						  {
							  itemList.push( [ Number(d[2]),args[i], 0, 0 ] );
						  }
  
						  SceneManager.push(Scene_Shop);
						  SceneManager.prepareNextScene( itemList, false);
						  break;
					  }
				  case 'item':
					  {
						  const m = d[1];
  
						  const splits = m.split(',');
  
						  let array = [];
						  for(let i = 0; i < splits.length; ++i)
						  {
							  array.push( splits[i].split('_') );
						  }
						  $gameParty.getItem(array);
						  this.setWaitMode('message', 'メッセージ');
					  }
				  break;
				  case 'notice':
					  {
						  const nameTag = d[2];
						  const message = d[1];
						  if(!message)
						  {
							  message = "";
						  }
						  $gameMessage.setPositionType(1);
						  {
							  $gameMessage.add("<wrap>" + message + "\f");
						  }
						  this.setWaitMode('message', 'メッセージ');
					  }
				  break;
				  case 'stillmode':
					{
						this._stillMode = true;
					}
					break;
				  case 'message':
					  {
						  let nameTag = d[2];
  
						  let message = '';
						  switch(ConfigManager.laungage)
						  {
							  case 1:
								  message = d.en;
								  break;
							  case 0:
							  default:
								  message = d[1];
								  break;
						  }
  
						  $gameMessage.setPositionType(2);
						  if(!message)
						  {
							  message = "";
						  }
						  console.log(nameTag);
						  switch(nameTag.replace('\r', ''))
						  {
							case 'aka':
								nameTag = '\\N[2]';
							break;
							case 'you':
								nameTag = '\\N[1]';
							break;
							case 'ao':
								nameTag = '\\N[3]';
							break;
							case 'ki':
								nameTag = '\\N[5]';
							break;
							case 'midori':
								nameTag = '\\N[4]';
							break;
							case 'tuti':
								nameTag = '\\N[6]';
							break;
							case 'siro':
								nameTag = '\\N[7]';
							break;
							case 'kuro':
								nameTag = '\\N[8]';
							break;
							case 'kori':
								nameTag = '\\N[9]';
							break;
							case 'keter':
								nameTag = 'ケテル';
							break;
							case 'shop':
								nameTag = 'ルート';
							break;
							case 'shop2':
								nameTag = 'マヌ';
							break;
							case 's1':
								nameTag = 'ラウロン';
								break;
							case 's2':
								nameTag = 'ピュートーン';
								break;
							case 's3':
								nameTag = 'ジャヴァウォック';
								break;
							case 's4':
								nameTag = 'ウロボロス';
								break;
							case 'tuto':
								nameTag = 'チュートリアルちゃん';
							break;
						  }
						  console.log(nameTag);

						  if(this._stillMode)
						  {
							$gameMessage.setBackground(1);
						  }

						  if(!!nameTag)
						  {
							  let n = nameTag;
  
  								$gameMessage.setSpeakerName(n);
							  $gameMessage.add( "\\^<wrap>" + message + "\f");
						  }
						  else
						  {
  								$gameMessage.setSpeakerName(null);

							  $gameMessage.add("\\^<wrap>" + message + "\f");
						  }
						  this.setWaitMode('message');
					  }
				  break;
				  case 'choice':
					  {
						  let choices = d[1].split(':');
						  let cancelIndex = d[2];
						  let defaultIndex = d[3];
						  let windowPos = d[4];
						  let windowType = d[5];
						  this.setupChoices([choices,cancelIndex,defaultIndex,windowPos,windowType]);
						  this.setWaitMode('message', '選択');
						  this._interpreter.setChioceMode();
						  //ここで一度スクリプトを切って下さい。
		  /*
						  switch (this._branch[this._indent]) {
						  case 0: $gameMessage.add("選択肢１を選択"); break;
						  case 1: $gameMessage.add("選択肢２を選択"); break;
						  case 2: $gameMessage.add("選択肢３を選択"); break;
						  case 3: $gameMessage.add("選択肢４を選択"); break;
						  case 4: $gameMessage.add("選択肢５を選択"); break;
						  case 5: $gameMessage.add("選択肢６を選択"); break;
						  default: $gameMessage.add("キャンセルを選択"); break;
						  }
						  */
					  }
				  break;
				  case 'playse':
					  {
						  let seName = d[1];
						  let volume = (!!d[2]) ? d[2] : 100;
						  let pitch = (!!d[3]) ? d[3] : 100;
						  let pan = (!!d[4]) ? d[4] : 0;
						  AudioManager.playSe({"name":seName,"volume":volume,"pitch":pitch,"pan":pan});
					  }
				  break;
				  case 'stopse':
					  {
						  AudioManager.stopSe();
					  }
				  break;
				  case 'wait':
					  {
						  let waitFrame = d[2];
						  this._interpreter.wait(Number(waitFrame));
					  }
				  break;
				  case 'battle':
					  {
							BattleManager._isBoss = true;
						  let battleId = Number(d[2]);
						  let canEscape = false;//(!!d[3]) ? d[3] : true;
						  let noGameOver = (!!d[4]) ? d[4] : true;
						  BattleManager.setup(battleId, canEscape, noGameOver);
						  BattleManager.setEventCallback(
							function(n) 
							{
								this._interpreter._branch[this._interpreter._indent] = n;
							}.bind(this));
						  $gamePlayer.makeEncounterCount();
						  SceneManager.push(Scene_Battle);
					  }
				  break;
				  case 'if_battleresult':
						if(this._interpreter._branch[this._interpreter._indent] == 0)
						{
							let q = i + 1;
							for(; q < data.length; ++q)
							{
								if(data[q].id != 'label')
								{
									continue;
								}
								if(data[q].param1 == d[1])
								{
									break;
								}
							}
							this._xlsxindex = q;
						}
						else
						{
							let q = i + 1;
							for(; q < data.length; ++q)
							{
								if(data[q].id != 'label')
								{
									continue;
								}
								if(data[q].param1 == d[2])
								{
									break;
								}
							}
							this._xlsxindex = q;
						}
						isNext = true;
					  break;
				  case 'jump':
					{
						let q = i + 1;
						for(; q <data.length; ++q)
						{
							if(data[q].id != 'label')
							{
								continue;
							}
							if(data[q].param1 == d[1])
							{
								break;
							}
						}
						this._xlsxindex = q;
						isNext = true;
					}
					break;
					case 'dir':
						this._dir = d[1] + '/';
						break;
					case 'still':
						{
							const names = d[1].split(',');
							let r = 0;
							for(; r < names.length; ++r)
							{
								const drawMode = names[r].indexOf('$') == -1 ? 0 : 2;
								$gameScreen.showPicture(Number(1) + addIndex + 1 + r, 'still/' + this._dir + names[r], 1,Graphics.width / 2, Graphics.height / 2,100,100,255,drawMode);
							}
							for(; r < 10; ++r)
							{
								$gameScreen.erasePicture(Number(1) + addIndex + 1 + r);
							}
							isNext = true;
						}
					break;
					// case 'stillbase':
					// 	$gameScreen.showPicture(Number(1) + addIndex, 'still/' + this._dir + d[1],1,Graphics.width / 2, Graphics.height / 2,100,100,255,0);
					// 	isNext = true;
					// break;
				  case 'showpicture':
					  $gameScreen.showPicture(Number(d[2]) + addIndex + 1,d[1],1,d[3],d[4],100,100,255,0);
					  isNext = true;
				  break;
				  case 'fa':
				  case 'forceaction':
					{
						let num1 = Number(d[1]);
						let num2 = Number(d[2]);
						let num3 = Number(d[3]);
						let num4 = Number(d[4]);
						this._interpreter.iterateBattler(num1, num2, function(battler) {
							if (!battler.isDeathStateAffected()) {
							battler.forceAction(num3, num4)
							BattleManager.forceAction(battler)
							this.setWaitMode('action')
							}
							}.bind(this));
					}
					break;
				  case 'balloon':
					  // 1:びっくり
					  // 2:はてな
					  // 3:音符
					  // 4:ハート
					  // 5:怒り
					  // 6:汗
					  // 7:くしゃくしゃ
					  // 8:沈黙
					  // 9:電球
					  // 10:Zzz
					  // 11:ユーザー定義1
					  // 12:ユーザー定義2
					  // 13:ユーザー定義3
					  // 14:ユーザー定義4
					  // 15:ユーザー定義5
					  const charaList = this._interpreter._charaList;
					  const event = charaList[ Number(d[2]) - 1 ];
					  event.requestBalloon(1);
					  //event.requestBalloon(Number(d[3]));
					  
					  AudioManager.playSe({"name":"Miss","volume":90,"pitch":100,"pan":0})
  
					  if(d[4] == 'isWait')
					  {
						  this.setWaitMode("balloon");
						  this._interpreter._character = event;
					  }
					  break;
				case 'flash':
					{
						$gameScreen.startFlash([255,255,255,255], 60);
					}
					break;
				//   case 'createevent':
				// 	  {
				// 		  //isNext = true;
				// 		  const events = $gameMap._events;
  
				// 		  const eventId = events.length + 1;
  
				// 		  let event = new Game_Event(Number(eventId), Number(eventId), Number(d[3]), Number(d[4]));
  
				// 		  const fileName = d[1];
  
				// 		  event.setImage(fileName, 1);
  
				// 		  SceneManager._scene.addCharacter(event);
				// 		  $gameMap.addEvent(event);
				// 		  this._interpreter._charaList.push(event);
				// 		  events.push( event );
				// 	  }
				// 	  break;
				case 'begin':
					isNext = true;
					break;
					case 'end':
						{
							for(let r = 0; r < 6 * 8; ++r)
								{
									$gameScreen.erasePicture(r + addIndex);
								}
						isNext = true;
	
						}
						break;
				case 'endscene':
					{
						AudioManager.stopBgs();
						$gameSystem.replayBgm();
						this._xlsxindex = 9999;
					isNext = true;

					}
					break;
				  case 'addevent':
					  {
						  //isNext = true;
  
						  const charaList = this._interpreter._charaList;
  
						  const event = charaList[ Number(d[2]) - 1 ];
						  
						  let code;
  
						  switch(d[1])
						  {
							  case 'moveup':
								  code = {"code":4};
								  break;
							  case 'moveleft':
								  code = {"code":2};
								  break;
							  case 'moveright':
								  code = {"code":3};
								  break;
							  case 'movedown':
								  code = {"code":1};
								  break;
							  case 'lookdown':
								  code = {"code":16};
								  break;
							  case 'lookup':
								  code = {"code":19};
								  break;
							  case 'lookright':
								  code = {"code":18};
								  break;
							  case 'lookleft':
								  code = {"code":17};
								  break;
							  case 'routeend':
								  code = {"code":0};
								  break;
							  case 'jump':
								  code = {"code":14, "parameters":[0, 0]};
								  AudioManager.playSe({"name":"Jump2","volume":90,"pitch":100,"pan":0})
								  break;
						  }
						  /*
						  ルートエンド：{"code":0}
						  下に移動：{"code":1}
						  左に移動：{"code":2}
						  右に移動：{"code":3}
						  上に移動：{"code":4}
						  左下に移動：{"code":5}
						  右下に移動：{"code":6}
						  左上に移動：{"code":7}
						  右上に移動：{"code":8}
						  下を向く：{"code":16}
						  左を向く：{"code":17}
						  右を向く：{"code":18}
						  上を向く：{"code":19}
						  */
  
						  event.forceMoveRoute({
							  "list":[
							  code,
							  {"code": 0},
								  /*{"code":1},
							  {"code":15,"parameters":[60]},
							  {"code":14,"parameters":[1,2]},
							  {"code":14,"parameters":[1,2]},
							  {"code":15,"parameters":[60]},
							  //{"code":44,"parameters":[{"name":"Applause1","volume":90,"pitch":100,"pan":0}]},
							  {"code":0}*/],
							  "repeat":false,
							  "skippable":true});
						  event.setMoveType(3);//customMove
						  this._interpreter._character = event;
						  this.setWaitMode('route');
						  //this._interpreter._charaList.push(event);
					  }
					  break;
				  case 'charaimage':
					  {
						let px = 0;
						let width = Graphics.width;
						let height = Graphics.height;
						let subx = 180;
						let pictureIndex = 0;
						  switch(d[3].replace('\r', ''))
						  {
							  case 'left':
								  px = subx;
								  pictureIndex = 6;
								  break;
								case 'left2':
								  px = subx*2;
								  pictureIndex = 5;

								  break;
								  case 'left3':
									px = subx*3;
									pictureIndex = 4;
									break;
							  case 'center':
								  px = width / 2;
									pictureIndex = 0;

								  break;
							  case 'right':
								  px = width - subx;
									pictureIndex = 3;

								  break;
							case 'right2':
								  px = width - subx*2;
									pictureIndex = 2;

								  break;
								  case 'right3':
									px = width - subx*3;
									pictureIndex = 1;

									break;
						  }
						  let xscale = 100;
						  if(d[4] && d[4] != "\r" && d[4] != "" )
						  {
							xscale = -100;

						  }
						  var scale = 1;

						  const splits = d[1].split('_');
						  let splits2 = null;

						  if(splits[0] == 'ao')
						  {
							splits2 = this.SearchImage( d[1], CHARA_AO );
						  }
						  else if(splits[0] == 'aka')
						  {
							splits2 = this.SearchImage( d[1], CHARA_AKA );
						  }
						  else if(splits[0] == 'keter')
						  {
							splits2 = this.SearchImage( d[1], CHARA_KETER );
						  }

						  const imageNum = 5;

						  let array = [];
						  let r = 0;
						  if(splits2 != null)
						  {
								{
								//array.push( splits[0] + '_base' );
								for(let r = 1; r < splits2.length; ++r)
								{
									array.push(splits2[r]);
								}
							  }
							}
							else if(d[1].length >= 2)
							{
								array.push(d[1]);
							}
							const pathName = "chara/"+splits[0] + "/";
							for(; r < array.length; ++r)
							{
							  const index = pictureIndex * imageNum + r + addIndex;
							  const drawMode = array[r].indexOf('$') == -1 ? 0 : 2;
  
							  $gameScreen.showPicture(index, pathName + array[r],1,px, height / 2 ,xscale * scale,100 * scale,255,drawMode);
							}

						  for(; r < imageNum; ++r)
						  {
							const index = pictureIndex * imageNum + r + addIndex;
							$gameScreen.erasePicture(index);
						  }
						  isNext = true;
					  }
				  break;
				  case 'hidepicture':
					  $gameScreen.erasePicture(Number(d[2]) + addIndex);
					  isNext = true;
				  break;
				  default:
					  isNext = true;
				  break;
			  }
		  }
  
		  this._xlsxindex++;
  
		  if(isNext && this._interpreter._waitMode == '')
		  {
			  return this.xlsxCheck();
		  }
		  return false;
	  }
	  
	  SearchImage(name, array)
	  {
		for(let i = 0; i < array.length; ++i)
		{
			if(name == array[i][0])
			{
				return array[i];
			}
		}

		return array[i];
	  }
  };

  Game_Player.prototype.isDebugEvent = function()
  {
	return this._debugEvent;
  }

  Game_Player.prototype.debugEventOn = function()
  {
	this._debugEvent = true;
  }
  Game_Player.prototype.debugEventOff = function()
  {
	this._debugEvent = false;
  }

	Game_Player.prototype.hasFlag = function(idName)
	{
		if(this._debugEvent)
			{
				return true;
			}
		if(this._flagList == undefined)
		{
			return false;
		}

		for(let i = 0; i < this._flagList.length; ++i)
		{
			if(this._flagList[i] == idName)
			{
				return true;
			}
		}

		return false;
	};

	Game_Player.prototype.setFlag = function(idName)
	{
		if(this._flagList == undefined)
		{
			this._flagList = [];
		}

		for(let i = 0; i < this._flagList.length; ++i)
		{
			if(this._flagList[i] == idName)
			{
				return;
			}
		}

		this._flagList.push(idName);
	};

	Game_Interpreter.prototype.setupXlsx = function(fileName, eventId) {
		$gameMap.hideMiniMap();

		$gamePlayer.setFlag(fileName);

		this._mapId = $gameMap.mapId();
		this._eventId = eventId || 0;
		//this._list = list;
		this._xlsx = new XlsxEvent(fileName, this);
	
		//this.setWaitMode('xlsx');
	
		//Game_Interpreter.requestImages(list);
	};

	// Game_Interpreter.prototype.isRunning = function() 
	// {
	// 	if(this._list != null)
	// 	{
	// 		return true;
	// 	}
	
	// 	if(this._childInterpreter != null)
	// 	{
	// 		if( this._childInterpreter.isRunning() )
	// 		{
	// 			return true;
	// 		}
	// 	}
	
	// 	if(this._xlsx != null)
	// 	{
	// 		const ret = this._xlsx.isRunning();
	// 		return ret;
	// 	}
	// 	return false;
	// };

	Game_Interpreter.prototype.update = function() {
		while (this.isRunning()) {
			if (this.updateChild() || this.updateWait()) {
				break;
			}
	
			if(this._xlsx != null)
			{
				if(this._xlsx.xlsxCheck() == true)
				{
					$gameMessage.setBackground(0);
					
					if(!$gameParty.inBattle())
					{
							$gameMap.updateMiniMap();
					}

					this._xlsx.end();
					this._xlsx = null;
				}
				return;
			}
	
			if(this._list == null)
			{
				break;
			}
	
	
			if (SceneManager.isSceneChanging()) {
				break;
			}
			if (!this.executeCommand()) {
				break;
			}
			if (this.checkFreeze()) {
				break;
			}
		}
	};

	Game_Interpreter.prototype.setupXlsxChild = function(fileName, eventId) {
		this._childInterpreter = new Game_Interpreter(this._depth + 1);
		this._childInterpreter.setupXlsx(fileName, eventId);
		this._childInterpreter._isXlsx = true;
	};

	Game_Interpreter.prototype.warp = function(idName)
	{
		const list = $dataMapInfos;
		for(let i = 0; i < list.length; ++i)
		{
			const mapInfoData = list[i];
			if(mapInfoData == null)
			{
				continue;
			}
			const mapName = mapInfoData.name;

			const splits = mapName.split(':');

			if(splits.length <= 4)
			{
				continue;
			}

			if(splits[1] != idName)
			{
				continue;
			}

			this.transfer(mapInfoData.id, Number(splits[2]), Number(splits[3]), Number(splits[4]), 0);
			//this.terminate();
			break;
		}
	}

	const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function (command, args) {
		_Game_Interpreter_pluginCommand.call(this, command, args);
		if(command === 'warphome')
		{
			this.warp4th(6, 2);
		}

		if(command === 'expsetup')
		{
			let max = 0;
			for(let i = 0; i < $gameActors._data.length; ++i)
			{
				if($gameActors._data[i] == null)
				{
					continue;
				}
				const exp = $gameActors._data[i].currentExp();
				if(exp > max)
				{
					max = exp;
				}
			}
			for(let i = 0; i < $gameActors._data.length; ++i)
			{
				if($gameActors._data[i] == null)
				{
					continue;
				}
				$gameActors._data[i].changeExp(max);
			}
		}

		if(command === 'checkdestroy')
		{
			const key = args[0];
			if($gamePlayer.hasFlag(key))
			{
				this._index = this._list.length//無理やり終了させる処理
				this.endXlsx();
				$gameMap.eraseEvent(this._eventId);
				return;
			}
			else
			{
				$gamePlayer.setFlag(key);
				command = 'test';
				//return;
			}
		}

        if(command === 'selectMap')
        {
            const defaultIndex = 0;
            const windowPosType = 0;//0:left 1:center 2:right
            const backGroundType = 0;//0:window 1:dark 2:unvisible
			
			let texts = [];

			const maps = 
			[
				['FOREST', '森:forest'],
				['SWAMP', '毒沼:swamp'],
				['SEA', '海:sea'],
				['SNOW', '雪:snow'],
			];

			for(let i = 0; i < maps.length; ++i)
			{
				if($gamePlayer.isUnLockMap(maps[i][0]))
				{
					texts.push(maps[i][1]);
				}
			}

            const onCancelIndex = texts.length;

			texts.push(TextManager.cancel);
            this.setupChoices([texts,onCancelIndex, defaultIndex, windowPosType, backGroundType]);
            this.setWaitMode('message');
			this.setChoiceMode('MAP');
        }

		if(command === 'warp')
		{
			this.warp(args[0]);
		}

		if(command === 'warp4th')
		{
			const mapIndex = Number(args[0]);
			const mapDirection = Number(args[1]);//2↓, 4←, 6→, 8↑

			this.warp4th(mapIndex, mapDirection);
			return;
		}

        if(command === 'joinParty' || command === 'JoinParty')
        {
            $gameParty.addActor(Number(args[0]));
            const actorData = $dataActors[args[0]];
            const actorName = actorData.getName();
            const classData = $dataClasses[actorData.classId];
            $gameMessage.add( TextManager.joinParty(classData.name.split(':')[0] + ' ' + actorName));
            AudioManager.playSe({"name":"Up1","volume":90,"pitch":100,"pan":0})
            this.setWaitMode('message', 'パーティ参加');
			return;
        }
        else if (command === pluginName) 
		{
			let filename = null;
			if(args == null || args.length == 0)
			{
				filename = $gameVariables.value(VARIABLE_ID_INPUT_STRING);
			}
			else
			{
				filename = args[0];
			}

			this.setupXlsxChild(filename, this.eventId());
			return;
		}
		if (command === 'xlsxonce') 
		{
			let filename = args[0]
			if(!$gamePlayer.hasFlag(filename))
			{

				this.setupXlsxChild(filename, this.eventId());
			}
			return;
		}
	};
})();

