//=============================================================================
// RPG Maker MZ - blank
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 
 * @author 
 *
 * @help TextPicture.js
 */

(() => {

    Game_Player.prototype.isBoteMode = function()
    {
        let members = $gameParty.allMembers();

        for(let i = 1; i < members.length; ++i)
        {
            let member = members[i];
            //member.extendCount = 2;
            if(member.extendCount < 2)
            {
                return false;
            }
        }
        return true;
    }

    Game_Interpreter.prototype.gotoNewActorScene = function()
    {
        SceneManager.push(Scene_NewActor);
    };

    //-----------------------------------------------------------------------------
    // Scene_NewActor
    //
    // The scene class of the title screen.

    function Scene_NewActor() {
        this.initialize(...arguments);
    }

    Scene_NewActor.prototype = Object.create(Scene_Base.prototype);
    Scene_NewActor.prototype.constructor = Scene_NewActor;

    Scene_NewActor.prototype.initialize = function() {
        Scene_Base.prototype.initialize.call(this);
    };

    Scene_NewActor.prototype.create = function() {
        Scene_Base.prototype.create.call(this);
        this.createBackground();
        this.createWindowLayer();
        this.createCommandWindow();
        this._count = 30;
        AudioManager.playSe({ "name":"Item3","volume":90,"pitch":100,"pan":0 });
    };

    Scene_NewActor.prototype.start = function() {
        Scene_Base.prototype.start.call(this);
    };

    Scene_NewActor.prototype.setBackgroundOpacity = function(opacity) {
        this._backgroundSprite.opacity = opacity;
    };

    Scene_NewActor.prototype.createBackground = function() {
        //this._backgroundFilter = new PIXI.filters.BlurFilter();
        this._backgroundSprite = new Sprite();
        this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
        //this._backgroundSprite.filters = [this._backgroundFilter];
        this.addChild(this._backgroundSprite);
        this.setBackgroundOpacity(255);
    };

    Scene_NewActor.prototype.update = function() {
        Scene_Base.prototype.update.call(this);

        if (this.isBusy()) {
         return;   //this._commandWindow.open();
        }

        if(this._isTrigger)
        {
            this._count--;
        }

        if(this._count > 0)
        {
            this._count--;
        }
        if( this._count <= 0 )
        {
            if( !this._isTrigger &&( Input.isTriggered("ok") ||  Input.isTriggered("cancel") || TouchInput.isTriggered() ) )
            {
                SoundManager.playCursor();
                this._isTrigger = true;
            }
        }

        if(this._count <= -30)
        {
            SceneManager.pop();
        }

        const x = this._count * 60;
        this._descriptWindow.x = x;
        //this._headderWindow.x = x;
    };

    Scene_NewActor.prototype.isBusy = function() {
        return (
            //this._commandWindow.isClosing() ||
            Scene_Base.prototype.isBusy.call(this)
        );
    };

    Scene_NewActor.prototype.terminate = function() {
        Scene_Base.prototype.terminate.call(this);
        SceneManager.snapForBackground();
        if (this._gameTitleSprite) {
            this._gameTitleSprite.bitmap.destroy();
        }
    };

    Scene_NewActor.prototype.helpWindowRect = function() {
        const adJustY = 23;
        const wx = 1800;//Graphics.boxWidth * 0.2;
        const wy = 128;//64 + 64;
        const ww = Graphics.boxWidth;
        const wh = Graphics.boxHeight * 0.8;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_NewActor.prototype.createCommandWindow = function() {

        $gameTemp._actorId = 1;
        $gameTemp._skillId = 20;

        const skill = $dataSkills[$gameTemp._skillId];
        const actor = $gameActors.actor($gameTemp._actorId);

        let baseWindow = null;
        {
            const rect = this.helpWindowRect();
            let window = new Window_Base(rect);
            this._descriptWindow = window
            this.addWindow(window);
            window.drawAllContents(  actor, 0, 0);
            baseWindow = window;
        }

        // {
        //     const x = baseWindow.x;
        //     const h = 56;
        //     const y = baseWindow.y - h;
        //     const w = baseWindow.width;
        //     const rect = new Rectangle( x, y, w, h );
        //     let window = new Window_Base(rect);
        //     this._headderWindow = window
        //     this.addWindow(window);
        //     const textWidth = 240;
        //     window.drawActorFace(actor, 0, -64);


        //     window.drawIcon(skill.iconIndex, w - textWidth - 32, 0);
        //     window.drawText(skill.name, w - textWidth, 0, textWidth);
        // }
    };

    Game_Interpreter.prototype.gotoGetSkillScene = function()
    {
        SceneManager.push(Scene_GetSkill);
    };

    //-----------------------------------------------------------------------------
    // Scene_GetSkill
    //
    // The scene class of the title screen.

    function Scene_GetSkill() {
        this.initialize(...arguments);
    }

    Scene_GetSkill.prototype = Object.create(Scene_Base.prototype);
    Scene_GetSkill.prototype.constructor = Scene_GetSkill;

    Scene_GetSkill.prototype.initialize = function() {
        Scene_Base.prototype.initialize.call(this);
    };

    Scene_GetSkill.prototype.create = function() {
        Scene_Base.prototype.create.call(this);
        this.createBackground();
        this.createWindowLayer();
        this.createCommandWindow();
        this._count = 30;
        AudioManager.playSe({ "name":"Item3","volume":90,"pitch":100,"pan":0 });
    };

    Scene_GetSkill.prototype.start = function() {
        Scene_Base.prototype.start.call(this);
    };

    Scene_GetSkill.prototype.setBackgroundOpacity = function(opacity) {
        this._backgroundSprite.opacity = opacity;
    };

    Scene_GetSkill.prototype.update = function() {
        Scene_Base.prototype.update.call(this);

        if (this.isBusy()) {
         return;   //this._commandWindow.open();
        }

        if(this._isTrigger)
        {
            this._count--;
        }

        if(this._count > 0)
        {
            this._count--;
        }
        if( this._count <= 0 )
        {
            if( !this._isTrigger &&( Input.isTriggered("ok") ||  Input.isTriggered("cancel") || TouchInput.isTriggered() ) )
            {
                SoundManager.playCursor();
                this._isTrigger = true;
            }
        }

        if(this._count <= -30)
        {
            SceneManager.pop();

            const actor = $gameActors.actor($gameTemp._actorId);
            const skill = $dataSkills[$gameTemp._skillId];
            const name = $dataSystem.skillTypes[skill.stypeId];
            // $gameTemp._actorId = actor._actorId;
            // $gameTemp._skillId = skillId;
            $gameMessage.add(actor.name() + "は" + name + "「" + skill.name + "」を\n習得した！");
            $gameTemp._interpreter.setWaitMode('message');
        }

        const x = Graphics.boxWidth * 0.2 -196 / 2 + this._count * 60;
        this._descriptWindow.x = x;
        this._headderWindow.x = x;
    };

    Scene_GetSkill.prototype.isBusy = function() {
        return (
            //this._commandWindow.isClosing() ||
            Scene_Base.prototype.isBusy.call(this)
        );
    };

    Scene_GetSkill.prototype.terminate = function() {
        Scene_Base.prototype.terminate.call(this);
        SceneManager.snapForBackground();
        if (this._gameTitleSprite) {
            this._gameTitleSprite.bitmap.destroy();
        }
    };

    Scene_GetSkill.prototype.helpWindowRect = function() {
        const adJustY = 23;
        const wx = 1800;//Graphics.boxWidth * 0.2;
        const wy = 128;//64 + 64;
        const ww = Graphics.boxWidth * 0.6 + 196;
        const wh = Graphics.boxHeight * 0.7 - adJustY;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_GetSkill.prototype.createCommandWindow = function() {

        const skill = $dataSkills[$gameTemp._skillId];
        const actor = $gameActors.actor($gameTemp._actorId);

        let baseWindow = null;
        {
            const rect = this.helpWindowRect();
            let window = new Window_Base(rect);
            this._descriptWindow = window
            this.addWindow(window);
            window.drawTextEx3(skill.getDescript(), 0, 0, 644);
            baseWindow = window;
        }

        {
            const x = baseWindow.x;
            const h = 56;
            const y = baseWindow.y - h;
            const w = baseWindow.width;
            const rect = new Rectangle( x, y, w, h );
            let window = new Window_Base(rect);
            this._headderWindow = window
            this.addWindow(window);
            const textWidth = 240;
            window.drawActorFace(actor, 0, -64);


            window.drawIcon(skill.iconIndex, w - textWidth - 32, 0);
            window.drawText(skill.name, w - textWidth, 0, textWidth);
            window.drawText($dataSystem.skillTypes[skill.stypeId], w - textWidth - 160, 0, 120, 'right');
        }
    };

    Game_Enemy.prototype.allSkills = function() {
        let skills = []
    
        const traits = $dataEnemies[this.enemy().id].traits;
    
        for(let i = 0; i < traits.length; ++i)
        {
          const trait = traits[i];
    
          if(trait.code == 43)
          {
            skills.push( $dataSkills[trait.dataId] );
          }
        }
    
        const actions = this.enemy().actions;
        for (let i = 0; i < actions.length; ++i) {
          const skill = $dataSkills[actions[i].skillId];
          if (skill)
          {
            skills.push(skill);
          } 
        }
        return skills;
      };

    Game_Enemy.prototype.skills = function() {
        let skills = []
    
        const traits = $dataEnemies[this.enemy().id].traits;
    
        for(let i = 0; i < traits.length; ++i)
        {
          const trait = traits[i];
    
          if(trait.code == 43)
          {
            skills.push( $dataSkills[trait.dataId] );
          }
        }
    
        const actions = this.enemy().actions;
        for (let i = 0; i < actions.length; ++i) {
          const skill = $dataSkills[actions[i].skillId];
          if (skill)
          {
            skills.push(skill);
          } 
        }
        return skills;
      };

    Window_Message.prototype.flushTextState = function(textState) {
        const text = textState.buffer;
        const rtl = textState.rtl;
        const width = this.textWidth(text);
        const height = textState.height;
        const x = rtl ? textState.x - width : textState.x;
        const y = textState.y;
        if (textState.drawing) {
            this.contents.drawText(text, x + 32, y + 16, width, height);
        }
        textState.x += rtl ? -width : width;
        textState.buffer = this.createTextBuffer(rtl);
        const outputWidth = Math.abs(textState.x - textState.startX);
        if (textState.outputWidth < outputWidth) {
            textState.outputWidth = outputWidth;
        }
        textState.outputHeight = y - textState.startY + height;
    };

    Game_Interpreter.prototype.checkTarget = function(skillId)
    {
        const members = $gameParty.battleMembers(); 
        let hitId = -1;
        for(let i = 0; i < members.length; ++i){
         if(members[i].isStateAffected(38))
         { 
            hitId = i;
            break; 
        }
        }
        if(hitId != -1)
        {
            this.iterateBattler(0, 0, function(battler) {
                    if (!battler.isDeathStateAffected()) {
                        battler.forceAction(skillId, hitId);
                        BattleManager.forceAction(battler);
                        this.setWaitMode('action');
                    }
                    }.bind(this));
            
            $gameParty.members().forEach(function(actor) {
                actor.removeState(38);
            
            });
        }
    };

    Sprite_Gauge.prototype.smoothness = function() {
        // return this._statusType === "time" ? 5 : 20;
        return 2;
    };
    
    Window_BattleLog.prototype.waitForNewLine = function() {
        // let baseLine = 0;
        // if (this._baseLineStack.length > 0) {
        //     baseLine = this._baseLineStack[this._baseLineStack.length - 1];
        // }
        // if (this._lines.length > baseLine) {
        //     this.wait();
        // }
    };

    Game_Action.prototype.speed = function() {
        const agi = this.subject().agi;
        let speed = agi /*+ Math.randomInt(Math.floor(5 + agi / 4))*/;
        if (this.item()) {
            speed += this.item().speed;
        }
        if (this.isAttack()) {
            speed += this.subject().attackSpeed();
        }
        return speed;
    };

    BattleManager.startBattle = function() {

        console.log("startBattle");
        for(let i = 0; i < 17; ++i)
        {
            $gameSwitches.setValue(1 + i,false);
        }

        this._turn = 0;
        this._oldTurn = -1;
    
        this._phase = 'start';
        $gameSystem.onBattleStart();
        $gameParty.onBattleStart();
        $gameTroop.onBattleStart();

        if(!this._tutorial)
        {
            $gameTemp.reserveCommonEvent(17);
            this._tutorial = true;
        }

        //this.displayStartMessages();
    };

    BattleManager.endAllBattlersTurn = function() {

        if( this._turn == this._oldTurn )
        {
            return;
        }

        this._oldTurn = this._turn;

        var repeatCount = 1;

        for (const battler of this.allBattleMembers()) {
            const skills = battler.passiveSkills();

            for(let i = 0; i < skills.length; ++i)
            {
                if(skills[i].meta.endAllBattlersTurn)
                {
                    let = num = Number(skills[i].meta.endAllBattlersTurn);
                    if(num > repeatCount)
                    {
                        repeatCount = num;
                    }
                }
            }
        }

        for(let rep = 0; rep < repeatCount; ++rep)
        {

            for (const battler of this.allBattleMembers()) {
                battler.onTurnEnd();
                this.displayBattlerStatus(battler, false);
            }
    
            for(let i = 0; i < this._turnEndSkills.length; ++i)
            {
                if(this._turnEndSkills[i].turn <= 0)
                {
                    continue;
                }
        
                this._turnEndSkills[i].turn--;
                BattleManager.setForceAction( this.allBattleMembers()[0], [], this._turnEndSkills[i].skillId);
            }
    
            const allies = $gameParty.battleMembers();
    
            {
                for(let i = 0; i < allies.length; ++i)
                {
                    //ランダムバフ
                    if(allies[i].actorId() == 5)
                    {
                        if(allies[i].isAlive())
                        {
                            allies[i].addBuff(Math.ceil(Math.random() * 6),5);
                        }
                    }
                }
            }
    
            {
                let isHit = false;
                for(let i = 0; i < allies.length; ++i)
                {
                    if(allies[i].actorId() == 7)
                    {
                        if(allies[i].isAlive())
                        {
                            isHit = true;
                            break;
                        }
                    }
                }
    
                if(isHit)
                {
                    for(let i = 0; i < allies.length; ++i)
                    {
                        if(allies[i].isAlive())
                        {
                            allies[i].gainHp( Math.ceil(allies[i].mhp * 0.1) );
                        }
                    }
                }
            }
    
            {
                let isHit = false;
                for(let i = 0; i < allies.length; ++i)
                {
                    if(allies[i].actorId() == 9)
                    {
                        if(allies[i].isAlive())
                        {
                            isHit = true;
                            break;
                        }
                    }
                }
    
                if(isHit)
                {
                    for(let i = 0; i < allies.length; ++i)
                    {
                        if(allies[i].isAlive())
                        {
                            if(allies[i].actorId() == 1 || allies[i].actorId() == 9 )
                            {
                                allies[i].addBuff(3,5);
                                allies[i].addBuff(5,5);
                            }
                        }
                    }
                }
            }
        }
    };

    Game_Battler.prototype.passiveStates = function()
    {
        let states = [];

        const skills = this.allSkills();
        for(let i = 0; i < skills.length; ++i)
        {
            const skill = skills[i]; 
            if(skill == undefined)
            {
                continue;
            }
            if(skill.stypeId != 3/*passiveId */)
            {
                continue;
            }
            if( skill.meta.passivestate )
            {
                const splits = skill.meta.passivestate.split(',');

                for(let r = 0; r < splits.length; ++r)
                {
                    states.push(Number(splits[r]));
                }
            }
        }

        return states;
    }

    Game_BattlerBase.prototype.isStateAffected = function(stateId) {

        const states = this.passiveStates();

        if(states.includes(stateId))
        {
            return true;
        }

        return this._states.includes(stateId);
    };

    Game_BattlerBase.prototype.states = function() {

        const states = this.passiveStates();

        return this._states.concat(states).map(id => $dataStates[id]);
    };

    Game_Battler.prototype.getRemoveWeakCount = function()
    {
        const skills = this.skills();

        for(let i = 0; i < skills.length; ++i)
        {
            const skill = skills[i];

            if(skill.stypeId != 3)
            {
                if(skill.meta.removeweak)
                {
                    return Number(skill.meta.removeweak);
                }
            }
        }
    }

    Game_Battler.prototype.regenerateAll = function() {

        if(!this.isAlive()){
            if(this.isStateAffected(35))
            {
                this.removeState(this.deathStateId());
            }
        }

        if (this.isAlive()) {

            for(let i = 0; i < this.getRemoveWeakCount(); ++i)
            {
                let buffs = this._buffs;
                let array = [];
                for(let r = 0; r < buffs.length; ++r )
                {
                    if(buffs[r] < 0)
                    {
                        array.push(r);
                    }
                }

                if(array.length == 0)
                {
                    break;
                }

                const index = buffs[ Math.ceil(Math.random() * array.length) ];
                this.addBuff( index, this._buffTurns[index] );
            }
            this.regenerateHp();
            this.regenerateMp();
            this.regenerateTp();
        }
    };

    Scene_Title.prototype.commandWindowRect = function() {
        const offsetX = $dataSystem.titleCommandWindow.offsetX;
        const offsetY = $dataSystem.titleCommandWindow.offsetY;
        const ww = this.mainCommandWidth() + 64;
        const wh = this.calcWindowHeight(3, true);
        const wx = (Graphics.boxWidth - ww) / 2 + offsetX - 364;
        const wy = Graphics.boxHeight - wh - 96 + offsetY + 40;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Title.prototype.createBackground = function() {
        this._backSprite1 = new Sprite(ImageManager.loadTitle1($dataSystem.title1Name));
        this._backSprite2 = new Sprite(ImageManager.loadTitle2($dataSystem.title2Name));
        this.addChild(this._backSprite1);
        this.addChild(this._backSprite2);
    
        //this._logo = new Sprite(ImageManager.loadPicture('logo'));
        this._logo = new Sprite(ImageManager.loadPicture('logotrial'));
        this._logo.x = 8;
        this._logo.y = 32;
        this.addChild(this._logo);
    };

    Scene_Title.prototype.createForeground = function() {
        this._gameTitleSprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
        this.addChild(this._gameTitleSprite);
        if ($dataSystem.optDrawTitle) {
            //this.drawGameTitle();
        }
        this.drawCopyRight();
        this.drawVersion();
    };

    Scene_Title.prototype.drawGameTitle = function() {
        var x = 0;
        var y = Graphics.height / 4;
        var maxWidth = Graphics.width - x * 2;
        var text = $dataSystem.gameTitle;
        this._gameTitleSprite.bitmap.outlineColor = 'black';
        this._gameTitleSprite.bitmap.outlineWidth = 8;
        this._gameTitleSprite.bitmap.fontSize = 72;
        this._gameTitleSprite.bitmap.drawText(text, x, y, maxWidth, 48, 'center');
    };

    Scene_Title.prototype.drawVersion = function() {
        var x = 24;
        var y = Graphics.height - 48;
        this._gameTitleSprite.bitmap.outlineColor = 'black';
        this._gameTitleSprite.bitmap.outlineWidth = 4;
        this._gameTitleSprite.bitmap.fontSize = 16;
        this._gameTitleSprite.bitmap.drawText('version 0.12', x, y, 260, 48, 'left');
    };

    Scene_Title.prototype.drawCopyRight = function() {
        var x = 0;
        var y = Graphics.height - 48;
        var maxWidth = Graphics.width - x * 2;
        this._gameTitleSprite.bitmap.outlineColor = 'black';
        this._gameTitleSprite.bitmap.outlineWidth = 4;
        this._gameTitleSprite.bitmap.fontSize = 16;
        this._gameTitleSprite.bitmap.drawText('© 2024 crows dream', x, y, maxWidth, 48, 'center');
    };

    BattleManager.playBattleBgm = function() {
        // AudioManager.playBgm($gameSystem.battleBgm());
        // AudioManager.stopBgs();
    };

    Scene_Map.prototype.stopAudioOnBattleStart = function() {
        if(BattleManager._isBoss)
        {
            AudioManager.stopBgm();
        }
        // if (!AudioManager.isCurrentBgm($dataMap.bgm)) {
        //      AudioManager.stopBgm();
        // }
        AudioManager.stopBgs();
        AudioManager.stopMe();
        AudioManager.stopSe();
    };

    BattleManager.displayStartMessages = function() {
        // for (const name of $gameTroop.enemyNames()) {
        //     $gameMessage.add(TextManager.emerge.format(name));
        // }
        if (this._preemptive) {
            $gameMessage.add(TextManager.preemptive.format($gameParty.name()));
        } else if (this._surprise) {
            $gameMessage.add(TextManager.surprise.format($gameParty.name()));
        }
    };

    Sprite_Enemy.prototype.update = function() {
        Sprite_Battler.prototype.update.call(this);
        if (this._enemy) {
            this.updateEffect();
            this.updateStateSprite();

            if(this._enemy.isStateAffected(31))
            {
                this.opacity = 0;
            }
        }
    };

    Game_Interpreter.prototype.setNewShopText = function()
    {
        const phase = $gameVariables.value(31);
        const is2 = phase >= 5;
        const is3 = phase >= 8;
        const is4 = phase >= 10;
        
        if(is2)
        {
            this.pluginCommand('xlsxonce',['shop_2']);
        }
        
        if(is3)
        {
            this.pluginCommand('xlsxonce',['shop_3']);
        }
    };

    Game_Interpreter.prototype.setShop = function()
    {
        let array = [];
        $gameTemp._choiceArray = [];
        const phase = $gameVariables.value(31);
        //array.push('初級消耗品の購入');$gameTemp._choiceArray.push(0);
        const is2 = phase >= 5;
        const is3 = phase >= 8;
        const is4 = phase >= 10;
        // if(is2){
        //     array.push('中級消耗品の購入');$gameTemp._choiceArray.push(1);
        // }
        // if(is3)
        // {
        //     array.push('上級消耗品の購入');$gameTemp._choiceArray.push(2);
        // }
        array.push('初級装飾品の購入');$gameTemp._choiceArray.push(3);
        if(is2){
            array.push('中級装飾品の購入');$gameTemp._choiceArray.push(4);
        }
        if(is3){
            array.push('上級装飾品の購入');$gameTemp._choiceArray.push(5);
        }
        // array.push('☆1魔石の購入');$gameTemp._choiceArray.push(6);
        // if(is2){
        //     array.push('☆2魔石の購入');$gameTemp._choiceArray.push(7);
        // }
        // if(is3){
        //     array.push('☆3魔石の購入');$gameTemp._choiceArray.push(8);
        // }
        // if(is4)
        // {
        //     array.push('☆4魔石');$gameTemp._choiceArray.push(10);
        // }
        array.push('特殊な品の購入');$gameTemp._choiceArray.push(9);
        array.push('キャンセル');$gameTemp._choiceArray.push(-1);
        this.setupChoices([array,array.length,0,2,0]);
        this.setWaitMode('message');
    };

    Game_Interpreter.prototype.showNameText = function(name)
    {
        //var 31
        const progress = $gameVariables.value(31);
        let index = 8;

        switch(progress)
        {
            case 1:
                index = 1;
                break;
            case 2:
                index = 1;
                break;
            case 3:
                index = 2;
                break;
            case 4:
                index = 3;
                break;
            case 5:
                index = 4;
                break;
            case 6:
                index = 5;
                break;
            case 7:
                index = 6;
                break;
            case 8:
                index = 7;
                break;
            case 9:
                index = 7;
                break;
            case 10:
                index = 7;
                break;
            case 11:
                index = 7;
                break;
        }
        this.pluginCommand('xlsx',[name + '_talk' + index]);
    }

    Game_Interpreter.prototype.setShopItem = function()
    {
        const index = this._branch[this._indent];
        if(index >= 0)
        {
            if($gameTemp._choiceArray[index] != -1)
            {
                let type = 0;
                let array = [];
                switch($gameTemp._choiceArray[index])
                {
                case 0:type = 0;array = [33];break;
                case 1:type = 0;array = [8,14,17];break;
                case 2:type = 0;array = [9,15,18];break;
                case 3:type = 2;array = [300,301,302,303,304,305,306,307,308,309,310];break;
                case 4:type = 2;array = [320,321,322,323,324,325,326];break;
                case 5:type = 2;array = [340,341,342,343,344,345,346];break;
                case 6:type = 2;array = [106,111,116,121,126,131,136,141,146,151,156,161,166,171,176,181,186,191,197,198,199,200,201];break;
                case 7:type = 2;array = [107,112,117,122,127,132,137,142,147,152,157,162,167,172,177,182,187,192];break;
                case 8:type = 2;array = [108,113,118,123,128,133,138,143,148,153,158,163,168,173,178,183,188,193];break;
                case 9:type = 0;array = [2,3];break;
                case 10:type = 2;array = [109,114,119,124,129,134,139,144,149,154,159,164,169,174,179,184,189,194];break;
                }
                
                let goods = [];

                let data = null;
                switch(type)
                {
                    case 0:
                        data = $dataItems;
                        break;
                    case 2:
                        data = $dataArmors;
                        break;
                }

                for(let i = 0; i < array.length; ++i)
                {
                    if(data[array[i]].name == "")
                    {
                        continue;
                    }
                    goods.push([type, array[i], 0, 0]);
                }
                
                SceneManager.push(Scene_Shop);
                SceneManager.prepareNextScene(goods, false);
                
            }
            else
            {
             this._index = this._list.length;
            }
        }
        else
        {
            this._index = this._list.length;
        }

    }

})();
