//-----------------------------------------------------------------------------
// Scene_Item
//
// The scene class of the item screen.

function Scene_Item() {
    this.initialize(...arguments);
}

Scene_Item.prototype = Object.create(Scene_ItemBase.prototype);
Scene_Item.prototype.constructor = Scene_Item;

Scene_Item.prototype.initialize = function() {
    Scene_ItemBase.prototype.initialize.call(this);
    this._shortcutButtons = [];
    this._categoryIndex = 0;
};

Scene_Item.prototype.isEnableSwitchActor = function()
{
    return false;
};

Scene_Item.prototype.isEnableSwitchScene = function()
{
    return false;
};

Scene_Item.prototype.update = function()
{
    Scene_ItemBase.prototype.update.call(this);


    
    if(Input.isTriggered('left'))
    {
        let keys = this.getButtonKey();
        this._categoryIndex = Math.max( this._categoryIndex - 1 , 0);
        this._updateCategory(keys[this._categoryIndex]);
        SoundManager.playCursor();
    }
    
    if(Input.isTriggered('right'))
    {
        let keys = this.getButtonKey();
        this._categoryIndex = Math.min( this._categoryIndex + 1 , keys.length - 1);
        this._updateCategory(keys[this._categoryIndex]);
        SoundManager.playCursor();
    }

};

Scene_Item.prototype.getButtonKey = function()
{
    return[
        //{ buttonKey:'item', categoryKey:'item' },
        //{ buttonKey:'battle', categoryKey:'battle' },
        { buttonKey:'equipitem', categoryKey:'equip' },
        { buttonKey:'stone', categoryKey:'stone' },
        { buttonKey:'keyItem', categoryKey:'keyItem' },
    ];
};

Scene_Item.prototype.create = function() {
    Scene_ItemBase.prototype.create.call(this);
    this.createHelpWindow();
    this.createItemWindow();
    this.createActorWindow();

    const key = this.getButtonKey();

    for(let i = 0; i < key.length; ++i)
    {
        {
            const data = key[i];
            let button = new Sprite_Button(data.buttonKey);
            this._itemButton = button;
            button.x = this.buttonX(5 - i);
            button.y = this.buttonY(5 - 1 - i);
            this.addChild(button);
            button.setClickHandler(()=>{
                this._updateCategory(data);
                SoundManager.playCursor();
            });
            this._shortcutButtons.push(button);
        }
    }
    this._updateCategory(key[0]);
};

Scene_Item.prototype._updateCategory = function(keyData) {
    const category = keyData.categoryKey;
    this._itemWindow.setCategory(category);
    const key = this.getButtonKey();

    for(let i = 0; i < this._shortcutButtons.length; ++i)
    {
        const categoryKey = key[i].categoryKey;
        this._shortcutButtons[i].setEnter( categoryKey == category);
        if(categoryKey == category)
        {
            this._categoryIndex = i;
        }
    }

    this._itemWindow.scrollTo(0, 0);
    this._itemWindow.select(0);
};

Scene_Item.prototype.previousActor = function()
{
    const key = this.getButtonKey();

    this._categoryIndex--;

    if( this._categoryIndex < 0 )
    {
        this._categoryIndex = key.length - 1;
    }
    this._updateCategory(key[this._categoryIndex]);
    SoundManager.playCursor();
};

Scene_Item.prototype.nextActor = function()
{
    const key = this.getButtonKey();

    this._categoryIndex++;

    if( this._categoryIndex >= key.length )
    {
        this._categoryIndex = 0;
    }

    this._updateCategory(key[this._categoryIndex]);
    SoundManager.playCursor();
};

Scene_Item.prototype.helpWindowRect = function()
{
    return this.helpWindowRectBase2();
};

Scene_Item.prototype.categoryWindowRect = function() {
    const wx = 0;
    const wy = this.mainAreaTop();
    const ww = Graphics.boxWidth;
    const wh = this.calcWindowHeight(1, true);
    return new Rectangle(wx, wy, ww, wh);
};

Scene_Item.prototype.createItemWindow = function() {
    const rect = this.itemWindowRectBase();
    this._itemWindow = new Window_ItemList(rect);
    this._itemWindow.setHelpWindow(this._helpWindow);
    this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
    //this._itemWindow.setHandler("cancel", this.onItemCancel.bind(this));
    // this._itemWindow.setHandler("pageup", this.prevCategory.bind(this));
    // this._itemWindow.setHandler("pagedown", this.nextCategory.bind(this));
    this._itemWindow.setHandler("cancel", this.popScene.bind(this));
    this.addWindow(this._itemWindow);

    this._itemWindow.activate();
    // this._categoryWindow.setItemWindow(this._itemWindow);
    // if (!this._categoryWindow.needsSelection()) {
    //     this._itemWindow.y -= this._categoryWindow.height;
    //     this._itemWindow.height += this._categoryWindow.height;
    //     this._itemWindow.createContents();
    //     this._categoryWindow.update();
    //     this._categoryWindow.hide();
    //     this._categoryWindow.deactivate();
    //     this.onCategoryOk();
    // }
};

Scene_Item.prototype.itemWindowRect = function() {
    const wx = 0;
    const wy = this._categoryWindow.y + this._categoryWindow.height;
    const ww = Graphics.boxWidth;
    const wh = this.mainAreaBottom() - wy;
    return new Rectangle(wx, wy, ww, wh);
};

Scene_Item.prototype.user = function() {
    const members = $gameParty.movableMembers();
    const bestPha = Math.max(...members.map(member => member.pha));
    return members.find(member => member.pha === bestPha);
};

Scene_Item.prototype.onCategoryOk = function() {
    this._itemWindow.activate();
    this._itemWindow.selectLast();
};

Scene_Item.prototype.onItemOk = function() {
    $gameParty.setLastItem(this.item());
    this.determineItem();
};

Scene_Item.prototype.playSeForItem = function() {
    SoundManager.playUseItem();
};

Scene_Item.prototype.useItem = function() {
    Scene_ItemBase.prototype.useItem.call(this);
    this._itemWindow.redrawCurrentItem();
};