
//-----------------------------------------------------------------------------
// Scene_MenuBase
//
// The superclass of all the menu-type scenes.

function Scene_MenuBase() {
    this.initialize(...arguments);
}

Scene_MenuBase.prototype = Object.create(Scene_Base.prototype);
Scene_MenuBase.prototype.constructor = Scene_MenuBase;

Scene_MenuBase.prototype.initialize = function() {
    Scene_Base.prototype.initialize.call(this);
};

Scene_MenuBase.prototype.isCreateActorListWindow = function()
{
    return true;
}

Scene_MenuBase.prototype.isEnableSwitchActor = function()
{
    return true;
};

Scene_MenuBase.prototype.isEnableSwitchScene = function()
{
    return true;
};

Scene_MenuBase.prototype.create = function() {
    Scene_Base.prototype.create.call(this);
    this.createBackground();
    this.updateActor();
    this.createWindowLayer();
    this.createButtons();

    if(this.isCreateActorListWindow())
    {
        const rect = new Rectangle( (Graphics.boxWidth - Graphics.uiWidth) / 2 + 8,  Graphics.boxHeight - 71, Graphics.uiWidth - 16, 71 );
        this._actorListWindow = new Window_ActorList(rect);
        this.addWindow(this._actorListWindow);
        this._actorListWindow.setHandler("ok",this.actorChange.bind(this));
        this._actorListWindow.activate();
    }
};

Scene_MenuBase.prototype.switchAlly = function()
{
    $gameTemp._isAlly = !$gameTemp._isAlly;

    SoundManager.playCursor();

    this.updateActor();
    this.onActorChange();
};


Scene_MenuBase.prototype.actorChange = function()
{
    this._actorListWindow.activate();
    this._actor = this._actorListWindow.actor(this._actorListWindow.index());
    $gameParty.setMenuActor(this._actor);
    this.onActorChange();
};

Scene_MenuBase.prototype.update = function() {
    Scene_Base.prototype.update.call(this);
    this.updatePageButtons();

    if(this.isEnableSwitchActor())
    {
        if(Input.isTriggered('pageup'))
        {
            this.previousActor();
        }
        
        if(Input.isTriggered('pagedown'))
        {
            this.nextActor();
        }
    }
    if( SceneManager._scene.constructor == Scene_Equip )
    {
        return;
    }
    if(this.isEnableSwitchScene())
    {
        if(Input.isTriggered('left'))
        {
            this.prevScene();
        }
    
        if(Input.isTriggered('right'))
        {
            this.nextScene();
        }
    }

    if(this._allyButton && this._enemyButton)
    {
        if(this._allyButton.visible == true || this._enemyButton.visible == true)
        {
            if(Input.isTriggered('tab'))
            {
                this.switchAlly();
            }
        }
    }
};

Scene_MenuBase.prototype.helpAreaTop = function() {
    if (this.isBottomHelpMode()) {
        return this.mainAreaBottom();
    } else if (this.isBottomButtonMode()) {
        return 0;
    } else {
        return this.buttonAreaBottom();
    }
};

Scene_MenuBase.prototype.helpAreaBottom = function() {
    return this.helpAreaTop() + this.helpAreaHeight();
};

Scene_MenuBase.prototype.helpAreaHeight = function() {
    return this.calcWindowHeight(2, false);
};

Scene_MenuBase.prototype.mainAreaTop = function() {
    if (!this.isBottomHelpMode()) {
        return this.helpAreaBottom();
    } else if (this.isBottomButtonMode()) {
        return 0;
    } else {
        return this.buttonAreaBottom();
    }
};

Scene_MenuBase.prototype.mainAreaBottom = function() {
    return this.mainAreaTop() + this.mainAreaHeight();
};

Scene_MenuBase.prototype.mainAreaHeight = function() {
    return Graphics.boxHeight - this.buttonAreaHeight() - this.helpAreaHeight();
};

Scene_MenuBase.prototype.actor = function() {
    return this._actor;
};

Scene_MenuBase.prototype.updateActor = function() {
    this._actor = ($gameTemp._targetActor && !$gameTemp._isAlly) ? $gameTemp._targetActor : $gameParty.menuActor();
};

Scene_MenuBase.prototype.createBackground = function() {
    this._backgroundFilter = new PIXI.filters.BlurFilter();
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
    this._backgroundSprite.filters = [this._backgroundFilter];
    this.addChild(this._backgroundSprite);
    this.setBackgroundOpacity(192);
};

Scene_MenuBase.prototype.setBackgroundOpacity = function(opacity) {
    this._backgroundSprite.opacity = opacity;
};

Scene_MenuBase.prototype.createHelpWindow = function() {
    const rect = this.helpWindowRect();
    this._helpWindow = new Window_Help(rect);
    this.addWindow(this._helpWindow);
};

Scene_MenuBase.prototype.helpWindowRect = function() {
    const wx = (Graphics.boxWidth - Graphics.uiWidth) / 2;
    const wy = this.helpAreaTop();
    const ww = Graphics.uiWidth;
    const wh = this.helpAreaHeight();
    return new Rectangle(wx, wy, ww, wh);
};

Scene_Base.prototype.createButtons = function() {
    if (ConfigManager.touchUI) {
        if (this.needsCancelButton()) {
            this.createCancelButton();
        }
        if (this.needsPageButtons()) {
            this.createPageButtons();
        }
    }
};
Scene_Base.prototype.needsCancelButton = function() {
    return false;
};
Scene_MenuBase.prototype.needsCancelButton = function() {
    return true;
};

Scene_Base.prototype.needsPageButtons = function() {
    return false;
};

Scene_Base.prototype.needsPageButtonsHide = function() {
    return false;
};

Scene_Base.prototype.createPageButtons = function() {
    ;
};

Scene_MenuBase.prototype.createPageButtons = function() {
    this._pageupButton = new Sprite_Button("pageup");
    this._pageupButton.x = 4;
    this._pageupButton.y = Graphics.boxHeight - 48 - 4;
    //const pageupRight = this._pageupButton.x + this._pageupButton.width;
    this._pagedownButton = new Sprite_Button("pagedown");
    this._pagedownButton.x = (Graphics.boxWidth - Graphics.uiWidth ) + Graphics.uiWidth - this._pagedownButton.width - 4;
    this._pagedownButton.y = Graphics.boxHeight - 48 - 4;
    this.addWindow(this._pageupButton);
    this.addWindow(this._pagedownButton);
    this._pageupButton.setClickHandler(this.previousActor.bind(this));
    this._pagedownButton.setClickHandler(this.nextActor.bind(this));

    if( SceneManager._scene.constructor == Scene_Equip )
    {
        return;
    }

    
    this._statusButton = new Sprite_Button("status");
    this._statusButton.x = this.buttonX(5);
    this._statusButton.y = this.buttonY(5);
    this.addWindow(this._statusButton);

    this._skillsButton = new Sprite_Button("skills");
    this._skillsButton.x = this.buttonX(4);
    this._skillsButton.y = this.buttonY(4);
    this.addWindow(this._skillsButton);

    this._magicButton = new Sprite_Button("magic");
    this._magicButton.x = this.buttonX(3);
    this._magicButton.y = this.buttonY(3);
    this.addWindow(this._magicButton);

    this._passiveButton = new Sprite_Button("passive", true);
    this._passiveButton.x = this.buttonX(2);
    this._passiveButton.y = this.buttonY(2);
    this.addWindow(this._passiveButton);

    if($gameTemp._isBattleMode)
    {
        this._stateButton = new Sprite_Button("state");
        this._stateButton.x = this.buttonX(1);
        this._stateButton.y = this.buttonY(1);
        this.addWindow(this._stateButton);
        this._stateButton.setClickHandler(this.stateButton.bind(this));
    }
    // else
    // {
    //     this._equipButton = new Sprite_Button("equip");
    //     this._equipButton.x = this.buttonX(1);
    //     this._equipButton.y = this.buttonY(1);
    //     this._equipButton.setClickHandler(this.equipButton.bind(this));
    //     this.addWindow(this._equipButton);
    // }

    if($gameTemp._isAnalyzeMode && $gameTemp._isBattleMode)
    {
        this._enemyButton = new Sprite_Button("enemy");
        this._enemyButton.x = 4;
        this._enemyButton.y = this.buttonY(6);
        this.addWindow(this._enemyButton);
        this._enemyButton.setClickHandler(this.switchAlly.bind(this));
    
        this._allyButton = new Sprite_Button("ally");
        this._allyButton.x = 4;
        this._allyButton.y = this.buttonY(6);
        this.addWindow(this._allyButton);
        this._allyButton.setClickHandler(this.switchAlly.bind(this));
        this._allyButton.hide();
    }

    this._statusButton.setClickHandler(this.statusButton.bind(this));

    this._skillsButton.setClickHandler(this.skillsButton.bind(this));

    this._passiveButton.setClickHandler(this.passiveButton.bind(this));

    this._magicButton.setClickHandler(this.magicButton.bind(this));

    if( SceneManager._scene.constructor == Scene_Status )
    {
        this._statusButton.setEnter(true);
    }

    if( SceneManager._scene.constructor == Scene_Skill )
    {
        switch($gameTemp._stypeId)
        {
            case 1:
            this._skillsButton.setEnter(true);
            break;
            case 2:
            this._magicButton.setEnter(true);
            break;
                default:
            this._passiveButton.setEnter(true);
                break;

        }
    }

    if( SceneManager._scene.constructor == Scene_Equip )
    {
        this._equipButton.setEnter(true);
    }

    if( SceneManager._scene.constructor == Scene_State )
    {
        this._stateButton.setEnter(true);
    }
};

Scene_MenuBase.prototype.nextScene = function()
{
    let value = $gameTemp._scene;
    switch(value)
    {
        case 'status':
            this.skillsButton();
            break;
        case 'skills':
            this.magicButton();
            break;
        case 'magic':
            this.passiveButton();
            break;
        case 'passive':
            if( $gameTemp._isBattleMode )
            {
                this.stateButton();
            }
            else
            {
                //this.equipButton();
                this.statusButton();
            }
            break;
        case 'state':
        case 'equip':
            this.statusButton();
            break;
            case 'load':
                case 'save':
                    break;
        default:
            console.log("error" + value);
    }
};

Scene_MenuBase.prototype.prevScene = function()
{
    let value = $gameTemp._scene;
    switch(value)
    {
        case 'status':
            if( $gameTemp._isBattleMode )
            {
                this.stateButton();
            }
            else
            {
                //this.equipButton();
                this.passiveButton();
            }
            break;
        case 'skills':
            this.statusButton();
            break;
        case 'magic':
            this.skillsButton();
            break;
        case 'passive':
            this.magicButton();
            break;
        case 'state':
        case 'equip':
            this.passiveButton();
            break;
        case 'load':
        case 'save':
            break;
        default:
            console.log("error" + value);
    }
};

Scene_MenuBase.prototype.statusButton = function()
{
    SceneManager.goto( Scene_Status );
    SoundManager.playCursor();
};

Scene_MenuBase.prototype.skillsButton = function()
{
    $gameTemp._stypeId = 1;
    SceneManager.goto( Scene_Skill );
    SoundManager.playCursor();
};

Scene_MenuBase.prototype.magicButton = function()
{
    $gameTemp._stypeId = 2;
    SceneManager.goto( Scene_Skill );
    SoundManager.playCursor();
};

Scene_MenuBase.prototype.passiveButton = function()
{
    $gameTemp._stypeId = 3;
    SceneManager.goto( Scene_Skill );
    SoundManager.playCursor();
};

Scene_MenuBase.prototype.stateButton = function()
{
    SceneManager.goto( Scene_State );
    SoundManager.playCursor();
};

Scene_MenuBase.prototype.equipButton = function()
{
    SceneManager.goto( Scene_Equip );
    SoundManager.playCursor();
};

Scene_Base.prototype.showPageButton = function()
{
    this._pageupButton.show();
    this._pagedownButton.show();
};

Scene_Base.prototype.hidePageButton = function()
{
    this._pageupButton.hide();
    this._pagedownButton.hide();
};

Scene_Base.prototype.showPageButton = function()
{
    this._pageupButton.show();
    this._pagedownButton.show();
};

Scene_Base.prototype.hidePageButton = function()
{
    this._pageupButton.hide();
    this._pagedownButton.hide();
};

Scene_MenuBase.prototype.updatePageButtons = function() {
    if (this._pageupButton && this._pagedownButton) {
        const enabled = this.arePageButtonsEnabled();
        this._pageupButton.visible = enabled;
        this._pagedownButton.visible = enabled;
    }
};

Scene_MenuBase.prototype.arePageButtonsEnabled = function() {
    return true;
};

Scene_Base.prototype.nextActor = function() {

    $gameParty.makeMenuActorNext();
    this.updateActor();
    this.onActorChange();
};

Scene_Base.prototype.previousActor = function() {
    $gameParty.makeMenuActorPrevious();
    this.updateActor();
    this.onActorChange();
};

Scene_MenuBase.prototype.onActorChange = function() {
    SoundManager.playCursor();

    if( this._actorListWindow )
    {
        index = -1;
        let members = $gameParty.allMembers();
        for(let i = 0; i < members.length; ++i)
        {
            if( members[i] == this._actor )
            {
                index = i;
                this._actorListWindow.select(index);
                break;
            }
        }
    }

    if( this._allyButton )
    {
        if( !this._actor.isEnemy() )
        {
            this._allyButton.show();
            this._enemyButton.hide();
            $gameTemp._isAlly = true;
        }
        else
        {
            this._allyButton.hide();
            this._enemyButton.show();
            $gameTemp._isAlly = false;
        }
    }

};
