
//-----------------------------------------------------------------------------
// Scene_MessageLog
//
// The superclass of Scene_Save and Scene_Load.

function Scene_MessageLog() {
    this.initialize(...arguments);
}

Scene_MessageLog.prototype = Object.create(Scene_MenuBase.prototype);
Scene_MessageLog.prototype.constructor = Scene_MessageLog;

Scene_MessageLog.prototype.initialize = function() {
    Scene_MenuBase.prototype.initialize.call(this);
};

Scene_MessageLog.prototype.isCreateActorListWindow = function()
{
    return false;
}

Scene_MessageLog.prototype.isEnableSwitchActor = function()
{
    return false;
};

Scene_MessageLog.prototype.isEnableSwitchScene = function()
{
    return false;
};

Scene_MessageLog.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
    DataManager.loadAllSavefileImages();
    this.createHelpWindow();
    this.createListWindow();
    this._helpWindow.setText(this.helpWindowText());
};

Scene_MessageLog.prototype.helpAreaHeight = function() {
    return 0;
};

Scene_MessageLog.prototype.start = function() {
    Scene_MenuBase.prototype.start.call(this);
    this._listWindow.refresh();
};

Scene_MessageLog.prototype.savefileId = function() {
    return this._listWindow.savefileId();
};

Scene_MessageLog.prototype.isSavefileEnabled = function(savefileId) {
    return this._listWindow.isEnabled(savefileId);
};

Scene_MessageLog.prototype.createHelpWindow = function() {
    const rect = this.helpWindowRect();
    this._helpWindow = new Window_Help(rect);
    this.addWindow(this._helpWindow);
};

Scene_MessageLog.prototype.helpWindowRect = function() {
    const wx = 0;
    const wy = this.mainAreaTop();
    const ww = Graphics.boxWidth - 120;
    const wh = this.calcWindowHeight(1, false);
    return new Rectangle(wx, wy, ww, wh);
};

Scene_MessageLog.prototype.createListWindow = function() {
    const rect = this.listWindowRect();
    this._listWindow = new Window_MessageLog(rect);
    this._listWindow.setHandler("ok", this.onSavefileOk.bind(this));
    this._listWindow.setHandler("cancel", this.popScene.bind(this));
    this._listWindow.refresh();
    this._listWindow.setMaxTopRow();
    this.addWindow(this._listWindow);
};

Scene_MessageLog.prototype.listWindowRect = function() {
    const wx = 0;
    const wy = this.mainAreaTop() + this._helpWindow.height;
    const ww = Graphics.boxWidth;
    const wh = this.mainAreaHeight() - this._helpWindow.height;
    return new Rectangle(wx, wy, ww, wh);
};

Scene_MessageLog.prototype.mode = function() {
    return null;
};

Scene_MessageLog.prototype.needsAutosave = function() {
    return $gameSystem.isAutosaveEnabled();
};

Scene_MessageLog.prototype.activateListWindow = function() {
    this._listWindow.activate();
};

Scene_MessageLog.prototype.helpWindowText = function() {
    return "";
};

Scene_MessageLog.prototype.firstSavefileId = function() {
    return 0;
};

Scene_MessageLog.prototype.onSavefileOk = function() {
    this._listWindow.activate();
};
