
//-----------------------------------------------------------------------------
// Scene_Options
//
// The scene class of the options screen.

function Scene_Options() {
    this.initialize(...arguments);
}

Scene_Options.prototype = Object.create(Scene_Base.prototype);
Scene_Options.prototype.constructor = Scene_Options;

Scene_Options.prototype.initialize = function() {
    Scene_Base.prototype.initialize.call(this);
};

Scene_Options.prototype.isCreateActorListWindow = function()
{
    return false;
};

Scene_Options.prototype.createCancelButton = function() {
    this._cancelButton = new Sprite_Button("cancel");
    this._cancelButton.x = Graphics.boxWidth - this._cancelButton.width - 4;
    //this._cancelButton.x = Graphics.boxWidth - this._cancelButton.width - 4;
    this._cancelButton.y = this.buttonY() + 48 + 16;
    this.addWindow(this._cancelButton);
};
Scene_Options.prototype.createBackground = function() {
    this._backgroundFilter = new PIXI.filters.BlurFilter();
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
    this._backgroundSprite.filters = [this._backgroundFilter];
    this.addChild(this._backgroundSprite);
    this.setBackgroundOpacity(192);
};
Scene_Options.prototype.setBackgroundOpacity = function(opacity) {
    this._backgroundSprite.opacity = opacity;
};

Scene_Options.prototype.create = function() {
    Scene_Base.prototype.create.call(this);
    this.createBackground();
    this.createWindowLayer();
    this.createOptionsWindow();
    this.createCancelButton();
    this._upButtons = [];
    this._downButtons = [];
    for(let i = 0; i < 4; ++i)
    {
        let upButton = new Sprite_Button("pagedown", true);
        this._upButtons.push(upButton);
        this.addChild( upButton );
        upButton._buttonType = "testup" + i;

        let downButton = new Sprite_Button("pageup", true);
        this._downButtons.push(downButton);
        this.addChild( downButton );
        downButton._buttonType = "testdown" + i;

        upButton.x = 760;
        downButton.x = 206;
        upButton.y = 68 * (i + 0.5) + 219 + 34;
        downButton.y = 68 *( i + 0.5) + 219 + 34;

        switch(i)
        {
            case 0:
                upButton.setClickHandler(this.onBgmUpVolume.bind(this));
                downButton.setClickHandler(this.onBgmDownVolume.bind(this));        
            break;
            case 1:
                upButton.setClickHandler(this.onBgsUpVolume.bind(this));
                downButton.setClickHandler(this.onBgsDownVolume.bind(this));        
            break;
            case 2:
                upButton.setClickHandler(this.onMeUpVolume.bind(this));
                downButton.setClickHandler(this.onMeDownVolume.bind(this));        
            break;
            case 3:
                upButton.setClickHandler(this.onSeUpVolume.bind(this));
                downButton.setClickHandler(this.onSeDownVolume.bind(this));        
            break;

        }
    }
};

Scene_Options.prototype.onBgmUpVolume = function()
{
    this._optionsWindow.changeVolume("bgmVolume",true);
};

Scene_Options.prototype.onBgmDownVolume = function()
{
    this._optionsWindow.changeVolume("bgmVolume",false);
};

Scene_Options.prototype.onBgsUpVolume = function()
{
    this._optionsWindow.changeVolume("bgsVolume",true);
};

Scene_Options.prototype.onBgsDownVolume = function()
{
    this._optionsWindow.changeVolume("bgsVolume",false);
};

Scene_Options.prototype.onMeUpVolume = function()
{
    this._optionsWindow.changeVolume("meVolume",true);
};

Scene_Options.prototype.onMeDownVolume = function()
{
    this._optionsWindow.changeVolume("meVolume",false);
};

Scene_Options.prototype.onSeUpVolume = function()
{
    this._optionsWindow.changeVolume("seVolume",true);
};

Scene_Options.prototype.onSeDownVolume = function()
{
    this._optionsWindow.changeVolume("seVolume",false);
};

Scene_Options.prototype.terminate = function() {
    Scene_Base.prototype.terminate.call(this);
    ConfigManager.save();
};

Scene_Options.prototype.createOptionsWindow = function() {
    const rect = this.optionsWindowRect();
    this._optionsWindow = new Window_Options(rect);
    this._optionsWindow.setHandler("cancel", this.popScene.bind(this));
    this.addWindow(this._optionsWindow);
};

Scene_Options.prototype.optionsWindowRect = function() {
    const n = Math.min(this.maxCommands(), this.maxVisibleCommands());
    const ww = 400;
    const wh = this.calcWindowHeight(n, true);
    const wx = (Graphics.boxWidth - ww) / 2;
    const wy = (Graphics.boxHeight - wh) / 2;
    return new Rectangle(wx, wy, ww, wh);
};

Scene_Options.prototype.maxCommands = function() {
    // Increase this value when adding option items.
    return 7;
};

Scene_Options.prototype.maxVisibleCommands = function() {
    return 12;
};
