
//-----------------------------------------------------------------------------
// Scene_Skill
//
// The scene class of the skill screen.

function Scene_Skill() {
    this.initialize(...arguments);
}

Scene_Skill.prototype = Object.create(Scene_ItemBase.prototype);
Scene_Skill.prototype.constructor = Scene_Skill;

Scene_Skill.prototype.initialize = function() {
    Scene_ItemBase.prototype.initialize.call(this);
    
    switch($gameTemp._stypeId)
    {
        case 3:
            $gameTemp._scene = 'passive';
            break;
        case 2:
            $gameTemp._scene = 'magic';
            break;
        case 1:
            default:
            $gameTemp._scene = 'skills';
            break;
    }
};

Scene_Skill.prototype.isCreateActorListWindow = function()
{
    return true;
};

Scene_Skill.prototype.create = function() {
    Scene_ItemBase.prototype.create.call(this);
    this.createHelpWindow();
    //this.createSkillTypeWindow();
    this.createStatusWindow();
    this.createItemWindow();
    this.createActorWindow();


};

Scene_Skill.prototype.createHelpWindow = function() {
    const rect = this.helpWindowRect();
    this._helpWindow = new Window_Help(rect);
    this.addWindow(this._helpWindow);
};

Scene_Skill.prototype.helpWindowRect = function() {
    return this.helpWindowRectBase();
};

Scene_Skill.prototype.start = function() {
    Scene_ItemBase.prototype.start.call(this);
    this.refreshActor();

    this._itemWindow.setStypeId($gameTemp._stypeId ? $gameTemp._stypeId : 1);

    this.commandSkill();
};

Scene_Skill.prototype.isEnableSwitchScene = function()
{
    return  (!this._actorWindow || !( this._actorWindow.active && this._actorWindow.visible ));
};

Scene_Skill.prototype.update = function(){
    Scene_MenuBase.prototype.update.call(this);
};

Scene_Skill.prototype.createStatusWindow = function() {
    let rect = this.oneLineWindowRect();
    this._statusWindow = new Window_OneLineStatus(rect);
    this.addWindow(this._statusWindow);
};

Scene_Skill.prototype.itemWindowRect = function() {
    const wy = this._statusWindow.y + this._statusWindow.height - 32;
    const ww = Graphics.boxWidth;

    const wx = (Graphics.boxWidth - Graphics.uiWidth) / 2;

    const wh = this.mainAreaHeight() - this._statusWindow.height + 31;
    return new Rectangle(wx, wy, ww, wh);
};

Scene_Skill.prototype.createItemWindow = function() {
    const rect = this.itemWindowRect();
    this._itemWindow = new Window_SkillList(rect);
    this._itemWindow.setHelpWindow(this._helpWindow);
    this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
    this._itemWindow.setHandler("cancel", this.popScene.bind(this));
    this.addWindow(this._itemWindow);
};

Scene_Skill.prototype.needsPageButtons = function() {
    return true;
};

Scene_Skill.prototype.arePageButtonsEnabled = function() {
    return !this.isActorWindowActive();
};

Scene_Skill.prototype.refreshActor = function() {
    const actor = this.actor();
    this._statusWindow.setActor(actor);
    this._itemWindow.setActor(actor);
};

Scene_Skill.prototype.user = function() {
    return this.actor();
};

Scene_Skill.prototype.commandSkill = function() {
    this._itemWindow.activate();
    this._itemWindow.selectLast();
};

Scene_Skill.prototype.onItemOk = function() {
    this._itemWindow.activate();
    // this.actor().setLastMenuSkill(this.item());
    // this.determineItem();
};

Scene_Skill.prototype.onItemCancel = function() {
    this._itemWindow.deselect();
};

Scene_Skill.prototype.playSeForItem = function() {
    SoundManager.playUseSkill();
};

Scene_Skill.prototype.useItem = function() {
    Scene_ItemBase.prototype.useItem.call(this);
    this._statusWindow.refresh();
    this._itemWindow.refresh();
};

Scene_Skill.prototype.onActorChange = function() {
    Scene_MenuBase.prototype.onActorChange.call(this);
    this.refreshActor();
    this._itemWindow.deselect();
};
