
//-----------------------------------------------------------------------------
// Scene_State
//
// The scene class of the skill screen.

function Scene_State() {
    this.initialize(...arguments);
}

Scene_State.prototype = Object.create(Scene_ItemBase.prototype);
Scene_State.prototype.constructor = Scene_State;

Scene_State.prototype.initialize = function() {
    Scene_ItemBase.prototype.initialize.call(this);
    $gameTemp._scene = 'state';
};

Scene_State.prototype.isCreateActorListWindow = function()
{
    return true;
};

Scene_State.prototype.create = function() {
    Scene_ItemBase.prototype.create.call(this);
    this.createHelpWindow();
    //this.createSkillTypeWindow();
    this.createStatusWindow();
    this.createItemWindow();
    this.createActorWindow();


};

Scene_State.prototype.start = function() {
    Scene_ItemBase.prototype.start.call(this);
    this.refreshActor();

    this.commandSkill();
};

Scene_State.prototype.update = function(){
    Scene_MenuBase.prototype.update.call(this);
};

// Scene_State.prototype.createSkillTypeWindow = function() {
//     const rect = this.skillTypeWindowRect();
//     this._skillTypeWindow = new Window_SkillType(rect);
//     this._skillTypeWindow.setHelpWindow(this._helpWindow);
//     this._skillTypeWindow.setHandler("skill", this.commandSkill.bind(this));
//     this._skillTypeWindow.setHandler("cancel", this.popScene.bind(this));
//     this._skillTypeWindow.setHandler("pagedown", this.nextActor.bind(this));
//     this._skillTypeWindow.setHandler("pageup", this.previousActor.bind(this));
//     this.addWindow(this._skillTypeWindow);
// };

// Scene_State.prototype.skillTypeWindowRect = function() {
//     const ww = this.mainCommandWidth();
//     const wh = this.calcWindowHeight(3, true);
//     const wx = Graphics.uiWidth - this.mainCommandWidth() + (Graphics.boxWidth - Graphics.uiWidth) / 2;
//     const wy = this.mainAreaTop();
//     return new Rectangle(wx, wy, ww, wh);
// };

Scene_State.prototype.createStatusWindow = function() {
    let rect = this.oneLineWindowRect();

    //this._statusWindow = new Window_SkillStatus(rect);
    this._statusWindow = new Window_OneLineStatus(rect);
    this.addWindow(this._statusWindow);
};

// Scene_State.prototype.statusWindowRect = function() {
//     const ww = Graphics.uiWidth - this.mainCommandWidth();
//     const wh = this._skillTypeWindow.height;
//     const wx = (Graphics.boxWidth - Graphics.uiWidth) / 2;//Graphics.boxWidth - ww;

//     const wy = this.mainAreaTop();
//     return new Rectangle(wx, wy, ww, wh);
// };

Scene_State.prototype.createItemWindow = function() {
    this._itemWindow = new Window_StateList(this.itemWindowRectBase());
    this._itemWindow.setHelpWindow(this._helpWindow);
    this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
    this._itemWindow.setHandler("cancel", this.popScene.bind(this));

    //this._itemWindow.setHandler("pagedown", this.nextActor.bind(this));
    //this._itemWindow.setHandler("pageup", this.previousActor.bind(this));
    //this._skillTypeWindow.setSkillWindow(this._itemWindow);
    this.addWindow(this._itemWindow);
};

Scene_State.prototype.needsPageButtons = function() {
    return true;
};

Scene_State.prototype.arePageButtonsEnabled = function() {
    return !this.isActorWindowActive();
};

Scene_State.prototype.refreshActor = function() {
    const actor = this.actor();
    //this._skillTypeWindow.setActor(actor);
    this._statusWindow.setActor(actor);
    this._itemWindow.setActor(actor);
};

Scene_State.prototype.user = function() {
    return this.actor();
};

Scene_State.prototype.commandSkill = function() {
    this._itemWindow.activate();
    this._itemWindow.selectLast();
};

Scene_State.prototype.onItemOk = function() {
    this._itemWindow.activate();
};

Scene_State.prototype.onItemCancel = function() {
    this._itemWindow.deselect();
    //this._skillTypeWindow.activate();
};

Scene_State.prototype.playSeForItem = function() {
    SoundManager.playUseSkill();
};

Scene_State.prototype.useItem = function() {
    Scene_ItemBase.prototype.useItem.call(this);
    this._statusWindow.refresh();
    this._itemWindow.refresh();
};

Scene_State.prototype.onActorChange = function() {
    Scene_MenuBase.prototype.onActorChange.call(this);
    this.refreshActor();
    this._itemWindow.deselect();
    //this._skillTypeWindow.activate();
};
