function Window_ActorCommand() {
    this.initialize(...arguments);
}

Window_ActorCommand.prototype = Object.create(Window_Command.prototype);
Window_ActorCommand.prototype.constructor = Window_ActorCommand;

Window_ActorCommand.prototype.initialize = function(rect) {
    Window_Command.prototype.initialize.call(this, rect);
    this.openness = 0;
    this.deactivate();
    this._actor = null;
};

Window_ActorCommand.prototype.makeCommandList = function() {
    if (this._actor) {
        this.addAttackCommand();
        this.addSkillCommands();
        this.addGuardCommand();
        //this.addItemCommand();
    }
};

Window_ActorCommand.prototype.addAttackCommand = function() {
    this.addCommand(TextManager.attack, "attack", this._actor.canAttack());
};

Window_ActorCommand.prototype.addSkillCommands = function() {
    const skillTypes = this._actor.skillTypes();
    for (const stypeId of skillTypes) {
        if(stypeId == 3 || stypeId == 4)
        {
            continue;
        }
        const name = $dataSystem.skillTypes[stypeId];
        this.addCommand(name, "skill", true, stypeId);
    }
};

Window_ActorCommand.prototype.addGuardCommand = function() {
    this.addCommand(TextManager.guard, "guard", this._actor.canGuard());
};

Window_ActorCommand.prototype.addItemCommand = function() {
    this.addCommand(TextManager.item, "item");
};

Window_ActorCommand.prototype.setup = function(actor) {
    this._actor = actor;
    this.refresh();
    this.selectLast();
    this.activate();
    this.open();
};

Window_ActorCommand.prototype.actor = function() {
    return this._actor;
};

Window_ActorCommand.prototype.processOk = function() {
    if (this._actor) {
        if (ConfigManager.commandRemember) {
            this._actor.setLastCommandSymbol(this.currentSymbol());
        } else {
            this._actor.setLastCommandSymbol("");
        }
    }
    Window_Command.prototype.processOk.call(this);
};

Window_ActorCommand.prototype.selectLast = function() {
    this.forceSelect(0);
    if (this._actor && ConfigManager.commandRemember) {
        const symbol = this._actor.lastCommandSymbol();
        this.selectSymbol(symbol);
        if (symbol === "skill") {
            const skill = this._actor.lastBattleSkill();
            if (skill) {
                this.selectExt(skill.stypeId);
            }
        }
    }
};
// //-----------------------------------------------------------------------------
// // Window_ActorCommand
// //
// // The window for selecting an actor's action on the battle screen.

// function Window_ActorCommand() {
//     this.initialize(...arguments);
// }

// Window_ActorCommand.prototype = Object.create(Window_Command.prototype);
// Window_ActorCommand.prototype.constructor = Window_ActorCommand;

// Window_ActorCommand.prototype.initialize = function(rect) {
//     Window_Command.prototype.initialize.call(this, rect);
//     this.openness = 0;
//     this.deactivate();
//     this._actor = null;
// };

// // Window_ActorCommand.prototype.makeItemList = function() {
// //     if (this._actor) {
// //         this._data = this._actor.skills().filter(item => this.includes(item));
// //     } else {
// //         this._data = [];
// //     }
// // };

// Window_ActorCommand.prototype.makeCommandList = function() {
//     if (this._actor) {

//         // for(let i = 0; i < this._data.length; ++i)
//         // {
//         //     const data = this._data[i];
//         //     this.addCommand("", data, this._actor.canUse(data));
//         // }

//         this.addAttackCommand();

//         this.addCommand($dataSystem.skillTypes[1].name, "skill", true, 1);
//         this.addCommand($dataSystem.skillTypes[1].name, "skill", true, 2);

//         //this.addSkillCommands();
//         this.addGuardCommand();
//         this.addItemCommand();
//     }
// };

// Window_ActorCommand.prototype.addAttackCommand = function() {
//     this.addCommand(TextManager.attack, "attack", this._actor.canAttack() && !$gameSwitches.value(13));
// };

// Window_ActorCommand.prototype.addSkillCommands = function() {
//     const skillTypes = this._actor.skillTypes();
//     for (const stypeId of skillTypes) {
//         const name = $dataSystem.skillTypes[stypeId];
//         if(stypeId == 3)
//         {
//             continue;
//         }
//         if(stypeId == 1)
//         {
//             this.addCommand(name, "skill", true && !$gameSwitches.value(15), stypeId);
//         }
//         if(stypeId == 2)
//         {
//             this.addCommand(name, "skill", true && !$gameSwitches.value(16), stypeId);
//         }
//     }
// };

// Window_ActorCommand.prototype.addGuardCommand = function() {
//     this.addCommand(TextManager.guard, "guard", this._actor.canGuard() && !$gameSwitches.value(14));
// };

// Window_ActorCommand.prototype.addItemCommand = function() {
//     let canItem = true;
//     switch(this._actor._actorId)
//     {
//         case 2:
//         case 4:
//         case 6:
//         canItem = false;
//             break;
//     }

//     this.addCommand(TextManager.item, "item", canItem && !$gameSwitches.value(17));
// };

// Window_ActorCommand.prototype.setup = function(actor) {
//     this._actor = actor;
//     this.refresh();
//     this.selectLast();
//     this.activate();
//     this.open();
// };

// Window_ActorCommand.prototype.actor = function() {
//     return this._actor;
// };

// Window_ActorCommand.prototype.processOk = function() {
//     if (this._actor) {
//         if (ConfigManager.commandRemember) {
//             this._actor.setLastCommandSymbol(this.currentSymbol());
//         } else {
//             this._actor.setLastCommandSymbol("");
//         }
//     }
//     Window_Command.prototype.processOk.call(this);
// };

// Window_ActorCommand.prototype.selectLast = function() {
//     this.forceSelect(0);
//     if (this._actor && ConfigManager.commandRemember) {
//         const symbol = this._actor.lastCommandSymbol();
//         this.selectSymbol(symbol);
//         if (symbol === "skill") {
//             const skill = this._actor.lastBattleSkill();
//             if (skill) {
//                 this.selectExt(skill.stypeId);
//             }
//         }
//     }
// };

// Window_ActorCommand.prototype.drawItemName = function(item, x, y, width, battler) {
//     if (!item) {return;}
//     const iconY = y + (this.lineHeight() - ImageManager.iconHeight) / 2;
//     const textMargin = ImageManager.iconWidth + 4;
//     const itemWidth = Math.max(0, width - textMargin);
//     this.resetTextColor();
//     this.drawIcon(item.iconIndex, x, iconY);

//     if(item.meta.iconLevel)
//     {
//         switch(item.meta.iconLevel)
//         {
//             case '1':
//                 this.drawIcon(155, x, iconY);
//                 break;
//             case '2':
//                 this.drawIcon(156, x, iconY);
//                 break;
//             case '3':
//                 this.drawIcon(157, x, iconY);
//                 break;
//             case '4':
//                 this.drawIcon(158, x, iconY);
//                 break;
//             case '5':
//                 this.drawIcon(159, x, iconY);
//                 break;
//         }
//     }

//     let isQuickSkill = false;
//     if(battler)
//     {
//         if(battler.isStateAffected(54))
//         {
//             if(item.stypeId == 2)
//             {
//                 isQuickSkill = true;
//             }
//         }
//     }

//     if(item.meta.QuickSkill || isQuickSkill )
//     {
//         this.drawIcon(91, x + 4, iconY - 4);
//     }

//     this.drawText(item.name, x + textMargin, y, itemWidth);
// };

// Window_ActorCommand.prototype.drawItem = function(index) {
//     const skill = this.itemAt(index);
//     if (skill) {
//         //const costWidth = this.costWidth();
//         this.contents.fontSize = 24;
//         const rect = this.itemLineRect(index);
//         this.changePaintOpacity(this.isEnabled(skill));
//         this.drawItemName(skill, rect.x, rect.y, rect.width, this._actor);
//         this.contents.fontSize = 16;
        
//         this.drawSkillCost(skill, rect.x, rect.y - 20, rect.width);
//         this.changePaintOpacity(1);
//     }
// };

// Window_ActorCommand.prototype.costWidth = function() {
//     return this.textWidth("000");
// };

// Window_ActorCommand.prototype.drawSkillCost = function(skill, x, y, width) {
//     if (this._actor.skillTpCost(skill) > 0) {
//         this.changeTextColor(ColorManager.tpCostColor());
//         this.drawText(this._actor.skillTpCost(skill), x, y, width, "right");
//     } else if (this._actor.skillMpCost(skill) > 0) {
//         this.changeTextColor(ColorManager.mpCostColor());
//         this.drawText(this._actor.skillMpCost(skill), x, y, width, "right");
//     }
// };


