
//-----------------------------------------------------------------------------
// Window_ActorList
//
// The window for selecting a target actor on the item and skill screens.

function Window_ActorList() {
    this.initialize(...arguments);
}

Window_ActorList.prototype = Object.create(Window_MenuStatus.prototype);
Window_ActorList.prototype.constructor = Window_ActorList;

Window_ActorList.prototype.initialize = function(rect) {
    Window_MenuStatus.prototype.initialize.call(this, rect);
};

Window_ActorList.prototype.drawCharacter = function(
    characterName, characterIndex, x, y
) {
    const bitmap = ImageManager.loadCharacter(characterName);
    const big = ImageManager.isBigCharacter(characterName);
    const pw = bitmap.width / (big ? 3 : 12);
    const ph = bitmap.height / (big ? 4 : 8);
    const n = big ? 0: characterIndex;
    const sx = ((n % 4) * 3 + 1) * pw;
    const sy = Math.floor(n / 4) * 4 * ph;
    this.contents.blt(bitmap, sx, sy, pw, ph, x - pw / 2, y - ph);
};

Window_ActorList.prototype.itemWidth = function() {
    return Math.floor(this.innerWidth / this.maxCols());
};

Window_ActorList.prototype.itemHeight = function() {
    return 42;
};

Window_ActorList.prototype.itemRect = function(index) {
    const maxCols = this.maxCols();
    const itemWidth = this.itemWidth();
    const itemHeight = this.itemHeight();
    const colSpacing = this.colSpacing();
    const rowSpacing = this.rowSpacing();
    const col = index % maxCols;
    const row = Math.floor(index / maxCols);
    const x = col * itemWidth + colSpacing / 2 - this.scrollBaseX();
    const y = row * itemHeight + rowSpacing / 2 - this.scrollBaseY();
    const width = itemWidth - colSpacing;
    const height = itemHeight - rowSpacing;
    return new Rectangle(x, y, width, height);
};

Window_ActorList.prototype.processHandling = function() {
    if (this.isOpenAndActive()) {
        // if (this.isOkEnabled() && this.isOkTriggered()) {
        //     return this.processOk();
        // }
        // if (this.isCancelEnabled() && this.isCancelTriggered()) {
        //     console.log('cancel');
        //     return this.processCancel();
        // }
        if (this.isHandled("pagedown") && Input.isTriggered("pagedown")) {
            return this.processPagedown();
        }
        if (this.isHandled("pageup") && Input.isTriggered("pageup")) {
            return this.processPageup();
        }
    }
};

Window_ActorList.prototype.maxCols = function()
{
    return $gameParty.allMembers().length;
}

Window_ActorList.prototype.maxRows = function()
{
    return 1;
}

Window_ActorList.prototype.drawItem = function(index)
{
    const rect = this.itemRect(index);
    const actor = this.actor(index);
    this.drawActorCharacter(actor,rect.x + rect.width / 2 - 24, rect.y + 40);
}

Window_ActorList.prototype.processOk = function() {
    if (!this.cursorAll()) {
        $gameParty.setTargetActor($gameParty.allMembers()[this.index()]);
    }
    this.callOkHandler();
};

Window_ActorList.prototype.selectLast = function() {
    this.forceSelect($gameParty.targetActor().index() || 0);
};

Window_ActorList.prototype.selectForItem = function(item) {
    const actor = $gameParty.menuActor();
    const action = new Game_Action(actor);
    action.setItemObject(item);
    this.setCursorFixed(false);
    this.setCursorAll(false);
    if (action.isForUser()) {
        if (DataManager.isSkill(item)) {
            this.setCursorFixed(true);
            this.forceSelect(actor.index());
        } else {
            this.selectLast();
        }
    } else if (action.isForAll()) {
        this.setCursorAll(true);
        this.forceSelect(0);
    } else {
        this.selectLast();
    }
};