
//-----------------------------------------------------------------------------
// Window_BattleEnemy
//
// The window for selecting a target enemy on the battle screen.

function Window_BattleEnemy() {
    this.initialize(...arguments);
}

Window_BattleEnemy.prototype = Object.create(Window_Selectable.prototype);
Window_BattleEnemy.prototype.constructor = Window_BattleEnemy;

Window_BattleEnemy.prototype.initialize = function(rect) {
    this._enemies = [];
    Window_Selectable.prototype.initialize.call(this, rect);
    this.refresh();
    this.hide();
    this._isEnemyMode = true;
};

Window_BattleEnemy.prototype.enemyMode = function()
{
    this._isEnemyMode = true;
};

Window_BattleEnemy.prototype.actorMode = function()
{
    this._isEnemyMode = false;
};

Window_BattleEnemy.prototype.maxCols = function() {
    return 1;
};

Window_BattleEnemy.prototype.maxItems = function() {
    return this._enemies.length;
};

Window_BattleEnemy.prototype.enemy = function() {
    return this._enemies[this.index()];
};

Window_BattleEnemy.prototype.enemyIndex = function() {
    const enemy = this.enemy();
    return enemy ? enemy.index() : -1;
};

Window_BattleEnemy.prototype.drawItem = function(index) {
    this.resetTextColor();
    const enemy = this._enemies[index]; 
    const name = enemy.name();
    const rect = this.itemLineRect(index);
    if(enemy.isActor())
    {
        this.drawFace(enemy.faceName(), enemy.faceIndex(), rect.x + 64, rect.y, rect.width, rect.height);
    }
    this.drawText(name, rect.x, rect.y, rect.width);

};

Window_BattleEnemy.prototype.show = function() {
    this.refresh();
    this.forceSelect(0);
    $gameTemp.clearTouchState();
    Window_Selectable.prototype.show.call(this);
};

Window_BattleEnemy.prototype.hide = function() {
    Window_Selectable.prototype.hide.call(this);
    $gameTroop.select(null);
    $gameParty.select(null);
};

Window_BattleEnemy.prototype.refresh = function() {
    if( this._isEnemyMode )
    {
        this._enemies = $gameTroop.aliveMembers();
    }
    else
    {
        let action = BattleManager.inputtingAction();
        if(action)
        {
            if(action.isForDeadFriend() || action.item().scope == 12)
            {
                this._enemies = $gameParty.allBattleMembers();
            }
            else
            {
                this._enemies = $gameParty.aliveMembers();
            }
        }
        else
        {
            this._enemies = $gameParty.aliveMembers();
        }
    }
    Window_Selectable.prototype.refresh.call(this);
};

Window_BattleEnemy.prototype.select = function(index) {
    Window_Selectable.prototype.select.call(this, index);
    if(this._isEnemyMode)
    {
        $gameTroop.select(this.enemy());
    }
    else
    {
        $gameParty.select(this.enemy());
    }
};

Window_BattleEnemy.prototype.processTouch = function() {
    Window_Selectable.prototype.processTouch.call(this);
    // if (this.isOpenAndActive()) {
    //     const target = $gameTemp.touchTarget();
    //     if (target) {
    //         if (this._enemies.includes(target)) {
    //             this.select(this._enemies.indexOf(target));
    //             if ($gameTemp.touchState() === "click") {
    //                 this.processOk();
    //             }
    //         }
    //         $gameTemp.clearTouchState();
    //     }
    // }
};