
//-----------------------------------------------------------------------------
// Window_BattleStatus
//
// The window for displaying the status of party members on the battle screen.

function Window_BattleStatus() {
    this.initialize(...arguments);
}

Window_BattleStatus.prototype = Object.create(Window_StatusBase.prototype);
Window_BattleStatus.prototype.constructor = Window_BattleStatus;

Window_BattleStatus.prototype.initialize = function(rect) {
    Window_StatusBase.prototype.initialize.call(this, rect);
    this.frameVisible = false;
    this.openness = 0;
    this._bitmapsReady = 0;
    this.preparePartyRefresh();

    this._faceWindows = [];
    this._statusWindows = [];
    this._faceStateWindows = [];
    for(let i = 0; i < this.maxCols(); ++i)
    {
        this._faceWindows[i] = new Sprite();
        //this._faceWindows[i].setBackgroundType(2);
        this.addChild(this._faceWindows[i]);

        this._faceStateWindows[i] = new Sprite();
        this._faceWindows[i].addChild(this._faceStateWindows[i]);
        this._faceStateWindows[i].bitmap = ImageManager.loadFace('badstate');
        const faceIndex = 7;
        this._faceStateWindows[i].setFrame(faceIndex % 4 * 144, faceIndex >= 4 ? 144 : 0, 144, 144);

        let rect = this.itemRect(i);
        rect.width += 32;
        rect.height += 32;
        this._statusWindows[i] = new Window_StatusBase( rect );
        this._statusWindows[i].setBackgroundType(2);
        this.addChild( this._statusWindows[i] );
    }
};

Window_BattleStatus.prototype.itemRect = function(index) {
    const maxCols = this.maxCols();
    const itemWidth = this.itemWidth();
    const itemHeight = this.itemHeight();
    const colSpacing = this.colSpacing();
    const rowSpacing = this.rowSpacing();
    const col = index % maxCols;
    const row = Math.floor(index / maxCols);
    const x = col * itemWidth + colSpacing / 2 - this.scrollBaseX();
    const y = row * itemHeight + rowSpacing / 2 - this.scrollBaseY();
    const width = itemWidth - colSpacing;
    const height = itemHeight - rowSpacing;
    const actor = this.actor(index); 
    if( actor && actor._damageCount > 0)
    {
        return new Rectangle(x + Math.random() * 20 - 10, y, width, height);
    }
    else
    {
        return new Rectangle(x , y, width, height);
    }
};

Window_BattleStatus.prototype.extraHeight = function() {
    return 10;
};

Window_BattleStatus.prototype.maxCols = function() {
    return 4;
};

Window_BattleStatus.prototype.itemHeight = function() {
    return this.innerHeight;
};

Window_BattleStatus.prototype.maxItems = function() {
    return $gameParty.battleMembers().length;
};

Window_BattleStatus.prototype.rowSpacing = function() {
    return 0;
};

Window_BattleStatus.prototype.updatePadding = function() {
    this.padding = 8;
};

Window_BattleStatus.prototype.actor = function(index) {
    return $gameParty.battleMembers()[index];
};

Window_BattleStatus.prototype.selectActor = function(actor) {
    const members = $gameParty.battleMembers();
    this.select(members.indexOf(actor));
};

Window_BattleStatus.prototype.update = function() {
    Window_StatusBase.prototype.update.call(this);
    // if( $gameSwitches.value(20) )
    // {
    //     for(let i = 0;i < this.maxItems(); ++i)
    //     {
    //         this._statusWindows[i].visible = false;
    //     }
    //     return;
    // }
    for(let i = 0;i < this.maxItems(); ++i)
    {
        this._statusWindows[i].visible = true;
    }
    for(let i = 0; i < this.maxItems(); ++i)
    {
        let actor = this.actor(i);
       if( actor._damageCount > 0)
       {
            actor._damageCount--;
       }

       if( actor._actionCount > 0)
       {
            actor._actionCount--;
       }

       
       if(actor.isSelected() && this.index() != i)
       {
        this.select(i);
       }

       const rect = this.itemRect(i);
       
       this._faceWindows[i].bitmap = ImageManager.loadFace(actor.faceName());
       let faceIndex = actor.faceIndex();

    //    const isDamage = actor._damageCount > 0;
    //    const isAction = actor._actionCount > 0;
    //    const isDanger = actor.hp / actor.mhp <= 0.3;
    //    const isDead = actor.isDead();
    //    const isHeal = false;
    //    if(isDanger)
    //    {
    //         faceIndex = 2;
    //    }
       
    //    if(isAction)
    //    {
    //         if(isDanger)
    //         {
    //             faceIndex = 5; 
    //         }
    //         else
    //         {
    //             faceIndex = 4;
    //         }
    //    }

    //    if(isHeal)
    //    {
    //     faceIndex = 6;
    //    }

    //    if(isDead)
    //    {
    //         faceIndex = 3;
    //    }

    //    if(isDamage)
    //    {
    //         faceIndex = 1;
    //    }

       this._faceWindows[i].setFrame(faceIndex % 4 * 144, faceIndex >= 4 ? 144 : 0, 144, 144);

       this._faceWindows[i].x = rect.x + 8;
       this._faceWindows[i].y = rect.y + 16;
       this._faceWindows[i].width = rect.width;// + 24;
       this._faceWindows[i].height = rect.width;// + 24;

        {
            faceIndex = 7;
            if(actor.isStateAffected(1))
            {
                    faceIndex = 2;
            }else if(actor.isStateAffected(36))
            {
                faceIndex = 0;
            }
            else if(actor.isStateAffected(37))
            {
                faceIndex = 1;
            }
            else if(actor.isStateAffected(38))
            {
                faceIndex = 3;
            }
            
           this._faceStateWindows[i].setFrame(faceIndex % 4 * 144, faceIndex >= 4 ? 144 : 0, 144, 144);
        }
       
       //this._faceWindows[i].setFrame(faceIndex % 4 * 144, faceIndex >= 4 ? 144 : 0, 144, 144);
    }
    // if( $gameSwitches.value(20) )
    // {
    //     this.refresh();
    //     this._isOld = true;
    //     return;
    // }

    // {
    //     if(this._isOld)
    //     {
    //         this._isOld = false;
    //         return;
    //     }
    // }

    //this.refresh();

    if ($gameTemp.isBattleRefreshRequested()) {
        this.preparePartyRefresh();
    }
};

Window_BattleStatus.prototype.preparePartyRefresh = function() {
    $gameTemp.clearBattleRefreshRequest();
    this._bitmapsReady = 0;
    for (const actor of $gameParty.members()) {
        const bitmap = ImageManager.loadFace(actor.faceName());
        bitmap.addLoadListener(this.performPartyRefresh.bind(this));
    }
};

Window_BattleStatus.prototype.performPartyRefresh = function() {
    this._bitmapsReady++;
    if (this._bitmapsReady >= $gameParty.members().length) {
        this.refresh();
    }
};

Window_BattleStatus.prototype.drawItem = function(index) {

    //this.drawItemImage(index);
    this.drawItemStatus(index);

    const actor = this.actor(index);
    if(actor.isStateAffected(36))
    {
        const rect = this.faceRect(index);

        this.drawFace("badstate", 0, rect.x, rect.y, rect.width, rect.height);
    }
    if(actor.isStateAffected(37))
    {
        const rect = this.faceRect(index);

        this.drawFace("badstate", 1, rect.x, rect.y, rect.width, rect.height);
    }
    if(actor.isStateAffected(38))
    {
        const rect = this.faceRect(index);

        this.drawFace("badstate", 3, rect.x, rect.y, rect.width, rect.height);
    }
    if(actor.isStateAffected(1))
    {
        const rect = this.faceRect(index);

        this.drawFace("badstate", 2, rect.x, rect.y, rect.width, rect.height);
    }
};

// Window_BattleStatus.prototype.drawItemImage = function(index) {
//     const actor = this.actor(index);
//     const rect = this.faceRect(index);
//     this.drawActorFace(actor, rect.x, rect.y, rect.width, rect.height);
// };

Window_BattleStatus.prototype.drawItemStatus = function(index) {
    const actor = this.actor(index);
    let rect = this.itemRectWithPadding(index);
    rect.x = 6;
    rect.y = 0;
    const nameX = this.nameX(rect);
    const nameY = this.nameY(rect);
    const stateIconX = this.stateIconX(rect);
    const stateIconY = this.stateIconY(rect);
    const basicGaugesX = this.basicGaugesX(rect);
    const basicGaugesY = this.basicGaugesY(rect);
    // this._statusWindows[index].contents.clear();
    // this._statusWindows[index].hideAdditionalSprites();
    //this._statusWindows[index].placeTimeGauge(actor, nameX, nameY);

    if(!this._statusWindows)
    {
        return;
    }

    if(index <= -1)
    {
        return;
    }

    if(this._statusWindows.length <= index)
    {
        return;
    }

    if(this._statusWindows[index].isOk)
    {
        return;
    }

    this._statusWindows[index].placeActorIndexName(index, nameX, nameY);
    this._statusWindows[index].placeStateIconIndex(index, stateIconX, stateIconY);
    if( $gameSwitches.value(20) )
        {
            return;
        }
    this._statusWindows[index].placeBasicGaugesIndex(index, basicGaugesX, basicGaugesY);
    this._statusWindows[index].isOk = true;
};

Window_BattleStatus.prototype.faceRect = function(index) {
    const rect = this.itemRect(index);
    rect.pad(-1);
    //rect.height = rect.width;
    rect.y = 32;
    rect.height = this.nameY(rect) + this.gaugeLineHeight() / 2 - rect.y;
    return rect;
};

Window_BattleStatus.prototype.nameX = function(rect) {
    return rect.x;
};

Window_BattleStatus.prototype.nameY = function(rect) {
    return this.basicGaugesY(rect) - this.gaugeLineHeight();
};

Window_BattleStatus.prototype.stateIconX = function(rect) {
    return rect.x + rect.width - ImageManager.iconWidth / 2 + 4;
};

Window_BattleStatus.prototype.stateIconY = function(rect) {
    return rect.y + ImageManager.iconHeight / 2 + 4;
};

Window_BattleStatus.prototype.basicGaugesX = function(rect) {
    return rect.x - 6;
};

Window_BattleStatus.prototype.basicGaugesY = function(rect) {
    const bottom = rect.y + rect.height - this.extraHeight();
    const numGauges = ($dataSystem.optDisplayTp ? 3 : 2) - 2;
    return bottom - 40;//this.gaugeLineHeight() * numGauges;
};
