
//-----------------------------------------------------------------------------
// Window_MessageLog
//
// The window for selecting a save file on the save and load screens.

function Window_MessageLog() {
    this.initialize(...arguments);
}

Window_MessageLog.prototype = Object.create(Window_Selectable.prototype);
Window_MessageLog.prototype.constructor = Window_MessageLog;

Window_MessageLog.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    this.activate();

    this.select( this.maxItems() - 1 );
};

Window_MessageLog.prototype.maxItems = function() {
    return $gameMessage._log.length;
};

Window_MessageLog.prototype.numVisibleRows = function() {
    return 6;
};

Window_MessageLog.prototype.itemHeight = function() {
    return Math.floor(this.innerHeight / this.numVisibleRows());
};

Window_MessageLog.prototype.drawItem = function(index) {
    //const savefileId = this.indexToSavefileId(index);
    //const info = DataManager.savefileInfo(savefileId);
    const rect = this.itemRectWithPadding(index);
    this.resetTextColor();

    let data = $gameMessage._log[index];

    this.changePaintOpacity(!data.isEx);

    let texts = data.text.split('<br>');
    
    let row = 0;
    if(data.name)
    {
        this.drawTextEx(data.name, rect.x + 12,rect.y + rect.height / 2 - 20);
    }
    
    for(let i = 0; i < texts.length; ++i)
    {
        if(data.isEx)
        {
            this.drawTextEx(texts[i], rect.x + 164,rect.y + 32 * row + 4 + 16);
        }
        else
        {
            this.drawTextEx(texts[i], rect.x + 164,rect.y + 32 * row + 4);
        }
        row++;
    }

    //this.drawTitle(savefileId, rect.x, rect.y + 4);
    //if (info) {
        //this.drawContents(info, rect);
    //}
};


Window_MessageLog.prototype.drawTitle = function(savefileId, x, y) {
    if (savefileId === 0) {
        this.drawText(TextManager.autosave, x, y, 180);
    } else {
        this.drawText(TextManager.file + " " + savefileId, x, y, 180);
    }
};

Window_MessageLog.prototype.drawContents = function(info, rect) {
    const bottom = rect.y + rect.height;
    if (rect.width >= 420) {
        this.drawPartyCharacters(info, rect.x + 220, bottom - 8);
    }
    const lineHeight = this.lineHeight();
    const y2 = bottom - lineHeight - 4;
    if (y2 >= lineHeight) {
        this.drawPlaytime(info, rect.x, y2, rect.width);
    }
};

Window_MessageLog.prototype.drawPartyCharacters = function(info, x, y) {
    if (info.characters) {
        let characterX = x;
        for (const data of info.characters) {
            this.drawCharacter(data[0], data[1], characterX, y);
            characterX += 48;
        }
    }
};

Window_MessageLog.prototype.drawPlaytime = function(info, x, y, width) {
    if (info.playtime) {
        this.drawText(info.playtime, x, y, width, "right");
    }
};

Window_MessageLog.prototype.playOkSound = function() {
    //
};