
//-----------------------------------------------------------------------------
// Window_SkillList
//
// The window for selecting a skill on the skill screen.

function Window_SkillList() {
    this.initialize(...arguments);
}

Window_SkillList.prototype = Object.create(Window_Selectable.prototype);
Window_SkillList.prototype.constructor = Window_SkillList;

Window_SkillList.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    this._actor = null;
    this._stypeId = 0;
    this._data = [];
};

Window_SkillList.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
        this.scrollTo(0, 0);
    }
};

Window_SkillList.prototype.setStypeId = function(stypeId) {
    if (this._stypeId !== stypeId) {
        this._stypeId = stypeId;
        this.refresh();
        this.scrollTo(0, 0);
    }
};

Window_SkillList.prototype.maxCols = function() {
    return 2;
};

Window_SkillList.prototype.colSpacing = function() {
    return 4;
};

Window_SkillList.prototype.maxItems = function() {
    return this._data ? this._data.length : 1;
};

Window_SkillList.prototype.item = function() {
    return this.itemAt(this.index());
};

Window_SkillList.prototype.itemAt = function(index) {
    return this._data && index >= 0 ? this._data[index] : null;
};

Window_SkillList.prototype.isCurrentItemEnabled = function() {
    return this.isEnabled(this._data[this.index()]);
};

Window_SkillList.prototype.includes = function(item) {
    return item && item.stypeId === this._stypeId;
};

Window_SkillList.prototype.isEnabled = function(item) {
    return this._actor && this._actor.canUse(item);
};

Window_SkillList.prototype.makeItemList = function() {
    if (this._actor) {
        this._data = this._actor.skills().filter(item => this.includes(item));
    } else {
        this._data = [];
    }
};

Window_SkillList.prototype.selectLast = function() {
    let index = 0;
    if(this._actor.isEnemy())
    {
        ;
    }
    else
    {
        index = this._data.indexOf(this._actor.lastSkill());
    }
    this.forceSelect(index >= 0 ? index : 0);
};

Window_SkillList.prototype.drawItemName = function(item, x, y, width, battler) {
    if (!item) {return;}
    const iconY = y + (this.lineHeight() - ImageManager.iconHeight) / 2;
    const textMargin = ImageManager.iconWidth + 4;
    const itemWidth = Math.max(0, width - textMargin);
    this.resetTextColor();
    this.drawIcon(item.iconIndex, x, iconY);

    if(item.meta.iconLevel)
    {
        switch(item.meta.iconLevel)
        {
            case '1':
                this.drawIcon(155, x, iconY);
                break;
            case '2':
                this.drawIcon(156, x, iconY);
                break;
            case '3':
                this.drawIcon(157, x, iconY);
                break;
            case '4':
                this.drawIcon(158, x, iconY);
                break;
            case '5':
                this.drawIcon(159, x, iconY);
                break;
        }
    }

    let isQuickSkill = false;
    if(battler)
    {
        if(battler.isStateAffected(54))
        {
            if(item.stypeId == 2)
            {
                isQuickSkill = true;
            }
        }
    }

    if(item.meta.QuickSkill || isQuickSkill )
    {
        this.drawIcon(91, x + 4, iconY - 4);
    }

    this.drawText(item.name, x + textMargin, y, itemWidth);
};

Window_SkillList.prototype.drawItem = function(index) {
    const skill = this.itemAt(index);
    if (skill) {
        //const costWidth = this.costWidth();
        this.contents.fontSize = 24;
        const rect = this.itemLineRect(index);
        this.changePaintOpacity(this.isEnabled(skill));
        this.drawItemName(skill, rect.x, rect.y, rect.width, this._actor);
        this.contents.fontSize = 16;
        
        this.drawSkillCost(skill, rect.x, rect.y - 20, rect.width);
        this.changePaintOpacity(1);
    }
};

Window_SkillList.prototype.costWidth = function() {
    return this.textWidth("000");
};

Window_SkillList.prototype.drawSkillCost = function(skill, x, y, width) {
    if (this._actor.skillTpCost(skill) > 0) {
        this.changeTextColor(ColorManager.tpCostColor());
        this.drawText("TP:" + this._actor.skillTpCost(skill), x, y, width, "right");
    } else if (this._actor.skillMpCost(skill) > 0) {
        this.changeTextColor(ColorManager.mpCostColor());
        this.drawText("MP:" + this._actor.skillMpCost(skill), x, y, width, "right");
    }
};

Window_SkillList.prototype.updateHelp = function() {
    this.setHelpWindowItem(this.item(), this._actor);
};

Window_SkillList.prototype.refresh = function() {
    this.makeItemList();
    Window_Selectable.prototype.refresh.call(this);
};