
//-----------------------------------------------------------------------------
// Window_StateList
//
// The window for selecting a skill on the skill screen.

function Window_StateList() {
    this.initialize(...arguments);
}

Window_StateList.prototype = Object.create(Window_Selectable.prototype);
Window_StateList.prototype.constructor = Window_StateList;

Window_StateList.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    this._actor = null;
    this._stypeId = 0;
    this._data = [];
};

Window_StateList.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
        this.scrollTo(0, 0);
    }
};

Window_StateList.prototype.setStypeId = function(stypeId) {
    if (this._stypeId !== stypeId) {
        this._stypeId = stypeId;
        this.refresh();
        this.scrollTo(0, 0);
    }
};

Window_StateList.prototype.maxCols = function() {
    return 1;
};

Window_StateList.prototype.colSpacing = function() {
    return 4;
};

Window_StateList.prototype.maxItems = function() {
    return this._data ? this._data.length : 1;
};

Window_StateList.prototype.item = function() {
    return this.itemAt(this.index());
};

Window_StateList.prototype.itemAt = function(index) {
    return this._data && index >= 0 ? this._data[index] : null;
};

Window_StateList.prototype.isCurrentItemEnabled = function() {
    return this.isEnabled(this._data[this.index()]);
};

Window_StateList.prototype.includes = function(item) {
    return item && item.stypeId === this._stypeId;
};

Window_StateList.prototype.isEnabled = function(item) {
    return this._actor && this._actor.canUse(item);
};

Window_StateList.prototype.makeItemList = function() {
    if (this._actor) {
        this._data = this._actor.states();

        this._data = this._data.filter(function( item ) {
            return item.id != 3;
          });
    } else {
        this._data = [];
    }
};

Window_StateList.prototype.selectLast = function() {
    this.forceSelect(0);
};

Window_StateList.prototype.drawItemName = function(item, x, y, width, battler) {
    if (!item) {return;}
    const iconY = y + (this.lineHeight() - ImageManager.iconHeight) / 2;
    const textMargin = ImageManager.iconWidth + 4;
    const itemWidth = Math.max(0, width - textMargin);
    this.resetTextColor();
    this.drawIcon(item.iconIndex, x, iconY);

    this.drawText(item.name, x + textMargin, y, itemWidth);
};

Window_StateList.prototype.drawItem = function(index) {
    const skill = this.itemAt(index);
    if (skill) {
        //const costWidth = this.costWidth();
        this.contents.fontSize = 24;
        const rect = this.itemLineRect(index);
        this.changePaintOpacity(this.isEnabled(skill));
        this.drawItemName(skill, rect.x, rect.y, rect.width, this._actor);
        this.contents.fontSize = 16;
        
        this.changePaintOpacity(1);
    }
};

Window_StateList.prototype.updateHelp = function() {
    this.setHelpWindowItem(this.item());
};

Window_StateList.prototype.refresh = function() {
    this.makeItemList();
    Window_Selectable.prototype.refresh.call(this);
};