//=============================================================================
// getItemUserId.js  2019/01/21
//=============================================================================

/*:
 * @plugindesc アイテムを使用したアクターのIDを指定した変数に格納します。
 * @help プラグインコマンドはありません。
 *
 * @param VariableID
 * @desc アイテムを使用したアクターのアクターIDを格納する変数。
 * @default 1
 * @type number
 * @min 1
 * @max 9999
 */

(function() {

/******************************************************************************/
//
// Plugin_Parameters
//
/******************************************************************************/

var p_parameters = PluginManager.parameters("getItemUserId");
var p_ID = p_parameters.VariableID;

/******************************************************************************/
//
// Game_Actor
//
/******************************************************************************/

var Game_Action_prototype_apply = Game_Action.prototype.apply;
Game_Action.prototype.apply = function(target) {
	Game_Action_prototype_apply.call(this, target);
    $gameVariables.setValue(p_ID, target.actorId());
};

var Game_Action_prototype_setTarget = Game_Action.prototype.setTarget;
Game_Action.prototype.setTarget = function(targetIndex) {
	Game_Action_prototype_setTarget.call(this, targetIndex);
    $gameVariables.setValue(p_ID, targetIndex);
};

})(this);