/*:
 * @target MZ
 *
 * @param expRateVariable
 * @text 経験値倍率変数
 * @type variable
 * 
 * @param goldRateVariable
 * @text お金倍率変数
 * @type variable
 * 
 * @param dropItemRateVariable
 * @text アイテムドロップ倍率変数
 * @type variable
 * 
 * @help
 * 変数の数値分、百分率で各種戦闘リザルトの倍率を設定する
 * 対象の変数を戦闘開始時に100で初期化する
 */
(() => {
  'use strict';

  const pluginName = document.currentScript.src.replace(/^.*\/(.*).js$/, function () {
    return arguments[1];
  });

  const pluginParameters = PluginManager.parameters(pluginName);

  const settings = {
    expRateVariable: Number(pluginParameters.expRateVariable),
    goldRateVariable: Number(pluginParameters.goldRateVariable),
    dropItemRateVariable: Number(pluginParameters.dropItemRateVariable),
  };

  function Game_Troop_ExpGoldRateVariableMixIn(gameTroop) {
    const _goldRate = gameTroop.goldRate;
    gameTroop.goldRate = function () {
      return _goldRate.call(this) * $gameVariables.value(settings.goldRateVariable)/100;
    };

    const _expTotal = gameTroop.expTotal;
    gameTroop.expTotal = function () {
      return _expTotal.call(this) * $gameVariables.value(settings.expRateVariable)/100;
    };
  }

  Game_Troop_ExpGoldRateVariableMixIn(Game_Troop.prototype);

  function Game_Enemy_DropItemRateVariableMixIn(gameEnemy) {
    const _dropItemRate = gameEnemy.dropItemRate;
    gameEnemy.dropItemRate = function () {
      return _dropItemRate.call(this) * $gameVariables.value(settings.dropItemRateVariable)/100;
    };
  }

  Game_Enemy_DropItemRateVariableMixIn(Game_Enemy.prototype);

  function Game_System_ExpGoldDropItemRateVariableMixIn(gameSystem) {
    const _onBattleStart = gameSystem.onBattleStart;
    gameSystem.onBattleStart = function () {
      _onBattleStart.call(this);
      /**
       * 戦闘開始時に各種倍率を100％にセット
       */
      $gameVariables.setValue(settings.expRateVariable, 100);
      $gameVariables.setValue(settings.goldRateVariable, 100);
      $gameVariables.setValue(settings.dropItemRateVariable, 100);
    };
  }

  Game_System_ExpGoldDropItemRateVariableMixIn(Game_System.prototype);
})();