//=============================================================================
// InfoWindow.js
//=============================================================================
/*:
 * @target MZ
 * @plugindesc 情報表示ウィンドウをメニュー画面に追加するプラグイン
 * @author Jetsoft
 * @param VerStr
 *      @desc 
 *      @default Version 1.0.0
 *
 *
 * @help 情報表示ウィンドウをメニュー画面上に追加します。
 *
 */
(() => {
	'use strict';

    const pluginName = 'InfoWindow';
    
    // Plugin Parameters
    const parameters = PluginManager.parameters(pluginName);
    const param_VerStr = parameters['VerStr'];

	var _windowA;
	var _windowB;
	var _windowC;

	// マップ上にウィンドウ表示するよ宣言
    const _Scene_Map_stop = Scene_Map.prototype.stop;
    Scene_Map.prototype.stop = function() {
        //_windowA.hide();
        _Scene_Map_stop.apply(this, arguments);
    };

    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function() {
        _Scene_Map_terminate.apply(this, arguments);
        if (!SceneManager.isNextScene(Scene_Battle)) {
            _windowA.hide();
            _windowB.hide();
            _windowC.hide();
        }
    };

    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function() {
        _Scene_Map_createAllWindows.apply(this, arguments);
        this.createWindowA();
    };

    Scene_Map.prototype.createWindowA = function() {
        _windowA = new Window_A();
        _windowB = new Window_B();
        _windowC = new Window_C();
        this.addWindow(_windowA);
        this.addWindow(_windowB);
        this.addWindow(_windowC);
		
		if ($gameMap.mapId()==3) return;

		if ($gameSwitches.value(7)) {
			$gameSwitches.setValue(7,false);
		}
		else {
	        _windowA.hide();
	        _windowB.hide();
	        _windowC.hide();
		}
    };

    const _Scene_Map_callMenu = Scene_Map.prototype.callMenu;
    Scene_Map.prototype.callMenu = function() {
        _Scene_Map_callMenu.apply(this, arguments);
        _windowA.hide();
        _windowB.hide();
        _windowC.hide();
    };
	
    //
    // Window_A
    //
//	function Window_A() {
//	    this.initialize.apply(this, arguments);
//	}

    function Window_A() {
        this.initialize(...arguments);
    }

	Window_A.prototype = Object.create(Window_Base.prototype);
	Window_A.prototype.constructor = Window_A;
//	Window_A.prototype.initialize = function() {
//		var x = -140;
//		var y = 10;
//	    var width = Graphics.width;
//	    var height = 32*4;
//		var rect = new Rectangle(x,y,width,height);
//		var rect = new Rectangle(x,y,width,height);
//	    Window_Base.prototype.initialize.call(this, rect);
//	};

    Window_A.prototype.initialize = function() {
        const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
        Window_Base.prototype.initialize.call(this, rect);

        this.width = 0;
        this.height = 0;
    };

	Window_A.prototype.resetFontSettings = function() {
	    //this.contents.fontFace = $gameSystem.mainFontFace();
		this.contents.fontFace = 'CF';
	    this.contents.fontSize = 26;
	    this.resetTextColor();
		this.contents.textColor = 'white';
		//this.contents.outlineColor = 'black';
		this.contents.outlineColor = "rgb(131, 172, 196)";
		//this.contents.textColor = 'black';
		//this.contents.outlineColor = 'white';
	};


    Window_A.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this.refresh();
    };

    Window_A.prototype.loadWindowskin = function() {
        this.windowskin = ImageManager.loadSystem('InfoWindow');
    };

    //
    // Window_B
    //

    function Window_B() {
        this.initialize(...arguments);
    }

	Window_B.prototype = Object.create(Window_Base.prototype);
	Window_B.prototype.constructor = Window_B;

    Window_B.prototype.initialize = function() {
        const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
        Window_Base.prototype.initialize.call(this, rect);

        this.width = 0;
        this.height = 0;
    };

	Window_B.prototype.resetFontSettings = function() {
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    this.contents.fontSize = 26;
	    this.resetTextColor();
		this.contents.textColor = 'white';
		this.contents.outlineColor = 'black';
	};


    Window_B.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this.refresh();
    };

    Window_B.prototype.loadWindowskin = function() {
        this.windowskin = ImageManager.loadSystem('InfoWindow');
    };

	// ウィンドウに載せる内容
	Window_B.prototype.refresh = function() {
		var mode = $gameVariables.value(14);

		if (mode==1) {
	        this.width = 154;
	        //this.height = 185;
	        this.height = 140;
	        //this.x = 5;
	        //this.y = 337;
	        this.x = 635;
	        this.y = 352;
		    this.contents.clear();
			var sinraido = $gameVariables.value(26);
			var inrando = $gameVariables.value(28);
			var sinraidostr = "\\FS[24]" + String(sinraido) + '%';
			var ts = this.textSizeEx(sinraidostr);
			var dx = Math.floor((144-ts.width) / 2);
			this.drawTextEx(sinraidostr, dx, 5);
			var inrandostr = "\\FS[24]" + String(inrando) + '%';
			var ts2 = this.textSizeEx(inrandostr);
			var dx2 = Math.floor((144-ts2.width) / 2);
			this.drawTextEx(inrandostr, dx, 77);
		}
		if (mode==2) {
	        this.width = 200;
	        this.height = 122;
	        this.x = 1080;
	        this.y = 802;
		    this.contents.clear();
		}
		if (mode==3) {
	        this.width = 200;
	        this.height = 122;
	        this.x = 1080;
	        this.y = 802;
		    this.contents.clear();
		}
		if (mode==4) {
//	        this.width = 174;
//	        this.height = 122;
//	        this.x = 1070;
//	        this.y = 802;
//		    this.contents.clear();
		}
	};

    //
    // Window_C
    //

    function Window_C() {
        this.initialize(...arguments);
    }

	Window_C.prototype = Object.create(Window_Base.prototype);
	Window_C.prototype.constructor = Window_C;

    Window_C.prototype.initialize = function() {
        const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
        Window_Base.prototype.initialize.call(this, rect);

        this.width = 0;
        this.height = 0;
    };

	Window_C.prototype.resetFontSettings = function() {
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    this.contents.fontSize = 26;
	    this.resetTextColor();
		this.contents.textColor = 'white';
		this.contents.outlineColor = 'black';
	};


    Window_C.prototype.update = function() {
        Window_Base.prototype.update.call(this);

        this.refresh();
    };

    Window_C.prototype.loadWindowskin = function() {
        this.windowskin = ImageManager.loadSystem('InfoWindow');
    };

	// ウィンドウに載せる内容
	Window_C.prototype.refresh = function() {
		var mode = $gameVariables.value(14);

		if (mode==1) {
	        this.width = 154;
	        //this.height = 230;
	        this.height = 140;
	        //this.x = 5;
	        //this.y = 600;
	        this.x = 465;
	        //this.y = 294;
	        this.y = 352;
		    this.contents.clear();

			var koudou = $gameVariables.value(24);
			var koudoustr = String(koudou) + "%";
			var ts2 = this.textSizeEx(koudoustr);
			var dx2 = Math.floor((144-ts2.width) / 2);
			//this.drawTextEx("\\FS[24]" + koudoustr, dx2, 63);
			this.drawTextEx("\\FS[24]" + koudoustr, dx2, 5);

			var syojikin = $gameParty.gold();
			if (syojikin>999999) syojikin = 999999;
			var syojikinstr = '￥' + syojikin.toLocaleString();
			var ts3 = this.textSizeEx(syojikinstr);
			var dx3 = Math.floor((144-ts3.width) / 2);
			//this.drawTextEx("\\FS[24]" + syojikinstr, dx3, 135);
			this.drawTextEx("\\FS[24]" + syojikinstr, dx3, 77);
		}
		if (mode==2) {
	        this.width = 200;
	        this.height = 122;
	        this.x = 1080;
	        this.y = 802;
		    this.contents.clear();
		}
		if (mode==3) {
	        this.width = 200;
	        this.height = 122;
	        this.x = 1080;
	        this.y = 802;
		    this.contents.clear();
		}
		if (mode==4) {
//	        this.width = 174;
//	        this.height = 122;
//	        this.x = 1070;
//	        this.y = 802;
//		    this.contents.clear();
		}
	};

	function hankaku2zenkaku(str) {
	    return str.replace(/[A-Za-z0-9]/g, function(s) {
	        return String.fromCharCode(s.charCodeAt(0) + 0xFEE0);
	    });
	}

	// ウィンドウに載せる内容
	Window_A.prototype.refresh = function() {
		var mode = $gameVariables.value(14);

		if (mode==3) {
	        this.width = 1280;
	        this.height = 960;
	        this.x = 0;
	        this.y = 0;
		    this.contents.clear();
		}
		if (mode==4) {
	        this.width = 1280;
	        this.height = 960;
	        this.x = 0;
	        this.y = 0;
		    this.contents.clear();
			this.drawTextEx(param_VerStr, 1000, 802);
		}
		if (mode==1) {
	        //this.width = 1280;
	        //this.height = 960;
	        this.width = 525;
	        this.height = 152;
	        //this.x = 470;
	        //this.y = 145;
	        this.x = 624;
	        this.y = 143;
		    this.contents.clear();
			var date = $gameVariables.value(22);
			var date2 = String(date);
			date2 = "8月" + date2 + "日";
			var datestr = "\\FS[36]" + date2;
			this.drawTextEx(datestr, 0, 0);
		}
		if (mode==2) {
	        this.width = 1280;
	        this.height = 960;
	        this.x = 0;
	        this.y = 0;
		    this.contents.clear();
			this.changeTextColor('#665258');
			this.changeOutlineColor('#f7ca86');
			this.contents.fontSize = 36;
			this.drawText('信頼度　　　999%', 120, 106);
			this.drawText('変態度　　　999%', 120, 156);
			this.drawText('自慰回数　　999回', 120, 206);
			this.drawText('絶頂回数　　999回', 120, 256);
			this.drawText('中出し回数　999回', 120, 306);
			this.drawText('精液接種量　999ml', 120, 356);
			this.drawText('毎日信頼度　+1%', 120, 720);
			this.drawText('バイト代　　+1000円', 120, 770);
			this.drawText('信頼度減少半減', 120, 820);
			var sinraido = $gameVariables.value(26);
			var sinraidostr = "\\FS[36]" + String(sinraido);
			var ts2 = this.textSizeEx(sinraidostr);
			//console.log('width:'+ts2.width);
			var x = (180 - ts2.width) / 2 + 1070 - 16;
			this.drawTextEx(sinraidostr, x, 802);
		}
	};
	
	Game_System.prototype.showInfo = function() {
        _windowA.show();
        _windowB.show();
        _windowC.show();
	};

	Game_System.prototype.hideInfo = function() {
        _windowA.hide();
        _windowB.hide();
        _windowC.hide();
	};


/*
    var _Bitmap_drawTextOutline = Bitmap.prototype._drawTextOutline;
    Bitmap.prototype._drawTextOutline = function(text, tx, ty, maxWidth) {
        if (this.decorationMode === 1) {
            var context = this._context;
            context.fillStyle = this.outlineColor;
            //context.fillText(text, tx + 2, ty + 2, maxWidth);
            context.fillText(text, tx, ty, maxWidth);
        } else {
            _Bitmap_drawTextOutline.call(this, text, tx, ty, maxWidth);
        }
    };
*/

})();
