/*:
 * @target MZ
 * @plugindesc プラグイン

*/
(() => {
  'use strict';

/*
	Scene_Message.prototype.messageWindowRect = function() {
		return new Rectangle(0, 0, Graphics.boxWidth, this.calcWindowHeight(2, false));
	};
*/

Scene_Message.prototype.messageWindowRect = function() {
    const ww = Graphics.boxWidth;

	const fh = 2 * (40 + 10) + $gameSystem.windowPadding() * 2;

    const wh = fh + 8;
    const wx = (Graphics.boxWidth - ww) / 2;
    const wy = 0;
    return new Rectangle(wx, wy, ww, wh);
};

/*
	const _Game_Message_add = Game_Message.prototype.add;
	Game_Message.prototype.add = function (text) {
		text = '\\FS[40]' + text;
		_Game_Message_add.call(this, text);
	};

	Window_Message.prototype.lineHeight = function() {
	    return 50;
	};
*/

    const _Window_Message_update = Window_Message.prototype.update;
    Window_Message.prototype.update = function() {
        _Window_Message_update.apply(this, arguments);

		if ($gameSwitches.value(17)) {
        	//this.windowskin = ImageManager.loadSystem("WindowWhite");
        	this.windowskin = ImageManager.loadSystem("Window");
		}
		else {
        	//this.windowskin = ImageManager.loadSystem("WindowNoOutline4");
        	this.windowskin = ImageManager.loadSystem("Window");
		}
    };

    const _Window_NameBox_update = Window_NameBox.prototype.update;
    Window_NameBox.prototype.update = function() {
        _Window_NameBox_update.apply(this, arguments);

		if ($gameSwitches.value(17)) {
        	//this.windowskin = ImageManager.loadSystem("WindowWhite");
        	this.windowskin = ImageManager.loadSystem("Window");
		}
		else {
        	//this.windowskin = ImageManager.loadSystem("WindowNoOutline4");
        	this.windowskin = ImageManager.loadSystem("Window");
		}
    };

	Window_Message.prototype.resetFontSettings = function() {
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    //this.contents.fontSize = 30;
	    this.contents.fontSize = 26;
	    this.resetTextColor();
		this.contents.textColor = 'black';
		this.contents.outlineColor = 'white';
	};

	Window_ChoiceList.prototype.resetFontSettings = function() {
	    this.contents.fontFace = $gameSystem.mainFontFace();
	    //this.contents.fontSize = 30;
	    this.contents.fontSize = 26;
	    this.resetTextColor();
		this.contents.textColor = 'black';
		this.contents.outlineColor = 'white';
	};

	Window_Message.prototype.loadWindowskin = function() {
    	//this.windowskin = ImageManager.loadSystem("WindowNoOutline4");
    	this.windowskin = ImageManager.loadSystem("Window");
	};

	Window_NameBox.prototype.loadWindowskin = function() {
    	//this.windowskin = ImageManager.loadSystem("WindowNoOutline4");
    	this.windowskin = ImageManager.loadSystem("Window");
	};

	Window_ChoiceList.prototype.loadWindowskin = function() {
    	//this.windowskin = ImageManager.loadSystem("WindowWhite");
    	this.windowskin = ImageManager.loadSystem("Window");
	};

	Window_Options.prototype.changeValue = function(symbol, value) {
		if (symbol!='autotextVolume' && symbol!= 'textspeedVolume') {
		    const lastValue = this.getConfigValue(symbol);
		    if (lastValue !== value) {
		        this.setConfigValue(symbol, value);
		        this.redrawItem(this.findSymbol(symbol));
		        this.playCursorSound();
		    }
		}
		else {
			if (symbol=='autotextVolume') {
		        this.redrawItem(0);
				const lastValue = $gameVariables.value(201);
		        //this.playCursorSound();
			    if (lastValue !== value) {
					$gameVariables.setValue(201,value);
			        this.playCursorSound();
				}
			}
			if (symbol=='textspeedVolume') {
		        this.redrawItem(1);
				const lastValue = $gameVariables.value(202);
		        //this.playCursorSound();
			    if (lastValue !== value) {
					$gameVariables.setValue(202,value);
			        this.playCursorSound();
				}
			}
		}
	};

	Window_Options.prototype.statusText = function(index) {
		console.log('Window_Options.prototype.statusText index:'+index);
		if (index>1) {
		    const symbol = this.commandSymbol(index);
		    const value = this.getConfigValue(symbol);
		    if (this.isVolumeSymbol(symbol)) {
		        return this.volumeStatusText(value);
		    } else {
		        return this.booleanStatusText(value);
		    }
		}
		else {
			if (index == 0) {
				var value = $gameVariables.value(201);
		        return this.volumeStatusText(value);
			}
			if (index == 1) {
				var value = $gameVariables.value(202);
		        return this.volumeStatusText(value);
			}
			return '';
		}
	};

	Window_Options.prototype.loadWindowskin = function() {
	    this.windowskin = ImageManager.loadSystem("WindowWhiteOutline");
	};

	Scene_Options.prototype.optionsWindowRect = function() {
	    const n = Math.min(this.maxCommands(), this.maxVisibleCommands());
	    const ww = 650;
	    const wh = this.calcWindowHeight(n, true);
	    const wx = (Graphics.boxWidth - ww) / 2;
	    const wy = (Graphics.boxHeight - wh) / 2;
	    return new Rectangle(wx, wy, ww, wh);
	};

	function hankaku2zenkaku(str) {
	    return str.replace(/[A-Za-z0-9]/g, function(s) {
	        return String.fromCharCode(s.charCodeAt(0) + 0xFEE0);
	    });
	}

	DataManager.makeSavefileInfo = function() {
	    const info = {};
//		var memo = window.prompt('メモを入力してください');
		var memo = hankaku2zenkaku(String($gameVariables.value(22))) + '日目';
		if (memo==null) memo = '';
	    info.title = $dataSystem.gameTitle;
	    info.characters = $gameParty.charactersForSavefile();
	    info.faces = $gameParty.facesForSavefile();
	    info.playtime = $gameSystem.playtimeText();
	    info.timestamp = Date.now();
		info.memo = memo;
	    return info;
	};

    Scene_Title.prototype.commandWindowRect = function () {
		console.log('***Scene_Title.prototype.commandWindowRect');
        const offsetX = $dataSystem.titleCommandWindow.offsetX;
        const offsetY = $dataSystem.titleCommandWindow.offsetY;
        const ww = this.mainCommandWidth() * 1.6;
        const wh = this.calcWindowHeight(5, true) * 2;
        const wx = (Graphics.boxWidth - ww) / 2 + offsetX;
        const wy = Graphics.boxHeight - wh - 96 + offsetY;
        return new Rectangle(wx, wy, ww, wh);
    };

	Window_TitleCommand.prototype.resetTextColor = function() {
	    this.changeTextColor(ColorManager.normalColor());
	    this.changeOutlineColor('#FFFFFF');
	};

	Window_TitleCommand.prototype.itemWidth = function() {
	    return Math.floor(this.innerWidth / this.maxCols()) * 2;
	};

	Window_TitleCommand.prototype.itemHeight = function() {
	    return (Window_Scrollable.prototype.itemHeight.call(this) + 8) * 2;
	};

	Window_TitleCommand.prototype.drawItem = function(index) {
		console.log('***Window_TitleCommand.prototype.drawItem:'+index);
	    const rect = this.itemLineRect(index);
	    const align = this.itemTextAlign();
	    this.resetTextColor();
	    this.changePaintOpacity(this.isCommandEnabled(index));
	    //this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
	    this.drawTextEx('\\FS[48]\\C[27]'+this.commandName(index), rect.x, rect.y);
	};

	Window_TitleCommand.prototype.drawBackgroundRect = function(rect) {
		console.log('***Window_TitleCommand.prototype.drawBackgroundRect:'+rect);
	    const c1 = "rgba(255, 255, 255, 1)";
	    const c2 = ColorManager.itemBackColor2();
	    const x = rect.x;
	    const y = rect.y;
	    const w = rect.width;
	    const h = rect.height;
	    this.contentsBack.gradientFillRect(x, y, w, h, c1, c2, true);
	    this.contentsBack.strokeRect(x, y, w, h, c1);
	};

	Window_TitleCommand.prototype.loadWindowskin = function() {
	    this._windowskin = ImageManager.loadSystem("WindowWhite");
	};

	Window_Help.prototype.loadWindowskin = function() {
	    this.windowskin = ImageManager.loadSystem("WindowWhiteOutline");
	};

	Window_SavefileList.prototype.updatePadding = function() {
	    this.padding = 96;
	};

	Window_SavefileList.prototype.loadWindowskin = function() {
	    this.windowskin = ImageManager.loadSystem("WindowNoOutline4");
	};

	Window_SavefileList.prototype.numVisibleRows = function() {
	    return 3;
	};

	Window_SavefileList.prototype.drawContents = function(info, rect) {
	    const bottom = rect.y + rect.height;
	    if (rect.width >= 420) {
	        //this.drawPartyCharacters(info, rect.x + 220, bottom - 8);
	    }
	    const lineHeight = this.lineHeight();
	    const y2 = rect.y + 8;
	    const y3 = bottom - lineHeight*3 - 4;
        this.drawPlaytime(info, rect.x, y2, rect.width);
        this.drawComment(info, rect.x+24, y3, rect.width);
	};

	Window_SavefileList.prototype.drawComment = function(info, x, y, width) {
	    if (info.playtime) {
	        this.drawText(info.memo, x, y, width, "left");
	    }
	};

	Game_System.prototype.copySwitches = function() {
		for (var i=1;i<=300;i++) {
			$gameSwitches.setValue(i+600,$gameSwitches.value(i+300));
		}
	}

	DataManager.isAnySavefileExists = function() {
	    const globalInfo = this._globalInfo;
	    const index = globalInfo.slice(1,20).findIndex(x => x);
	    return index >= 0;
	};

	DataManager.latestSavefileId = function() {
	    const globalInfo = this._globalInfo;
	    const validInfo = globalInfo.slice(1,20).filter(x => x);
	    const latest = Math.max(...validInfo.map(x => x.timestamp));
	    const index = globalInfo.findIndex(x => x && x.timestamp === latest);
		if (index==20) index = 1;
	    return index > 0 ? index : 0;
	};

	DataManager.earliestSavefileId = function() {
	    const globalInfo = this._globalInfo;
	    const validInfo = globalInfo.slice(1,20).filter(x => x);
	    const earliest = Math.min(...validInfo.map(x => x.timestamp));
	    const index = globalInfo.findIndex(x => x && x.timestamp === earliest);
	    return index > 0 ? index : 0;
	};

	DataManager.emptySavefileId = function() {
	    const globalInfo = this._globalInfo;
	    const maxSavefiles = this.maxSavefiles();
	    if (globalInfo.length < maxSavefiles) {
	        return Math.max(1, globalInfo.length);
	    } else {
	        //const index = globalInfo.slice(1).findIndex(x => !x);
	        const index = globalInfo.slice(1,20).findIndex(x => !x);
	        return index >= 0 ? index + 1 : -1;
	    }
	};

	Game_System.prototype.makeQuestion = function() {
		// typ 0:加算　1:減算　2:乗算　3:割り算
		var typ = Math.floor( Math.random() * 4 );
		// correct 0:正解　1:間違い
		var correct = Math.floor( Math.random() * 2 );
		var str = '';

		//加算
		if (typ==0) {
			var val1 = Math.floor( Math.random() * 9 ) + 1;
			var val2 = Math.floor( Math.random() * 9 ) + 1;
			var ans = val1 + val2;
			// delta -2,-1,1,2
			var delta = Math.floor( Math.random() * 4 );
			delta = delta - 1;
			if (delta==0) delta = -2;
			if (correct==1) {
				ans = ans + delta;
				if (ans < 1) ans = 1;	// ans=1は絶対に不正解なので問題ない
			}
			str = String(val1) + '+' + String(val2) + '=' + String(ans);
		}

		//減算
		if (typ==1) {
			var val2 = Math.floor( Math.random() * 9 ) + 1;
			var ans = Math.floor( Math.random() * 9 ) + 1;
			var val1 = ans + val2;
			// delta -2,-1,1,2
			var delta = Math.floor( Math.random() * 4 );
			delta = delta - 1;
			if (delta==0) delta = -2;
			if (correct==1) {
				if (ans + delta < 1) {
					ans = ans + 1;
				}
				else {
					ans = ans + delta;
				}
			}
			str = String(val1) + '-' + String(val2) + '=' + String(ans);
		}

		//乗算
		if (typ==2) {
			var val1 = Math.floor( Math.random() * 9 ) + 1;
			var val2 = Math.floor( Math.random() * 9 ) + 1;
			var ans = val1 * val2;
			// delta -2,-1,1,2
			var delta = Math.floor( Math.random() * 4 );
			delta = delta - 1;
			if (delta==0) delta = -2;
			if (correct==1) {
				if (ans + delta < 1) {
					ans = ans + 1;
				}
				else {
					ans = ans + delta;
				}
			}
			str = String(val1) + '×' + String(val2) + '=' + String(ans);
		}

		//割り算
		if (typ==3) {
			var val2 = Math.floor( Math.random() * 9 ) + 1;
			var ans = Math.floor( Math.random() * 9 ) + 1;
			var val1 = ans * val2;
			// delta -2,-1,1,2
			var delta = Math.floor( Math.random() * 4 );
			delta = delta - 1;
			if (delta==0) delta = -2;
			if (correct==1) {
				if (ans + delta < 1) {
					ans = ans + 1;
				}
				else {
					ans = ans + delta;
				}
			}
			str = String(val1) + '÷' + String(val2) + '=' + String(ans);
		}

		$gameVariables.setValue(101,str);
		$gameVariables.setValue(102,correct);
	};

    var _TouchInput__onMouseMove = TouchInput._onMouseMove;
    TouchInput._onMouseMove = function(event) {
        _TouchInput__onMouseMove.apply(this, arguments);
        this.mouseX = Graphics.pageToCanvasX(event.pageX);
        this.mouseY = Graphics.pageToCanvasY(event.pageY);
    };

    var _Window_ShopCommand_maxCols = Window_ShopCommand.prototype.maxCols;
    Window_ShopCommand.prototype.maxCols = function() {
        var columnNumber = _Window_ShopCommand_maxCols.apply(this, arguments);
        return this._purchaseOnly ? columnNumber - 1 : columnNumber;
    };

    var _Window_ShopCommand_makeCommandList = Window_ShopCommand.prototype.makeCommandList;
    Window_ShopCommand.prototype.makeCommandList = function() {
        _Window_ShopCommand_makeCommandList.apply(this, arguments);
        if (this._purchaseOnly) {
            this._list = this._list.filter(function(command) {
                return command.symbol !== 'sell'
            });
        }
    };

})();
