(function () {
    'use strict';

    var WrapParams = /** @class */ (function () {
        function WrapParams() {
            this.letterCountMax = 70;
        }
        Object.defineProperty(WrapParams.prototype, "LetterCountMax", {
            get: function () { return this.letterCountMax; },
            set: function (value) { this.letterCountMax = value; },
            enumerable: false,
            configurable: true
        });
        return WrapParams;
    }());
    var WrapParamsFactory = /** @class */ (function () {
        function WrapParamsFactory() {
        }
        WrapParamsFactory.FromBaseParams = function (baseParams) {
            var wrapParams = new WrapParams();
            this.SetNumbersFromParams(baseParams, wrapParams);
            return wrapParams;
        };
        WrapParamsFactory.SetNumbersFromParams = function (baseParams, wrapParams) {
            wrapParams.LetterCountMax = Number(baseParams[names.LetterCountMax]);
        };
        return WrapParamsFactory;
    }());
    // To avoid magic strings when fetching from Plugin Params
    var names = {
        LetterCountMax: "LetterCountMax",
    };

    var pluginName = "CGT_LetterCountWrap_MV";
    var baseParams = PluginManager.parameters(pluginName);
    var lcbParams = WrapParamsFactory.FromBaseParams(baseParams);

    var __extends = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var TextMeasurer = CGT.WWCore.Overflow.TextMeasurer;
    var LCTextMeasurer = /** @class */ (function (_super) {
        __extends(LCTextMeasurer, _super);
        function LCTextMeasurer() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LCTextMeasurer.prototype.GetDefaultWidthOf = function (text, textField) {
            return text.length;
        };
        return LCTextMeasurer;
    }(TextMeasurer));

    var __extends$1 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var OverflowFinder = CGT.WWCore.Overflow.OverflowFinder;
    var LCOverflowFinder = /** @class */ (function (_super) {
        __extends$1(LCOverflowFinder, _super);
        function LCOverflowFinder() {
            var _this = _super.call(this) || this;
            _this.textMeasurer = new LCTextMeasurer();
            return _this;
        }
        LCOverflowFinder.prototype.RegularWrapSpace = function (args) {
            var fullSpace = this.FullWrapSpace(args);
            var spacing = args.wordWrapArgs.spacing;
            var allSidePadding = spacing.SidePadding * 2;
            return fullSpace - allSidePadding;
        };
        LCOverflowFinder.prototype.FullWrapSpace = function (args) {
            return this.LCBParams.LetterCountMax;
        };
        Object.defineProperty(LCOverflowFinder.prototype, "CoreParams", {
            get: function () { return CGT.WWCore.Params; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LCOverflowFinder.prototype, "LCBParams", {
            get: function () { return CGT.LeCoWr.Params; },
            enumerable: false,
            configurable: true
        });
        return LCOverflowFinder;
    }(OverflowFinder));

    var __extends$2 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var UnderflowCascader = CGT.WWCore.UnderflowCascader;
    var LCUnderflowCascader = /** @class */ (function (_super) {
        __extends$2(LCUnderflowCascader, _super);
        function LCUnderflowCascader() {
            var _this = _super.call(this) || this;
            _this.textMeasurer = new LCTextMeasurer();
            return _this;
        }
        return LCUnderflowCascader;
    }(UnderflowCascader));

    var __extends$3 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var LineWrapper = CGT.WWCore.LineWrapper;
    var LCLineWrapper = /** @class */ (function (_super) {
        __extends$3(LCLineWrapper, _super);
        function LCLineWrapper() {
            var _this = _super.call(this) || this;
            _this.overflowFinder = new LCOverflowFinder();
            _this.underflowCascader = new LCUnderflowCascader();
            return _this;
        }
        return LCLineWrapper;
    }(LineWrapper));

    var __extends$4 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var WordWrapper = CGT.WWCore.WordWrapper;
    var LCWrapper = /** @class */ (function (_super) {
        __extends$4(LCWrapper, _super);
        function LCWrapper() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(LCWrapper.prototype, "WrapCode", {
            get: function () { return LCWrapper.WrapCode; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LCWrapper, "WrapCode", {
            get: function () { return this.wrapCode; },
            enumerable: false,
            configurable: true
        });
        LCWrapper.wrapCode = "letterCount";
        return LCWrapper;
    }(WordWrapper));

    var LeCoWr = {
        Params: lcbParams,
    };
    RegisterWrapper();
    function RegisterWrapper() {
        var lineWrapper = new LCLineWrapper();
        var lcbWrapper = new LCWrapper(lineWrapper);
        CGT.WWCore.RegisterWrapper(lcbWrapper);
    }
    CGT.WWCore.UpdateActiveWrappers(); // For when this plugin's supposed to handle wrapping

    /*:
    * @plugindesc Wraps text on a letter-count-per-line basis.
    * @author CG-Tespy – https://github.com/CG-Tespy
    * @help This is version 3.01.01 of this plugin. Tested with RMMV versions 1.5.1 and
    * 1.6.2.
    *
    * Requires version 3.01.01+ of the CGT WordWrapCore plugin. To have this
    * set as the wrapper right away, set the WordWrapCore's Wrapper param to
    * "letterCount".
    *
    * Recommended WordWrapCore settings changes for this plugin
    * (tested with the Amaranth font):
    * SidePadding: 1
    * MugshotWidth: 10
    * MugshotPadding: 1
    *
    * @param LetterCountMax
    * @type number
    * @min 1
    * @default 70
    * @desc The max amount of letters you want to allow per line.
    *
    */
    var plugin = {
        LeCoWr: LeCoWr,
    };
    Object.assign(CGT, plugin);

}());
