(function () {
    'use strict';

    var singleNewline = "\n";
    var singleSpace = " ";
    var emptyString = "";
    var openingParenthesis = "(";
    var closingParenthesis = ")";
    var global = "g";
    var globalMultiline = "gm";
    var caseInsensitive = "i";
    var unicode = "u";
    var corePluginName = "CGT_WordWrapCore_MV";
    var pluginCommandPrefix = "CGTWWC_";

    var _Strings = {
        __proto__: null,
        singleNewline: singleNewline,
        singleSpace: singleSpace,
        emptyString: emptyString,
        openingParenthesis: openingParenthesis,
        closingParenthesis: closingParenthesis,
        global: global,
        globalMultiline: globalMultiline,
        caseInsensitive: caseInsensitive,
        unicode: unicode,
        corePluginName: corePluginName,
        pluginCommandPrefix: pluginCommandPrefix
    };

    var doubleSpaces = /[^\S\r\n][^\S\r\n]+/gm;
    // ^Had to do this weird double-negative so it wouldn't treat newlines
    // as whitespace
    var newlines = /\n+/gm;
    var notWhitespace = /\S+/gm;
    var spaceAsSeparator = / /gm;
    var yanflyNametag = /^\\n<\S+>/gm;
    var basicNametag = /^\S+:/gm;
    var bracketNametag = /^\[\S+\]:/gm;
    var bracketNametagNoColon = /^\[\S+\]/gm;
    var doubleQuotes = /"/gm;
    var noWrapTag = /<noWrap>\s?/gmi;
    var disableNametagScanTag = /<disableNametagScan>\s?/gmi;
    var disableCascadingUnderflowTag = /<disableCascadingUnderflow>\s?/gmi;
    var boldMarkers = /\u001bMSGCORE\[1\]/gmi;
    var italicsMarkers = /\u001bMSGCORE\[2\]/gmi;

    var _Regexes = {
        __proto__: null,
        doubleSpaces: doubleSpaces,
        newlines: newlines,
        notWhitespace: notWhitespace,
        spaceAsSeparator: spaceAsSeparator,
        yanflyNametag: yanflyNametag,
        basicNametag: basicNametag,
        bracketNametag: bracketNametag,
        bracketNametagNoColon: bracketNametagNoColon,
        doubleQuotes: doubleQuotes,
        noWrapTag: noWrapTag,
        disableNametagScanTag: disableNametagScanTag,
        disableCascadingUnderflowTag: disableCascadingUnderflowTag,
        boldMarkers: boldMarkers,
        italicsMarkers: italicsMarkers
    };

    var __values$8 = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var Event = CGT.Core.Utils.Event;
    var ArrayEx = CGT.Core.Extensions.ArrayEx;
    /**
     * Params to affect the word-wrapping, set in the Plugin Manager.
     */
    var CoreWrapParams = /** @class */ (function () {
        function CoreWrapParams() {
            this.messageWrapper = "null";
            this.descWrapper = "null";
            this.messageBacklogWrapper = "null";
            this.bubbleWrapper = "null";
            this.wrapModeChanged = new Event(2);
            this.nametagFormats = [];
            this.nametagFormatRegexes = [];
            this.lineBreakMarkers = [];
            this.emptyText = [];
            this.lineMinCharCount = 3;
            this.parenthesisAlignment = true;
            this.wordSeparator = " ";
            this.separateWithSeparator = true;
            this.wrapDescs = false;
            this.cascadingUnderflow = false;
            this.cuLenience = 5;
            this.rememberResults = true;
            this.wrapMessageLog = true;
        }
        Object.defineProperty(CoreWrapParams.prototype, "MessageWrapper", {
            /** Affects how this decides when a line can't hold more. */
            get: function () { return this.messageWrapper; },
            set: function (value) { this.messageWrapper = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "MessageSpacing", {
            get: function () { return this.messageSpacing; },
            set: function (value) { this.messageSpacing = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "DescWrapper", {
            get: function () { return this.descWrapper; },
            set: function (value) { this.descWrapper = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "DescSpacing", {
            get: function () { return this.descSpacing; },
            set: function (value) { this.descSpacing = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "MessageBacklogWrapper", {
            get: function () { return this.messageBacklogWrapper; },
            set: function (value) { this.messageBacklogWrapper = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "BacklogSpacing", {
            get: function () { return this.backlogSpacing; },
            set: function (value) { this.backlogSpacing = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "BubbleWrapper", {
            get: function () { return this.bubbleWrapper; },
            set: function (value) { this.bubbleWrapper = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "BubbleSpacing", {
            get: function () { return this.bubbleSpacing; },
            set: function (value) { this.bubbleSpacing = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "WrapModeChanged", {
            get: function () { return this.wrapModeChanged; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "NametagFormats", {
            /**
             * Decides how the wrapper detects nametags.
             * */
            get: function () { return this.nametagFormats; },
            set: function (value) {
                ArrayEx.Clear(this.nametagFormats);
                this.nametagFormats = this.nametagFormats.concat(value);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "NametagFormatRegexes", {
            get: function () { return this.nametagFormatRegexes; },
            set: function (value) {
                ArrayEx.Clear(this.nametagFormatRegexes);
                this.nametagFormatRegexes = this.NametagFormatRegexes.concat(value);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "LineBreakMarkers", {
            get: function () { return this.lineBreakMarkers; },
            set: function (value) {
                ArrayEx.Clear(this.lineBreakMarkers);
                this.lineBreakMarkers = this.lineBreakMarkers.concat(value);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "EmptyText", {
            get: function () { return this.emptyText; },
            set: function (value) {
                ArrayEx.Clear(this.emptyText);
                this.emptyText = this.emptyText.concat(value);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "LineMinCharCount", {
            // ~~~Special Rules~~~
            /**
             * How many chars this makes sure each line has, when the text
             * besides the nametag has enough.
             */
            get: function () { return this.lineMinCharCount; },
            set: function (value) { this.lineMinCharCount = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "ParenthesesAlignment", {
            /**
             * Whether or not this aligns parentheses a certain way.
             */
            get: function () { return this.parenthesisAlignment; },
            set: function (value) { this.parenthesisAlignment = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "WordSeparator", {
            get: function () { return this.wordSeparator; },
            set: function (value) { this.wordSeparator = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "SeparateWithSeparator", {
            get: function () { return this.separateWithSeparator; },
            set: function (value) { this.separateWithSeparator; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "WrapDescs", {
            get: function () { return this.wrapDescs; },
            set: function (value) { this.wrapDescs = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "CascadingUnderflow", {
            get: function () { return this.cascadingUnderflow; },
            set: function (value) { this.cascadingUnderflow = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "CULenience", {
            get: function () { return this.cuLenience; },
            set: function (value) { this.cuLenience = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "RememberResults", {
            get: function () { return this.rememberResults; },
            set: function (value) { this.rememberResults = value; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CoreWrapParams.prototype, "WrapMessageLog", {
            get: function () { return this.wrapMessageLog; },
            set: function (value) { this.wrapMessageLog = value; },
            enumerable: false,
            configurable: true
        });
        return CoreWrapParams;
    }());
    var WrapParamsFactory = /** @class */ (function () {
        function WrapParamsFactory() {
        }
        /* Converted by fenix-tools convertParameters func*/
        WrapParamsFactory.FromConvertedParams = function (baseParams) {
            var wrapParams = new CoreWrapParams();
            this.SetStringsFromParams(baseParams, wrapParams);
            this.SetNumbersFromParams(baseParams, wrapParams);
            this.SetBooleansFromParams(baseParams, wrapParams);
            this.SetRegexesFromParams(baseParams, wrapParams);
            this.SetArraysFromParams(baseParams, wrapParams);
            this.SetSpacingFromParams(baseParams, wrapParams);
            return wrapParams;
        };
        WrapParamsFactory.SetStringsFromParams = function (baseParams, wrapParams) {
            var wordSeparator = baseParams.WordSeparator;
            wordSeparator = wordSeparator.replace(doubleQuotes, emptyString);
            wrapParams.WordSeparator = wordSeparator;
            wrapParams.MessageWrapper = baseParams.MessageWrapper;
            wrapParams.DescWrapper = baseParams.DescWrapper;
            wrapParams.MessageBacklogWrapper = baseParams.MessageBacklogWrapper;
            wrapParams.BubbleWrapper = baseParams.BubbleWrapper;
        };
        WrapParamsFactory.SetNumbersFromParams = function (baseParams, wrapParams) {
            wrapParams.LineMinCharCount = baseParams.LineMinCharCount;
            wrapParams.CULenience = baseParams.CULenience;
        };
        WrapParamsFactory.SetRegexesFromParams = function (baseParams, wrapParams) {
            this.SetNametagFormats(baseParams, wrapParams);
            this.SetEmptyText(baseParams, wrapParams);
        };
        WrapParamsFactory.SetNametagFormats = function (baseParams, wrapParams) {
            var formatObjects = baseParams.NametagFormats;
            this.ApplyRegexObjectsTo(formatObjects);
            // ^Since the Param def doesn't let you define Regex objects, we have to
            // convert things ourselves
            wrapParams.NametagFormats = formatObjects;
            wrapParams.NametagFormatRegexes = this.RegexObjectsFrom(formatObjects);
        };
        WrapParamsFactory.ApplyRegexObjectsTo = function (formats) {
            var e_1, _a;
            try {
                for (var formats_1 = __values$8(formats), formats_1_1 = formats_1.next(); !formats_1_1.done; formats_1_1 = formats_1.next()) {
                    var formatEl = formats_1_1.value;
                    var asString = formatEl.RegexAsString;
                    formatEl.Regex = new RegExp(asString, globalMultiline + caseInsensitive);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (formats_1_1 && !formats_1_1.done && (_a = formats_1.return)) _a.call(formats_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        };
        WrapParamsFactory.RegexObjectsFrom = function (formats) {
            var e_2, _a;
            var result = [];
            try {
                for (var formats_2 = __values$8(formats), formats_2_1 = formats_2.next(); !formats_2_1.done; formats_2_1 = formats_2.next()) {
                    var formatEl = formats_2_1.value;
                    result.push(formatEl.Regex);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (formats_2_1 && !formats_2_1.done && (_a = formats_2.return)) _a.call(formats_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
            return result;
        };
        WrapParamsFactory.SetEmptyText = function (hasParams, wrapParams) {
            wrapParams.EmptyText = hasParams.EmptyText;
            this.ApplyRegexObjectsTo(wrapParams.EmptyText);
        };
        WrapParamsFactory.SetBooleansFromParams = function (baseParams, wrapParams) {
            wrapParams.ParenthesesAlignment = baseParams.ParenthesisAlignment;
            wrapParams.CascadingUnderflow = baseParams.CascadingUnderflow;
            wrapParams.RememberResults = baseParams.RememberResults;
        };
        WrapParamsFactory.SetArraysFromParams = function (baseParams, wrapParams) {
            wrapParams.LineBreakMarkers = baseParams.LineBreakMarkers;
        };
        WrapParamsFactory.SetSpacingFromParams = function (baseParams, wrapParams) {
            wrapParams.MessageSpacing = baseParams.MessageSpacing;
            wrapParams.DescSpacing = baseParams.DescSpacing;
            wrapParams.BacklogSpacing = baseParams.BacklogSpacing;
            wrapParams.BubbleSpacing = baseParams.BubbleSpacing;
        };
        return WrapParamsFactory;
    }());

    /**
     * Recursive method that will convert all string values in an object to a more
     * appropriate type.
     *
     * In MV there are a lot of objects filled with strings of different values, a lot
     * of times we need to convert each value manually, instead use this to quickly
     * deep parse each value from string to the correct type.
     *
     * @function convertParameters
     * @since 1.0.0
     * @memberof module:Utils
     *
     * @param {object} parameters - The string filled object you want converted
     *
     * @returns An object with it's string values converted
     * @example
     *
     * const myParams = { p1: '22', p2: 'true' }
     * convertParameters(myParams) // => { p1: 22, p2: true }
     *
     * const myParams = { p1: '{a: 1'1, c: '2'}', p2: '[{}, {}, {}]' }
     * convertParameters(myParams) // => { p1: {a: 1, c: 2}, p2: [{}, {}, {}] }
     *
     */
    function convertParameters (parameters) {
      const _isBoolean = function(string) { return string === 'true' || string === 'false'; }

      const _isJson = function (text) {
        try {
          const parsed = JSON.parse(text);
          if (parsed && (typeof parsed === 'object' || Array.isArray(parsed))) {
            return parsed
          }
        } catch (error) { }
        return false
      };

      const result = {};

      Object.keys(parameters).forEach(function(key) {
        const parameter = parameters[key];
        if (parameter === '') {
          result[key] = '';
        } else if (isFinite(parameter)) {
          result[key] = Number(parameter);
        } else if (_isBoolean(parameter)) {
          result[key] = JSON.parse(parameter);
        } else if (Array.isArray(parameter)) {
          result[key] = Array.from(parameter);
        } else if (_isJson(parameter)) {
          result[key] = convertParameters(JSON.parse(parameter));
        } else {
          result[key] = parameter;
        }
      });
      return result
    }

    /**
     * Returns the appropriate wrapper spacing assuming that the input is a
     * valid WrapTarget enum value
     */
    function WrapperSpacingByString(input) {
        var wrapTargetRaw = input.toLowerCase();
        var wrapTarget = wrapTargetRaw;
        var allSpacings = CGT.WWCore.WrapperSpacing;
        var whatWeWant = allSpacings.get(wrapTarget);
        return whatWeWant;
    }
    /** Since MV 1.5.1 doesn't support the regular Object.values() func */
    function ValuesFromObject(obj) {
        var result = [];
        for (var key in obj) {
            result.push(obj[key]);
        }
        return result;
    }

    var _Functions = {
        __proto__: null,
        WrapperSpacingByString: WrapperSpacingByString,
        ValuesFromObject: ValuesFromObject
    };

    var baseParams = PluginManager.parameters(corePluginName);
    var parsedParams = convertParameters(baseParams);
    // convertParameters for some reason renders arrays as objects with the indexes as 
    // keys, and the array elements as the corresponding values. We need to fix that here...
    parsedParams.EmptyText = ValuesFromObject(parsedParams.EmptyText);
    parsedParams.NametagFormats = ValuesFromObject(parsedParams.NametagFormats);
    parsedParams.LineBreakMarkers = ValuesFromObject(parsedParams.LineBreakMarkers);
    var pluginParams = WrapParamsFactory.FromConvertedParams(parsedParams);

    function SetBoldItalicPadding(args) {
        var newPadding = Number(args[0]);
        var wrapTargetRaw = args[1];
        var spacingToChange = WrapperSpacingByString(wrapTargetRaw);
        spacingToChange.BoldItalicPadding = newPadding;
    }

    function SetLineMinCharCount(args) {
        var newMin = Number(args[0]);
        CGT.WWCore.Params.LineMinCharCount = newMin;
    }

    function SetMugshotPadding(args) {
        var newPadding = Number(args[0]);
        var wrapTargetRaw = args[1];
        var spacingToChange = WrapperSpacingByString(wrapTargetRaw);
        spacingToChange.MugshotPadding = newPadding;
    }

    function SetParenthesisAlignment(args) {
        var newAlignment = args[0] === 'true';
        CGT.WWCore.Params.ParenthesesAlignment = newAlignment;
    }

    function SetMugshotWidth(args) {
        var newWidth = Number(args[0]);
        var wrapTargetRaw = args[1];
        var spacingToChange = WrapperSpacingByString(wrapTargetRaw);
        spacingToChange.MugshotWidth = newWidth;
    }

    function SetSidePadding(args) {
        var newPadding = Number(args[0]);
        var wrapTargetRaw = args[1];
        var spacingToChange = WrapperSpacingByString(wrapTargetRaw);
        spacingToChange.SidePadding = newPadding;
    }

    function SetWordSeparator(args) {
        // The separator input is expected to be within a 
        // pair of single or double quotes, so...
        var baseInput = args.join(" ");
        // ^Need to join since setting the separator to a space will lead to the args
        // array having multiple elements
        var newSeparator = baseInput.replace(singleOrDoubleQuotes, emptyString);
        CGT.WWCore.Params.WordSeparator = newSeparator;
    }
    var singleOrDoubleQuotes = /'|"/g;

    var __values$7 = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var e_1, _a;
    var commands = [
        SetBoldItalicPadding,
        SetLineMinCharCount,
        SetMugshotPadding,
        SetMugshotWidth,
        SetParenthesisAlignment,
        SetSidePadding,
        SetWordSeparator,
    ];
    var Register = CGT.Core.PluginCommands.Register;
    try {
        for (var commands_1 = __values$7(commands), commands_1_1 = commands_1.next(); !commands_1_1.done; commands_1_1 = commands_1.next()) {
            var commandFunc = commands_1_1.value;
            var commandName = pluginCommandPrefix + commandFunc.name;
            Register(commandName, commandFunc);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (commands_1_1 && !commands_1_1.done && (_a = commands_1.return)) _a.call(commands_1);
        }
        finally { if (e_1) throw e_1.error; }
    }

    var __values$6 = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    /**
     * Base class for applying certain rules to text meant to be word-wrapped.
     * Can be made to not quite apply if the text has tags meant to tell the rule not
     * to apply; in that case, all the rules will do is remove said tags, otherwise
     * leaving the input as-is.
     */
    var WrapRule = /** @class */ (function () {
        function WrapRule() {
            /** Override this to set the tags your rule should only handle removing. */
            this.invalidationTags = [];
        }
        Object.defineProperty(WrapRule.prototype, "InvalidationTags", {
            /** Regexes for tags that say that this particular rule shouldn't apply to certain inputs. */
            get: function () { return this.invalidationTags.slice(); },
            enumerable: false,
            configurable: true
        });
        WrapRule.prototype.AppliedTo = function (input) {
            if (!this.CanApplyTo(input))
                return input;
            return this.ProcessInput(input);
        };
        /**
         * Does not take into account tags telling the rule not to apply.
         */
        WrapRule.prototype.CanApplyTo = function (input) {
            return input != null;
        };
        /**
         *  Handles either applying the rule, or removing the tags telling it to
        not quite apply.
         * @param input
         */
        WrapRule.prototype.ProcessInput = function (input) {
            if (this.ShouldRemoveTagsFrom(input))
                return this.WithoutTags(input);
            else
                return this.ProcessNormally(input);
        };
        /** Override this if there are any tags to tell this rule not to apply. */
        WrapRule.prototype.ShouldRemoveTagsFrom = function (input) { return false; };
        /** Returns the passed input, minus the tags telling it not to apply. */
        WrapRule.prototype.WithoutTags = function (input) { return input; };
        /** Whether or not the text has any tags that'd tell this rule not to apply to it. */
        WrapRule.prototype.IsValidFor = function (text) {
            var e_1, _a;
            try {
                for (var _b = __values$6(this.invalidationTags), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var tag = _c.value;
                    var hasTag = text.match(tag) != null;
                    if (hasTag)
                        return false;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return true;
        };
        return WrapRule;
    }());

    var __extends$b = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    /** For Wrap Rules that work with wrapped lines of text */
    var LineWrapRule = /** @class */ (function (_super) {
        __extends$b(LineWrapRule, _super);
        function LineWrapRule() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineWrapRule;
    }(WrapRule));

    var __extends$a = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values$5 = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    /**
     * Applies a minimum chars-per-line on the input, or instead removes the tags
     * that demand that this rule be ignored.
     * */
    var CharPerLineMin = /** @class */ (function (_super) {
        __extends$a(CharPerLineMin, _super);
        function CharPerLineMin() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.invalidationTags = [/ <ignoreLmcc>/gmi];
            return _this;
        }
        CharPerLineMin.prototype.CanApplyTo = function (lines) {
            var baseRequirements = _super.prototype.CanApplyTo.call(this, lines);
            var atLeastTwoLinesToWorkWith = lines.length > 1;
            return baseRequirements && atLeastTwoLinesToWorkWith;
        };
        CharPerLineMin.prototype.ShouldRemoveTagsFrom = function (lines) {
            var e_1, _a, e_2, _b;
            try {
                for (var lines_1 = __values$5(lines), lines_1_1 = lines_1.next(); !lines_1_1.done; lines_1_1 = lines_1.next()) {
                    var lineEl = lines_1_1.value;
                    try {
                        for (var _c = (e_2 = void 0, __values$5(this.invalidationTags)), _d = _c.next(); !_d.done; _d = _c.next()) {
                            var tag = _d.value;
                            var lineHasTag = tag.test(lineEl);
                            if (lineHasTag)
                                return true;
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (lines_1_1 && !lines_1_1.done && (_a = lines_1.return)) _a.call(lines_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return false;
        };
        CharPerLineMin.prototype.WithoutTags = function (lines) {
            var e_3, _a;
            lines = lines.slice(); // <- To avoid modifying the orig
            for (var i = 0; i < lines.length; i++) {
                var lineEl = lines[i], withTagsRemoved = "";
                try {
                    for (var _b = (e_3 = void 0, __values$5(this.invalidationTags)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var tag = _c.value;
                        withTagsRemoved = lineEl.replace(tag, emptyString);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
                lines[i] = withTagsRemoved;
            }
            return lines;
        };
        CharPerLineMin.prototype.ProcessNormally = function (lines) {
            lines = lines.slice(); // <- To not modify the orig
            var lastTwoLines = this.GetLastTwoSplitLinesOf(lines);
            var lastLineWords = lastTwoLines[theLastOfWhich];
            var secondToLastLineWords = lastTwoLines[theFirstOfWhich];
            var balancedLastLines = this.BalanceCharCountBetween(secondToLastLineWords, lastLineWords);
            lastLineWords = balancedLastLines[theLastOfWhich];
            secondToLastLineWords = balancedLastLines[theFirstOfWhich];
            lines = this.WithLastLinesApplied(lines, balancedLastLines);
            return lines;
        };
        /** Returned in the same order as they are in the original array they came from. */
        CharPerLineMin.prototype.GetLastTwoSplitLinesOf = function (lines) {
            var lastLineFull = lines[lines.length - 1];
            var lastLineSplit = lastLineFull.split(this.WordSeparator);
            var secondToLastLineFull = lines[lines.length - 2];
            var secondToLastLineSplit = secondToLastLineFull.split(this.WordSeparator);
            return [secondToLastLineSplit, lastLineSplit];
        };
        Object.defineProperty(CharPerLineMin.prototype, "WordSeparator", {
            get: function () { return CGT.WWCore.Params.WordSeparator; },
            enumerable: false,
            configurable: true
        });
        /**
         * Returns an array containing versions of the passed arrays that fulfill the char per
         * line minimum, and in the same order as they were in their original source array.
         * @param sharerLine The full line that may have its words moved to the other one
         * @param takerLine Line that, if it doesn't have enough characters, may have words moved to it from the other line
         */
        CharPerLineMin.prototype.BalanceCharCountBetween = function (sharerLine, takerLine) {
            sharerLine = sharerLine.slice();
            takerLine = takerLine.slice();
            // ^ To avoid modifying the originals
            var fullTakerLine = takerLine.join(this.WordSeparator);
            var fullSharerLine = sharerLine.join(this.WordSeparator);
            // ^ Since the inputs are string arrays that each have words as their
            // elements.
            var lastWordInSharer = sharerLine[sharerLine.length - 1];
            var sharerReducedByAWord = (fullSharerLine.length - lastWordInSharer.length);
            var canAffordToShare = sharerReducedByAWord >= this.LineMinCharCount;
            var thereIsAnImbalance = fullTakerLine.length < this.LineMinCharCount;
            while (thereIsAnImbalance && canAffordToShare) {
                var wordToMove = sharerLine.pop();
                this.MoveToBeginningOf(takerLine, wordToMove);
                // We want to be sure whether or not we need to still move words from one
                // line to the other, hence the need to update these vars below to then 
                // check them again.
                fullTakerLine = takerLine.join(this.WordSeparator);
                fullSharerLine = sharerLine.join(this.WordSeparator);
                sharerReducedByAWord = (fullSharerLine.length - lastWordInSharer.length);
                canAffordToShare = sharerReducedByAWord >= this.LineMinCharCount;
                thereIsAnImbalance = fullTakerLine.length < this.LineMinCharCount;
            }
            return [sharerLine, takerLine];
        };
        Object.defineProperty(CharPerLineMin.prototype, "LineMinCharCount", {
            get: function () { return CGT.WWCore.Params.LineMinCharCount; },
            enumerable: false,
            configurable: true
        });
        CharPerLineMin.prototype.MoveToBeginningOf = function (line, toMove) {
            line.unshift(toMove);
        };
        CharPerLineMin.prototype.WithLastLinesApplied = function (toApplyTo, lastTwoLines) {
            toApplyTo = toApplyTo.slice();
            // Keep in mind that each element of lastTwoLines is an array with each element
            // within being words
            var lastLineCombined = lastTwoLines[theLastOfWhich].join(this.WordSeparator);
            var secondToLastLineCombined = lastTwoLines[theFirstOfWhich].join(this.WordSeparator);
            toApplyTo[toApplyTo.length - 1] = lastLineCombined;
            toApplyTo[toApplyTo.length - 2] = secondToLastLineCombined;
            return toApplyTo;
        };
        return CharPerLineMin;
    }(LineWrapRule));
    var theFirstOfWhich = 0, theLastOfWhich = 1;

    var __extends$9 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values$4 = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var ParenthesisAlignment = /** @class */ (function (_super) {
        __extends$9(ParenthesisAlignment, _super);
        function ParenthesisAlignment() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ParenthesisAlignment.prototype.CanApplyTo = function (linesCopy) {
            var baseRequirements = _super.prototype.CanApplyTo.call(this, linesCopy);
            var enoughLines = baseRequirements && linesCopy.length > 1;
            var openingParenIndex = baseRequirements && this.OpeningParenthesisIndex(linesCopy);
            var parenthesisIsThere = baseRequirements && openingParenIndex >= 0;
            var thatLineIsntTheLast = baseRequirements && openingParenIndex != linesCopy.length - 1;
            return this.AllowedToAct && enoughLines && parenthesisIsThere && thatLineIsntTheLast;
        };
        /**
         * Returns the index of the line where this should start applying leading spaces.
         * Returns -1 if there is no line starting with an opening parenthesis.
         * @param lines
         */
        ParenthesisAlignment.prototype.OpeningParenthesisIndex = function (lines) {
            var lineFound = this.LineWithStartingParenthesis(lines);
            var lineIsValid = lineFound != emptyString;
            if (lineIsValid)
                return lines.indexOf(lineFound);
            else
                return -1;
        };
        Object.defineProperty(ParenthesisAlignment.prototype, "AllowedToAct", {
            get: function () { return CGT.WWCore.Params.ParenthesesAlignment; },
            enumerable: false,
            configurable: true
        });
        ParenthesisAlignment.prototype.ProcessNormally = function (lines) {
            var lineWithParenthesis = this.LineWithStartingParenthesis(lines);
            var whereThatLineIs = lines.indexOf(lineWithParenthesis);
            var rightAfterThatLine = whereThatLineIs + 1;
            // ^So the alignment is applied after the line with the starting parenthesis
            return this.WithLeadingSpacesApplied(lines, rightAfterThatLine);
        };
        /** The first such line in the input, anyway. */
        ParenthesisAlignment.prototype.LineWithStartingParenthesis = function (lines) {
            var e_1, _a;
            try {
                for (var lines_1 = __values$4(lines), lines_1_1 = lines_1.next(); !lines_1_1.done; lines_1_1 = lines_1.next()) {
                    var line = lines_1_1.value;
                    var firstLetterInLine = line[0];
                    var startsWithOpeningParenthesis = firstLetterInLine === openingParenthesis;
                    if (startsWithOpeningParenthesis)
                        return line;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (lines_1_1 && !lines_1_1.done && (_a = lines_1.return)) _a.call(lines_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return emptyString;
        };
        ParenthesisAlignment.prototype.WithLeadingSpacesApplied = function (lines, startingIndex) {
            for (var whereWeAre = startingIndex; whereWeAre < lines.length; whereWeAre++) {
                var currentLine = lines[whereWeAre];
                var withAlignmentApplied = singleSpace + currentLine;
                lines[whereWeAre] = withAlignmentApplied;
                var lastLetterInLine = currentLine[currentLine.length - 1];
                var endsWithClosingParenthesis = lastLetterInLine === closingParenthesis;
                var missionAccomplished = endsWithClosingParenthesis;
                if (missionAccomplished)
                    return lines;
            }
            return lines;
            // ^This func getting to this point implies that the writer forgot to include 
            // any closing parentheses. Mission's still accomplished, since this rule isn't 
            // supposed to worry about grammar
        };
        return ParenthesisAlignment;
    }(LineWrapRule));

    var WordWrapArgValidator = /** @class */ (function () {
        function WordWrapArgValidator() {
        }
        WordWrapArgValidator.prototype.Validate = function (args) {
            var textField = args.textField;
            if (textField == null) {
                var message = 'Cannot wrap for a null bitmap/text field!';
                alert(message);
                throw new Error(message);
            }
            var text = args.rawTextToWrap;
            if (text == null) {
                var message = "Cannot wrap null text!";
                alert(message);
                throw new Error(message);
            }
        };
        return WordWrapArgValidator;
    }());

    var __values$3 = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    /** Applies Wrap Rules for the word-wrapping process. */
    var WrapRuleApplier = /** @class */ (function () {
        function WrapRuleApplier() {
            this.preWrapRules = new Set();
            this.postWrapRules = new Set();
        }
        WrapRuleApplier.prototype.ApplyPreRulesTo = function (text) {
            return this.ApplyRules(this.preWrapRules, text);
        };
        /** Exists to cut down on boilerplate code */
        WrapRuleApplier.prototype.ApplyRules = function (rules, input) {
            var e_1, _a;
            try {
                for (var rules_1 = __values$3(rules), rules_1_1 = rules_1.next(); !rules_1_1.done; rules_1_1 = rules_1.next()) {
                    var ruleEl = rules_1_1.value;
                    input = ruleEl.AppliedTo(input);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (rules_1_1 && !rules_1_1.done && (_a = rules_1.return)) _a.call(rules_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return input;
        };
        WrapRuleApplier.prototype.ApplyPostRulesTo = function (lines) {
            return this.ApplyRules(this.postWrapRules, lines);
        };
        WrapRuleApplier.prototype.RegisterPreRule = function (rule) {
            this.preWrapRules.add(rule);
        };
        WrapRuleApplier.prototype.RegisterPostRule = function (rule) {
            this.postWrapRules.add(rule);
        };
        WrapRuleApplier.prototype.RemovePreRule = function (rule) {
            this.preWrapRules.delete(rule);
        };
        WrapRuleApplier.prototype.RemovePostRule = function (rule) {
            this.postWrapRules.delete(rule);
        };
        return WrapRuleApplier;
    }());

    var __extends$8 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    /** For Wrap Rules that work with wrapped lines of text */
    var StringWrapRule = /** @class */ (function (_super) {
        __extends$8(StringWrapRule, _super);
        function StringWrapRule() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StringWrapRule;
    }(WrapRule));

    var __extends$7 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var WithoutExtraSpaces = /** @class */ (function (_super) {
        __extends$7(WithoutExtraSpaces, _super);
        function WithoutExtraSpaces() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        WithoutExtraSpaces.prototype.ProcessNormally = function (text) {
            return text.replace(doubleSpaces, singleSpace);
        };
        return WithoutExtraSpaces;
    }(StringWrapRule));

    var __extends$6 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    /** For replacing all newlines that were already in the input it gets given,
     * with the word separator set in the params. */
    var TurnNewlinesIntoSeparators = /** @class */ (function (_super) {
        __extends$6(TurnNewlinesIntoSeparators, _super);
        function TurnNewlinesIntoSeparators() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TurnNewlinesIntoSeparators.prototype.ProcessNormally = function (text) {
            return text.replace(newlines, this.WordSeparator);
        };
        Object.defineProperty(TurnNewlinesIntoSeparators.prototype, "WordSeparator", {
            get: function () { return CGT.WWCore.Params.WordSeparator; },
            enumerable: false,
            configurable: true
        });
        return TurnNewlinesIntoSeparators;
    }(StringWrapRule));

    var __values$2 = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var NametagFetcher = /** @class */ (function () {
        function NametagFetcher() {
        }
        NametagFetcher.prototype.FetchFrom = function (text, wrapArgs) {
            var e_1, _a;
            if (!this.ShouldScanForNametagIn(text, wrapArgs)) {
                return emptyString;
            }
            var nametagsFound = [];
            try {
                for (var _b = __values$2(this.NametagFormats), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var format = _c.value;
                    if (!format.Enabled)
                        continue;
                    var formatRegex = format.Regex;
                    var matchesFound = text.match(formatRegex) || [];
                    nametagsFound = nametagsFound.concat(matchesFound);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            nametagsFound.push(emptyString); // For when no matches were found
            var firstMatch = 0;
            return nametagsFound[firstMatch].trim().replace(newlines, emptyString);
            // We don't want any extra spaces in the tag. We also want to account for when a
            // nametag regex includes a newline for the sake of better detection
        };
        NametagFetcher.prototype.ShouldScanForNametagIn = function (text, wrapArgs) {
            return !this.YanflyNametagIsThere(wrapArgs) && !this.HasDisableNametagScanTag(text);
        };
        NametagFetcher.prototype.YanflyNametagIsThere = function (wrapArgs) {
            // Since the nametag gets taken out of the text by the time FetchFrom gets called,
            // at least in normal message boxes
            var shouldCareForIt = wrapArgs.considerYanflyNamebox;
            var theNametag = CGT.WWCore.Yanfly.activeNametagText;
            return shouldCareForIt && theNametag.length > 0;
        };
        NametagFetcher.prototype.HasDisableNametagScanTag = function (text) {
            return text.match(NametagFetcher.noNametagScanTag) != null;
        };
        NametagFetcher.prototype.WithoutNametagScanTags = function (text) {
            return text.replace(NametagFetcher.noNametagScanTag, emptyString);
        };
        Object.defineProperty(NametagFetcher.prototype, "NametagFormats", {
            get: function () {
                // @ts-ignore
                return CGT.WWCore.Params.NametagFormats;
            },
            enumerable: false,
            configurable: true
        });
        NametagFetcher.noNametagScanTag = /<disableNametagScan>\s?/gmi;
        return NametagFetcher;
    }());

    var __extends$5 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    // This should make it so that it doesn't matter whether an LB tag is attached to any other text;
    // newlines will be put wherever is appropriate
    var HaveLBTagsBeNewlines = /** @class */ (function (_super) {
        __extends$5(HaveLBTagsBeNewlines, _super);
        function HaveLBTagsBeNewlines() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        HaveLBTagsBeNewlines.prototype.ProcessNormally = function (text) {
            var toReplaceWith = this.WordSeparator + singleNewline + this.WordSeparator;
            // ^We surround the newlines with separators so said newlines can be properly detected 
            // as separate from other text
            for (var i = 0; i < this.LineBreakTags.length; i++) {
                var currentTag = this.LineBreakTags[i];
                var allCurrentTagInstances = new RegExp(currentTag, "gmi");
                text = text.replace(allCurrentTagInstances, toReplaceWith);
            }
            return text;
        };
        Object.defineProperty(HaveLBTagsBeNewlines.prototype, "LineBreakTags", {
            get: function () { return CGT.WWCore.Params.LineBreakMarkers; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(HaveLBTagsBeNewlines.prototype, "WordSeparator", {
            get: function () { return CGT.WWCore.Params.WordSeparator; },
            enumerable: false,
            configurable: true
        });
        return HaveLBTagsBeNewlines;
    }(StringWrapRule));

    var __extends$4 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var NoColorTagsAsFirstWords = /** @class */ (function (_super) {
        __extends$4(NoColorTagsAsFirstWords, _super);
        function NoColorTagsAsFirstWords() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.colorTagAsFirstWord = /^(|\\)(C\[\d+\])\s+/gmi;
            _this.colorTagAttachedToNextWord = "$1$2";
            return _this;
        }
        NoColorTagsAsFirstWords.prototype.ProcessNormally = function (input) {
            input = input.replace(this.colorTagAsFirstWord, this.colorTagAttachedToNextWord);
            return input;
        };
        return NoColorTagsAsFirstWords;
    }(StringWrapRule));

    var __extends$3 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var RemoveDisableNametagScanTags = /** @class */ (function (_super) {
        __extends$3(RemoveDisableNametagScanTags, _super);
        function RemoveDisableNametagScanTags() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        // Pre-rules execute before the nametag gets fetched, and as the fetcher should return nothing
        // if the tag is there...
        RemoveDisableNametagScanTags.prototype.ProcessNormally = function (input) {
            return input.replace(disableNametagScanTag, emptyString);
        };
        return RemoveDisableNametagScanTags;
    }(StringWrapRule));

    /**
     * Encapsulates an algorithm for doing word-wrapping.
     * Best create instances of this class, passing it the LineWrapper
     * you want it to use.
     * */
    var WordWrapper = /** @class */ (function () {
        function WordWrapper(lineWrapper) {
            this.lineWrapper = lineWrapper;
            this.wrapCode = emptyString;
            this.argValidator = new WordWrapArgValidator();
            /**
             * This is a cache maintained to minimize the string garbage we generate, by fetching
             * previous results for inputs the wrapper already worked with.
             */
            this.wrapResults = new Map();
            /**
             * Wrappers do their thing two ways: by either going through a conversion process,
             * or fetching from a cache said process maintains.
             * This is a map containing the methods that do those two things, with the key
             * being whether or not the input has already been wrapped.
            */
            this.wrapResultFetchers = new Map();
            this.nametagFetcher = new NametagFetcher();
            this.ruleApplier = new WrapRuleApplier();
            this.InitSubmodules();
        }
        Object.defineProperty(WordWrapper.prototype, "WrapCode", {
            get: function () { return this.wrapCode; },
            set: function (value) { this.wrapCode = value; },
            enumerable: false,
            configurable: true
        });
        WordWrapper.prototype.Wrap = function (args) {
            this.argValidator.Validate(args);
            var shouldFetchFromCache = this.ShouldRememberResults && this.HasAlreadyWrapped(args.rawTextToWrap);
            var getOutput = this.wrapResultFetchers.get(shouldFetchFromCache);
            return getOutput(args);
        };
        Object.defineProperty(WordWrapper.prototype, "ShouldRememberResults", {
            get: function () { return CGT.WWCore.Params.RememberResults; },
            enumerable: false,
            configurable: true
        });
        WordWrapper.prototype.HasAlreadyWrapped = function (text) {
            return this.wrapResults.has(text);
        };
        WordWrapper.prototype.InitSubmodules = function () {
            this.InitRuleApplier();
            this.InitWrapResultFetchers();
        };
        WordWrapper.prototype.InitRuleApplier = function () {
            // These rules are applied in the order they are registered
            this.ruleApplier.RegisterPreRule(new RemoveDisableNametagScanTags());
            this.ruleApplier.RegisterPreRule(new TurnNewlinesIntoSeparators());
            this.ruleApplier.RegisterPreRule(new HaveLBTagsBeNewlines());
            this.ruleApplier.RegisterPreRule(new WithoutExtraSpaces());
            //this.ruleApplier.RegisterPreRule(new NoSpacesBeforeColorTags());
            this.ruleApplier.RegisterPreRule(new NoColorTagsAsFirstWords());
            this.ruleApplier.RegisterPostRule(new CharPerLineMin());
            this.ruleApplier.RegisterPostRule(new ParenthesisAlignment());
        };
        WordWrapper.prototype.InitWrapResultFetchers = function () {
            var inputAlreadyWrapped = true;
            this.wrapResultFetchers.set(inputAlreadyWrapped, this.ReturnFromCache.bind(this));
            this.wrapResultFetchers.set(!inputAlreadyWrapped, this.ApplyWrapOperations.bind(this));
        };
        WordWrapper.prototype.ReturnFromCache = function (args) {
            return this.wrapResults.get(args.rawTextToWrap);
        };
        WordWrapper.prototype.ApplyWrapOperations = function (args) {
            var originalText = args.rawTextToWrap;
            // ^Used as a key for caching the result when this is done
            var result = emptyString;
            if (this.ShouldWrap(originalText)) {
                var nametag = this.nametagFetcher.FetchFrom(originalText, args);
                var beforeLineWrapping = this.ruleApplier.ApplyPreRulesTo(originalText);
                var dialogueOnly = beforeLineWrapping.replace(nametag, emptyString);
                dialogueOnly = dialogueOnly.trim();
                // ^For when there are any extra spaces left over from extracting the
                // nametag
                nametag = this.WithNewlineAsNeeded(nametag);
                var wrappedLines = this.lineWrapper.WrapIntoLines(args, dialogueOnly);
                wrappedLines = this.ruleApplier.ApplyPostRulesTo(wrappedLines);
                result = nametag + wrappedLines.join(singleNewline);
            }
            else {
                result = this.WithoutTag(noWrapTag, originalText);
            }
            this.RegisterAsWrapped(originalText, result);
            this.lineWrapper.OnWrapJobFinished();
            return result;
        };
        WordWrapper.prototype.ShouldWrap = function (text) {
            return noWrapTag.test(text) == false;
        };
        WordWrapper.prototype.WithoutTag = function (tagRegex, text) {
            return text.replace(tagRegex, emptyString);
        };
        WordWrapper.prototype.WithNewlineAsNeeded = function (nametag) {
            if (nametag.length > 0)
                nametag += singleNewline;
            return nametag;
        };
        WordWrapper.prototype.RegisterAsWrapped = function (originalInput, wrappedOutput) {
            this.wrapResults.set(originalInput, wrappedOutput);
        };
        Object.defineProperty(WordWrapper.prototype, "LineWrapper", {
            // @ts-ignore
            get: function () { return this.lineWrapper; },
            enumerable: false,
            configurable: true
        });
        return WordWrapper;
    }());

    var __extends$2 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    /** Default wrapper that simply leaves the text as-is. */
    var NullWordWrapper = /** @class */ (function (_super) {
        __extends$2(NullWordWrapper, _super);
        function NullWordWrapper() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NullWordWrapper.prototype.WouldCauseOverflow = function (currentWord, currentLine) {
            return false;
        };
        NullWordWrapper.prototype.Wrap = function (args) {
            this.argValidator.Validate(args);
            return args.rawTextToWrap;
        };
        return NullWordWrapper;
    }(WordWrapper));

    function ApplyYanflyMessageCoreOverrides() {
        if (!YanflyMessageCoreIsAvailable())
            return;
        ApplyWindowNameBoxOverrides();
    }
    function YanflyMessageCoreIsAvailable() {
        var messageCoreName = "YEP_MessageCore";
        var messageCoreParams = PluginManager.parameters(messageCoreName);
        var messageCoreIsThere = Object.keys(messageCoreParams).length > 0;
        return messageCoreIsThere;
    }
    function ApplyWindowNameBoxOverrides() {
        OverrideNameBoxRefresh();
        OverrideNameBoxDeactivate();
        OverrideNameBoxClose();
        AddNewNameboxFunctions();
    }
    function OverrideNameBoxRefresh() {
        var oldNameBoxRefresh = Window_NameBox.prototype.refresh;
        function NewRefreshNameBox(text, position) {
            var oldResult = oldNameBoxRefresh.call(this, text, position);
            this.UpdateWWCoreNametagText();
            return oldResult;
        }
        Window_NameBox.prototype.refresh = NewRefreshNameBox;
    }
    function UpdateWWCoreNametagText() {
        CGT.WWCore.Yanfly.activeNametagText = this._text;
    }
    function OverrideNameBoxDeactivate() {
        var oldNameBoxDeactivate = Window_NameBox.prototype.deactivate;
        function NewNameBoxDeactivate() {
            oldNameBoxDeactivate.call(this);
            this.ClearNameText();
            this.UpdateWWCoreNametagText();
        }
        Window_NameBox.prototype.deactivate = NewNameBoxDeactivate;
    }
    function ClearNameText() {
        this._text = "";
    }
    function OverrideNameBoxClose() {
        var oldNameBoxClose = Window_NameBox.prototype.close;
        function NewNameBoxClose() {
            oldNameBoxClose.call(this);
            this.ClearNameText();
            this.UpdateWWCoreNametagText();
        }
        Window_NameBox.prototype.close = NewNameBoxClose;
    }
    function AddNewNameboxFunctions() {
        Window_NameBox.prototype.UpdateWWCoreNametagText = UpdateWWCoreNametagText;
        Window_NameBox.prototype.ClearNameText = ClearNameText;
    }

    function ApplyYanflyMsgBacklogOverrides() {
        if (!YanflyMessageBacklogIsThere())
            return null;
        OverrideAddIndividualLines();
        AddNewMemberFunctions();
    }
    function YanflyMessageBacklogIsThere() {
        var messageBacklogName = "YEP_X_MessageBacklog";
        var messageBacklogParams = PluginManager.parameters(messageBacklogName);
        var itIsThere = Object.keys(messageBacklogParams).length > 0;
        return itIsThere;
    }
    function OverrideAddIndividualLines() {
        var oldVersion = Window_MessageBacklog.prototype.addIndividualLines;
        function NewAddIndividualLines(text) {
            // Need to convert escape chars here so that cascading underflow works as intended
            // for the log
            text = this.convertEscapeCharacters(text);
            var wrappedText = this.WrapText(text);
            oldVersion.call(this, wrappedText);
        }
        Window_MessageBacklog.prototype.addIndividualLines = NewAddIndividualLines;
    }
    function WrapText(text) {
        var WrapTarget = CGT.WWCore.WrapTarget;
        var targetBacklog = WrapTarget.MessageBacklog;
        var activeWrapper = CGT.WWCore.ActiveWrappers.get(targetBacklog);
        var spacing = CGT.WWCore.WrapperSpacing.get(targetBacklog);
        var wrapArgs = {
            textField: this.contents,
            rawTextToWrap: text,
            spacing: spacing,
            considerYanflyNamebox: false,
        };
        var wrappedText = activeWrapper.Wrap(wrapArgs);
        return wrappedText;
    }
    function AddNewMemberFunctions() {
        Window_MessageBacklog.prototype.WrapText = WrapText;
    }

    function ApplyYanflyScriptOverrides() {
        ApplyYanflyMessageCoreOverrides();
        ApplyYanflyMsgBacklogOverrides();
    }

    function ApplyWindowMessageOverrides(coreParams) {
        OverrideConvertEscapeCharacters();
        OverrideOpen();
    }
    function OverrideConvertEscapeCharacters() {
        var oldVersion = Window_Message.prototype.convertEscapeCharacters;
        Window_Message.prototype.convertEscapeCharacters = NewConvertEscapeCharacters;
        function NewConvertEscapeCharacters(text) {
            CGT.WWCore.currentMessageIsBubble = IsMessageBubble(text);
            text = ControlCharCleanup(text);
            return oldVersion.call(this, text);
        }
        function ControlCharCleanup(text) {
            // Gets rid of certain control chars that can mess up the wrapping. Note that
            // this should happen before any text gets wrapped.
            var problemControlChars = /\\>|\\</gm;
            return text.replace(problemControlChars, singleSpace);
        }
        function IsMessageBubble(message) {
            var itIsGalvBubble = galvBubbleTag.test(message);
            return itIsGalvBubble;
        }
        var galvBubbleTag = /pop\[([-a]*\d*)+(,[0-9]+)*\]/;
    }
    function OverrideOpen() {
        var oldOpen = Window_Message.prototype.open;
        function NewOpen() {
            if (ShouldApplyWrappedText.call(this)) {
                ApplyWrappedText.call(this);
                UpdateGalvGlobals.call(this);
            }
            oldOpen.call(this);
        }
        function ShouldApplyWrappedText() {
            var textStateIsThere = this._textState != null;
            // ^It sometimes is null when this func is called, so...
            // when that's the case, we should NOT touch it
            return textStateIsThere;
        }
        function ApplyWrappedText() {
            var wrapTarget = DecideOnWrapTarget();
            var wrapperToUse = DecideWrapperToUse(wrapTarget);
            var wrapArgs = GetInfoForWrapper.call(this, wrapTarget);
            var wrappedText = wrapperToUse.Wrap(wrapArgs);
            this._textState.text = wrappedText;
        }
        function DecideWrapperToUse(wrapTarget) {
            var activeWrappers = CGT.WWCore.ActiveWrappers;
            var theOneToUse = activeWrappers.get(wrapTarget);
            return theOneToUse;
        }
        function DecideOnWrapTarget() {
            var WrapTarget = CGT.WWCore.WrapTarget;
            var decidedOn;
            if (CGT.WWCore.currentMessageIsBubble)
                decidedOn = WrapTarget.Bubble;
            else
                decidedOn = WrapTarget.MessageBox;
            return decidedOn;
        }
        function GetInfoForWrapper(wrapTarget) {
            var wrapArgs = null;
            var spacing = null;
            var wrapperSpacing = CGT.WWCore.WrapperSpacing;
            spacing = wrapperSpacing.get(wrapTarget);
            var rawText = this._textState.text + "";
            var textField = this.contents;
            wrapArgs =
                {
                    textField: textField,
                    rawTextToWrap: rawText,
                    spacing: spacing,
                    considerYanflyNamebox: true,
                };
            return wrapArgs;
        }
        function UpdateGalvGlobals() {
            var textForMessageStyles = "";
            var showingBubble = this.pTarget != null;
            if (showingBubble)
                textForMessageStyles = this._textState.text;
            CGT.WWCore.textForGalvMessageStyles = textForMessageStyles;
        }
        Window_Message.prototype.open = NewOpen;
    }

    Window_Help.prototype.setText;
    // This is for the window that shows descs of items and such
    function ApplyWindowHelpOverrides() {
        var defaultWordWrapArgs = {
            textField: null,
            rawTextToWrap: "",
            spacing: null,
            considerYanflyNamebox: false,
        };
        Window_Help.prototype.wordWrapArgs = Object.assign({}, defaultWordWrapArgs);
        Window_Help.prototype.setText = NewSetText;
    }
    function NewSetText(text) {
        text += ""; // In case a number or something else is passed
        ApplyDescWrapping.call(this, text);
        this.refresh();
    }
    function ApplyDescWrapping(text) {
        UpdateWrapArgs.call(this, text);
        var WrapTarget = CGT.WWCore.WrapTarget;
        var wordWrapper = CGT.WWCore.ActiveWrappers.get(WrapTarget.Desc);
        var wrappedText = wordWrapper.Wrap(this.wordWrapArgs);
        this._text = wrappedText;
    }
    function UpdateWrapArgs(text) {
        this.wordWrapArgs.textField = this.contents;
        this.wordWrapArgs.rawTextToWrap = text;
        var WrapTarget = CGT.WWCore.WrapTarget;
        var spacing = CGT.WWCore.WrapperSpacing.get(WrapTarget.Desc);
        this.wordWrapArgs.spacing = spacing;
    }

    /** For overriding the base functionality of MV's Window classes */
    function ApplyBuiltInWindowOverrides(coreParams) {
        ApplyWindowMessageOverrides();
        ApplyWindowHelpOverrides();
    }

    function ApplyMessageStyleOverrides() {
        OverrideWindowChangeDimensions();
    }
    function OverrideWindowChangeDimensions() {
        var oldChangeWindowDimensions = Window_Message.prototype.changeWindowDimensions;
        function NewChangeWindowDimensions() {
            oldChangeWindowDimensions.call(this);
            var thereIsTextForMessageStyles = CGT.WWCore.textForGalvMessageStyles.length > 0;
            if (!thereIsTextForMessageStyles)
                return;
            var wrappedTextLines = CGT.WWCore.textForGalvMessageStyles.split(singleNewline);
            HaveWidthAccomodateWrappedText.call(this, wrappedTextLines);
            HaveHeightAccomodateWrappedText.call(this, wrappedTextLines);
        }
        function HaveWidthAccomodateWrappedText(wrappedTextLines) {
            var textWidth = CalcTextWidth.call(this, wrappedTextLines);
            this.width = textWidth;
        }
        function CalcTextWidth(wrappedTextLines) {
            var xOffset = CalcXOffset.call(this);
            var textWidth = 0;
            for (var i = 0; i < wrappedTextLines.length; i++) {
                var currentLine = wrappedTextLines[i];
                var widthOfCurrentLine = this.testWidthEx(currentLine) +
                    this.standardPadding() * 2 + xOffset;
                textWidth = Math.max(textWidth, widthOfCurrentLine);
            }
            return textWidth;
        }
        function CalcXOffset() {
            var result = 0;
            var faceOffset = CalcFaceOffset.call(this);
            result = $gameMessage._faceName ? faceOffset : 0;
            var padding = Galv.Mstyle.padding[1] + Galv.Mstyle.padding[3];
            result += padding;
            return result;
        }
        function CalcFaceOffset() {
            var result = 0;
            if (Imported.Galv_MessageBusts) {
                if ($gameMessage.bustPos == 1) {
                    result = 0;
                }
                else {
                    result = Galv.MB.w;
                }
            }
            else {
                result = Window_Base._faceWidth + 25;
            }
            return result;
        }
        function HaveHeightAccomodateWrappedText(wrappedTextLines) {
            var textHeight = CalcTextHeight.call(this, wrappedTextLines);
            this.height = textHeight;
        }
        function CalcTextHeight(wrappedTextLines) {
            var result = 0;
            var textState = { index: 0, text: wrappedTextLines.join(singleNewline) };
            var rawTextHeight = this.calcTextHeight(textState, true);
            var paddedTextHeight = rawTextHeight + this.standardPadding() * 2;
            var minHeight = this.fittingHeight(wrappedTextLines.length);
            var minFaceHeight = CalcMinFaceHeight.call(this, wrappedTextLines);
            result = Math.max(paddedTextHeight, minHeight, minFaceHeight);
            result += Galv.Mstyle.padding[0] + Galv.Mstyle.padding[2];
            return result;
        }
        function CalcMinFaceHeight(wrappedTextLines) {
            var minFaceHeight = 0;
            var textWidth = CalcTextWidth.call(this, wrappedTextLines);
            var mugshotIsShowing = $gameMessage._faceName.length > 0;
            if (mugshotIsShowing) {
                textWidth += 15;
                if (Imported.Galv_MessageBusts) {
                    if ($gameMessage.bustPos == 1)
                        textWidth += Galv.MB.w;
                    minFaceHeight = 0;
                }
                else {
                    minFaceHeight = Window_Base._faceHeight + this.standardPadding() * 2;
                }
            }
            return minFaceHeight;
        }
        Window_Message.prototype.changeWindowDimensions = NewChangeWindowDimensions;
    }

    function ApplyGalvScriptOverrides() {
        ApplyMessageStyleOverrides();
    }

    function ApplyOverrides(coreParams) {
        ApplyBuiltInWindowOverrides();
        ApplyYanflyScriptOverrides();
        ApplyGalvScriptOverrides();
    }

    // ^ Added underscores to the file names to avoid a certain glitch

    var Shared = {
        __proto__: null,
        Regexes: _Regexes,
        Strings: _Strings,
        Functions: _Functions
    };

    var WrapRules = {
        __proto__: null,
        WrapRule: WrapRule,
        WrapRuleApplier: WrapRuleApplier,
        StringWrapRule: StringWrapRule,
        TurnNewlinesIntoSeparators: TurnNewlinesIntoSeparators,
        WithoutExtraSpaces: WithoutExtraSpaces,
        LineWrapRule: LineWrapRule,
        CharPerLineMin: CharPerLineMin,
        ParenthesisAlignment: ParenthesisAlignment
    };

    var __values$1 = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var LineWrapper = /** @class */ (function () {
        function LineWrapper() {
        }
        LineWrapper.prototype.WrapIntoLines = function (args, actualTextToWrap) {
            actualTextToWrap += emptyString; // In case the orig was a non-string
            var lines = this.WithNormalLineWrapping(args, actualTextToWrap);
            if (this.ShouldApplyCascadingUnderflowTo(lines))
                lines = this.ApplyCUTo(lines, args);
            return lines;
        };
        LineWrapper.prototype.WithNormalLineWrapping = function (args, actualTextToWrap) {
            var e_1, _a;
            var lines = [];
            var words = actualTextToWrap.split(this.WordSeparator);
            var currentLine = emptyString;
            var overflowFindArgs = this.CreateOverflowFindArgs();
            overflowFindArgs.fullTextHasBoldOrItalics = this.HasBoldOrItalicMarkers(actualTextToWrap);
            try {
                for (var words_1 = __values$1(words), words_1_1 = words_1.next(); !words_1_1.done; words_1_1 = words_1.next()) {
                    var currentWord = words_1_1.value;
                    // "currentWord" would be a bit misleading for when the text is like Japanese or 
                    // Chinese, where there's no designated character to separate words... but hey.
                    this.Update(overflowFindArgs, args, currentWord, currentLine);
                    var thereIsOverflow = this.overflowFinder.Find(overflowFindArgs);
                    var foundLineBreak = this.IsLineBreak(currentWord);
                    if (thereIsOverflow || foundLineBreak) {
                        lines.push(currentLine.trim()); // Make sure not to include any extra spaces
                        currentLine = emptyString;
                    }
                    if (foundLineBreak) // We don't want any line break codes added to the next line
                        continue;
                    currentLine += currentWord + this.WordSeparator;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (words_1_1 && !words_1_1.done && (_a = words_1.return)) _a.call(words_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            // The last line is always left out by the above loop, so...
            lines.push(currentLine.trim());
            return lines;
        };
        LineWrapper.prototype.CreateOverflowFindArgs = function () {
            var args = {
                word: "",
                line: "",
                wordWrapArgs: null,
                fullTextHasBoldOrItalics: false,
            };
            return args;
        };
        LineWrapper.prototype.HasBoldOrItalicMarkers = function (text) {
            return text.match(boldMarkers) != null || text.match(italicsMarkers) != null;
        };
        Object.defineProperty(LineWrapper.prototype, "WordSeparator", {
            get: function () { return CGT.WWCore.Params.WordSeparator; },
            enumerable: false,
            configurable: true
        });
        LineWrapper.prototype.Update = function (overflowFindArgs, wordWrapArgs, word, line) {
            overflowFindArgs.word = word;
            overflowFindArgs.line = line;
            overflowFindArgs.wordWrapArgs = wordWrapArgs;
        };
        LineWrapper.prototype.IsLineBreak = function (text) {
            // If the pre-rule for replacing LB tags with newlines works right, each newline
            // should be separated from the rest of the text as its own word 
            // (or "word" in the case of langs like jp or cn)
            return text == singleNewline;
        };
        Object.defineProperty(LineWrapper.prototype, "LineBreakMarkers", {
            get: function () { return CGT.WWCore.Params.LineBreakMarkers; },
            enumerable: false,
            configurable: true
        });
        /** Call every time you finish a word-wrapping session. */
        LineWrapper.prototype.OnWrapJobFinished = function () {
            this.overflowFinder.OnWrapJobFinished();
        };
        LineWrapper.prototype.ShouldApplyCascadingUnderflowTo = function (lines) {
            var moreThanOneLine = lines.length > 1;
            var userEnabledIt = CGT.WWCore.Params.CascadingUnderflow == true;
            var cascaderIsThere = this.underflowCascader != null;
            // ^It might not be if the user's using older versions of the specific wrappers
            return moreThanOneLine && userEnabledIt && cascaderIsThere;
        };
        LineWrapper.prototype.ApplyCUTo = function (lines, args) {
            var cascaderArgs = {
                textField: args.textField,
                lines: lines,
                focusedLineIndex: 1,
                spacing: args.spacing,
            };
            lines = this.underflowCascader.WithCascadingUnderflow(cascaderArgs);
            return lines;
        };
        return LineWrapper;
    }());

    var __extends$1 = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var NullLineWrapper = /** @class */ (function (_super) {
        __extends$1(NullLineWrapper, _super);
        function NullLineWrapper() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NullLineWrapper.prototype.WrapIntoLines = function (wordWrapArgs, actualTextToWrap) {
            return [wordWrapArgs.rawTextToWrap];
        };
        return NullLineWrapper;
    }(LineWrapper));

    // Best inherit from this, since what defines wrap width
    // can vary between wrapper types
    var OverflowFinder = /** @class */ (function () {
        function OverflowFinder() {
        }
        OverflowFinder.prototype.Find = function (args) {
            var measurerArgs = this.PrepareArgsForMeasurerFrom(args);
            var spaceTakenUp = this.textMeasurer.MeasureFor(measurerArgs);
            var spaceAvailable = this.GetWrapSpace(args);
            return spaceTakenUp > spaceAvailable;
        };
        OverflowFinder.prototype.PrepareArgsForMeasurerFrom = function (args) {
            var textField = args.wordWrapArgs.textField;
            var text = args.line + args.word;
            var measurerArgs = {
                text: text,
                textField: textField,
                textHasBoldOrItalic: args.fullTextHasBoldOrItalics,
                spacing: args.wordWrapArgs.spacing,
            };
            return measurerArgs;
        };
        /** Returns how much space there is to have text on a single line, based on the inputs. */
        OverflowFinder.prototype.GetWrapSpace = function (args) {
            var mugshotIsThere = $gameMessage.faceName() != "";
            if (mugshotIsThere)
                return this.SpaceMinusMugshot(args);
            else
                return this.RegularWrapSpace(args);
        };
        OverflowFinder.prototype.SpaceMinusMugshot = function (args) {
            var spacing = args.wordWrapArgs.spacing;
            var offset = spacing.MugshotWidth + spacing.MugshotPadding;
            return this.RegularWrapSpace(args) - offset;
        };
        /** Call this after you finish a full wrapping session. */
        OverflowFinder.prototype.OnWrapJobFinished = function () {
        };
        Object.defineProperty(OverflowFinder.prototype, "Params", {
            // @ts-ignore
            get: function () { return CGT.WWCore.Params; },
            enumerable: false,
            configurable: true
        });
        return OverflowFinder;
    }());

    var __values = (undefined && undefined.__values) || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    /**
     * Measures text while using a history to help keep track of what's
     * bolded or italicised.
     */
    var TextMeasurer = /** @class */ (function () {
        function TextMeasurer() {
        }
        TextMeasurer.prototype.MeasureFor = function (args) {
            var text = args.text + emptyString; // In case a non-string is passed
            text = this.WithoutEmptyTexts(text);
            var textField = args.textField;
            var baseWidth = this.GetDefaultWidthOf(text, textField);
            var offset = 0;
            if (args.textHasBoldOrItalic)
                offset = args.spacing.BoldItalicPadding;
            // ^ We want to treat the text as bigger in this case to help avoid
            // overflow caused by bolding or italicization
            var totalWidth = baseWidth + offset;
            return totalWidth;
        };
        TextMeasurer.prototype.WithoutEmptyTexts = function (text) {
            var e_1, _a;
            try {
                for (var _b = __values(this.EmptyText), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var emptyTextEl = _c.value;
                    var theRegex = emptyTextEl.Regex;
                    text = text.replace(theRegex, emptyString);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return text;
        };
        Object.defineProperty(TextMeasurer.prototype, "EmptyText", {
            get: function () { return CGT.WWCore.Params.EmptyText; },
            enumerable: false,
            configurable: true
        });
        return TextMeasurer;
    }());

    var __extends = (undefined && undefined.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var NullOverflowFinder = /** @class */ (function (_super) {
        __extends(NullOverflowFinder, _super);
        function NullOverflowFinder() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NullOverflowFinder.prototype.Find = function (args) { return false; };
        NullOverflowFinder.prototype.GetWrapWidth = function (args) {
            // Dummy implementation; this finder only exists to fulfill Wrapper requirements
            return 666;
        };
        return NullOverflowFinder;
    }(OverflowFinder));

    var Overflow = {
        __proto__: null,
        OverflowFinder: OverflowFinder,
        TextMeasurer: TextMeasurer,
        NullOverflowFinder: NullOverflowFinder
    };

    // For applying cascading underflow
    var UnderflowCascader = /** @class */ (function () {
        function UnderflowCascader() {
        }
        UnderflowCascader.prototype.WithCascadingUnderflow = function (args) {
            args = this.CopyOf(args); // To avoid mutating the orig
            this.AddEmptyLineForSafetyTo(args.lines);
            var result = this.WithWordsShiftedAsNeeded(args);
            this.RemoveExtraLineAsNeeded(result);
            return result;
        };
        UnderflowCascader.prototype.CopyOf = function (args) {
            var theCopy = {
                lines: args.lines.slice(),
                textField: args.textField,
                focusedLineIndex: args.focusedLineIndex,
                spacing: args.spacing
            };
            return theCopy;
        };
        UnderflowCascader.prototype.AddEmptyLineForSafetyTo = function (lines) {
            // In case the wrapped text as-is doesn't have enough to have things cascade properly.
            // As we're working with a copy of the LineWrapper's orig input, it's fine to mutate things
            // directly in it
            lines.push(emptyString);
        };
        UnderflowCascader.prototype.WithWordsShiftedAsNeeded = function (args) {
            if (!this.ShouldApplyCascading(args)) // Since we're using recursion here
                return args.lines;
            var lines = args.lines;
            var wordMoveDecision = this.MakeDecisionAboutMovingWord(args);
            while (wordMoveDecision.moveIt) {
                var withTextMoved = this.WithWordMovedToNextLine(wordMoveDecision.linesToCascade);
                // ^We want to move one word (or "word", depending on the lang) at a time
                lines[args.focusedLineIndex] = withTextMoved.focusedLine;
                var nextLineIndex = args.focusedLineIndex + 1;
                lines[nextLineIndex] = withTextMoved.nextLine;
                wordMoveDecision = this.MakeDecisionAboutMovingWord(args);
            }
            args.focusedLineIndex++; // So that the next call shifts stuff from the next line as needed
            lines = this.WithWordsShiftedAsNeeded(args);
            return lines;
        };
        UnderflowCascader.prototype.ShouldApplyCascading = function (args) {
            var lastLineIndex = args.lines.length - 1;
            return args.focusedLineIndex < lastLineIndex;
        };
        UnderflowCascader.prototype.MakeDecisionAboutMovingWord = function (args) {
            var toCascade = this.GetLinesToCascade(args);
            var widthsMeasured = this.MeasuredWidthsOf(toCascade, args);
            var decision = {
                linesToCascade: toCascade,
                widthsMeasured: widthsMeasured,
                moveIt: widthsMeasured.currentLineWidth > widthsMeasured.firstLineWidth,
            };
            return decision;
        };
        // The lines involved in a potential word-shift. They're decided based on the index of what
        // we're treating as the current line, which we're assuming is always at least 1 here
        UnderflowCascader.prototype.GetLinesToCascade = function (args) {
            var focusedLineIndex = args.focusedLineIndex;
            var theLines = {
                focusedLine: args.lines[focusedLineIndex],
                firstLine: args.lines[0],
                nextLine: args.lines[focusedLineIndex + 1],
            };
            return theLines;
        };
        UnderflowCascader.prototype.MeasuredWidthsOf = function (relevantLines, cascadeArgs) {
            var textField = cascadeArgs.textField;
            var firstLine = relevantLines.firstLine;
            var currentLine = relevantLines.focusedLine;
            var firstLineArgs = {
                text: firstLine,
                textField: textField,
                textHasBoldOrItalic: false,
                spacing: cascadeArgs.spacing,
            };
            var currentLineArgs = {
                text: currentLine,
                textField: textField,
                textHasBoldOrItalic: false,
                spacing: cascadeArgs.spacing,
            };
            var results = {
                firstLineWidth: this.textMeasurer.MeasureFor(firstLineArgs) + this.CULenience,
                currentLineWidth: this.textMeasurer.MeasureFor(currentLineArgs),
            };
            return results;
        };
        Object.defineProperty(UnderflowCascader.prototype, "CULenience", {
            get: function () { return CGT.WWCore.Params.CULenience; },
            enumerable: false,
            configurable: true
        });
        UnderflowCascader.prototype.WithWordMovedToNextLine = function (toCascade) {
            var focusedLineSplit = toCascade.focusedLine.split(this.WordSeparator);
            var nextLineSplit = toCascade.nextLine.split(this.WordSeparator);
            var wordToMove = focusedLineSplit.pop();
            nextLineSplit.unshift(wordToMove);
            var withThingsShifted = {
                firstLine: toCascade.firstLine,
                focusedLine: focusedLineSplit.join(this.WordSeparator),
                nextLine: nextLineSplit.join(this.WordSeparator),
            };
            return withThingsShifted;
        };
        Object.defineProperty(UnderflowCascader.prototype, "WordSeparator", {
            get: function () { return CGT.WWCore.Params.WordSeparator; },
            enumerable: false,
            configurable: true
        });
        /** Without this, the outputted text could lead to an empty message box */
        UnderflowCascader.prototype.RemoveExtraLineAsNeeded = function (lines) {
            var extraLine = lines[lines.length - 1];
            var itIsEmpty = extraLine == emptyString;
            if (itIsEmpty)
                lines.pop();
        };
        return UnderflowCascader;
    }());

    var WrapTarget;
    (function (WrapTarget) {
        WrapTarget["MessageBox"] = "messagebox";
        WrapTarget["Desc"] = "desc";
        WrapTarget["MessageBacklog"] = "messageBacklog";
        WrapTarget["Bubble"] = "bubble";
    })(WrapTarget || (WrapTarget = {}));

    var WWCore = {
        version: 30103,
        Params: pluginParams,
        WrapRules: WrapRules,
        Overflow: Overflow,
        CoreWrapParams: CoreWrapParams,
        WordWrapper: WordWrapper,
        LineWrapper: LineWrapper,
        NametagFetcher: NametagFetcher,
        UnderflowCascader: UnderflowCascader,
        UpdateActiveWrappers: function () {
            var params = this.Params;
            this.SetActiveWrapper(WrapTarget.MessageBox, params.MessageWrapper);
            this.SetActiveWrapper(WrapTarget.Desc, params.DescWrapper);
            this.SetActiveWrapper(WrapTarget.MessageBacklog, params.MessageBacklogWrapper);
            this.SetActiveWrapper(WrapTarget.Bubble, params.BubbleWrapper);
        },
        SetActiveWrapper: function (target, wrapMode) {
            // It's too bad that types aren't always auto-detected for regular 
            // objects, even in TS...
            var wrappers = this.RegisteredWrappers;
            var anythingRegisteredHasMode = wrappers.has(wrapMode);
            if (!anythingRegisteredHasMode)
                return false;
            var toSetAsActive = wrappers.get(wrapMode);
            var activeOnes = this.activeWrappers;
            activeOnes.set(target, toSetAsActive);
            return true;
        },
        get RegisteredWrappers() { return this.registeredWrappers; },
        registeredWrappers: new Map(),
        get ActiveWrappers() { return this.activeWrappers; },
        activeWrappers: new Map(),
        UpdateWrapSpacing: function () {
            var spacings = this.wrapperSpacing;
            var params = this.Params;
            spacings.set(WrapTarget.MessageBox, params.MessageSpacing);
            spacings.set(WrapTarget.Desc, params.DescSpacing);
            spacings.set(WrapTarget.MessageBacklog, params.BacklogSpacing);
            spacings.set(WrapTarget.Bubble, params.BubbleSpacing);
        },
        get WrapperSpacing() { return this.wrapperSpacing; },
        wrapperSpacing: new Map(),
        RegisterWrapper: function (wrapper) {
            var registeredWrappers = this.registeredWrappers;
            registeredWrappers.set(wrapper.WrapCode, wrapper);
        },
        Shared: Shared,
        Yanfly: {
            activeNametagText: "",
            messageBacklogWindow: null,
        },
        WrapTarget: WrapTarget,
        currentMessageIsBubble: false,
        textForGalvMessageStyles: "",
    };
    SetDefaultWrappers();
    function SetDefaultWrappers() {
        var lineWrapper = new NullLineWrapper();
        var defaultWrapper = new NullWordWrapper(lineWrapper);
        defaultWrapper.WrapCode = "null";
        WWCore.RegisterWrapper(defaultWrapper);
        WWCore.SetActiveWrapper(WrapTarget.MessageBox, defaultWrapper.WrapCode);
        WWCore.SetActiveWrapper(WrapTarget.Desc, defaultWrapper.WrapCode);
        WWCore.SetActiveWrapper(WrapTarget.MessageBacklog, defaultWrapper.WrapCode);
        WWCore.SetActiveWrapper(WrapTarget.Bubble, defaultWrapper.WrapCode);
    }
    WatchForWrapModeChanges();
    function WatchForWrapModeChanges() {
        var WrapModeChanged = WWCore.Params.WrapModeChanged;
        WrapModeChanged.AddListener(OnWrapModeChanged, this);
    }
    function OnWrapModeChanged(oldMode, newMode) {
        WWCore.UpdateActiveWrappers();
    }
    WWCore.UpdateWrapSpacing();
    ApplyOverrides(WWCore.Params);

    /*:
    * @plugindesc Needed for the CGT word-wrapping plugins, holding information they can use.
    * @author CG-Tespy – https://github.com/CG-Tespy
    * @help This is version 3.01.03 of this plugin. Tested with RMMV versions
    * 1.5.1 and 1.6.2.
    *
    * Needs the CGT CoreEngine 1.01.11+ to work. Make sure this is below that
    * in the Plugin Manager.
    *
    * Please make sure to credit me (and any of this plugin's contributing coders)
    * if you're using this plugin in your game (include the names and webpage links).
    *
    * If you want to edit this plugin, you may be better off editing and
    * building the source: https://github.com/CG-Tespy/CGT_WordWrapCore_MV
    *
    * Other Contributors:
    * LTN Games
    *
    * @param DesignatedWrappers
    * @desc Here, you decide which wrappers are assigned to different parts of the UI.
    *
    * @param MessageWrapper
    * @text MessageBoxes
    * @parent DesignatedWrappers
    * @type string
    * @default null
    * @desc For regular message boxes. Default: null
    *
    * @param MessageSpacing
    * @text Spacing
    * @parent MessageWrapper
    * @type struct<WrapperSpacing>
    * @default {"MugshotWidth":"144","MugshotPadding":"25","SidePadding":"8","BoldItalicPadding":"15"}
    *
    * @param DescWrapper
    * @text Descs
    * @parent DesignatedWrappers
    * @type string
    * @default null
    * @desc For the windows that show descs for items and such. Default: null
    *
    * @param DescSpacing
    * @text Spacing
    * @parent DescWrapper
    * @type struct<WrapperSpacing>
    * @default {"MugshotWidth":"144","MugshotPadding":"25","SidePadding":"5","BoldItalicPadding":"15"}
    *
    * @param MessageBacklogWrapper
    * @text MessageBacklog
    * @parent DesignatedWrappers
    * @type string
    * @default null
    * @desc For message backlogs. Default: null
    *
    * @param BacklogSpacing
    * @text Spacing
    * @parent MessageBacklogWrapper
    * @type struct<WrapperSpacing>
    * @default {"MugshotWidth":"10","MugshotPadding":"1","SidePadding":"5","BoldItalicPadding":"3"}
    *
    * @param BubbleWrapper
    * @text MessageBubbles
    * @parent DesignatedWrappers
    * @type string
    * @default null
    * @desc For message bubbles like the ones from Galv's MessageStyles plugin. Default: null
    *
    * @param BubbleSpacing
    * @text Spacing
    * @parent BubbleWrapper
    * @type struct<WrapperSpacing>
    * @default {"MugshotWidth":"10","MugshotPadding":"1","SidePadding":"2","BoldItalicPadding":"3"}
    *
    * @param NametagFormats
    * @type struct<RegexEntry>[]
    * @desc Tells the algorithm what counts as a nametag.
    * @default ["{\"Name\":\"AnyColored\",\"RegexAsString\":\"^(\\u001b|\\\\\\\\)c\\\\[\\\\d+\\\\][^\\\\n]+(\\u001b|\\\\\\\\)c\\\\[\\\\d+\\\\]\",\"Enabled\":\"true\",\"Notes\":\"\\\"This catches any (non-newline) colored text starting from \\\\nthe beginning and ending with a color tag. If any newlines \\\\nare before the ending tag, then this format won't catch\\\\nanything in whatever text the wrapper is working with.\\\\n\\\\nThis is mainly for Yanfly Nametags as shown in the message\\\\nlog, due to how Yanfly's scripts handle those in different\\\\nsituations.\\\"\"}","{\"Name\":\"Normal\",\"RegexAsString\":\"^[^\\\\n]+:((\\u001b|\\\\\\\\)c\\\\[\\\\d+\\\\])?\",\"Enabled\":\"true\",\"Notes\":\"\\\"This catches any (non-newline) text starting from the \\\\nbeginning and ending with a colon. If any newlines \\\\nare before the colon, then this format won't catch\\\\nanything in whatever text the wrapper is working with.\\\\n\\\\nWorks with colored text, too.\\\"\"}","{\"Name\":\"SquareBrackets\",\"RegexAsString\":\"^\\\\\\\\[[^\\\\n]+\\\\\\\\]((\\u001b|\\\\\\\\)c\\\\[\\\\d+\\\\])?\",\"Enabled\":\"true\",\"Notes\":\"\\\"This catches any (non-newline) text starting from the \\\\nbeginning with an opening square bracket, and ending with \\\\na closing square bracket. If any newlines are before that\\\\nsecond one, then this format won't catch anything in \\\\nwhatever text the wrapper is working with.\\\\n\\\\nWorks with colored text, too.\\\"\"}"]
    *
    * @param EmptyText
    * @type struct<RegexEntry>[]
    * @default ["{\"Name\":\"Text-ColoringCode\",\"RegexAsString\":\"\\\\s?(\\u001b|\\\\\\\\)C\\\\[\\\\d+\\\\]\\\\s?\",\"Enabled\":\"true\",\"Notes\":\"\\\"\\\"\"}","{\"Name\":\"GoldWindowCode\",\"RegexAsString\":\"\\u001b\\\\$\",\"Enabled\":\"true\",\"Notes\":\"\"}","{\"Name\":\"DotPause\",\"RegexAsString\":\"\\u001b\\\\.\",\"Enabled\":\"true\",\"Notes\":\"\\\"For the code that applies a slight pause in text.\\\"\"}","{\"Name\":\"BoldTextMarker\",\"RegexAsString\":\"\\u001bMSGCORE\\\\[1\\\\]\",\"Enabled\":\"true\",\"Notes\":\"\"}","{\"Name\":\"ItalicTextMarker\",\"RegexAsString\":\"\\u001bMSGCORE\\\\[2\\\\]\",\"Enabled\":\"true\",\"Notes\":\"\"}","{\"Name\":\"One-SecondWaitMarker\",\"RegexAsString\":\"\\u001b|\",\"Enabled\":\"true\",\"Notes\":\"\"}","{\"Name\":\"AutoscrollMarker\",\"RegexAsString\":\"\\u001b^\",\"Enabled\":\"true\",\"Notes\":\"\"}"]
    *
    * @param LineBreakMarkers
    * @type string[]
    * @default ["<br>", "<br2>", "<line-break>"]
    * @desc You put these in the text where you want to guarantee a line break.
    *
    * @param RememberResults
    * @type boolean
    * @default true
    * @desc Whether or not this will keep track of and always return its original outputs for the same inputs.
    *
    * @param ForAesthetics
    *
    * @param LineMinCharCount
    * @parent ForAesthetics
    * @type number
    * @default 10
    * @min 0
    * @desc Minimum amount of characters a line can hold. Default: 10
    *
    * @param ParenthesisAlignment
    * @parent ForAesthetics
    * @type boolean
    * @default true
    * @desc Whether or not this aligns text based on parentheses. Default: On
    *
    * @param WordSeparator
    * @parent ForAesthetics
    * @type string
    * @default " "
    * @desc What a wrapper should look for to tell words apart. Default: " "
    *
    * @param CascadingUnderflow
    * @parent ForAesthetics
    * @type boolean
    * @default false
    * @desc Whether any line in a given input's allowed to be wider than the first. Default: Off
    *
    * @param CULenience
    * @parent CascadingUnderflow
    * @type number
    * @min -999999
    * @default 5
    * @desc How many units wider than the first line that later ones in its input are allowed to be. Default: 5
    *
    */

    
/*:es
* @plugindesc Requisito para los plugins ajustelíneas CGT, teniendo información que pueden usar.
* @author CG-Tespy – https://github.com/CG-Tespy
* @help Este es la versión 3.01.03 de este plugin. Lo probé con versiones RMMV 1.5.1 
* y 1.6.2.
* 
* Necesita el CGT CoreEngine 1.0.11+ para funcionar. Asegurate que este es abajo 
* de ese en el Gestor de Plugins.
* 
* Por favor acredita a mí y los otros programadores colaboradores de este plugin 
* si lo usas en tu juego. Incluye los nombres y (si disponible) los 
* enlaces de web.
* 
* Si quieres editar este plugin, tal vez será mejor si lo haces por el fuente:
* https://github.com/CG-Tespy/CGT_WordWrapCore_MV
* 
* Otros donantes:
* LTN Games
* 
* @param DesignatedWrappers
* @text AjustelíneasDesignados
* @desc Aquí, decides cuales ajustelíneas se asignan a partes diferentes del IU.
*
* @param MessageWrapper
* @text CajasDeMensajes
* @parent DesignatedWrappers
* @type string
* @default null
* @desc Para cajas de mensajes normales. Por defecto: null
*
* @param MessageSpacing
* @text Espaciado
* @parent MessageWrapper
* @type struct<WrapperSpacing>
* @default {"MugshotWidth":"144","MugshotPadding":"25","SidePadding":"5","BoldItalicPadding":"15"}
*
* @param DescWrapper
* @text Descripciones
* @parent DesignatedWrappers
* @type string
* @default null
* @desc Para ventanas que enseñan descripciónes para objetos y cosas así. Por defecto: null
*
* @param DescSpacing
* @text Espaciado
* @parent DescWrapper
* @type struct<WrapperSpacing>
* @default {"MugshotWidth":"144","MugshotPadding":"25","SidePadding":"5","BoldItalicPadding":"15"}
*
* @param MessageBacklogWrapper
* @text RegistrosDeMensajes
* @parent DesignatedWrappers
* @type string
* @default null
* @desc Por defecto: null
*
* @param BacklogSpacing
* @text Espaciado
* @parent MessageBacklogWrapper
* @type struct<WrapperSpacing>
* @default {"MugshotWidth":"10","MugshotPadding":"1","SidePadding":"8","BoldItalicPadding":"3"}
*
* @param BubbleWrapper
* @text BurbujasDeMensajes
* @parent DesignatedWrappers
* @type string
* @default null
* @desc Para burbujas de mensajes como los del MessageStyles plugin de Galv. Por defecto: null
*
* @param BubbleSpacing
* @text Espaciado
* @parent BubbleWrapper
* @type struct<WrapperSpacing>
* @default {"MugshotWidth":"10","MugshotPadding":"1","SidePadding":"2","BoldItalicPadding":"3"}
*
* @param NametagFormats
* @text FormatosDeGafete
* @type struct<RegexEntry>[]
* @desc Avise al algorítmo que se vale como gafete.
* @default ["{\"Name\":\"TodosDeColor\",\"RegexAsString\":\"^(\\u001b|\\\\\\\\)c\\\\[\\\\d+\\\\][^\\\\n]+(\\u001b|\\\\\\\\)c\\\\[\\\\d+\\\\]\",\"Enabled\":\"true\",\"Notes\":\"\\\"Este detecta cualquier texto colorado (no nueva línea)\\\\nempezando por el principio y terminando con un etiqueta\\\\nde color. Si unas nuevas líneas son antes del \\\\netiqueta terminante, pues este formato no detectará\\\\nnada en cualquier texto el ajustelíneas estaba \\\\ntrabajando con.\\\\n\\\\nEste es principalmente para los gafetes Yanfly como\\\\nse enseñan en el registro de mensajes. Es debido a\\\\ncomo los plugins de Yanfly los usan en situaciones\\\\ndiferentes.\\\"\"}","{\"Name\":\"Normal\",\"RegexAsString\":\"^[^\\\\n]+:((\\u001b|\\\\\\\\)c\\\\[\\\\d+\\\\])?\",\"Enabled\":\"true\",\"Notes\":\"\\\"Este detecta el texto (no nueva línea) empezando en el\\\\nprincipio y termina con los dos puntos. Si algunas\\\\nnueva líneas son antes de los dos puntos, pues este\\\\nformato no detectará nada en cualquier texto el\\\\najustelíneas estaba trabajando con.\\\\n\\\\nFunciona con el texto colorado tambien.\\\"\"}","{\"Name\":\"SquareBrackets\",\"RegexAsString\":\"^\\\\\\\\[[^\\\\n]+\\\\\\\\]((\\u001b|\\\\\\\\)c\\\\[\\\\d+\\\\])?\",\"Enabled\":\"true\",\"Notes\":\"\\\"Este detecta cualquier texto (no nueva línea)\\\\nempezando del principio con un corchete inicial,\\\\ny terminando con un corchete final. Si alguna nueva\\\\nlínea estaba antes del corchete final, pues este formato\\\\nno detectará nada en cualquier texto el ajustelíneas\\\\nestaba trabajando con.\\\\n\\\\nFunciona con el texto colorado tambien.\\\"\"}"]
* 
* @param EmptyText
* @text TextoVacío
* @type struct<RegexEntry>[]
* @default ["{\"Name\":\"Text-ColoringCode\",\"RegexAsString\":\"\\\\s?(\\u001b|\\\\\\\\)C\\\\[\\\\d+\\\\]\\\\s?\",\"Enabled\":\"true\",\"Notes\":\"\\\"\\\"\"}","{\"Name\":\"GoldWindowCode\",\"RegexAsString\":\"\\u001b\\\\$\",\"Enabled\":\"true\",\"Notes\":\"\"}","{\"Name\":\"DotPause\",\"RegexAsString\":\"\\u001b\\\\.\",\"Enabled\":\"true\",\"Notes\":\"\\\"For the code that applies a slight pause in text.\\\"\"}","{\"Name\":\"BoldTextMarker\",\"RegexAsString\":\"\\u001bMSGCORE\\\\[1\\\\]\",\"Enabled\":\"true\",\"Notes\":\"\"}","{\"Name\":\"ItalicTextMarker\",\"RegexAsString\":\"\\u001bMSGCORE\\\\[2\\\\]\",\"Enabled\":\"true\",\"Notes\":\"\"}","{\"Name\":\"One-SecondWaitMarker\",\"RegexAsString\":\"\\u001b|\",\"Enabled\":\"true\",\"Notes\":\"\"}","{\"Name\":\"AutoscrollMarker\",\"RegexAsString\":\"\\u001b^\",\"Enabled\":\"true\",\"Notes\":\"\"}"]
* 
* @param LineBreakMarkers
* @text SeñalesDeSaltalíneas
* @type string[]
* @default ["<br>", "<br2>", "<line-break>"]
* @desc Pon estos en el texto dónde quieres garantizar una salta de línea.
* 
* @param RememberResults
* @text RecuerdaResultos
* @type boolean
* @default true
* @desc Si o no esto llevará un registro y siempre da las salidas para las mismas entradas.
* 
* @param ForAesthetics
* @text PorEstéticos
*
* @param LineMinCharCount
* @text MinDeLíneasTotalDeCará
* @parent ForAesthetics
* @type number
* @default 10
* @min 0
* @desc Minimo de carácteres que una línea puede tener. Por defecto: 10
* 
* @param ParenthesisAlignment
* @text AlineaciónDeParéntesis
* @parent ForAesthetics
* @type boolean
* @default true
* @desc Si o no esto alinea el texto basado en paréntesis. Por defecto: true
* 
* @param WordSeparator
* @text SeparadorDePalabras
* @parent ForAesthetics
* @type string
* @default " "
* @desc Que un ajustelíneas debe buscar para diferenciar las palabras. Por defecto: " "
*
* @param CascadingUnderflow
* @text NegadesbordamientoCascadando
* @parent ForAesthetics
* @type boolean
* @default false
* @desc Si o no una línea en cualquier entrada puede ser más ancho que la primera. Por defecto: OFF
* 
* @param CULenience
* @text IndulgenciaDeNC
* @parent CascadingUnderflow
* @type number
* @min -999999
* @default 5
* @desc Cuántos unidades más ancho que la primera línea que las posteriores se permiten ser. Por defecto: 5
* 
*/
    var plugin = {
        WWCore: WWCore
    };
    //@ts-ignore
    window.CGT = window.CGT || {};
    Object.assign(window.CGT, plugin);

})();
