//=============================================================================
// RPG Maker MZ - Mano_BattleControl
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 戦闘を調整します
 * @author 天叢雲劍
 * 
 * @param tpRateOfUp
 * @text TP上昇倍率
 * @desc ダメージを受けた時のTP上昇率 0~100倍
 * @default 1.00
 * @type number
 * @decimals 2
 * @min 0
 * @max 100
 * 
 * @param isNotTpUpWithMap
 * @text マップTP再生無効
 * @default true
 * @type boolean
 * @desc マップでの歩行でTP再生率を付与されたキャラのTPの再生を防ぐ
 * 
 * @help Mano_BattleControl.js
 *
 * 1.被ダメージ時のTPの調整
 * 2.ターン開始時の敏捷性によるステートの付与
 *
 * プラグインコマンドはありません。
 */
(function(){
    var parameters = PluginManager.parameters('Mano_BattleControl');
    var tpRateOfUp = Number(parameters['tpRateOfUp'] || 100);
    var isNotTpUpWithMap = String(parameters['isNotTpUpWithMap'] || "true");

    // 被ダメージ時のTPの調整
    Game_Battler.prototype.chargeTpByDamage = function(damageRate) {
        const value = Math.floor(50 * damageRate * this.tcr * tpRateOfUp);
        this.gainSilentTp(value);
    };

    Game_Actor.prototype.turnEndOnMap = function() {
        if ($gameParty.steps() % this.stepsForTurn() === 0) {
            if (isNotTpUpWithMap == 'true') {
                this.onTurnEndMap();
            }else{
                this.onTurnEnd();
            }
            if (this.result().hpDamage > 0) {
                this.performMapDamage();
            }
        }
    };

    Game_Battler.prototype.onTurnEndMap = function() {
        this.clearResult();
        if (this.isAlive()) {
            this.regenerateHp();
            this.regenerateMp();
        }
        this.updateStateTurns();
        this.updateBuffTurns();
        this.removeStatesAuto(2);
    };
    


    // ターン開始時の敏捷性によるステートの付与
    // BattleManager.endTurn = function() {
    //     this._phase = "turnEnd";
    //     this._preemptive = false;
    //     this._surprise = false;
    //     this.addSpeedState();
    //     if (!this.isTpb()) {
    //         this.endAllBattlersTurn();
    //     }
    // };

    // BattleManager.addSpeedState = function() {
    //     $gameActors.actor(1).addState(SppedState);
    //     this.push('addText', '2回行動だ！');
    // }
    
})();