// --------------------------------------------------------------------------
// 
// PNDK_ShopPriceChanger
// Copyright (c) 2016 PANDAKO
// This software is released under the MIT License.
// 
// Version:1.2.1	2023/05/08  MZのプラグインコマンドに対応
// Version:1.2.0	2016/10/27	小数ではなく整数の％で設定できるように変更
// Version:1.1.0	2016/10/26	制御文字に対応。名称を他と重なりにくいよう変更
// Version:1.0.0	2016/10/24	初版
// 
// --------------------------------------------------------------------------

/*:ja
 * @target MZ
 * @plugindesc お店で売買する時の価格を変更します。
 * @author パンダコ（MZ版:さかなのまえあし移植）
 *
 * @help
 * プラグインコマンド:
 *   buy 50      #購入価格を半額（50%）にする
 *   sell 100    #売却価格を購入価格と同じ（100%）にする
 *   sell \V[n]  #売却価格を変数n番のレートにする
 *   reset       #パラメータで設定した値にリセット
 * 
 * @param buyingPrice
 * @desc 購入時の価格レート（単位は％です）
 * ※制御文字利用可（\V[n]）
 * @default 100
 * 
 * @param sellingPrice
 * @desc 売却時の価格レート（単位は％です）
 * ※制御文字利用可（\V[n]）
 * @default 50
 * 
 * 
 * @command Changer_buy
 * @text buy
 * @desc 購入時の価格レート（単位は％です）
 * 
 * @arg buy
 * @text 購入時の価格
 * @desc レート（単位は％です）
 * @type Number
 * @default 100
 * 
 * @command Changer_sell
 * @text sell
 * @desc 売却時の価格レート（単位は％です）
 * @type Number
 * @default 50 
 * 
 * @arg sell 
 * @text 売却時の価格
 * @desc レート（単位は％です）
 * 
 * @command Changer_reset
 * @text reset
 * @desc レートをリセットします
 * 
 */

(() => {
    'use strict';
	//プラグインマネージャーで設定されたパラメータを取得
	const pluginName = 'PNDK_ShopPriceChanger';
	const parameters = PluginManager.parameters('PNDK_ShopPriceChanger');
	
	//パラメータを変数へ
	let buyingPrice = parameters['buyingPrice'];
	let sellingPrice = parameters['sellingPrice'];
	
	//プラグインコマンドの処理

    PluginManager.registerCommand(pluginName, "Changer_buy", function (args) {
		// 処理
		buyingPrice = args.buy;
    });

    PluginManager.registerCommand(pluginName, "Changer_sell", function (args) {
		// 処理
		sellingPrice = args.sell;
    });

    PluginManager.registerCommand(pluginName, "Changer_reset", function (args) {
		// 処理
		buyingPrice = parameters['buyingPrice'];
		sellingPrice = parameters['sellingPrice'];
    });

	//表示価格＆販売価格の処理に追記
	const _Window_ShopBuy_prototype_price = Window_ShopBuy.prototype.price;
	Window_ShopBuy.prototype.price = function(item) {
		_Window_ShopBuy_prototype_price.call(this, item);
		//
		return Math.floor(this._price[this._data.indexOf(item)] * (Number(Window_Base.prototype.convertEscapeCharacters(buyingPrice)) / 100));
	};

	//売却価格処理に追記
	const _Scene_Shop_prototype_sellingPrice = Scene_Shop.prototype.sellingPrice;
	Scene_Shop.prototype.sellingPrice = function() {
		_Scene_Shop_prototype_sellingPrice.call(this);
		//
		return Math.floor(this._item.price * (Number(Window_Base.prototype.convertEscapeCharacters(sellingPrice)) / 100));
	};
	
})();