/*:
 * @plugindesc MAP画面の倍率を設定するプラグイン
 * @target MZ
 * @param MapScale
 * @text MAP倍率
 * @type number
 * @decimals 2
 * @default 1.50
 * @desc MAP画面の倍率を設定します（例: 1.00 = 100%）。
 */

(() => {
    const parameters = PluginManager.parameters('0NTMAPZoom');
    const mapScale = parseFloat(parameters['MapScale'] || 1.00);

    const _Spriteset_Map_updatePosition = Spriteset_Map.prototype.updatePosition;
    Spriteset_Map.prototype.updatePosition = function() {
        _Spriteset_Map_updatePosition.call(this);
        this.scale.x = mapScale;
        this.scale.y = mapScale;
    };
})();