/*:
 * @target MZ
 * @plugindesc セーブ時に任意のコモンイベントを実行するプラグイン
 * @param commonEventId
 * @text コモンイベントID
 * @desc セーブ時に実行するコモンイベントのID
 * @default 1013
 * @type common_event
 */

(function() {
    var parameters = PluginManager.parameters('0NT_SaveCommon');
    var commonEventId = Number(parameters['commonEventId'] || 1);

    // コモンイベントを実行する関数
    function executeCommonEvent(eventId) {
        const commonEvent = $dataCommonEvents[eventId];
        if (commonEvent) {
            const interpreter = new Game_Interpreter();
            interpreter.setup(commonEvent.list);
            interpreter.update();
        }
    }

    // セーブ処理の前にコモンイベントを実行するように修正
    const originalSaveGame = DataManager.saveGame;
    DataManager.saveGame = function(savefileId) {
        executeCommonEvent(commonEventId);
        return originalSaveGame.call(this, savefileId);
    };
})();