/*:
 * @target MZ
 * @plugindesc 【戦闘】敵キャラクターの行動を、実際に行動する直前に再決定するプラグイン
 * @author PLG
 *
 * @help
 * ◆概要
 * このプラグインは、敵が行動を開始する直前にその行動を再決定します。
 * これにより、イベントコマンドやスクリプトでHPやステートが変化した場合でも
 * 最新の条件に基づいた行動が反映されます。
 *
 * ◆仕様
 * ・敵がターン行動を開始する直前に `clearActions()` で既存の行動を消去
 * ・`makeActions()` で最新条件に基づき行動を決定し直す
 * ・自己対象（自身をターゲットにするスキル等）の場合も行動更新される
 *
 * 似たプラグインとしてRX_T_ChgEnemyBehavior_in_RT.js というプラグインもあります。
 * アクターが敵をターゲットにした時しか行動の更新がされませんが、そちらで十分な場合はそちらを推奨します。
 * 
 */


(() => {
    'use strict';

    const _BattleManager_startAction = BattleManager.startAction;
    BattleManager.startAction = function() {
        const subject = this._subject;
        // 敵の場合は行動直前に再決定する
        if (subject && subject.isEnemy()) {
            //console.log("[DEBUG] 再決定前:", subject.currentAction());
            subject.clearActions(); // 既存アクション消去
            subject.makeActions();  // 最新の条件で行動を決め直す
            //console.log("[DEBUG] 再決定後:", subject.currentAction());
        }
        _BattleManager_startAction.apply(this, arguments);
    };

})();
