/*:
 * @target MZ
 * @plugindesc 【戦闘】戦闘中アクターコマンドのアクティブ／決定でスイッチをONにするプラグイン
 * @author PLG
 *
 * @param SwitchA
 * @text カーソルアクティブ／移動時スイッチ
 * @type switch
 * @default 1041
 *
 * @param SwitchB
 * @text 決定時スイッチ
 * @type switch
 * @default 1042
 */

(() => {
    const pluginName = document.currentScript.src.match(/([^\/]+)\.js$/)[1];
    const parameters = PluginManager.parameters(pluginName);

    const switchA = Number(parameters["SwitchA"] || 0);
    const switchB = Number(parameters["SwitchB"] || 0);

    // =========================
    // アクティブになったとき
    // =========================
    const _Window_ActorCommand_activate = Window_ActorCommand.prototype.activate;
    Window_ActorCommand.prototype.activate = function() {
        _Window_ActorCommand_activate.apply(this, arguments);
        //dm("A");
        if (switchA > 0) $gameSwitches.setValue(switchA, true);
    };

    // =========================
    // カーソル移動（選択変更）
    // =========================
    // スキル選択後、コマンドウィンドウが出なくても呼び出されるので注意
    const _Window_ActorCommand_select = Window_ActorCommand.prototype.select;
    Window_ActorCommand.prototype.select = function(index) {
        _Window_ActorCommand_select.apply(this, arguments);
        //dm("B");
		    // ウィンドウがアクティブでない場合はスキップ
		    if (this.active && switchA > 0) {
		        if (switchA > 0) $gameSwitches.setValue(switchA, true);
		    }
    };

    // =========================
    // 決定（OK）時
    // =========================
    const _Window_ActorCommand_processOk = Window_ActorCommand.prototype.processOk;
    Window_ActorCommand.prototype.processOk = function() {
        _Window_ActorCommand_processOk.apply(this, arguments);
        //dm("C");
        if (switchB > 0) $gameSwitches.setValue(switchB, true);
    };
})();
