/*:
 * @target MZ
 * @plugindesc 【戦闘】指定アクターの名前を戦闘コマンド名に置き換えるプラグイン
 * @author PLG
 *
 * @param SaveActorId
 * @text 保存先アクターID
 * @type actor
 * @default 122
 * @desc 現在のコマンド名を保存するアクターのID
 */

(() => {
    const pluginName = document.currentScript.src.match(/([^\/]+)\.js$/)[1];
    const parameters = PluginManager.parameters(pluginName);

    const saveActorId = Number(parameters["SaveActorId"] || 122);

    // コマンド名を安全に取得する
    function getCommandDisplayName(window) {
        if (
            window &&
            Array.isArray(window._list) &&
            window.index() >= 0 &&
            window.index() < window._list.length
        ) {
            return window.commandName(window.index());
        }
        return null;
    }

    // 名前を指定アクターに反映
    function applyCommandNameToActor(name) {
        const actor = $gameActors.actor(saveActorId);
        if (actor && name) {
            actor.setName(name);
            //console.log(`Actor[${saveActorId}] Name changed to: ${name}`);
        }
    }

    // アクターコマンドウィンドウがセットアップされた時
    const _Window_ActorCommand_setup = Window_ActorCommand.prototype.setup;
    Window_ActorCommand.prototype.setup = function(actor) {
        _Window_ActorCommand_setup.apply(this, arguments);
        const name = getCommandDisplayName(this);
        if (name) applyCommandNameToActor(name);
    };

    // アクターコマンド選択時
    const _Window_ActorCommand_select = Window_ActorCommand.prototype.select;
    Window_ActorCommand.prototype.select = function(index) {
        _Window_ActorCommand_select.apply(this, arguments);
        const name = getCommandDisplayName(this);
        if (name) applyCommandNameToActor(name);
    };

    // パーティコマンド選択時
    const _Window_PartyCommand_select = Window_PartyCommand.prototype.select;
    Window_PartyCommand.prototype.select = function(index) {
        _Window_PartyCommand_select.apply(this, arguments);
        const name = getCommandDisplayName(this);
        if (name) applyCommandNameToActor(name);
    };
		
})();
