/*:
 * @target MZ
 * @plugindesc 「文章のスクロール表示」で使用される内部ビットマップの高さを変更します。
 * @author PLG
 *
 * @param MaxBitmapHeight
 * @text 最大ビットマップ高さ
 * @desc スクロールテキストで内部的に使用される1ブロックのビットマップの最大高さ。デフォルトは2048。
 * @type number
 * @min 256
 * @default 4096
 *
 * @help
 * ◆説明
 * UIの高さを1024+8= 1032以上にすると「文章のスクロール表示」が正常に動かない問題の修正。
 * 
 * ◆注意
 * ・値を大きくしすぎるとビデオメモリを多く消費する。
 * ・2048～8192 程度がおすすめ。
 * 
 */

(() => {
    // プラグインパラメータを取得
    const pluginName = document.currentScript.src.match(/([^\/]+)\.js$/)[1];
    const parameters = PluginManager.parameters(pluginName);
    const maxBitmapHeight = Number(parameters["MaxBitmapHeight"] || 4096);

    // Window_ScrollText の初期化を上書き
    const _Window_ScrollText_initialize = Window_ScrollText.prototype.initialize;
    Window_ScrollText.prototype.initialize = function(rect) {
        _Window_ScrollText_initialize.call(this, rect);
        this._maxBitmapHeight = maxBitmapHeight;
    };
})();
