/*=============================================================================
 PL_MessageWindowKeep.js _ v.1.02 2025/01/26
----------------------------------------------------------------------------

/*:
 * @plugindesc メッセージウィンドウの維持プラグイン
 * @target MZ
 * @plugindesc 条件分岐から抜けた場合メッセージウィンドウを閉じる処理をスルーする
 * @author PL
 *
 * @help PL_MessageWindowKeep.js
 *
 * 条件分岐から抜けた場合メッセージウィンドウを閉じる処理をスルーする。
 * メッセージ→条件分岐から抜ける→選択肢でメッセージが消えてしまう問題を回避するためのものです。
 *
 */

(() => {

	// ----------------------------------------------------------------
	// ----　Type.A
	// 以下、メッセージ表示 → 条件分岐終了 → 選択肢表示の際にメッセージウィンドウが消えてしまう問題を回避するもの。

	// ■仕様メモ
	// 条件分岐から抜けた場合「一度だけ」メッセージウィンドウを閉じる処理をスルーする。

	// ■問題点
	// ただし、現バージョンでは条件分岐でイベントが終わるとメッセージウィンドウが閉じなくなる。

	/*
	var MessageWindowKeepSwitch = false;

	// 条件分岐から抜けた場合の処理をフック
	Game_Interpreter.prototype.command412 = function() {
		// var message = "command412";
	  // console.log(message);
	    
		MessageWindowKeepSwitch = true;

	  return true;
	};

const _Window_Message_doesContinue = Window_Message.prototype.doesContinue;
Window_Message.prototype.doesContinue = function() {
		// 一度だけ閉じる処理をスルー
		var temp = MessageWindowKeepSwitch;
		MessageWindowKeepSwitch = false;
	const result = _Window_Message_doesContinue.apply(this, arguments);
	return result || temp;
};
*/

	// ----------------------------------------------------------------
	// ----　Type.B
	// 以下、メッセージ表示 → 条件分岐終了 → 選択肢表示の際にメッセージウィンドウが消えてしまう問題を回避するもの。
	// さらに、メッセージ表示 → 条件分岐終了 → 選択肢表示の間に一度エンターを押す必要があるのを回避するためのもの。
	// ただし、文章表示命令をごっそり上書きしているので本体バージョンアップや他のプラグインとの競合には注意。

	// ■仕様メモ
	// メッセージ表示時、先のコマンドを調べて条件分岐なら自前の処理で条件分岐終了まですっ飛ばす。
	// あとは、RPGツクール独自の次が選択肢の場合の処理でメッセージウィンドウを消さずにすむ。

	// ■問題点
	// 条件分岐が連続した場合に対応できない「それ以外のとき」にいれれば対応可能。

	// 条件分岐を強制的に飛ばす関数
	/*
	Game_Interpreter.prototype.plSkipBranch = function() {
		let depth = 0;
		while (this._index < this._list.length - 1) {
			this._index++;
			const command = this.currentCommand();

			if (command.code === 411) { // ElseIf
				depth++;
			} else if (command.code === 412) { // EndIf
				if (depth === 0) {
					// 条件分岐の終端に到達
					break;
				} else {
					depth--;
				}
			}
		}
	};
	
	// メッセージ表示処理を強制上書き
const _Game_Interpreter_command101 = Game_Interpreter.prototype.command101;
	Game_Interpreter.prototype.command101 = function(params) {
if ($gameMessage.isBusy()) {
	return false;
}
$gameMessage.setFaceImage(params[0], params[1]);
$gameMessage.setBackground(params[2]);
$gameMessage.setPositionType(params[3]);
$gameMessage.setSpeakerName(params[4]);
while (this.nextEventCode() === 401) {
	// Text data
	this._index++;
	$gameMessage.add(this.currentCommand().parameters[0]);
}
 
while (this.nextEventCode() === 401) {
	// Text data
	this._index++;
	$gameMessage.add(this.currentCommand().parameters[0]);
}
 
// 最大64回まで条件分岐から抜けた処理を事前に処理する(あくまで保険なので無限でも良い)
for(let i=0;i<64;i++) {
		let nextEventCode = this.nextEventCode();
		// console.log("PL_MessageWindowKeep:nextEventCode:"+nextEventCode);
	switch (nextEventCode) {
	case 0: // 何もしないコード
		this._index++;
		break;
	case 411: // 条件分岐のELSE
		this._index++;
		this.plSkipBranch();
		break;
	case 412: // 条件分岐のEND
		this._index++;
		break;
	default:
			i = Number.MAX_SAFE_INTEGER;
		break;
  }
}
 
switch (this.nextEventCode()) {
	case 102: // Show Choices
		this._index++;
		this.setupChoices(this.currentCommand().parameters);
		break;
	case 103: // Input Number
		this._index++;
		this.setupNumInput(this.currentCommand().parameters);
		break;
	case 104: // Select Item
		this._index++;
		this.setupItemChoice(this.currentCommand().parameters);
		break;
}
this.setWaitMode("message");
return true;
};
*/

	// ----------------------------------------------------------------
	// ----　Type.C

	// ■仕様メモ
	// 文字表示時にウィンドウを閉じない条件をオンに、条件分岐や空白でなければオフにする関数

	// メッセージウィンドウを閉じない
	var MessageWindowKeepSwitch = false;

	// イベントの最後かを判定する関数
	Game_Interpreter.prototype.isLastCommand = function () {
		return this._index >= this._list.length - 1;
	};

	// メッセージ表示処理
	const _Game_Interpreter_command101 = Game_Interpreter.prototype.command101;
	Game_Interpreter.prototype.command101 = function (params) {
		const nextCode = this.nextEventCode();

		//dm("nextCode:" + nextCode + " | MessageWindowKeepSwitch:" + MessageWindowKeepSwitch);

    let isCommonEvOrParallelEv = false;

    //console.log("this._eventId:", this._eventId);

    if (this._eventId == 0) {
        // コモンイベントの並列処理を確認
        //const commonEvent = $dataCommonEvents[this._commonEventId];
        //isCommonEvOrParallelEv = commonEvent && commonEvent.trigger === 2;
        
        // インタープリターインスタンスからコモンイベントのIDを取得することは大本を改造しないとできないので一旦無条件で処理をスルー。
        isCommonEvOrParallelEv = true;
    } else if (this._eventId > 0) {
        // 通常イベントの並列処理を確認
        const event = $gameMap.event(this._eventId);
        isCommonEvOrParallelEv = event && event.page() && event.page().trigger === 4;
    }
    
	  if (!isCommonEvOrParallelEv) {
			// 次のコマンドが特定のときは101が勝手に先の処理を行う為ウィンドウをキープしない
			// 102:選択肢
			// 103:数字入力
			// 104:アイテム選択
			if (!(nextCode == 102 || nextCode == 103 || nextCode == 104)) {
				MessageWindowKeepSwitch = true;
			}
    }
    
		return _Game_Interpreter_command101.apply(this, arguments);
	}

	// コマンドコード実行処理
	const _Game_Interpreter_executeCommand = Game_Interpreter.prototype.executeCommand;
	Game_Interpreter.prototype.executeCommand = function() {
	    const command = this.currentCommand();
	    if (command) {

	        let isCommonEvOrParallelEv = false;

	        //console.log("this._eventId:", this._eventId);

	        if (this._eventId == 0) {
	            // コモンイベントの並列処理を確認
	            //const commonEvent = $dataCommonEvents[this._commonEventId];
	            //isCommonEvOrParallelEv = commonEvent && commonEvent.trigger === 2;
	            
	            // インタープリターインスタンスからコモンイベントのIDを取得することは大本を改造しないとできないので一旦無条件で処理をスルー。
	            isCommonEvOrParallelEv = true;
	        } else if (this._eventId > 0) {
	            // 通常イベントの並列処理を確認
	            const event = $gameMap.event(this._eventId);
	            isCommonEvOrParallelEv = event && event.page() && event.page().trigger === 4;
	        }

	        // デバッグ用表示
	        //console.log("現在のイベントが並列処理か？:", isCommonEvOrParallelEv);

	        if (!isCommonEvOrParallelEv) {
	            //    console.log("並列処理ではない");

	            const code = command.code;

	            //dm("code:" + code + " | MessageWindowKeepSwitch:" + MessageWindowKeepSwitch);

	            // 101:文章表示
	            // 401:文章表示（継続）
	            // 102:選択肢
	            // 111:条件分岐
	            // 411:条件分岐のELSE
	            // 412:条件分岐のEND
	            if (this.isLastCommand()) {
	                MessageWindowKeepSwitch = false;
	                //console.log("MessageWindowKeepSwitch:false - イベントの最後である");
	            }
	            else if (!(code == 0 || code == 101 || code == 401 || code == 102 || code == 111 || code == 411 || code == 412)) {
	                MessageWindowKeepSwitch = false;
	                //console.log("MessageWindowKeepSwitch:false - 閉じる処理を行うコマンドである");
	            }

	        }
	    }

	    return _Game_Interpreter_executeCommand.apply(this, arguments);
	};

	const _Window_Message_doesContinue = Window_Message.prototype.doesContinue;
	Window_Message.prototype.doesContinue = function () {
		const result = _Window_Message_doesContinue.apply(this, arguments);
		return result || MessageWindowKeepSwitch;
	};


})();
