//=============================================================================
// PL_NTF2_BtlSys.js ver.1.02
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 【戦闘】NTF2独自システム。PL_Lib.jsとYEP_BattleEngineCore.jsを先に読み込んでいること前提。
 * @author R
 *
 * @param debug
 * @type boolean
 * @default false
 * @desc デバッグモード
 *
 * @param INT_BTL_ACTION_ENEMY_ID
 * @type number
 * @default 321
 * @desc 行動しているモンスターID
 *
 * @param DAMAGE_VIEW_X
 * @type number
 * @default 800
 * @desc ダメージ表示のX座標
 *
 * @param DAMAGE_VIEW_Y
 * @type number
 * @default 400
 * @desc ダメージ表示のY座標
 * 
 *  * @param OV_VIEW_X
 * @type number
 * @default 300
 * @desc 立ち絵のX座標
 *
 * @param OV_VIEW_Y
 * @type number
 * @default 0
 * @desc 立ち絵のY座標
 *
 * @param EV_VIEW_X
 * @type number
 * @default 300
 * @desc イベントCGのX座標
 *
 * @param EV_VIEW_Y
 * @type number
 * @default 0
 * @desc イベントCGのY座標
 *
 * @param EV_SECTION_X
 * @type number
 * @default 0
 * @desc 断面図のX座標
 *
 * @param EV_SECTION_Y
 * @type number
 * @default 730
 * @desc 断面図のY座標
 *
 * @param CharBote1ID
 * @type number
 * @default 31
 * @desc 変更可能なゲーム変数のID
 *
 * @param CharBote2ID
 * @type number
 * @default 51
 * @desc 変更可能なゲーム変数のID
 *
 * @param CharBote3ID
 * @type number
 * @default 71
 * @desc 変更可能なゲーム変数のID
 *
 * @param CharBote4ID
 * @type number
 * @default 91
 * @desc 変更可能なゲーム変数のID
 *
 * @help このプラグインは基本ハードコーディングです。
 */

// ■マニュアル

// サイドビューモードにすること（味方へのダメージ表示を使うため）

// PTは必ず一人の状態で戦闘すること

// ヒールなどの味方選択技は全体にするほうが良い

// モンスターには PL_unknown_rate:0-100 で 不明率指定可能defaultでは50％

// ----------------------------------------------------------------

// ステータス関連
(function () {
    'use strict';

    var parameters = PluginManager.parameters('PL_NTF2_BtlSys');
    var debug = parameters['debug'];

    var INT_BTL_ACTION_ENEMY_ID = parameters['INT_BTL_ACTION_ENEMY_ID']; // 最後に行動している敵のID

    window.DAMAGE_VIEW_X = Number(parameters['DAMAGE_VIEW_X'] || 800); // ダメージ表示X座標
    window.DAMAGE_VIEW_Y = Number(parameters['DAMAGE_VIEW_Y'] || 400); // ダメージ表示Y座標

    var preloadPictures = ["pl_system/btl_number", "pl_system/btl_gauge_hp", "pl_system/btl_gauge_mp", "pl_system/btl_gauge_tp"];

    var OV_VIEW_X = parameters['OV_VIEW_X'];
    var OV_VIEW_Y = parameters['OV_VIEW_Y'];

    var EV_VIEW_X = parameters['EV_VIEW_X'];
    var EV_VIEW_Y = parameters['EV_VIEW_Y'];

    var EV_SECTION_X = parameters['EV_SECTION_X'];
    var EV_SECTION_Y = parameters['EV_SECTION_Y'];

    // 瀕死時のアニメID
    var DYING_ANIME_ID = 151;
    var DYING_ANIME_WAIT = 0;

    // 通常OV
    var lay_ov;

    // 通常EV
    var lay_ev

    // spineOV
    var lay_spine_ov;
    var spine_ov;
    var sprite_spine_ov;

    // spine断面図
    var lay_spine_section;
    var spine_section;
    var sprite_spine_section;

    var lay_grd;

    var lay_hp_header;
    var lay_hp_num;
    var lay_hp_gauge_bg;
    var lay_hp_gauge;
    var lay_mp_header;
    var lay_mp_num;
    var lay_mp_gauge_bg;
    var lay_mp_gauge;
    var lay_tp_header;
    var lay_tp_num;
    var lay_tp_gauge_bg;
    var lay_tp_gauge;
    var lay_icons;

    var lay_bg;

    // ダメージのイラストを表示する
    var damageImage = false;
    var damageImageTimer = 0;
    var dying = false;


    // ----------------
    // 立ち絵のファイル名を取得する
    // 最終的に 【 Battle{先頭のキャラID}_A_Normal 】などの文字列を作りたい。
    function getOVFileName() {

        //dm('getOVFileName');

        // 通常時の立ち絵のファイル名
        var FILE_DEFAULT_NAME = 'pl_system/Battle_Actor{CharaID}_{Bote}_{Dying}_{Damage}';

        // 強制的に立ち絵を変更する『ステートID52』状態異常をうけている場合
        var FILE_WEAK_NAME = 'pl_system/Battle_Actor{CharaID}_{Bote}_2Held';

        // --------------------

        // 最終的なファイルのフォーマットの設定（ひとまずdefault_name）
        var file = FILE_DEFAULT_NAME;

        // --------------------
        // 各種情報

        // パーティ先頭のキャラID
        if ($gameParty.members().length == 0) {
            //パーティが居ない場合は立ち絵の処理をスルー
            return;
        }
        var actorId = $gameParty.members()[0].actorId();

        // 先頭のアクターのポインタ
        var actor = $gameActors.actor(actorId);

        // 先頭キャラのID（2桁）
        var formattedActorId = String(actorId).padStart(2, '0'); // PT先頭のキャラID 4桁0埋め

        // 試作品：アクターが立ち絵強制変更ステート52番の状態異常にかかっているかどうか
        var isState52 = actor.isStateAffected(52);

        // ステート52の状態異常をうけている時はステート52のファイルフォーマットで強制上書き
        if (isState52) {
            file = FILE_WEAK_NAME;
        }

        // --------------------------------------------------------------------------------

        //dm('getOVFileName:formattedActorId:' + formattedActorId);

        // 先頭キャラのID
        file = file.replace('{CharaID}', formattedActorId);

        // --------------------
        // 先頭キャラがボテ腹か
        var charBoteId;
        var CharBote1ID = Number(parameters['CharBote1ID'] );
        var CharBote2ID = Number(parameters['CharBote2ID'] );
        var CharBote3ID = Number(parameters['CharBote3ID'] );
        var CharBote4ID = Number(parameters['CharBote4ID'] );
        switch (actorId) {
            case 1: // キャラクター1の場合
                charBoteId = CharBote1ID;
                break;
            case 2: // キャラクター2の場合
                charBoteId = CharBote2ID;
                break;
            case 3: // キャラクター3の場合
                charBoteId = CharBote3ID;
                break;
            case 4: // キャラクター4の場合
                charBoteId = CharBote4ID;
                break;
            default: // その他のキャラクター
                charBoteId = CharBote1ID; // デフォルト値
                break;
        }
        if ($gameVariables.value(charBoteId) >= 2)
            file = file.replace('{Bote}', "1Bote");
        else
            file = file.replace('{Bote}', "0");

        // --------------------
        // 先頭キャラが瀕死あるいは死んでいるか
        if (actor.isDead() || actor.isDying())
            file = file.replace('{Dying}', "1Dying");
        else
            file = file.replace('{Dying}', "0");

        // --------------------

        // 先頭キャラがダメージモーションをしているか
        if (damageImage)
            file = file.replace('{Damage}', "1Damage");
        else
            file = file.replace('{Damage}', "0");


        // --------------------

        //dm('getOVFileName_file:' + file);

        return file;
    };

    // ----------------

    var _Scene_Battle_start = Scene_Battle.prototype.start;
    Scene_Battle.prototype.start = function () {
        //dm("■start:");
        _Scene_Battle_start.apply(this);

        // ピクチャ1に画像を表示
        $gameScreen.showPicture(19, "01CG/黒", 0, 0, 0, 100, 100, 255, 0);
        $gameScreen.showPicture(10, "01CG/Dammy", 0, 0, 0, 100, 100, 255, 0);

        //実行を1秒遅らせ登場エフェクトと被らないようにする
        setTimeout(() => {
            init();
            refresh();
        }, 1000);

    };

    var _Window_BattleStatus_refresh = Window_BattleStatus.prototype.refresh;
    Window_BattleStatus.prototype.refresh = function () {
        _Window_BattleStatus_refresh.apply(this);
        refresh();
    };

    var _Window_BattleStatus_update = Window_BattleStatus.prototype.update;
    Window_BattleStatus.prototype.update = function () {
        _Window_BattleStatus_update.apply(this);
        refresh();
        update2();
    };

    // ステータスウィンドウは自前でやるので非表示
    /*
    var Scene_Battle_createStatusWindow = Scene_Battle.prototype.createStatusWindow;
    Scene_Battle.prototype.createStatusWindow = function () {
        Scene_Battle_createStatusWindow.call(this);
        this._statusWindow.visible = false;
    };
    */
    // ステータスウィンドウを画面外に飛ばす（他のプラグインとの競合により非表示より楽）
    const _Window_BattleStatus_initialize = Window_BattleStatus.prototype.initialize;
    Window_BattleStatus.prototype.initialize = function (rect) {
        dm("■initialize:");
        _Window_BattleStatus_initialize.call(this, rect);
        this.hide();
        this.opacity = 0;
        this.visible = false;
        this.y = -9999;
    };


    // 指定対象が指定目標に対してのアクションを起動する。
    var BattleManager_invokeAction = BattleManager.invokeAction;
    BattleManager.invokeAction = function (subject, target) {
        //dm("invokeAction:"+INT_BTL_ACTION_ENEMY_ID+":"+subject.enemyId());
        BattleManager_invokeAction.call(this, subject, target);

        // 行動者の情報
        var isEnemy = subject.isEnemy();

        // アクションしている人のID
        if (isEnemy)
            $gameVariables.setValue(INT_BTL_ACTION_ENEMY_ID, subject.enemyId());
    };

    // ----------------

    Game_Screen.prototype.hideTachie = function () {
        lay_ov.visible = false;
    };
    Game_Screen.prototype.showTachie = function () {
        lay_ov.visible = true;
    };

    Game_Screen.prototype.viewEv = function (file, fx, fy) {
        var x = EV_VIEW_X;
        var y = EV_VIEW_Y;
        //dm("viewEv");
        if (typeof fx !== 'undefined') {
            x = fx;
        }
        if (typeof fy !== 'undefined') {
            y = fy
        }
        lay_ev.setPos(x, y);
        lay_ev.bitmap = ImageManager.loadPicture(file);
        lay_ev.visible = true;
        lay_ov.visible = false;
    };

    Game_Screen.prototype.hideEv = function () {
        //dm("hideEv");
        lay_ev.visible = false;
        lay_ov.visible = true;
    };

    Game_Screen.prototype.viewSectionSpine = function (skeleton, animation) {
        //dm("viewSectionSpine");
        spine_section.setSkeleton(skeleton).setAnimation(0, animation);
        lay_spine_section.visible = true;
    };

    Game_Screen.prototype.hideSectionSpine = function () {
        //dm("hideSectionSpine");
        lay_spine_section.visible = false;
    };


    var init = function () {

        for (var i = 0; i < preloadPictures.length; i++) {
            ImageManager.reservePicture(preloadPictures[i]);
        }

        var parent = SceneManager._scene._spriteset._battleField;

        // スペースができるので強制的に画面サイズいっぱいに変更する
        SceneManager._scene._spriteset._battleField.x = 0;
        SceneManager._scene._spriteset._battleField.y = 0;
        SceneManager._scene._spriteset._battleField.width = Graphics.width;
        SceneManager._scene._spriteset._battleField.height = Graphics.height;

        // パーティ先頭のキャラID
        var actorId = $gameParty.members()[0].actorId();

        // 先頭のアクターのポインタ
        var actor = $gameActors.actor(actorId);

        lay_bg = new PL_Layer(parent);
        lay_bg.bitmap = ImageManager.loadPicture("pl_system/btl_frame");
        lay_bg.visible = true;

        // 呼吸あり立ち絵
        lay_ov = new PL_EffectLayer(parent, OV_VIEW_X, OV_VIEW_Y);
        lay_ov.setEffectBreath(true);
        lay_ov.visible = true;

        // ev絵
        lay_ev = new PL_EffectLayer(parent, EV_VIEW_X, EV_VIEW_Y);
        lay_ev.visible = false;

        // Spine断面図
        lay_spine_section = new PL_Layer(parent);
        spine_section = new Game_Spine();
        sprite_spine_section = new Sprite_Spine(spine_section);
        lay_spine_section.addChild(sprite_spine_section);
        //spine_section.setSkeleton('spineboy-pro/spineboy-pro').setAnimation(0, 'walk');
        lay_spine_section.setPos(EV_SECTION_X, EV_SECTION_Y);
        lay_spine_section.visible = false;

        // 背景黒グラデ
        var bitmap = new Bitmap(Graphics.width, 200);
        lay_grd = new PL_Layer(SceneManager._scene._spriteset, 0, Graphics.height - bitmap.height);
        //dm("■Graphics.height:" + Graphics.height);
        //dm("■Graphics.width:" + Graphics.width);
        //dm("■bitmap.height:" + bitmap.height);
        //dm("■parent.height:" + parent.height);
        //dm("■parent.width:" + parent.width);
        var c1 = 'rgba(0, 0, 0, 0.0)';
        var c2 = 'rgba(0, 0, 0, 0.5)';
        bitmap.gradientFillRect(0, 0, bitmap.width, bitmap.height, c1, c2, true);
        lay_grd.bitmap = bitmap;
        lay_grd.visible = true;


        // ゲージ類
        var OFFSET_HAED_X = 0;
        var OFFSET_HAED_Y = 10;
        var OFFSET_NUMBER_X = 90;
        var OFFSET_NUMBER_Y = 1;
        var OFFSET_GAUGE_X = 0;
        var OFFSET_GAUGE_Y = 20;

        var x = 620 - 300;
        var y = lay_grd.y + 80;
        
        
        lay_hp_header = new PL_Layer(SceneManager._scene._spriteset, x + OFFSET_HAED_X, y + OFFSET_HAED_Y);
        lay_hp_header.bitmap = ImageManager.loadPicture("pl_system/btl_gaugeHead_hp");
        lay_hp_header.visible = true;

        lay_hp_num = new PL_NumericLayer(SceneManager._scene._spriteset, "pl_system/btl_number", 4, -3);
        lay_hp_num.setPos(x + OFFSET_NUMBER_X, y + OFFSET_NUMBER_Y);
        lay_hp_num.setNum(actor.hp);
        lay_hp_num.visible = true;

        lay_hp_gauge_bg = new PL_Layer(SceneManager._scene._spriteset, x + OFFSET_GAUGE_X, y + OFFSET_GAUGE_Y);
        lay_hp_gauge_bg.bitmap = ImageManager.loadPicture("pl_system/btl_gauge_commonBlank");
        lay_hp_gauge_bg.visible = true;

        lay_hp_gauge = new PL_GaugeLayer(SceneManager._scene._spriteset, "pl_system/btl_gauge_hp", 154, 2);
        lay_hp_gauge.setPos(x + OFFSET_GAUGE_X + 2, y + OFFSET_GAUGE_Y + 2);
        lay_hp_gauge.setRate(actor.hpRate());
        lay_hp_gauge.visible = true;

        x -= 10;
        y += 35;

        lay_mp_header = new PL_Layer(SceneManager._scene._spriteset, x + OFFSET_HAED_X, y + OFFSET_HAED_Y);
        lay_mp_header.bitmap = ImageManager.loadPicture("pl_system/btl_gaugeHead_mp");
        lay_mp_header.visible = true;

        lay_mp_num = new PL_NumericLayer(SceneManager._scene._spriteset, "pl_system/btl_number", 4, -3);
        lay_mp_num.setPos(x + OFFSET_NUMBER_X, y + OFFSET_NUMBER_Y);
        lay_mp_num.setNum(actor.mp);
        lay_mp_num.visible = true;

        lay_mp_gauge_bg = new PL_Layer(SceneManager._scene._spriteset, x + OFFSET_GAUGE_X, y + OFFSET_GAUGE_Y);
        lay_mp_gauge_bg.bitmap = ImageManager.loadPicture("pl_system/btl_gauge_commonBlank");
        lay_mp_gauge_bg.visible = true;

        lay_mp_gauge = new PL_GaugeLayer(SceneManager._scene._spriteset, "pl_system/btl_gauge_mp", 154, 2);
        lay_mp_gauge.setPos(x + OFFSET_GAUGE_X + 2, y + OFFSET_GAUGE_Y + 2);
        lay_mp_gauge.setRate(actor.mpRate());
        lay_mp_gauge.visible = true;

        x -= 10;
        y += 35;

        lay_tp_header = new PL_Layer(SceneManager._scene._spriteset, x + OFFSET_HAED_X, y + OFFSET_HAED_Y);
        lay_tp_header.bitmap = ImageManager.loadPicture("pl_system/btl_gaugeHead_tp");
        lay_tp_header.visible = true;

        lay_tp_num = new PL_NumericLayer(SceneManager._scene._spriteset, "pl_system/btl_number", 4, -3);
        lay_tp_num.setPos(x + OFFSET_NUMBER_X, y + OFFSET_NUMBER_Y);
        lay_tp_num.setNum(actor.tp);
        lay_tp_num.visible = true;

        lay_tp_gauge_bg = new PL_Layer(SceneManager._scene._spriteset, x + OFFSET_GAUGE_X, y + OFFSET_GAUGE_Y);
        lay_tp_gauge_bg.bitmap = ImageManager.loadPicture("pl_system/btl_gauge_commonBlank");
        lay_tp_gauge_bg.visible = true;

        lay_tp_gauge = new PL_GaugeLayer(SceneManager._scene._spriteset, "pl_system/btl_gauge_tp", 154, 2);
        lay_tp_gauge.setPos(x + OFFSET_GAUGE_X + 2, y + OFFSET_GAUGE_Y + 2);
        lay_tp_gauge.setRate(0);
        lay_tp_gauge.visible = true;
        

				// 状態異常アイコン
        const bmp_IconSet = ImageManager.loadSystem('IconSet'); // 事前ロードとデバッグを兼ねて
        lay_icons = new PL_Layer(SceneManager._scene._spriteset, 500-20, lay_grd.y + 80+70);
    		lay_icons.bitmap = new Bitmap(128, Window_Base._iconHeight); // 空のキャンバス
        //lay_icons.bitmap.blt(bmp_IconSet, 32, 0, 32, 32, 0, 0);
        lay_icons.visible = true;
    }

    //-----------------------------------------------------------------

    var refresh = function () {

        if (typeof lay_ov === "undefined")
            return;

        // パーティ先頭のキャラID
        if ($gameParty.members().length == 0) {
            //パーティが居ない場合はスルー
            return;
        }
        var actorId = $gameParty.members()[0].actorId();

        // 先頭のアクターのポインタ
        var actor = $gameActors.actor(actorId);
        //dm(actorId);
        //dm(actor);
        // 立ち絵
        var file = getOVFileName();

        // 20250326立ち絵の表示を一旦別方法に
        /*
        if (lay_ov.bitmap != ImageManager.loadPicture(file))
        {
            dm("BTLSys.js : lay_ov.bitmap != ImageManager.loadPicture(file)");
            lay_ov.bitmap = ImageManager.loadPicture(file);
        }
        */
        // ピクチャ10番にfileを表示
        const picture = $gameScreen.picture(10);
        if (picture) {
            $gameScreen.showPicture(10, file, 0, 0, 0, 50, 50, 255, 0);
        }
        
        // 状態異常アイコン
        lay_icons.bitmap.clear();
        var bitmap = ImageManager.loadSystem('IconSet');
        var icons = actor.allIcons();
        for (var i = 0; i < icons.length; i++) {
            var pw = Window_Base._iconWidth;
            var ph = Window_Base._iconHeight;
            var sx = icons[i] % 16 * pw;
            var sy = Math.floor(icons[i] / 16) * ph;
            lay_icons.bitmap.blt(bitmap, sx, sy, pw, ph, Window_Base._iconWidth * (i), 0);
        		//lay_icons.bitmap.blt(bitmap, 32, 0, 32, 32, 0, 0);
        }
        
		    // アイコン描画
		    /*
		    const currentStates = actor.states().map(s => s.id).join(",");
		    if (lay_icons._lastStates !== currentStates) {
		        lay_icons.bitmap.clear();
		        drawActorIcons(actor, 10, 0, 128);
		        lay_icons._lastStates = currentStates;
		        console.log("Icons redrawn for states:", currentStates);
		    }
		    */

		    // テスト用ダミーアイコン描画
		    /*
		    const bitmap = ImageManager.loadSystem('IconSet');
		    if (bitmap.isReady()) {
		        lay_icons.bitmap.blt(bitmap, 32, 0, 32, 32, 0, 0);
		        console.log("Dummy icon drawn at x=10, y=0");
		    } else {
		        console.log("IconSet is not ready yet!");
		    }
		    */
		    

        lay_hp_num.setToNum(actor.hp);
        lay_hp_gauge.setToRate(actor.hpRate());
        lay_mp_num.setToNum(actor.mp);
        lay_mp_gauge.setToRate(actor.mpRate());
        lay_tp_num.setToNum(actor.tp);
        lay_tp_gauge.setToRate(actor.tpRate());

        if (dying != actor.isDying()) {
            if (actor.isDying()) {
                // 破れアニメーションを一体削除
                //$gameActors.actor(1).startAnimation(DYING_ANIME_ID, false, 0);
                //if(BattleManager._logWindow)
                //  BattleManager._logWindow._waitCount = DYING_ANIME_WAIT;
            }
            dying = actor.isDying();
        }

    }
    
		// drawActorIconsの実装
		function drawActorIcons(actor, x, y, width) {
		    const iconWidth = Window_Base._iconWidth; // 通常32ピクセル
		    const iconHeight = Window_Base._iconHeight;
		    const bitmap = ImageManager.loadSystem('IconSet');
		    
		    // ビットマップのロード状態をログ出力
		    if (!bitmap.isReady()) {
		        console.log("IconSet is not ready yet!");
		        return;
		    }

		    const states = actor.states();
		    let drawnWidth = 0;

		    console.log("States:", states); // ステートリストを確認
		    for (const state of states) {
		        if (state.iconIndex > 0 && drawnWidth < width) {
		            const sx = (state.iconIndex % 16) * iconWidth;
		            const sy = Math.floor(state.iconIndex / 16) * iconHeight;
		            console.log(`Drawing icon: index=${state.iconIndex}, x=${x + drawnWidth}, y=${y}`);
		            lay_icons.bitmap.blt(bitmap, sx, sy, iconWidth, iconHeight, x + drawnWidth, y);
		            drawnWidth += iconWidth;
		        }
		    }
		}

    var update2 = function () {
        if (damageImage) {
            if (damageImageTimer <= 0) {
                damageImage = false;
                refresh();
            }
            else {
                damageImageTimer--;
            }
        }
    }

    // サイドビューモードだと味方のダメージ時に寂しいので、シェイクさせておく。+キャラクターダメージ表示。
    var _Game_Actor_performDamage = Game_Actor.prototype.performDamage;
    Game_Actor.prototype.performDamage = function () {
        //画面を揺らす
        $gameScreen.startShake(5, 20, 10);
        _Game_Actor_performDamage.call(this);

        // 立ち絵を一時的に変更
        damageImage = true;
        damageImageTimer = 120;
        refresh();
    };

})();
// ----------------------------------------------------------------

// 既存戦闘アクターSVの処理とダメージ表示位置
(function () {
    'use strict';

    //var DAMAGE_VIEW_X = 800;
    //var DAMAGE_VIEW_Y = 400;


    // 戦闘武器演出。
    Sprite_Weapon.prototype.loadBitmap = function () {
        this.bitmap = ImageManager.loadSystem('');
    };

    // アクターSVの位置調整、ダメージ位置調整用
    Sprite_Actor.prototype.setActorHome = function (index) {
        this.setHome(DAMAGE_VIEW_X, DAMAGE_VIEW_Y);
    };

})();
// ----------------------------------------------------------------

// コマンドとウィンドウ位置処理関連

(function () {

    //コマンドを左に表示
    const _Scene_Battle_isRightInputMode = Scene_Battle.prototype.isRightInputMode;
    Scene_Battle.prototype.isRightInputMode = function () {
        let result = _Scene_Battle_isRightInputMode.apply(this);
        result = false;
        return result;
    };

    // 戦うのコマンドを削除する
    const _Window_ActorCommand_makeCommandList = Window_ActorCommand.prototype.makeCommandList;
    Window_ActorCommand.prototype.makeCommandList = function () {
        _Window_ActorCommand_makeCommandList.apply(this, arguments);
        if (this._actor) {
            this._list = this._list.filter(command => command.symbol !== 'attack');
        }
    };

    // 防御時自分自身を自動的に選択する
    const _Scene_Battle_commandGuard = Scene_Battle.prototype.commandGuard;
    Scene_Battle.prototype.commandGuard = function () {
        const action = BattleManager.inputtingAction();
        action.setGuard();
        action.setTarget(BattleManager.actor().index());
        this.selectNextCommand();
    };

    // 味方を選ぶ時自動的に自身を対象にする
    const _Scene_Battle_selectActorSelection = Scene_Battle.prototype.selectActorSelection;
    Scene_Battle.prototype.selectActorSelection = function () {
        this.onActorOk();
    };
    const _Scene_Battle_onActorOk = Scene_Battle.prototype.onActorOk;
    Scene_Battle.prototype.onActorOk = function () {
        let action = BattleManager.inputtingAction();
        action.setTarget(0);
        this.selectNextCommand();

        //_Scene_Battle_onActorOk.call(this);
    };

})();

// ----------------------------------------------------------------

const _Scene_Battle_createAllWindows = Scene_Battle.prototype.createAllWindows;
Scene_Battle.prototype.createAllWindows = function() {
  _Scene_Battle_createAllWindows.call(this);
  
  // コマンドウィンドウの位置を変更。　単純に消すだけならWebデザイン技術と同じく画面外に飛ばす手もある。
  //this._actorCommandWindow.x = -9999; // X座標
  this._actorCommandWindow.y = -9999; // Y座標
  
  // コマンドウィンドウの透明度を変更する
  this._actorCommandWindow.opacity = 0; 
  
  // コマンドウィンドウの背景と選択肢や文字を含む透明度を設定
  this._actorCommandWindow.backOpacity = 64; 
  this._actorCommandWindow.contentsOpacity = 64;
};

// ----------------------------------------------------------------

// コマンドキャンセルの無効化

(function() {
    // Window_ActorCommandのキャンセル処理を上書き
    const _Window_ActorCommand_processCancel = Window_ActorCommand.prototype.processCancel;
    Window_ActorCommand.prototype.processCancel = function() {
        // キャンセルを無効化（何もしない）
        // デフォルトの処理を呼び出したくないのでコメントアウト
        // _Window_ActorCommand_processCancel.call(this);
    };

    // Window_BattleActorのキャンセル処理を上書き
    const _Window_BattleActor_processCancel = Window_BattleActor.prototype.processCancel;
    Window_BattleActor.prototype.processCancel = function() {
        // キャンセルを無効化（何もしない）
        // _Window_BattleActor_processCancel.call(this);
    };
})();