﻿//=============================================================================
// IRPP_MV_LetterEmpty.js
//=============================================================================

/*:
 * @plugindesc (※下部)敵キャラの判別ワードを無効にします。
 * @author イロスマRPG制作委員会
 *
 * @help 敵キャラのメモに<LetterEmpty>と書き込む事で
 * そのエネミーの名前の後ろにはアルファベットがつかなくなります。
 * 変身を繰り返すような敵を作成する場合に便利です。
 */

var Imported = Imported || {};
Imported.IRPP_MV_LetterEmpty = true;
(function() {
var reLetterEmpty = /<LetterEmpty>/i;

var _Game_Enemy_setLetter = Game_Enemy.prototype.setLetter;
Game_Enemy.prototype.setLetter = function(letter) {
    if(reLetterEmpty.exec(this.enemy().note) == null){
        _Game_Enemy_setLetter.call(this, letter);
    }
};
})();