/*:
 * @target MZ
 * @plugindesc オプションでの音量設定が実際の音量の20%を基準とするプラグイン
 * @help 
 * このプラグインは、オプションで設定した音量が実際の音量の20%になるようにします。
 * 例えば、オプションで音量を100%に設定すると実際の音量は20%になります。
 * オプションで音量を50%に設定すると実際の音量は10%になります。
 */

(() => {
    const VOLUME_SCALE = 0.2; // 音量のスケールを20%に設定

    // 音量のスケールを適用するヘルパー関数
    const applyVolumeScale = (volume) => {
        return volume * VOLUME_SCALE;
    };

    // AudioManagerの初期設定をオーバーライドして音量をスケール
    const _AudioManager_setup = AudioManager.setup;
    AudioManager.setup = function() {
        _AudioManager_setup.call(this);
        this._bgmVolume = applyVolumeScale(ConfigManager.bgmVolume || 100);
        this._bgsVolume = applyVolumeScale(ConfigManager.bgsVolume || 100);
        this._meVolume = applyVolumeScale(ConfigManager.meVolume || 100);
        this._seVolume = applyVolumeScale(ConfigManager.seVolume || 100);
    };

    // BGM音量を更新する
    const _AudioManager_updateBgmParameters = AudioManager.updateBgmParameters;
    AudioManager.updateBgmParameters = function(bgm) {
        if (this._bgmBuffer) {
            _AudioManager_updateBgmParameters.call(this, bgm);
            this._bgmBuffer.volume *= VOLUME_SCALE;
        }
    };

    // BGS音量を更新する
    const _AudioManager_updateBgsParameters = AudioManager.updateBgsParameters;
    AudioManager.updateBgsParameters = function(bgs) {
        if (this._bgsBuffer) {
            _AudioManager_updateBgsParameters.call(this, bgs);
            this._bgsBuffer.volume *= VOLUME_SCALE;
        }
    };

    // ME音量を更新する
    const _AudioManager_updateMeParameters = AudioManager.updateMeParameters;
    AudioManager.updateMeParameters = function(me) {
        if (this._meBuffer) {
            _AudioManager_updateMeParameters.call(this, me);
            this._meBuffer.volume *= VOLUME_SCALE;
        }
    };

    // SE音量を更新する
    const _AudioManager_updateSeParameters = AudioManager.updateSeParameters;
    AudioManager.updateSeParameters = function(buffer, se) {
        if (buffer) {
            _AudioManager_updateSeParameters.call(this, buffer, se);
            buffer.volume *= VOLUME_SCALE;
        }
    };
})();