//=============================================================================
// 第1版 - 初版
// 第2版 - 麻雀牌の画像の設置場所をsystemに変更
//         本プラグインを使用していないプロジェクトで開始したセーブデータに対応
//         BGM、効果音の設定の変更コマンドを個別で変更できるように変更
// 第3版 - 対局中ボイスに対応
// 第5版 - CPUの刷新に伴いCPU設定関連の項目を更新
// 第6版 - 標準ゲームルールの設定を項目ごとに個別に変更できるように変更
//         雀士登録内に麻雀イベントプラグイン用の項目を追加
// 第8版 - 副露特徴の「常にしない」の値を修訂
// 第9版 - 戻るときのシーンを指定する機能追加
//         終了時に実行する関数を追加する機能追加
//         待ち牌ウィンドウ、及びドラ牌強調表示の設定を追加
// 第10版 - 二人麻雀に対応
//          詳細ゲームルールに積み符の点数を上家取りにするかを設定する項目を追加
// 第11版 - インスタンス化されていないアクターは
//          $gameActors内で新たにオブジェクトを作成しないように変更
//          二人麻雀に チーが可能か設定する項目を追加
//          漢数字表示関数の不具合を修訂
//          
// 
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 麻雀 (メイン)
 * @author 
 * @base AP1S_MajiangObjects
 * @base AP1S_MajiangManagers
 * @base AP1S_MajiangScenes
 * @base AP1S_MajiangWindows
 * @base AP1S_MajiangSprites
 * @base AP1S_MajiangCPU
 * 
 * @help
 * 
 * 麻雀
 * 
 * 詳細な使用方法は 同梱の説明書をご覧ください
 * 
 * 
 * @command startMajiang
 * @text 麻雀対局を開始
 * @desc 麻雀の対局を開始します
 * 
 * @arg zijia
 * @text 自家(プレイヤー)
 * @desc 必ず雀士登録をしたアクターを指定してください 
 * @type struct<nominateBattler>
 * @default {}
 * 
 * @arg shimojia
 * @text 下家
 * @desc 必ず雀士登録をしたアクターを指定してください 
 * @type struct<nominateBattler>
 * @default {}
 * 
 * @arg duimian
 * @text 対面
 * @desc 必ず雀士登録をしたアクターを指定してください 
 * @type struct<nominateBattler>
 * @default {}
 * 
 * @arg kamijia
 * @text 上家
 * @desc 必ず雀士登録をしたアクターを指定してください 
 * @type struct<nominateBattler>
 * @default {}
 * 
 * 
 * @arg randomPosition
 * @text 席順をランダムにする
 * @desc 自家以外の雀士の座る位置をランダムに変更します
 * @type boolean
 * @default false
 * 
 * @arg dealerPosition
 * @text 起家
 * @desc 起家を指定します. 三麻の場合は ここでの設定にかかわらず 空席の下家側が起家になります
 * @type select
 * @option ランダム @value 4
 * @option 自家 @value 0
 * @option 下家 @value 1
 * @option 対面 @value 2
 * @option 上家 @value 3
 * @default 4
 * 
 * @arg match
 * @text 対局形式
 * @desc 対局の長さを指定します
 * @type select
 * @option 標準ゲームルールの設定を参照 @value -1
 * @option 東風戦 @value 0
 * @option 半荘戦 @value 1
 * @option 一荘戦 @value 2
 * @option 一局戦 @value 3
 * @default -1
 * 
 * 
 * @arg abstention
 * @text 中断可能
 * @desc ONの場合 対局中 キャンセルボタンで対局を中断できます. (中断された場合 各種対局リザルトは変数に記録されません)
 * @type boolean
 * @default true
 * 
 * 
 * 
 * @command options
 * @text 麻雀オプションメニューを開く
 * @desc 麻雀の標準ゲームルールを変更する画面を開きます
 * 
 * 
 * 
 * 
 * 
 * 
 * @command setYakuData
 * @text 役の設定を変更
 * @desc 
 * 
 * @arg name
 * @text 変更する役
 * @desc 
 * @type select
 * @option 立直 @value lizhi
 * @option ダブル立直 @value doubleLizhi
 * @option 一発 @value yifa
 * @option 門前清自摸和 @value zimo
 * @option 断么九 @value duanyaojiu
 * @option 平和 @value pinghe
 * @option 一盃口 @value yibeikou
 * @option 二盃口 @value liangbeikou
 * @option 嶺上開花 @value lingshangKaihua
 * @option 海底撈月 @value haidiLaoyue
 * @option 河底撈魚 @value hediLaoyu
 * @option 場風牌 @value quanfeng
 * @option 自風牌 @value menfeng
 * @option 連風牌 @value lianfeng
 * @option 白 @value baiban
 * @option 發 @value lufa
 * @option 中 @value hongzhong
 * @option 北 @value bei
 * @option 槍槓 @value qianggang
 * @option 七対子 @value qiduizi
 * @option 対々和 @value duiduihe
 * @option 一気通貫 @value yiqiTongguan
 * @option 三色同順 @value sanseTongshun
 * @option 三色同刻 @value sanseTongke
 * @option 混全帯么九 @value hunquandai
 * @option 純全帯么九 @value chunquandai
 * @option 混老頭 @value hunlaotou
 * @option 清老頭 @value qinglaotou
 * @option 混一色 @value hunyise
 * @option 清一色 @value qingyise
 * @option 三暗刻 @value sananke
 * @option 四暗刻 @value sianke
 * @option 四暗刻単騎 @value siankeDanqi
 * @option 三槓子 @value sangangzi
 * @option 四槓子 @value sigangzi
 * @option 小三元 @value xiaosanyuan
 * @option 大三元 @value dasanyuan
 * @option 国士無双 @value guoshiwushuang
 * @option 純正国士無双 @value chunzhengGuoshi
 * @option 小四喜和 @value xiaosixi
 * @option 大四喜和 @value dasixi
 * @option 字一色 @value ziyise
 * @option 緑一色 @value luyise
 * @option 大車輪 @value dachelun
 * @option 九蓮宝燈 @value jiulianBaodeng
 * @option 純正九蓮宝燈 @value chunzhengJiulian
 * @option 天和 @value tianhe
 * @option 地和 @value dihe
 * @option 人和 @value renhe
 * @option 八連荘 @value balianzhuang
 * @option 三連刻 @value sanlianke
 * @option 四連刻 @value silianke
 * @option 一色三順 @value yiseSanshun
 * @option 一色四順 @value yiseSishun
 * @option 三風刻 @value sanfengke
 * @option 客風三刻 @value kefengSanke
 * @option 五門斉 @value wumenqi
 * @option 清海湖 @value qinghaihu
 * @option 十二落抬 @value shierLuotai
 * @option 紅孔雀 @value hongkongque
 * @option 大七星 @value daqixing
 * @option 黒一色 @value heiyise
 * @default lizhi
 * 
 * @arg data
 * @text 変更後の設定
 * @desc 
 * @type struct<yaku>
 * @default {"text":"","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 *
 * 
 * @command clearYakuData
 * @text 役の設定を標準に戻す
 * @desc ゲーム中変更されたデータを プラグインパラメータで設定した値に戻します
 * 
 * 
 * 
 * @command setGamerule
 * @text 標準ゲームルールを変更
 * 
 * @arg subject
 * @text 変更対象
 * @desc 変更対象の項目を指定します. 項目前にある[英字]の記号に対応する項目に変更後の値を設定してください
 * @type select
 * @option [M]対局形式 @value match_M
 * @option [A]ドラの採用 @value dora_A
 * @option [A]赤ドラの採用 @value akadora_A
 * @option [A]喰いタンの採用 @value kuiduan_A
 * @option [A]二翻縛りの採用 @value liangfan_A
 * @option [A]飛び終了の採用 @value tobi_A
 * @option [A]喰い替え禁止の採用 @value kuigae_A
 * @option [A]流し満貫の採用 @value nagashiMangan_A
 * @option [A]三家和流局の採用 @value sanjiahe_A
 * @option [A]四家立直流局の採用 @value sijiaLizhi_A
 * @option [A]九種九牌の採用 @value jiuzhongJiupai_A
 * @option [A]頭ハネの採用 @value atamahane_A
 * @option [A]青天井ルールの採用 @value aotenjo_A
 * @option [A]符なしルールの採用 @value funashi_A
 * @default match_M
 * 
 * @arg value_M
 * @text [M]変更後の値
 * @desc 変更対象の記号が[M]の場合この項目で値を指定してください
 * @type select
 * @option 東風戦 @value 0
 * @option 半荘戦 @value 1
 * @option 一荘戦 @value 2
 * @option オプションで選択(初期値:東風) @value 10
 * @option オプションで選択(初期値:半荘) @value 11
 * @option オプションで選択(初期値:一荘) @value 12
 * @option 東風戦(一時固定) @value 20
 * @option 半荘戦(一時固定) @value 21
 * @option 一荘戦(一時固定) @value 22
 * @default 0
 * 
 * @arg value_A
 * @text [A]変更後の値
 * @desc 変更対象の記号が[A]の場合この項目で値を指定してください
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @option 採用(一時固定) @value 21
 * @option 不採用(一時固定) @value 20
 * @default 1
 * 
 * @arg value_B
 * @text [B]変更後の値
 * @desc 変更対象の記号が[B]の場合この項目で値を指定してください
 * @type select
 * @option ON @value 1
 * @option OFF @value 0
 * @option オプションで選択(初期値:ON) @value 11
 * @option オプションで選択(初期値:OFF) @value 10
 * @option ON(一時固定) @value 21
 * @option OFF(一時固定) @value 20
 * @default 1
 * 
 * @arg clear
 * @text 対象を標準に戻す
 * @desc 対象をプラグインパラメータでの初期値に戻す場合 変更後の値を指定せずこの項目をONにしてください
 * @type boolean
 * @default false
 * 
 * 
 * @command clearGamerule
 * @text 標準ゲームルールの変更を戻す
 * @desc ゲーム中変更された標準ゲームルールを 全て以前の値に戻します
 * 
 * @arg subject
 * @text 戻す対象
 * @desc 「全てを戻す」を選択で 完全にプラグインパラメータでの設定状況に戻ります
 * @type select
 * @option 一時固定を解除 @value 2
 * @option 変更を標準に戻す @value 1
 * @option 全てを戻す @value 0

 * @default 2
 * 
 * 
 * 
 * 
 * @command setScoreSettings
 * @text 得点設定(四麻)を変更
 * 
 * @arg scoreSettings
 * @text 得点設定(四麻)
 * @desc 
 * @type struct<scoreSettings>
 * @default {}
 * 
 * 
 * @command clearScoreSettings
 * @text 得点設定(四麻)を標準に戻す
 * @desc ゲーム中変更されたデータを プラグインパラメータで設定した値に戻します
 * 
 * @command setScoreSettingsSamma
 * @text 得点設定(三麻)を変更
 * 
 * @arg scoreSettingsSamma
 * @text 得点設定(三麻)
 * @desc 
 * @type struct<scoreSettingsSamma>
 * @default {}
 * 
 * @command setDuoSettings
 * @text 二人麻雀の設定を変更
 * 
 * @arg duoSettings
 * @text 二人麻雀の設定
 * @desc 
 * @type struct<duoSettings>
 * @default {}
 * 
 * 
 * @command clearDuoSettings
 * @text 二人麻雀の設定を標準に戻す
 * @desc ゲーム中変更されたデータを プラグインパラメータで設定した値に戻します
 * 
 * 
 * 
 * @command setAudioData
 * @text BGM、効果音の設定を変更
 * @desc 
 * 
 * @arg subject
 * @text 変更対象
 * @desc 
 * @type select
 * @option 打牌時のME @value dapai
 * @option 対局時のBGM @value duijuBgm
 * @option 立直時のBGM(標準) @value lizhiBgm
 * @option 対局開始時のSE @value startDuiju
 * @option プレイヤー和了時のME @value heleMe_hele
 * @option プレイヤー満貫以上和了時のME @value heleMe_mangan
 * @option プレイヤー跳満以上和了時のME @value heleMe_haneman
 * @option プレイヤー倍満以上和了時のME @value heleMe_baiman
 * @option プレイヤー三倍満以上和了時のME @value heleMe_sambaiman
 * @option プレイヤー役満以上和了時のME @value heleMe_yakuman
 * @default dapai
 * 
 * 
 * @arg bgm
 * @text 変更後のBGM
 * @desc 変更対象の種類がBGMの場合 ここで変更後のファイルを指定してください
 * @type struct<audioBgm>
 * @default 
 * 
 * @arg bgs
 * @text 変更後のBGS
 * @desc 変更対象の種類がBGSの場合 ここで変更後のファイルを指定してください
 * @type struct<audioBgs>
 * @default 
 * 
 * @arg me
 * @text 変更後のME
 * @desc 変更対象の種類がMEの場合 ここで変更後のファイルを指定してください
 * @type struct<audioMe>
 * @default 
 * 
 * @arg se
 * @text 変更後のSE
 * @desc 変更対象の種類がSEの場合 ここで変更後のファイルを指定してください
 * @type struct<audioSe>
 * @default 
 * 
 * @arg clear
 * @text 対象を標準に戻す
 * @desc 対象をプラグインパラメータでの初期値に戻す場合 ファイルを指定せずこの項目をONにしてください
 * @type boolean
 * @default false
 * 
 * 
 * @command clearAudioData
 * @text BGM、効果音の設定を標準に戻す
 * @desc ゲーム中変更されたデータを プラグインパラメータで設定した値に戻します
 * 
 * 
 * 
 * @command setImgData
 * @text 画像の設定を変更
 * 
 * @arg imgData
 * @text 画像の設定
 * @desc 
 * @type struct<imgData>
 * @default {}
 * 
 * 
 * 
 * @command clearImgData
 * @text 画像の設定を標準に戻す
 * @desc ゲーム中変更されたデータを プラグインパラメータで設定した値に戻します
 * 
 * 
 * @command clearHeleCount
 * @text 和了カウント変数を全て0にする
 * @desc 役ごとに設定された和了カウント変数をすべて0にします
 * 
 * 
 * 
 * 
 * @command pushStack
 * @text 積み込み予約を追加
 * @desc 説明書に記載されている牌コードを 「,」(カンマ区切り)で入力してください
 * 
 * @arg peipai_0
 * @text 自家の配牌
 * @desc 13枚分指定してください
 * @type string
 * @default ,,,,,,,,,,,,
 * 
 * @arg peipai_1
 * @text 下家の配牌
 * @desc 13枚分指定してください
 * @type string
 * @default ,,,,,,,,,,,,
 * 
 * @arg peipai_2
 * @text 対面の配牌
 * @desc 13枚分指定してください
 * @type string
 * @default ,,,,,,,,,,,,
 * 
 * @arg peipai_3
 * @text 上家の配牌
 * @desc 13枚分指定してください
 * @type string
 * @default ,,,,,,,,,,,,
 * 
 * @arg echoDora
 * @text ドラ表示牌
 * @desc 5枚分指定してください
 * @type string
 * @default ,,,,
 * 
 * @arg echoUradora
 * @text 裏ドラ表示牌
 * @desc 5枚分指定してください
 * @type string
 * @default ,,,,
 * 
 * @arg zimo_0
 * @text 自家自摸予約
 * @desc 自家が自摸る牌を予め指定できます この予約は嶺上自摸にも有効です
 * @type string
 * @default ,,,,,,,,,,,,,,,,,
 * 
 * @arg zimo_1
 * @text 下家自摸予約
 * @desc 下家が自摸る牌を予め指定できます この予約は嶺上自摸にも有効です
 * @type string
 * @default ,,,,,,,,,,,,,,,,,
 * 
 * @arg zimo_2
 * @text 対面自摸予約
 * @desc 対面が自摸る牌を予め指定できます この予約は嶺上自摸にも有効です
 * @type string
 * @default ,,,,,,,,,,,,,,,,,
 * 
 * @arg zimo_3
 * @text 上家自摸予約
 * @desc 上家が自摸る牌を予め指定できます この予約は嶺上自摸にも有効です
 * @type string
 * @default ,,,,,,,,,,,,,,,,,
 * 
 * 
 * @command clearStack
 * @text 積み込み予約を全て削除
 * @desc 
 * 
 * 
 * 
 * 
 * @command debug
 * @text デバッグコマンド
 * @desc 次の対局に対して特殊な挙動を設定します
 * 
 * 
 * @arg tehaiOpen
 * @text 他家の手牌を表示する
 * @desc 他家の手牌を常に開いて表示します
 * @type boolean
 * @default false
 * 
 * @arg echoConsole
 * @text CPUの思考をコンソールに表示する
 * @desc 指定の対局者の行動判断の内訳をコンソールに出力します
 * @type select[]
 * @option 全員 @value 4
 * @option 自家 @value 0
 * @option 下家 @value 1
 * @option 対面 @value 2
 * @option 上家 @value 3
 * @default []
 * 
 * @arg entrust
 * @text CPU代打ち
 * @desc プレイヤーがCPUによる代打ちになります
 * @type boolean
 * @default false
 * 

 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * @param battlerData
 * @text 雀士登録
 * @desc 麻雀の対局者として登場するアクターは 必ずここで設定をしてください
 * @type struct<battlerData>[]
 * @default []
 * 
 * @param battlerTable
 * @text 雀士テーブル
 * @desc ランダムで対局者を指定する場合に使用します
 * @type struct<battlerTable>[]
 * @default []
 * 
 * 
 * @param duijuResult
 * @text 対局結果出力変数
 * @desc 対局の結果を 対局終了後 設定された変数にそれぞれ出力します. これらの数値は 対局ごとにリセットされます
 * 
 * @type struct<duijuResult>
 * @default {"rank_0":"0","rank_1":"0","rank_3":"0","rank_4":"0","actor_1":"0","actor_2":"0","actor_3":"0","point_0":"0","point_1":"0","point_2":"0","point_3":"0","hele":"0","yakuman":"0","fangchong":"0"}
 * 
 * @param yakuData
 * @text 役の設定
 * @desc 
 * @type struct<yakuData>
 * @default {"lizhi":"{\"text\":\"立直\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","doubleLizhi":"{\"text\":\"ダブル立直\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","yifa":"{\"text\":\"一発\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","zimo":"{\"text\":\"門前清自摸和\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","duanyaojiu":"{\"text\":\"断么九\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","pinghe":"{\"text\":\"平和\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","yibeikou":"{\"text\":\"一盃口\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","liangbeikou":"{\"text\":\"二盃口\",\"adopt\":\"true\",\"fan\":\"3\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","lingshangKaihua":"{\"text\":\"嶺上開花\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","haidiLaoyue":"{\"text\":\"海底撈月\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","hediLaoyu":"{\"text\":\"河底撈魚\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","quanfeng":"{\"text\":\"場風牌\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","menfeng":"{\"text\":\"自風牌\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","lianfeng":"{\"text\":\"連風牌\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","baiban":"{\"text\":\"白\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","lufa":"{\"text\":\"發\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","hongzhong":"{\"text\":\"中\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","bei":"{\"text\":\"北\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","qianggang":"{\"text\":\"槍槓\",\"adopt\":\"true\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","qiduizi":"{\"text\":\"七対子\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","duiduihe":"{\"text\":\"対々和\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","yiqiTongguan":"{\"text\":\"一気通貫\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"true\",\"priority\":\"50\",\"countVariable\":\"0\"}","sanseTongshun":"{\"text\":\"三色同順\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"true\",\"priority\":\"50\",\"countVariable\":\"0\"}","sanseTongke":"{\"text\":\"三色同刻\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","hunquandai":"{\"text\":\"混全帯么九\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"true\",\"priority\":\"50\",\"countVariable\":\"0\"}","chunquandai":"{\"text\":\"純全帯么九\",\"adopt\":\"true\",\"fan\":\"3\",\"fuluJian\":\"true\",\"priority\":\"50\",\"countVariable\":\"0\"}","hunlaotou":"{\"text\":\"混老頭\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","qinglaotou":"{\"text\":\"清老頭\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","hunyise":"{\"text\":\"混一色\",\"adopt\":\"true\",\"fan\":\"3\",\"fuluJian\":\"true\",\"priority\":\"50\",\"countVariable\":\"0\"}","qingyise":"{\"text\":\"清一色\",\"adopt\":\"true\",\"fan\":\"6\",\"fuluJian\":\"true\",\"priority\":\"50\",\"countVariable\":\"0\"}","sananke":"{\"text\":\"三暗刻\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","sianke":"{\"text\":\"四暗刻\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","siankeDanqi":"{\"text\":\"四暗刻単騎\",\"adopt\":\"true\",\"fan\":\"-2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","sangangzi":"{\"text\":\"三槓子\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","sigangzi":"{\"text\":\"四槓子\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","xiaosanyuan":"{\"text\":\"小三元\",\"adopt\":\"true\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","dasanyuan":"{\"text\":\"大三元\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","guoshiwushuang":"{\"text\":\"国士無双\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","chunzhengGuoshi":"{\"text\":\"純正国士無双\",\"adopt\":\"true\",\"fan\":\"-2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","xiaosixi":"{\"text\":\"小四喜和\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","dasixi":"{\"text\":\"大四喜和\",\"adopt\":\"true\",\"fan\":\"-2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","ziyise":"{\"text\":\"字一色\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","luyise":"{\"text\":\"緑一色\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","dachelun":"{\"text\":\"大車輪\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","jiulianBaodeng":"{\"text\":\"九蓮宝燈\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","chunzhengJiulian":"{\"text\":\"純正九蓮宝燈\",\"adopt\":\"true\",\"fan\":\"-2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","tianhe":"{\"text\":\"天和\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","dihe":"{\"text\":\"地和\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","renhe":"{\"text\":\"人和\",\"adopt\":\"true\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","balianzhuang":"{\"text\":\"八連荘\",\"adopt\":\"false\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","sanlianke":"{\"text\":\"三連刻\",\"adopt\":\"false\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","silianke":"{\"text\":\"四連刻\",\"adopt\":\"false\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"countVariable\":\"0\"}","yiseSanshun":"{\"text\":\"一色三順\",\"adopt\":\"false\",\"fan\":\"3\",\"fuluJian\":\"true\",\"countVariable\":\"0\"}","yiseSishun":"{\"text\":\"一色四順\",\"adopt\":\"false\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"countVariable\":\"0\"}","sanfengke":"{\"text\":\"三風刻\",\"adopt\":\"false\",\"fan\":\"2\",\"fuluJian\":\"false\",\"countVariable\":\"0\"}","kefengSanke":"{\"text\":\"客風三刻\",\"adopt\":\"false\",\"fan\":\"3\",\"fuluJian\":\"false\",\"countVariable\":\"0\"}","wumenqi":"{\"text\":\"五門斉\",\"adopt\":\"false\",\"fan\":\"2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","qinghaihu":"{\"text\":\"清海湖\",\"adopt\":\"false\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","shierLuotai":"{\"text\":\"十二落抬\",\"adopt\":\"false\",\"fan\":\"1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","hongkongque":"{\"text\":\"紅孔雀\",\"adopt\":\"false\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","daqixing":"{\"text\":\"大七星\",\"adopt\":\"false\",\"fan\":\"-2\",\"fuluJian\":\"false\",\"priority\":\"50\",\"countVariable\":\"0\"}","heiyise":"{\"text\":\"黒一色\",\"adopt\":\"false\",\"fan\":\"-1\",\"fuluJian\":\"false\",\"countVariable\":\"0\"}"}
 * 
 * @param text
 * @text テキスト設定
 * @desc 表示されるテキストの設定を行います
 * @type struct<text>
 * @default {"lizhi":"立直","zimo":"ツモ","rong":"ロン","peng":"ポン","chi":"チー","gang":"カン","dong":"東","nan":"南","xi":"西","bei":"北","ju":"%1%2局","homba":"%1本場","jia":"%1家","fan":"%1翻","fu":"%1符","point":"%1点","ranking":"%1位","mangan":"満貫","haneman":"跳満","baiman":"倍満","sambaiman":"三倍満","yakuman":"役満","kazoeYakuman":"数え役満","doubleYakuman":"ダブル役満","tripleYakuman":"トリプル役満","nthYakuman":"%1倍役満","tingpai":"テンパイ","noting":"ノーテン","huangpaiPingju":"流局","jiuzhongJiupai":"九種九牌","sikaigang":"四開槓","sijiaLizhi":"四家立直","sanjiahe":"三家和","sifengLianda":"四風連打","nagashiMangan":"流し満貫","dora":"ドラ","uradora":"裏ドラ","furiten":"フリテン","allLast":"オーラス","cancel":"やめる","menuGameEnd":"対局を中断する","menuContinue":"対局を続ける","shuzi_0":"〇","shuzi_1":"一","shuzi_2":"二","shuzi_3":"三","shuzi_4":"四","shuzi_5":"五","shuzi_6":"六","shuzi_7":"七","shuzi_8":"八","shuzi_9":"九","shuzi_decem":"十","shuzi_centum":"百","shuzi_mille":"千","shuzi_wan":"万","shuzi_yi":"億","shuzi_zhao":"兆","adopt":"採用","reject":"不採用","dongfeng":"東風戦","banzhuang":"半荘戦","yizhuang":"一荘戦","option_match":"対局形式","option_akadora":"赤ドラ","option_kuiduan":"喰いタン","option_liangfan":"二翻縛り","option_dora":"ドラ","option_tobi":"飛び終了","option_kuigae":"食い替え禁止","option_nagashiMangan":"流し満貫","option_sanjiahe":"三家和流局","option_sijiaLizhi":"四家立直流局","option_jiuzhongJiupai":"九種九牌","option_atamahane":"頭ハネ","option_aotenjo":"青天井ルール","option_funashi":"符なしルール"}
 * 
 * @param gamerule
 * @text 標準ゲームルール
 * @desc 「オプションで選択」を指定した項目は ゲーム中麻雀オプション画面で プレイヤーにより設定変更が可能です
 * @type struct<gamerule>
 * @default {"match":"11","dora":"1","akadora":"11","kuiduan":"11","liangfan":"0","tobi":"1","kuigae":"0","nagashiMangan":"1","sanjiahe":"0","sijiaLizhi":"1","jiuzhongJiupai":"1","atamahane":"0","aotenjo":"0","funashi":"0"}
 * 
 * @param scoreSettings
 * @text 得点設定(四麻)
 * @desc 四人麻雀を行う場合の得点の設定です
 * @type struct<scoreSettings>
 * @default {"basePoint":"25000","adoptOka":"false","point":"30000","lower":"30000","uma1_4":"0","uma2_3":"0","rounding":"0","tsumifuRong":"300","tsumifuZimo":"100"}
 * 
 * @param scoreSettingsSamma
 * @text 得点設定(三麻)
 * @desc 三人麻雀を行う場合の得点の設定です
 * @type struct<scoreSettingsSamma>
 * @default {"basePoint":"25000","adoptOka":"false","point":"30000","lower":"30000","uma1_3":"0","rounding":"0","tsumifuRong":"1000","tsumifuZimo":"500"}
 * 
 * @param duoSettings
 * @text 二人麻雀の設定
 * @desc 二人麻雀を行う場合のルールや得点の設定です
 * @type struct<duoSettings>
 * @default {"basePoint":"25000","lower":"0","uma1_2":"0","rounding":"0","tsumifuRong":"300","tsumifuZimo":"300","leave":"60","canFulu":"true","canGang":"true"}
 * 
 * 
 * 
 * 
 * @param audioData
 * @text BGM、効果音の設定
 * @desc 
 * @type struct<audioData>
 * @default {"dapai":"{\"se\":\"Cursor1\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","duijuBgm":"{\"bgm\":\"Scene3\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","lizhiBgm":"{\"bgm\":\"Battle1\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","startDuiju":"{\"se\":\"\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","heleMe_hele":"{\"me\":\"\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","heleMe_mangan":"{\"me\":\"Victory1\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","heleMe_haneman":"{\"me\":\"\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","heleMe_baiman":"{\"me\":\"\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","heleMe_sambaiman":"{\"me\":\"\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","heleMe_yakuman":"{\"me\":\"Victory3\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}","victory":"{\"me\":\"Like\",\"volume\":\"90\",\"pitch\":\"100\",\"pan\":\"0\"}"}
 * 
 * @param imgData
 * @text 画像の設定
 * @desc 
 * @type struct<imgData>
 * @default {"majiangpai":"Majiangpai","majiangBackground":"MajiangBackground"}
 * 
 * @param heleAnimation
 * @text 標準和了アニメーション
 * @desc アニメーションが設定されている場合 和了時 牌の上で再生されます
 * @type struct<heleAnimation>
 * @default {"hele":"76","mangan":"0","haneman":"0","baiman":"0","sambaiman":"0","yakuman":"80"}
 * 
 * @param settings
 * @text 詳細ゲームルール
 * @desc 
 * @type struct<settings>
 * @default {"liangfengFu":"4","akadoraPieces":"3","akadoraPiecesSamma":"2","maxYakuman":"0","nagashiManganPoint":"mangan","siqidui":"false","guoshiFuZimo":"25","guoshiFuRong":"25","adoptQiduizi":"true","adoptQianggang":"true"}
 * 
 * @param params
 * @text プラグイン設定
 * @desc 
 * @type struct<params>
 * @default {"dongjiaTextColor":"1","echoDora":"true","tajiaPaiWidth":"24","paiWidth":"36","zhuoPadding":"48","heCols":"6","drawFace":"true","nameBox":"1","wait":"30","zimoWait":"5","dapaiWait":"10","messageWait":"60","linesWait":"60","tehaiCanRepeat":"false","backGroundFilter":"0","sceneEffect":"1"}
 */
 
 
/*~struct~battlerTable:
 * 
 * @param name
 * @text リスト名
 * @desc このリストに名前を付けてください. 呼び出し時使用します
 * @type string
 * @default 
 * 
 * @param actors
 * @text アクターリスト
 * @desc 必ず雀士登録をしたアクターを指定してください
 * @type actor[]
 * @default []
 */

 
/*~struct~yakuData:
 * 
 * @param lizhi
 * @text 立直
 * @desc 
 * @type struct<yaku>
 * @default {"text":"立直","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param doubleLizhi
 * @text ダブル立直
 * @desc 
 * @type struct<yaku>
 * @default {"text":"ダブル立直","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param yifa
 * @text 一発
 * @desc 
 * @type struct<yaku>
 * @default {"text":"一発","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param zimo
 * @text 門前清自摸和
 * @desc 
 * @type struct<yaku>
 * @default {"text":"門前清自摸和","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param duanyaojiu
 * @text 断么九
 * @desc 
 * @type struct<yaku>
 * @default {"text":"断么九","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 *  
 * @param pinghe
 * @text 平和
 * @desc 
 * @type struct<yaku>
 * @default {"text":"平和","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param yibeikou
 * @text 一盃口
 * @desc 
 * @type struct<yaku>
 * @default {"text":"一盃口","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param liangbeikou
 * @text 二盃口
 * @desc 
 * @type struct<yaku>
 * @default {"text":"二盃口","adopt":"true","fan":"3","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param lingshangKaihua
 * @text 嶺上開花
 * @desc 
 * @type struct<yaku>
 * @default {"text":"嶺上開花","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param haidiLaoyue
 * @text 海底撈月
 * @desc 
 * @type struct<yaku>
 * @default {"text":"海底撈月","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param hediLaoyu
 * @text 河底撈魚
 * @desc 
 * @type struct<yaku>
 * @default {"text":"河底撈魚","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param quanfeng
 * @text 場風牌
 * @desc 
 * @type struct<yaku>
 * @default {"text":"場風牌","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param menfeng
 * @text 自風牌
 * @desc 
 * @type struct<yaku>
 * @default {"text":"自風牌","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param lianfeng
 * @text 連風牌
 * @desc 
 * @type struct<yaku>
 * @default {"text":"連風牌","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param baiban
 * @text 白
 * @desc 
 * @type struct<yaku>
 * @default {"text":"白","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param lufa
 * @text 發
 * @desc 
 * @type struct<yaku>
 * @default {"text":"發","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param hongzhong
 * @text 中
 * @desc 
 * @type struct<yaku>
 * @default {"text":"中","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param bei
 * @text 北(三麻用)
 * @desc この役は 三麻において北を刻子にしたときにつきます
 * @type struct<yaku>
 * @default {"text":"北","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param qianggang
 * @text 槍槓
 * @desc 
 * @type struct<yaku>
 * @default {"text":"槍槓","adopt":"true","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param qiduizi
 * @text 七対子
 * @desc 
 * @type struct<yaku>
 * @default {"text":"七対子","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param duiduihe
 * @text 対々和
 * @desc 
 * @type struct<yaku>
 * @default {"text":"対々和","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param yiqiTongguan
 * @text 一気通貫
 * @desc 
 * @type struct<yaku>
 * @default {"text":"一気通貫","adopt":"true","fan":"2","fuluJian":"true","priority":"50","countVariable":"0"}
 * 
 * @param sanseTongshun
 * @text 三色同順
 * @desc 
 * @type struct<yaku>
 * @default {"text":"三色同順","adopt":"true","fan":"2","fuluJian":"true","priority":"50","countVariable":"0"}
 * 
 * @param sanseTongke
 * @text 三色同刻
 * @desc 
 * @type struct<yaku>
 * @default {"text":"三色同刻","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param hunquandai
 * @text 混全帯么九
 * @desc 
 * @type struct<yaku>
 * @default {"text":"混全帯么九","adopt":"true","fan":"2","fuluJian":"true","priority":"50","countVariable":"0"}
 * 
 * @param chunquandai
 * @text 純全帯么九
 * @desc 
 * @type struct<yaku>
 * @default {"text":"純全帯么九","adopt":"true","fan":"3","fuluJian":"true","priority":"50","countVariable":"0"}
 * 
 * @param hunlaotou
 * @text 混老頭
 * @desc 
 * @type struct<yaku>
 * @default {"text":"混老頭","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param qinglaotou
 * @text 清老頭
 * @desc 
 * @type struct<yaku>
 * @default {"text":"清老頭","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param hunyise
 * @text 混一色
 * @desc 
 * @type struct<yaku>
 * @default {"text":"混一色","adopt":"true","fan":"3","fuluJian":"true","priority":"50","countVariable":"0"}
 * 
 * @param qingyise
 * @text 清一色
 * @desc 
 * @type struct<yaku>
 * @default {"text":"清一色","adopt":"true","fan":"6","fuluJian":"true","priority":"50","countVariable":"0"}
 * 
 * @param sananke
 * @text 三暗刻
 * @desc 
 * @type struct<yaku>
 * @default {"text":"三暗刻","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param sianke
 * @text 四暗刻
 * @desc 
 * @type struct<yaku>
 * @default {"text":"四暗刻","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param siankeDanqi
 * @text 四暗刻単騎
 * @desc 
 * @type struct<yaku>
 * @default {"text":"四暗刻単騎","adopt":"true","fan":"-2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param sangangzi
 * @text 三槓子
 * @desc 
 * @type struct<yaku>
 * @default {"text":"三槓子","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param sigangzi
 * @text 四槓子
 * @desc 
 * @type struct<yaku>
 * @default {"text":"四槓子","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param xiaosanyuan
 * @text 小三元
 * @desc 
 * @type struct<yaku>
 * @default {"text":"小三元","adopt":"true","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param dasanyuan
 * @text 大三元
 * @desc 
 * @type struct<yaku>
 * @default {"text":"大三元","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param guoshiwushuang
 * @text 国士無双
 * @desc 
 * @type struct<yaku>
 * @default {"text":"国士無双","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param chunzhengGuoshi
 * @text 純正国士無双
 * @desc 
 * @type struct<yaku>
 * @default {"text":"純正国士無双","adopt":"true","fan":"-2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param xiaosixi
 * @text 小四喜和
 * @desc 
 * @type struct<yaku>
 * @default {"text":"小四喜和","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param dasixi
 * @text 大四喜和
 * @desc 
 * @type struct<yaku>
 * @default {"text":"大四喜和","adopt":"true","fan":"-2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param ziyise
 * @text 字一色
 * @desc 
 * @type struct<yaku>
 * @default {"text":"字一色","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param luyise
 * @text 緑一色
 * @desc 
 * @type struct<yaku>
 * @default {"text":"緑一色","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param dachelun
 * @text 大車輪
 * @desc 
 * @type struct<yaku>
 * @default {"text":"大車輪","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param jiulianBaodeng
 * @text 九蓮宝燈
 * @desc 
 * @type struct<yaku>
 * @default {"text":"九蓮宝燈","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param chunzhengJiulian
 * @text 純正九蓮宝燈
 * @desc 
 * @type struct<yaku>
 * @default {"text":"純正九蓮宝燈","adopt":"true","fan":"-2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param tianhe
 * @text 天和
 * @desc 
 * @type struct<yaku>
 * @default {"text":"天和","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param dihe
 * @text 地和
 * @desc 
 * @type struct<yaku>
 * @default {"text":"地和","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param renhe
 * @text 人和
 * @desc 
 * @type struct<yaku>
 * @default {"text":"人和","adopt":"true","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param balianzhuang
 * @text 八連荘
 * @desc 
 * @type struct<yaku>
 * @default {"text":"八連荘","adopt":"false","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param sanlianke
 * @text 三連刻
 * @desc 
 * @type struct<yaku>
 * @default {"text":"三連刻","adopt":"false","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param silianke
 * @text 四連刻
 * @desc 
 * @type struct<yaku>
 * @default {"text":"四連刻","adopt":"false","fan":"-1","fuluJian":"false","countVariable":"0"}
 * 
 * @param yiseSanshun
 * @text 一色三順
 * @desc 
 * @type struct<yaku>
 * @default {"text":"一色三順","adopt":"false","fan":"3","fuluJian":"true","countVariable":"0"}
 * 
 * @param yiseSishun
 * @text 一色四順
 * @desc 
 * @type struct<yaku>
 * @default {"text":"一色四順","adopt":"false","fan":"-1","fuluJian":"false","countVariable":"0"}
 * 
 * @param sanfengke
 * @text 三風刻
 * @desc 
 * @type struct<yaku>
 * @default {"text":"三風刻","adopt":"false","fan":"2","fuluJian":"false","countVariable":"0"}
 * 
 * @param kefengSanke
 * @text 客風三刻
 * @desc 
 * @type struct<yaku>
 * @default {"text":"客風三刻","adopt":"false","fan":"3","fuluJian":"false","countVariable":"0"}
 * 
 * @param wumenqi
 * @text 五門斉
 * @desc 
 * @type struct<yaku>
 * @default {"text":"五門斉","adopt":"false","fan":"2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param qinghaihu
 * @text 清海湖
 * @desc 
 * @type struct<yaku>
 * @default {"text":"清海湖","adopt":"false","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param shierLuotai
 * @text 十二落抬
 * @desc 
 * @type struct<yaku>
 * @default {"text":"十二落抬","adopt":"false","fan":"1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param hongkongque
 * @text 紅孔雀
 * @desc 
 * @type struct<yaku>
 * @default {"text":"紅孔雀","adopt":"false","fan":"-1","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param daqixing
 * @text 大七星
 * @desc 
 * @type struct<yaku>
 * @default {"text":"大七星","adopt":"false","fan":"-2","fuluJian":"false","priority":"50","countVariable":"0"}
 * 
 * @param heiyise
 * @text 黒一色
 * @desc 
 * @type struct<yaku>
 * @default {"text":"黒一色","adopt":"false","fan":"-1","fuluJian":"false","countVariable":"0"}
 * 
 */

/*~struct~yaku:
 * 
 * 
 * @param text
 * @text 役の名称
 * @desc 
 * @type string
 * @default 
 * 
 * @param adopt
 * @text 採用
 * @desc 
 * @type boolean
 * @default true
 * 
 * @param fan
 * @text 翻
 * @desc 
 * @type select
 * @option 1翻 @value 1
 * @option 2翻 @value 2
 * @option 3翻 @value 3
 * @option 4翻 @value 4
 * @option 5翻 @value 5
 * @option 6翻 @value 6
 * @option 7翻 @value 7
 * @option 8翻 @value 8
 * @option 9翻 @value 9
 * @option 10翻 @value 10
 * @option 11翻 @value 11
 * @option 12翻 @value 12
 * @option 役満 @value -1
 * @option ダブル役満 @value -2
 * @option トリプル役満 @value -3
 * @default 1
 * 
 * @param fuluJian
 * @text 食い下がり
 * @desc 門前役、役満の場合無効
 * @type boolean
 * @default false
 * 
 * @param priority
 * @text 表示順
 * @desc 和了時のリザルト画面で この値が大きい役ほど上部に表示します
 * @type number
 * @default 50
 * 
 * @param countVariable
 * @text 和了カウント
 * @desc プレイヤーがこの役を和了ったとき 次の変数に値を加算します
 * @type variable
 * @default 0
 */
 
/*~struct~battlerData:
 * 
 * 
 * @param actorId
 * @text アクター
 * @desc 登録対象のアクターを指定してください
 * @type actor
 * @default 0
 * 
 * @param cpuSettings
 * @text CPU設定(標準)
 * @desc このアクターが他家として出た場合のCPUの挙動を指定します
 * @type struct<cpuSettings>
 * @default {"atk":"0","lizhi":"0","yakuWeight":"0","allLast":"0","badmove":"0","traits":"{}","yaku":"[]"}
 * 
 * @param cpuConfiguration
 * @text CPU設定(高度)
 * @desc 高度なCPU設定を使用しない場合は これらの項目はすべて空白にしてください. 高度なCPUについては説明書を参照
 * @type struct<cpuConfiguration>
 * @default {"cpuClass":"","unitName":"","note":""}
 * 
 * @param lines
 * @text セリフ設定
 * @desc 
 * @type struct<lines>
 * @default {"zimo":"[\"ツモ！\"]","rong":"[\"ロン！\"]","lizhi":"[\"リーチ！\"]","doubleLizhi":"[\"ダブルリーチ！\"]","peng":"[\"ポン！\"]","chi":"[\"チー！\"]","gang":"[\"カン！\"]","jiuzhongJiupai":"[\"九種九牌\"]"}
 * 
 * @param heleAnimation
 * @text 和了アニメーション
 * @desc 指定無しの場合標準アニメーションが再生されます
 * @type struct<heleAnimation>
 * @default {"hele":"0","mangan":"0","haneman":"0","baiman":"0","sambaiman":"0","yakuman":"0"}
 * 
 * @param lizhiBgm
 * @text 立直時のBGM
 * @desc 指定無しの場合標準立直BGMが再生されます
 * @type struct<audioBgm>
 * @default {"bgm":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param voiceLines
 * @text ボイスSE(セリフ)
 * @desc セリフ設定でのセリフに対応したボイスを設定できます
 * @type struct<voiceLines>
 * @default {"zimo":"[]","rong":"[]","lizhi":"[]","doubleLizhi":"[]","peng":"[]","chi":"[]","gang":"[]","jiuzhongJiupai":"[]"}
 * 
 * @param note
 * @text メモ
 * @desc 
 * @type multiline_string
 * @default 
 * 
 */

 /*~struct~cpuSettings:
 * 
 * @param atk
 * @text 攻防特徴
 * @desc オリやすさを設定します
 * @type select
 * @option 常にベタオリ @value -10
 * @option 防御型 @value -1
 * @option 標準 @value 0
 * @option 攻撃型 @value 1
 * @option 常に全ツ @value 10
 * @default 0
 * 
 * @param lizhi
 * @text 立直の頻度
 * @desc 立直のしやすさを設定します
 * @type select
 * @option しない @value -10
 * @option 稀 @value -1
 * @option 標準 @value 0
 * @option 頻繁 @value 1
 * @option 聴牌即リー @value 10
 * @default 0
 * 
 * @param yakuWeight
 * @text 役の重視
 * @desc 切る牌の選択において 役を重視するかを設定します
 * @type select
 * @option アガリ優先 @value -1
 * @option 標準 @value 0
 * @option 役優先 @value 1
 * @default 0
 * 
 * @param allLast
 * @text オーラス時の和了判断
 * @desc オーラス、または飛び終了が発生する場合 和了を実行するかの判断を設定します
 * @type select
 * @option とにかく和了る @value 0
 * @option ラス確なら和了らない @value 1
 * @option トップ確定でなければ和了らない @value 2
 * @default 0
 * 
 * @param badmove
 * @text 弱さ補正
 * @desc 切る牌にランダム要素を追加し 意図的に弱いCPUを作成します
 * @type select
 * @option 補正無し @value 0
 * @option 弱さ補正Lv.1 @value 1
 * @option 弱さ補正Lv.2 @value 2
 * @default 0
 * 
 * @param traits
 * @text 特殊特徴
 * @desc 
 * @type struct<cpuTraits>
 * @default {"zimogiri":"false","fulu":"0"}
 * 
 * @param yaku
 * @text 役の好み
 * @desc 好む役や嫌う役を登録できます
 * @type struct<yakuPreference>[]
 * @default []
 */
 
 /*~struct~cpuConfiguration:
 * 
 * @param cpuClass
 * @text CPU打ち筋名
 * @desc CPU打ち筋登録にて設定された打ち筋を読み込みます. 空白の場合標準
 * @type string
 * @default 
 * 
 * @param unitName
 * @text CPUユニット名
 * @desc 読み込むCPUユニットを指定します. 空白の場合標準ユニットを読み込みます
 * @type string
 * @default 
 * 
 */

/*~struct~cpuTraits: 
 * 
 * 
 * @param zimogiri
 * @text 常に自摸切り
 * @desc 有効の場合 常に自摸切りします
 * @type boolean
 * @default false 
 * 
 * @param fulu
 * @text 副露特徴
 * @desc 
 * @type select
 * @option 標準 @value 0 
 * @option 常にしない @value -1
 * @default 0
 * 
 */ 

/*~struct~yakuPreference: 
 * 
 * @param subject
 * @text 対象の役
 * @desc 
 * @type select
 * @option 断么九 @value duanyaojiu
 * @option 平和 @value pinghe
 * @option 対々和 @value duiduihe
 * @option 清一色 @value qingyise
 * @option 混一色 @value hunyise
 * @option 字一色 @value ziyise
 * @option 緑一色 @value luyise
 * @option 純全帯么九 @value chunquandai
 * @option 混全帯么九 @value hunquandai
 * @option 清老頭 @value qinglaotou
 * @option 混老頭 @value hunlaotou
 * @option 三色同順 @value sanseTongshun
 * @option 三色同刻 @value sanseTongke
 * @option 一気通貫 @value yiqiTongguan
 * @option 三、四暗刻 @value anke
 * @option 七対子 @value qiduizi
 * @option 国士無双 @value guoshiwushuang
 * @option 大、小三元 @value sanyuan
 * @option 大、小四喜 @value sixi
 * @option 役牌 @value yipai
 * @option ドラ @value dora
 * @default duanyaojiu
 * 
 * @param value
 * @text 好み度
 * @desc 
 * @type select
 * @option 意識しない @value 0
 * @option あまり好まない @value 1
 * @option 好む @value 3
 * @option とても好む @value 4
 * @default 3
 */
 
 
 

 
/*~struct~lines:
 * 
 * @param zimo
 * @text ツモ時のセリフ
 * @desc 複数設定されている場合 ランダムで発声します
 * @type multiline_string[]
 * @default ["ツモ！"]
 * 
 * @param rong
 * @text ロン時のセリフ
 * @desc 複数設定されている場合 ランダムで発声します
 * @type multiline_string[]
 * @default ["ロン！"]
 * 
 * @param lizhi
 * @text 立直時のセリフ
 * @desc 複数設定されている場合 ランダムで発声します
 * @type multiline_string[]
 * @default ["リーチ！"]
 * 
 * @param doubleLizhi
 * @text ダブル立直時のセリフ
 * @desc 複数設定されている場合 ランダムで発声します
 * @type multiline_string[]
 * @default ["ダブルリーチ！"]
 * 
 * @param peng
 * @text ポン時のセリフ
 * @desc 複数設定されている場合 ランダムで発声します
 * @type multiline_string[]
 * @default ["ポン！"]
 * 
 * @param chi
 * @text チー時のセリフ
 * @desc 複数設定されている場合 ランダムで発声します
 * @type multiline_string[]
 * @default ["チー！"]
 * 
 * @param gang
 * @text カン時のセリフ
 * @desc 複数設定されている場合 ランダムで発声します
 * @type multiline_string[]
 * @default ["カン！"]
 * 
 * @param jiuzhongJiupai
 * @text 九種九牌時のセリフ
 * @desc 複数設定されている場合 ランダムで発声します
 * @type multiline_string[]
 * @default ["九種九牌"]
 */
 
/*~struct~voiceLines:
 * 
 * @param zimo
 * @text ツモ時のボイス
 * @desc 「セリフ設定」の当該項目が複数設定されている場合 同じ番号に対応するボイスを設定してください
 * @type struct<audioSe>[]
 * @default []
 * 
 * @param rong
 * @text ロン時のボイス
 * @desc 「セリフ設定」の当該項目が複数設定されている場合 同じ番号に対応するボイスを設定してください
 * @type struct<audioSe>[]
 * @default []
 * 
 * @param lizhi
 * @text 立直時のボイス
 * @desc 「セリフ設定」の当該項目が複数設定されている場合 同じ番号に対応するボイスを設定してください
 * @type struct<audioSe>[]
 * @default []
 * 
 * @param doubleLizhi
 * @text ダブル立直時のボイス
 * @desc 「セリフ設定」の当該項目が複数設定されている場合 同じ番号に対応するボイスを設定してください
 * @type struct<audioSe>[]
 * @default []
 * 
 * @param peng
 * @text ポン時のボイス
 * @desc 「セリフ設定」の当該項目が複数設定されている場合 同じ番号に対応するボイスを設定してください
 * @type struct<audioSe>[]
 * @default []
 * 
 * @param chi
 * @text チー時のボイス
 * @desc 「セリフ設定」の当該項目が複数設定されている場合 同じ番号に対応するボイスを設定してください
 * @type struct<audioSe>[]
 * @default []
 * 
 * @param gang
 * @text カン時のボイス
 * @desc 「セリフ設定」の当該項目が複数設定されている場合 同じ番号に対応するボイスを設定してください
 * @type struct<audioSe>[]
 * @default []
 * 
 * @param jiuzhongJiupai
 * @text 九種九牌時のボイス
 * @desc 「セリフ設定」の当該項目が複数設定されている場合 同じ番号に対応するボイスを設定してください
 * @type struct<audioSe>[]
 * @default []
 */



/*~struct~text:
 * 
 * @param lizhi
 * @text 立直の表示
 * @desc 
 * @type string
 * @default 立直
 * 
 * @param zimo
 * @text ツモの表示
 * @desc 
 * @type string
 * @default ツモ
 * 
 * @param rong
 * @text ロンの表示
 * @desc 
 * @type string
 * @default ロン
 * 
 * @param peng
 * @text ポンの表示
 * @desc 
 * @type string
 * @default ポン
 * 
 * @param chi
 * @text チーの表示
 * @desc 
 * @type string
 * @default チー
 * 
 * @param gang
 * @text カンの表示
 * @desc 
 * @type string
 * @default カン
 * 
 * @param dong
 * @text 東の表示
 * @desc 
 * @type string
 * @default 東 
 * 
 * @param nan
 * @text 南の表示
 * @desc 
 * @type string
 * @default 南
 * 
 * @param xi
 * @text 西の表示
 * @desc 
 * @type string
 * @default 西
 * 
 * @param bei
 * @text 北の表示
 * @desc 
 * @type string
 * @default 北
 * 
 * @param ju
 * @text ～局の表示
 * @desc 東一局 などの表示に使用します %1が場風 %2が漢数字に置き換えられます
 * @type string
 * @default %1%2局
 * 
 * @param homba
 * @text ～本場の表示
 * @desc %1が 漢数字に置き換えられます
 * @type string
 * @default %1本場
 * 
 * @param jia
 * @text ～家の表示
 * @desc 東家、南家 などの表示に使用します %1が自風に置き換えられます
 * @type string
 * @default %1家
 * 
 * @param fan
 * @text ～翻の表示
 * @desc %1が 数字に置き換えられます
 * @type string
 * @default %1翻
 * 
 * @param fu
 * @text ～符の表示
 * @desc %1が 数字に置き換えられます
 * @type string
 * @default %1符
 * 
 * @param point
 * @text ～点の表示
 * @desc %1が 数字に置き換えられます
 * @type string
 * @default %1点
 * 
 * @param ranking
 * @text ～位の表示
 * @desc %1が 数字に置き換えられます
 * @type string
 * @default %1位
 * 
 * @param mangan
 * @text 満貫の表示
 * @desc 
 * @type string
 * @default 満貫
 * 
 * @param haneman
 * @text 跳満の表示
 * @desc 
 * @type string
 * @default 跳満
 * 
 * @param baiman
 * @text 倍満の表示
 * @desc 
 * @type string
 * @default 倍満
 * 
 * @param sambaiman
 * @text 三倍満の表示
 * @desc 
 * @type string
 * @default 三倍満
 * 
 * @param yakuman
 * @text 役満の表示
 * @desc 
 * @type string
 * @default 役満
 * 
 * @param kazoeYakuman
 * @text 数え役満の表示
 * @desc 
 * @type string
 * @default 数え役満
 * 
 * @param doubleYakuman
 * @text ダブル役満の表示
 * @desc 
 * @type string
 * @default ダブル役満
 * 
 * @param tripleYakuman
 * @text トリプル役満の表示
 * @desc 
 * @type string
 * @default トリプル役満
 * 
 * @param nthYakuman
 * @text n倍役満の表示
 * @desc %1が漢数字に置き換えられます
 * @type string
 * @default %1倍役満
 * 
 * @param tingpai
 * @text 聴牌の表示
 * @desc 
 * @type string
 * @default テンパイ
 * 
 * @param noting
 * @text ノーテンの表示
 * @desc 
 * @type string
 * @default ノーテン
 * 
 * @param huangpaiPingju
 * @text 流局の表示
 * @desc 
 * @type string
 * @default 流局
 * 
 * @param jiuzhongJiupai
 * @text 九種九牌の表示
 * @desc 
 * @type string
 * @default 九種九牌
 * 
 * @param sikaigang
 * @text 四開槓の表示
 * @desc 
 * @type string
 * @default 四開槓
 * 
 * @param sijiaLizhi
 * @text 四家立直の表示
 * @desc 
 * @type string
 * @default 四家立直
 * 
 * @param sanjiahe
 * @text 三家和の表示
 * @desc 
 * @type string
 * @default 三家和
 * 
 * @param sifengLianda
 * @text 四風連打の表示
 * @desc 
 * @type string
 * @default 四風連打
 * 
 * @param nagashiMangan
 * @text 流し満貫の表示
 * @desc 
 * @type string
 * @default 流し満貫
 * 
 * @param dora
 * @text ドラの表示
 * @desc 
 * @type string
 * @default ドラ
 * 
 * @param uradora
 * @text 裏ドラの表示
 * @desc 
 * @type string
 * @default 裏ドラ
 * 
 * @param furiten
 * @text フリテンの表示
 * @desc 
 * @type string
 * @default フリテン
 * 
 * @param allLast
 * @text オーラスの表示
 * @desc 
 * @type string
 * @default オーラス
 * 
 * @param cancel
 * @text キャンセルの表示
 * @desc 副露、ロン等を実行しない選択肢に使用します
 * @type string
 * @default やめる
 * 
 * @param menuGameEnd
 * @text 対局中断選択肢の表示
 * @desc 
 * @type string
 * @default 対局を中断する
 * 
 * @param menuContinue
 * @text 対局続行選択肢の表示
 * @desc 
 * @type string
 * @default 対局を続ける
 * 
 * 
 * @param shuzi_0
 * @text 漢数字 零 の表示
 * @desc 
 * @type string
 * @default 〇
 * 
 * @param shuzi_1
 * @text 漢数字 一 の表示
 * @desc 
 * @type string
 * @default 一
 * 
 * @param shuzi_2
 * @text 漢数字 二 の表示
 * @desc 
 * @type string
 * @default 二
 * 
 * @param shuzi_3
 * @text 漢数字 三 の表示
 * @desc 
 * @type string
 * @default 三
 * 
 * @param shuzi_4
 * @text 漢数字 四 の表示
 * @desc 
 * @type string
 * @default 四
 * 
 * @param shuzi_5
 * @text 漢数字 五 の表示
 * @desc 
 * @type string
 * @default 五
 * 
 * @param shuzi_6
 * @text 漢数字 六 の表示
 * @desc 
 * @type string
 * @default 六
 * 
 * @param shuzi_7
 * @text 漢数字 七 の表示
 * @desc 
 * @type string
 * @default 七
 * 
 * @param shuzi_8
 * @text 漢数字 八 の表示
 * @desc 
 * @type string
 * @default 八
 * 
 * @param shuzi_9
 * @text 漢数字 九 の表示
 * @desc 
 * @type string
 * @default 九
 * 
 * @param shuzi_decem
 * @text 漢数字 十 の表示
 * @desc 
 * @type string
 * @default 十
 * 
 * @param shuzi_centum
 * @text 漢数字 百 の表示
 * @desc 
 * @type string
 * @default 百
 * 
 * @param shuzi_mille
 * @text 漢数字 千 の表示
 * @desc 
 * @type string
 * @default 千
 * 
 * @param shuzi_wan
 * @text 漢数字 万 の表示
 * @desc 
 * @type string
 * @default 万
 * 
 * @param shuzi_yi
 * @text 漢数字 億 の表示
 * @desc 
 * @type string
 * @default 億
 * 
 * @param shuzi_zhao
 * @text 漢数字 兆 の表示
 * @desc 
 * @type string
 * @default 兆
 * 
 * @param adopt
 * @text 採用の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 採用
 * 
 * @param reject
 * @text 不採用の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 不採用
 * 
 * @param dongfeng
 * @text 東風戦の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 東風戦
 * 
 * @param banzhuang
 * @text 半荘戦の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 半荘戦
 * 
 * @param yizhuang
 * @text 一荘戦の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 一荘戦
 * 
 * @param option_match
 * @text 「対局形式」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 対局形式
 * 
 * @param option_akadora
 * @text 「赤ドラの採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 赤ドラ
 * 
 * @param option_kuiduan
 * @text 「喰いタンの採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 喰いタン
 * 
 * @param option_liangfan
 * @text 「二翻縛りの採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 二翻縛り
 * 
 * @param option_dora
 * @text 「ドラの採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default ドラ
 * 
 * @param option_tobi
 * @text 「飛び終了の採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 飛び終了
 * 
 * @param option_kuigae
 * @text 「食い替え禁止の採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 食い替え禁止
 * 
 * @param option_nagashiMangan
 * @text 「流し満貫の採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 流し満貫
 * 
 * @param option_sanjiahe
 * @text 「三家和流局の採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 三家和流局
 * 
 * @param option_sijiaLizhi
 * @text 「四家立直流局の採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 四家立直流局
 * 
 * @param option_jiuzhongJiupai
 * @text 「九種九牌の採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 九種九牌
 * 
 * @param option_atamahane
 * @text 「頭ハネの採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 頭ハネ
 * 
 * @param option_aotenjo
 * @text 「青天井ルールの採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 青天井ルール
 * 
 * @param option_funashi
 * @text 「符なしルールの採用」の表示
 * @desc オプション画面で使用します
 * @type string
 * @default 符なしルール
 * 
 */

/*~struct~scoreSettings:
 * 
 * @param basePoint
 * @text 配給原点
 * @desc 
 * @type number
 * @default 25000
 * 
 * @param adoptOka
 * @text オカを設定する
 * @desc 
 * @type boolean
 * @default false
 * 
 * @param point
 * @parent adoptOka
 * @text 原点
 * @desc オカ無しの場合無効
 * @type number
 * @default 30000
 * 
 * @param lower
 * @text 1位必要点数
 * @desc 
 * @type number
 * @default 30000
 * 
 * @param uma1_4
 * @text ウマ(4位→1位)
 * @desc 
 * @type number
 * @default 0
 * 
 * @param uma2_3
 * @text ウマ(3位→2位)
 * @desc 
 * @type number
 * @default 0
 * 
 * 
 * @param rounding
 * @text 最終得点の処理
 * @desc 
 * @type select
 * @option そのまま @value 0
 * @option 100の位を五捨六入 @value 1
 * @option 100の位を四捨五入 @value 2
 * @option 1000で割って五捨六入 @value 3
 * @option 1000で割って四捨五入 @value 4
 * @default 0
 * 
 * @param tsumifuRong
 * @text 積み符(ロン)
 * @desc 
 * @type number
 * @default 300
 * 
 * @param tsumifuZimo
 * @text 積み符(自摸)
 * @desc 一人当たりの支払い
 * @type number
 * @default 100
 * 
 */
 
/*~struct~scoreSettingsSamma:
 * 
 * @param basePoint
 * @text 配給原点
 * @desc 
 * @type number
 * @default 25000
 * 
 * @param adoptOka
 * @text オカを設定する
 * @desc 
 * @type boolean
 * @default false
 * 
 * @param point
 * @parent adoptOka
 * @text 原点
 * @desc オカ無しの場合無効
 * @type number
 * @default 30000
 * 
 * @param lower
 * @text 1位必要点数
 * @desc 
 * @type number
 * @default 30000
 * 
 * @param uma1_3
 * @text ウマ(3位→1位)
 * @desc 
 * @type number
 * @default 0
 * 
 * @param rounding
 * @text 最終得点の処理
 * @desc 
 * @type select
 * @option そのまま @value 0
 * @option 100の位を五捨六入 @value 1
 * @option 100の位を四捨五入 @value 2
 * @option 1000で割って五捨六入 @value 3
 * @option 1000で割って四捨五入 @value 4
 * @default 0
 * 
 * @param tsumifuRong
 * @text 積み符(ロン)
 * @desc 
 * @type number
 * @default 1000
 * 
 * @param tsumifuZimo
 * @text 積み符(自摸)
 * @desc 一人当たりの支払い
 * @type number
 * @default 500
 * 
 */

/*~struct~duoSettings:
 * 
 * @param basePoint
 * @text 配給原点
 * @desc 
 * @type number
 * @default 25000
 * 
 * 
 * @param lower
 * @text 1位必要点数
 * @desc 
 * @type number
 * @default 0
 * 
 * @param uma1_2
 * @text ウマ(2位→1位)
 * @desc 
 * @type number
 * @default 0
 * 
 * @param rounding
 * @text 最終得点の処理
 * @desc 
 * @type select
 * @option そのまま @value 0
 * @option 100の位を五捨六入 @value 1
 * @option 100の位を四捨五入 @value 2
 * @option 1000で割って五捨六入 @value 3
 * @option 1000で割って四捨五入 @value 4
 * @default 0
 * 
 * @param tsumifuRong
 * @text 積み符(ロン)
 * @desc 
 * @type number
 * @default 300
 * 
 * @param tsumifuZimo
 * @text 積み符(自摸)
 * @desc 一人当たりの支払い
 * @type number
 * @default 300
 * 
 * @param leave
 * @text 残す枚数
 * @desc 牌山から次の枚数 自模らず残します
 * @type number
 * @default 60
 * 
 * @param canFulu
 * @text 副露可能
 * @desc ポン、大明槓が可能かを指定します
 * @type boolean
 * @default true
 * 
 * @param canChi
 * @parent canFulu
 * @text チー可能
 * @desc 上記に加えチーが可能かを指定します(上記がOFFの場合無効)
 * @type boolean
 * @default false
 * 
 * @param canGang
 * @text カン可能
 * @desc 大明槓、加槓、暗槓が可能かを指定します
 * @type boolean
 * @default true
 * 
 * 
 */



/*~struct~imgData:
 * 
 * @param majiangpai
 * @text 麻雀牌
 * @desc 
 * @dir img/system
 * @type file
 * @default Majiangpai
 * 
 * @param majiangBackground
 * @text 対局時の背景
 * @desc 指定無しの場合 現在のマップが背景となります
 * @dir img/pictures
 * @type file
 * @default MajiangBackground
 */
 
/*~struct~audioData:
 * 
 * @param dapai
 * @text 打牌時のSE
 * @desc 
 * @type struct<audioSe>
 * @default {"se":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param duijuBgm
 * @text 対局時のBGM
 * @desc 
 * @type struct<audioBgm>
 * @default {"bgm":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param lizhiBgm
 * @text 立直時のBGM(標準)
 * @desc 
 * @type struct<audioBgm>
 * @default {"bgm":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param startDuiju
 * @text 対局開始時のSE
 * @desc 
 * @type struct<audioSe>
 * @default {"se":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param heleMe_hele
 * @text プレイヤー和了時のME
 * @desc 
 * @type struct<audioMe>
 * @default {"me":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param heleMe_mangan
 * @text プレイヤー満貫以上和了時のME
 * @desc 
 * @type struct<audioMe>
 * @default {"me":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param heleMe_haneman
 * @text プレイヤー跳満以上和了時のME
 * @desc 
 * @type struct<audioMe>
 * @default {"me":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param heleMe_baiman
 * @text プレイヤー倍満以上和了時のME
 * @desc 
 * @type struct<audioMe>
 * @default {"me":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param heleMe_sambaiman
 * @text プレイヤー三倍満以上和了時のME
 * @desc 
 * @type struct<audioMe>
 * @default {"me":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param heleMe_yakuman
 * @text プレイヤー役満以上和了時のME
 * @desc 
 * @type struct<audioMe>
 * @default {"me":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * @param victory
 * @text プレイヤー総合一位時のME
 * @desc 
 * @type struct<audioMe>
 * @default {"me":"","volume":"90","pitch":"100","pan":"0"}
 * 
 * 
 * 
 * 
*/

/*~struct~audioBgm:
 * 
 * @param bgm
 * @text 指定のBGM
 * @desc 
 * @dir audio/bgm
 * @type file
 * @default
 * 
 * @param volume
 * @text 音量
 * @desc 
 * @type number
 * @default 90
 * 
 * @param pitch
 * @text ピッチ
 * @desc 
 * @type number
 * @default 100
 * 
 * @param pan
 * @text 位相
 * @desc 
 * @type number
 * @default 0
 */

/*~struct~audioBgs:
 * 
 * @param bgs
 * @text 指定のBGS
 * @desc 
 * @dir audio/bgs
 * @type file
 * @default
 * 
 * @param volume
 * @text 音量
 * @desc 
 * @type number
 * @default 90
 * 
 * @param pitch
 * @text ピッチ
 * @desc 
 * @type number
 * @default 100
 * 
 * @param pan
 * @text 位相
 * @desc 
 * @type number
 * @default 0
 */
 
/*~struct~audioMe:
 * 
 * @param me
 * @text 指定のME
 * @desc 
 * @dir audio/me
 * @type file
 * @default
 * 
 * @param volume
 * @text 音量
 * @desc 
 * @type number
 * @default 90
 * 
 * @param pitch
 * @text ピッチ
 * @desc 
 * @type number
 * @default 100
 * 
 * @param pan
 * @text 位相
 * @desc 
 * @type number
 * @default 0
 */

/*~struct~audioSe:
 * 
 * @param se
 * @text 指定のSE
 * @desc 
 * @dir audio/se
 * @type file
 * @default
 * 
 * @param volume
 * @text 音量
 * @desc 
 * @type number
 * @default 90
 * 
 * @param pitch
 * @text ピッチ
 * @desc 
 * @type number
 * @default 100
 * 
 * @param pan
 * @text 位相
 * @desc 
 * @type number
 * @default 0
 */




 /*~struct~nominateBattler:
 * 
 * @param method
 * @text 指定方法
 * @desc いずれかを選択し 対象の項目を設定してください
 * @type select
 * @option 直接指定 @value actorId
 * @option テーブルから指定 @value table
 * @option 変数で指定 @value variable
 * @option パーティーで指定 @value party
 * @option パーティーの中から抽選 @value randomParty
 * @option 空席(二、三人麻雀用) @value empty
 * @default actorId
 * 
 * @param actorId
 * @text [直接指定] 対象のアクター
 * @desc 「直接指定」選択時のみ. 必ず雀士登録をしたアクターを選択してください
 * @type actor
 * @default 0
 * 
 * @param table
 * @text [テーブルから指定] 対象の雀士リスト名
 * @desc 「テーブルから指定」選択時のみ. 雀士リストからランダムで選択します
 * @type string
 * @default 
 * 
 * @param variable
 * @text [変数で指定] 指定変数
 * @desc 「変数で指定」選択時のみ. アクターIDが入った変数を指定してください
 * @type variable
 * @default 0
 * 
 * @param party
 * @text [パーティで指定] パーティメンバーインデックス
 * @desc 「パーティで指定」選択時のみ. パーティメンバーn番目を対局者として選出します
 * @type select
 * @option パーティーリーダー @value 0
 * @option パーティー2番目のアクター @value 1
 * @option パーティー3番目のアクター @value 2
 * @option パーティー4番目のアクター @value 3
 * @option パーティー5番目のアクター @value 4
 * @option パーティー6番目のアクター @value 5
 * @option パーティー7番目のアクター @value 6
 * @option パーティー8番目のアクター @value 7
 * @default 0
 */
 
 
 
/*~struct~gamerule:
 * 
 * @param match
 * @text 対局形式
 * @desc 
 * @type select
 * @option 東風戦 @value 0
 * @option 半荘戦 @value 1
 * @option 一荘戦 @value 2
 * @option オプションで選択(初期値:東風) @value 10
 * @option オプションで選択(初期値:半荘) @value 11
 * @option オプションで選択(初期値:一荘) @value 12
 * @default 11
 * 
 * @param dora
 * @text ドラの採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 1
 * 
 * @param akadora
 * @text 赤ドラの採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 11
 * 
 * @param kuiduan
 * @text 喰いタンの採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 11
 * 
 * @param liangfan
 * @text 二翻縛りの採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 0
 * 
 * @param tobi
 * @text 飛び終了の採用
 * @desc 0点ジャストは続行になります
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 1
 * 
 * @param kuigae
 * @text 喰い替え禁止の採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 0
 * 
 * @param nagashiMangan
 * @text 流し満貫の採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 1
 * 
 * @param sanjiahe
 * @text 三家和流局の採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 0
 * 
 * @param sijiaLizhi
 * @text 四家立直流局の採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 1
 * 
 * @param jiuzhongJiupai
 * @text 九種九牌の採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 1
 * 
 * @param atamahane
 * @text 頭ハネの採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 0
 * 
 * @param aotenjo
 * @text 青天井ルールの採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 0
 * 
 * @param funashi
 * @text 符なしルールの採用
 * @desc 
 * @type select
 * @option 採用 @value 1
 * @option 不採用 @value 0
 * @option オプションで選択(初期値:採用) @value 11
 * @option オプションで選択(初期値:不採用) @value 10
 * @default 0
 */
 
/*~struct~settings:
 * 
 * @param liangfengFu
 * @text 連風牌の符
 * @desc 
 * @type number
 * @default 4
 * 
 * @param akadoraPieces
 * @text 赤ドラの枚数
 * @desc 赤ドラを採用する場合の枚数. 筒子、萬子、索子の順に追加されます
 * @type number
 * @default 3
 * 
 * @param akadoraPiecesSamma
 * @text 赤ドラの枚数(三麻)
 * @desc 三麻で赤ドラを採用する場合の枚数. 筒子、索子の順に追加されます
 * @type number
 * @default 2
 * 
 * @param maxYakuman
 * @text 役満の最大数
 * @desc 0で無制限
 * @type number
 * @default 0
 * 
 * @param nagashiManganPoint
 * @text 流し満貫の点数
 * @desc 
 * @type select
 * @option 満貫 @value mangan
 * @option 跳満 @value haneman
 * @option 倍満 @value baiman
 * @option 三倍満 @value sambaiman
 * @option 役満 @value yakuman
 * @default mangan
 * 
 * @param liangfanHomba
 * @text 二翻縛り採用時の適用本場数
 * @desc 標準ゲームルールにおいて二翻縛りが採用の時 指定の本場以降二翻縛りが適用されます
 * @type number
 * @default 0
 * 
 * @param siqidui
 * @text 七対子に4枚使いを認める
 * @desc 
 * @type boolean
 * @default false
 * 
 * @param guoshiFuZimo
 * @text 国士無双の符(自摸時)
 * @desc 国士無双が役満以外に設定されている場合使用します
 * @type number
 * @default 25
 * 
 * @param guoshiFuRong
 * @text 国士無双の符(ロン時)
 * @desc 国士無双が役満以外に設定されている場合使用します
 * @type number
 * @default 25
 * 
 * @param adoptQiduizi
 * @text 七対子を役として不採用の時 七対子を和了型として採用する
 * @desc 
 * @type boolean
 * @default true
 * 
 * @param adoptQianggang
 * @text 槍槓を役として不採用の時 槍槓和了りを可能にする
 * @desc 
 * @type boolean
 * @default true
 * 
 * @param tsumifuKamijia
 * @text 積み棒の点数は上家取り
 * @desc 
 * @type boolean
 * @default true
 */

/*~struct~heleAnimation:
 * 
 * @param hele
 * @text 通常
 * @desc 
 * @type animation
 * @default 0
 * 
 * @param mangan
 * @text 満貫以上和了時
 * @desc 
 * @type animation
 * @default 0
 * 
 * @param haneman
 * @text 跳満以上和了時
 * @desc 
 * @type animation
 * @default 0
 * 
 * @param baiman
 * @text 倍満以上和了時
 * @desc 
 * @type animation
 * @default 0
 * 
 * @param sambaiman
 * @text 三倍満以上和了時
 * @desc 
 * @type animation
 * @default 0
 * 
 * @param yakuman
 * @text 役満以上和了時
 * @desc 
 * @type animation
 * @default 0
 */

/*~struct~params:
 * 
 * 
 * @param dongjiaTextColor
 * @text 東家の表示文字色
 * @desc 東家の文字を指定の色で表示します
 * @type color
 * @default 1
 * 
 * @param abstentionSwitch
 * @text 中断判定スイッチ
 * @desc 対局中 キャンセルボタンにより中断された場合 次のスイッチをONにします
 * @type switch
 * @default 0
 * 
 * @param echoDora
 * @text 和了リザルトでのドラ牌の表示
 * @desc 
 * @type boolean
 * @on 現物を表示
 * @off ドラ表示牌を表示
 * @default true
 * 
 * @param setDoraColor
 * @text ドラ牌の強調表示を行う
 * @desc ドラ牌に対しカラーフィルターを設定します
 * @type boolean
 * @default true
 * 
 * @param doraColor
 * @parent setDoraColor
 * @text ドラ牌の色
 * @desc 上記がONの場合 カラーフィルターを指定してください
 * @type struct<color>
 * @default {"colorR":"255","colorG":"255","colorB":"0","opacity":"64"}
 * 
 * @param tingpaiMachiWindow
 * @text 待ち牌ウィンドウを表示する
 * @desc 自家が聴牌したとき 全ての待ち牌を表示するウィンドウを表示します
 * @type select
 * @option 表示しない @value 0
 * @option 常に表示 @value 1
 * @option 打牌選択中のみ表示 @value 2
 * @default 1
 * 
 * @param tajiaPaiWidth
 * @text 牌の表示横幅(ピクセル)
 * @desc 
 * @type number
 * @default 24
 * 
 * @param paiWidth
 * @text 手牌の表示横幅(ピクセル)
 * @desc 
 * @type number
 * @default 36
 * 
 * @param resultPaiWidth
 * @text 和了リザルトでの牌の表示横幅(ピクセル)
 * @desc 0で文字幅に合わせます
 * @type number
 * @default 0
 * 
 * @param zhuoPadding
 * @text 雀卓のパディング(ピクセル)
 * @desc 
 * @type number
 * @default 48
 * 
 * @param zhuoVartMargin
 * @text 雀卓の垂直マージン(ピクセル)
 * @desc 
 * @type number
 * @default 0
 * 
 * @param zhuoHorzMargin
 * @text 雀卓の水平マージン(ピクセル)
 * @desc 
 * @type number
 * @default 0
 * 
 * @param heCols
 * @text 河の列数
 * @desc 
 * @type number
 * @default 6
 * 
 * @param heRows
 * @text 河の最大行数
 * @desc 最大行数を超過した牌は 改行されず最大列数を越えて横に並べられます
 * @type number
 * @default 3
 * 
 * @param fontSize
 * @text 文字の大きさ
 * @desc 0でシステム設定の値を参照します
 * @type number
 * @default 0
 * 
 * @param lineHeight
 * @text 一行の高さ
 * @desc 0で初期値
 * @type number
 * @default 0
 * 
 * @param zijaFuluOffset
 * @text 自家副露エリアのオフセット
 * @desc 指定ピクセル 自家の副露,暗槓の置き場所を左にずらします
 * @type number
 * @default 0
 * 
 * @param drawFace
 * @text 対局画面にアクターの画像を表示する
 * @desc 
 * @type boolean
 * @default true
 * 
 * @param nameBox
 * @text メッセージウィンドウの名前表示
 * @desc メッセージウィンドウの上部に発声者の名前を表示します
 * @type select
 * @option 表示しない @value 0
 * @option 名前を表示 @value 1
 * @option 自風と名前を表示 @value 2
 * @default 1
 * 
 * @param wait
 * @text 対局開始時等の待機時間(フレーム)
 * @desc 
 * @type number
 * @default 30
 * 
 * @param zimoWait
 * @text 自摸から打牌開始までの待機時間(フレーム)
 * @desc 
 * @type number
 * @default 5
 * 
 * @param dapaiWait
 * @text 打牌後等の待機時間(フレーム)
 * @desc 
 * @type number
 * @default 10
 * 
 * @param messageWait
 * @text メッセージの表示時間(フレーム)
 * @desc 
 * @type number
 * @default 60
 * 
 * @param linesWait
 * @text セリフの表示時間(フレーム)
 * @desc 
 * @type number
 * @default 60
 * 
 * @param tehaiCanRepeat
 * @text 決定キー長押しで自摸切りする
 * @desc 
 * @type boolean
 * @default false
 * 
 * @param backGroundFilter
 * @text 背景マップの処理
 * @desc 背景画像が指定されていない場合に背景に表示するマップの処理を指定します
 * @type select
 * @option そのまま @value 0
 * @option 暗くする @value 1
 * @option 暗くしてぼかす @value 2
 * @default 0
 * 
 * @param sceneEffect
 * @text 対局開始 / 終了時のエフェクト
 * @desc 
 * @type select
 * @option 何もしない @value 0
 * @option フェードアウト/フェードイン @value 1
 * @option バトルと同じ @value 2
 * @default 1
 * 
 * @param limited
 * @text システムデータに干渉しない
 * @desc この項目をONにすると 当プラグインでのデータが変数を除きセーブされません. 競合対策等に
 * @type boolean
 * @default false
 * 
 * @param actorInstantiation
 * @text アクターデータ節減機能を使用しない
 * @desc 
 * @type boolean
 * @default false
 */
 


/*~struct~duijuResult:
 * 
 * @param rank_0
 * @text プレイヤーの順位
 * @desc 
 * @type variable
 * @default 0
 * 
 * @param rank_1
 * @text 下家の順位
 * @desc ランダム席順が有効な場合 変更前の席のアクターが対象になります
 * @type variable
 * @default 0
 * 
 * @param rank_2
 * @text 対面の順位
 * @desc ランダム席順が有効な場合 変更前の席のアクターが対象になります
 * @type variable
 * @default 0
 * 
 * @param rank_3
 * @text 上家の順位
 * @desc ランダム席順が有効な場合 変更前の席のアクターが対象になります
 * @type variable
 * @default 0
 * 
 * @param actor_0
 * @text 自家のアクターID
 * @desc ランダム席順が有効な場合 変更前の席のアクターが対象になります
 * @type variable
 * @default 0
 * 
 * @param actor_1
 * @text 下家のアクターID
 * @desc ランダム席順が有効な場合 変更前の席のアクターが対象になります
 * @type variable
 * @default 0
 * 
 * @param actor_2
 * @text 対面のアクターID
 * @desc ランダム席順が有効な場合 変更前の席のアクターが対象になります
 * @type variable
 * @default 0
 * 
 * @param actor_3
 * @text 上家のアクターID
 * @desc ランダム席順が有効な場合 変更前の席のアクターが対象になります
 * @type variable
 * @default 0
 * 
 * @param point_0
 * @text プレイヤーの最終得点
 * @desc 
 * @type variable
 * @default 0
 * 
 * @param point_1
 * @text 下家の最終得点
 * @desc 
 * @type variable
 * @default 0
 * 
 * @param point_2
 * @text 対面の最終得点
 * @desc 
 * @type variable
 * @default 0
 * 
 * @param point_3
 * @text 上家の最終得点
 * @desc 
 * @type variable
 * @default 0
 * 
 * @param hele
 * @text プレイヤーが和了った回数
 * @desc 
 * @type variable
 * @default 0
 * 
 * @param yakuman
 * @text プレイヤーが役満を和了った回数
 * @desc 
 * @type variable
 * @default 0
 * 
 * @param fangchong
 * @text プレイヤーが放銃した回数
 * @desc 
 * @type variable
 * @default 0
*/


/*~struct~color:
 * 
 * 
 * @param colorR
 * @text 赤の強さ
 * @desc 
 * @type number
 * @max 255
 * @default 0
 * 
 * @param colorG
 * @text 緑の強さ
 * @desc 
 * @type number
 * @max 255
 * @default 0
 * 
 * @param colorB
 * @text 青の強さ
 * @desc 
 * @type number
 * @max 255
 * @default 0
 * 
 * @param opacity
 * @text 色の不透明度
 * @desc 
 * @type number
 * @max 255
 * @default 0
 *
 */



const $dataMajiangSystem = {};
const $dataMajiangBattlers = [];


let $gameMajiangSystem = null;
let $gameMajiangPaishan = null;
let $gameMajiangBattlers = null;
const $gameMajiangCPU = {};



(function() 
{
	"use strict";
	
	
	const P_name = decodeURIComponent(document.currentScript.src).match(/([^\/]+)\.js$/)[1]; //プラグイン名
	
	const GP = PluginManager.parameters(P_name);
	
	
	const PF_parseObject = function(string)
	{
		
		const data = JSON.parse(string || "{}");
		for (const key in data)
		{
			if(data[key] === "true" || data[key] === "false")
			{
				data[key] = (data[key] === "true");
			}
			else if (!isNaN(data[key]))
			{
				data[key] = Number(data[key]);
			}
			
		}
		return data;
	}
	
	
	
	
	
	const PF_parseColor = function(string)
	{
		const data = JSON.parse(string || "{}");
		const ret = [];
		for (const key of ["colorR","colorG","colorB","opacity"])
		{
			ret.push(Number(data[key]) || 0);
		}
		return ret;
	}
	
	$dataMajiangSystem.temp = {};
	
	$dataMajiangSystem.gamerule = PF_parseObject(GP.gamerule);
	
	$dataMajiangSystem.scoreSettings = PF_parseObject(GP.scoreSettings);
	
	$dataMajiangSystem.scoreSettingsSamma = PF_parseObject(GP.scoreSettingsSamma);
	
	$dataMajiangSystem.duoSettings = PF_parseObject(GP.duoSettings);
	
	$dataMajiangSystem.settings = PF_parseObject(GP.settings);
	
	$dataMajiangSystem.params = PF_parseObject(GP.params);
	
	
	$dataMajiangSystem.heleAnimation = PF_parseObject(GP.heleAnimation);
	
	
	
	
	
	
	
	
	(() =>
	{
		$dataMajiangSystem.basicUnitName = "basic";
		
		$dataMajiangSystem.imagePaiWidth = 48;
		$dataMajiangSystem.imagePaiHeight = 64;
		
		const paiWidth = $dataMajiangSystem.params.paiWidth;
		$dataMajiangSystem.paiWidth = paiWidth; //36;
		$dataMajiangSystem.paiHeight = paiWidth / 0.75 ; //48;
		
		const tajiaPaiWidth = $dataMajiangSystem.params.tajiaPaiWidth;
		$dataMajiangSystem.tajiaPaiWidth = tajiaPaiWidth; //24;
		$dataMajiangSystem.tajiaPaiHeight = tajiaPaiWidth / 0.75; //32;
		
		$dataMajiangSystem.zimoSpacing = paiWidth / 3;
		
		$dataMajiangSystem.paiSpacing = tajiaPaiWidth / 4;
		
		$dataMajiangSystem.lizhiboWidth = tajiaPaiWidth / 0.375 ; // 64
		
		$dataMajiangSystem.lizhiboHeight = $dataMajiangSystem.lizhiboWidth / 8;
		
		for(const colorSetting of ["doraColor"])
		{
			$dataMajiangSystem.params[colorSetting] = PF_parseColor($dataMajiangSystem.params[colorSetting]);
		}
		
	})();
	
	const PF_makeMajiangPaiCode = function()
	{
		const paicode = [];
		for(let type = 0; type < 4 ; type++)
		{
			for(let value = 1; value <= 9 ; value++)
			{
				if(type === 3 && value >= 8) break;
				paicode.push(type * 10 + value);
			}
		}
		return paicode;
	}
	
	$dataMajiangSystem.allPaicode = PF_makeMajiangPaiCode();
	
	
	const PF_makeMajiangPaiData = function() 
	{
		const pai = [null];
		
		let index = 1;
		
		for(const code of $dataMajiangSystem.allPaicode)
		{
			for(var i = 0 ; i < 4 ; i++ )
			{
				pai.push({"id" : index, "code" : code });
				index++;
			}
		}
		
		return pai;
	};
	
	$dataMajiangSystem.paiData = PF_makeMajiangPaiData();
	
	
	const PF_parseAudio = function(string)
	{
		const ret = {};
		ret.data = {};
		const data = JSON.parse(string || "{}");
		const nameKeys = ["bgm","bgs","me" ,"se"];
		for(const k in data)
		{
			const keyIndex = nameKeys.indexOf(k);
			if(keyIndex !== -1)
			{
				ret.kind = nameKeys[keyIndex];
				ret.data.name = data[nameKeys[keyIndex]];
			}
			else
			{
				ret.data[k] = Number(data[k]);
			}
		}
		ret.enabled = !!ret.data.name;
		return ret;
	}
	
	
	const PF_parseAudioData = function(string)
	{
		const gp = JSON.parse(string || "{}")
		const ret = {};
		
		for (const key in gp)
		{
			ret[key] = PF_parseAudio(gp[key]);
			
		}
		return ret;
	}
	
	
	$dataMajiangSystem.audioData = PF_parseAudioData(GP.audioData);
	
	
	$dataMajiangSystem.imgData = JSON.parse(GP.imgData || "{}");
	
	if($dataMajiangSystem.params.sceneEffect)
	{
		const _Scene_Map_stop = Scene_Map.prototype.stop;
		Scene_Map.prototype.stop = function() 
		{
			_Scene_Map_stop.apply(this,arguments);
			
			if(SceneManager.isNextScene(Scene_MajiangBattle))
			{
				if($dataMajiangSystem.params.sceneEffect === 1)
				{
					this.startFadeOut(this.fadeSpeed(), false);
				}
        		else if($dataMajiangSystem.params.sceneEffect === 2)
        		{
					this.launchBattle();
				}
			}
		};
		
		const _Scene_Map_update = Scene_Map.prototype.update;
		Scene_Map.prototype.update = function() 
		{
        	_Scene_Map_update.apply(this,arguments);
			if(!this.isSceneChangeOk()
				&& SceneManager.isNextScene(Scene_MajiangBattle)
        	)
			{
				this.updateEncounterEffect();
			}
		};
		const _Scene_Map_needsFadeIn = Scene_Map.prototype.needsFadeIn;
		Scene_Map.prototype.needsFadeIn = function() 
		{
			return (_Scene_Map_needsFadeIn.apply(this,arguments)
				||  SceneManager.isPreviousScene(Scene_MajiangBattle)
    		);
		};
	}
	
	
	const PF_parseBattler = function(string)
	{
		const ret = [];
		const data = JSON.parse(string || "[]");
		for (const d of data)
		{
			
			const b = JSON.parse(d || "{}");
			b.actorId = Number(b.actorId);
			b.lines = JSON.parse(b.lines ||"{}");
			for(const linesKey in b.lines)
			{
				b.lines[linesKey] = JSON.parse(b.lines[linesKey] || "[]");
			}
			b.cpuSettings = JSON.parse(b.cpuSettings || "{}");
			for(const csKey in b.cpuSettings)
			{
				switch(csKey)
				{
					case "traits" : 
						b.cpuSettings[csKey] = PF_parseObject(b.cpuSettings[csKey]);
					break;
					case "yaku" : 
						b.cpuSettings[csKey] = JSON.parse(b.cpuSettings[csKey] || "[]");
						b.cpuSettings[csKey] = b.cpuSettings[csKey].map(y =>
						{
							return PF_parseObject(y);
						});
						
					break;
					
					default:
						b.cpuSettings[csKey] = Number(b.cpuSettings[csKey]);
					break;
				}
			}
			
			b.heleAnimation = PF_parseObject(b.heleAnimation);
			
			
			
			const cpuConfiguration = JSON.parse(b.cpuConfiguration || "{}");
			
			b.unitName = cpuConfiguration.unitName || $dataMajiangSystem.basicUnitName;
			
			b.cpuClass = cpuConfiguration.cpuClass;
			
			b.note ??= "";
			
			DataManager.extractMetadata(b);
			
			ret.push(b)
		}
		return ret;
	}
	
	$dataMajiangBattlers.push(...PF_parseBattler(GP.battlerData));
	
	(() =>
	{
		$dataMajiangBattlers.forEach(b =>
		{
			const lizhiBgm = PF_parseAudio(b.lizhiBgm);
			const lizhiBgmKey = "actorLizhi_" + b.actorId;
			$dataMajiangSystem.audioData[lizhiBgmKey] = lizhiBgm;
			
			const voiceLines = JSON.parse(b.voiceLines || "{}");
			
			for(const vlKey in voiceLines)
			{
				const vlArray = JSON.parse(voiceLines[vlKey] || "[]");
				vlArray.forEach(function(vl,i)
				{
					const data = PF_parseAudio(vl);
					const key = "voiceLines_%1_%2_%3".format(b.actorId,vlKey,i);
					$dataMajiangSystem.audioData[key] = data;
				});
			}
		})
	})();
	
	
	
	const PF_parseBattlerTable = function(string)
	{
		const ret = [];
		const data = JSON.parse(string || "[]");
		for (const table of data)
		{
			const d = JSON.parse(table || "{}");
			d.actors = JSON.parse(d.actors || "[]").map(v => Number(v));
			ret.push(d);
		}
		return ret;
	}
	
	
	$dataMajiangSystem.battlerTable = PF_parseBattlerTable(GP.battlerTable);
	
	const PF_parseYakuData = function(string)
	{
		const d = JSON.parse(string || "{}");
		//d.code = key;
		d.adopt = (d.adopt === "true");
		d.fan = Number(d.fan);
		d.fuluJian = (d.fuluJian === "true");
		return d;
	}
	
	const PF_parseAllYakudata = function(string)
	{
		const ret = {};
		const data = JSON.parse(string || "{}");
		
		for (const key in data)
		{
			ret[key] = PF_parseYakuData(data[key]);
		}
		return ret;
	}
	
	
	$dataMajiangSystem.yakuData = PF_parseAllYakudata(GP.yakuData);
	
	const PF_parseText = function(string)
	{
		return JSON.parse(string || "{}");
	}
	
	$dataMajiangSystem.text = PF_parseText(GP.text);
	
	$dataMajiangSystem.duijuResult = PF_parseObject(GP.duijuResult);
	
	
	
	
	$dataMajiangSystem.gameruleTable = {
		"match" : {statusText : ["dongfeng","banzhuang","yizhuang"]} , 
		"akadora" : {statusText : ["reject","adopt"]} , 
		"kuiduan" : {statusText : ["reject","adopt"]} , 
		"liangfan" : {statusText : ["reject","adopt"]} , 
		"dora" : {statusText : ["reject","adopt"]} , 
		"nagashiMangan" : {statusText : ["reject","adopt"]} , 
		"sanjiahe" : {statusText : ["reject","adopt"]} , 
		"sijiaLizhi" : {statusText : ["reject","adopt"]} , 
		"jiuzhongJiupai" : {statusText : ["reject","adopt"]} , 
		"atamahane" : {statusText : ["reject","adopt"]} , 
		"aotenjo" : {statusText : ["reject","adopt"]} , 
		"funashi" : {statusText : ["reject","adopt"]} , 
		"tobi" : {statusText : ["reject","adopt"]},
		"kuigae" : {statusText : ["reject","adopt"]}
	};
	
	
	
	const MajiangSystemManager = {};
	
	MajiangSystemManager.loadData = function()
	{
		if($dataMajiangSystem.params.limited)
		{
			return this.tempData();
		}
		else
		{
			return this.systemData();
		}
	};
	MajiangSystemManager.systemData = function()
	{
		if(!$gameSystem.majiangData())
		{
			$gameSystem.majiangDataInitialize();
		}
		return $gameSystem.majiangData();
	};
		
	MajiangSystemManager.tempData = function()
	{
		if(!this._data)
		{
			this._data = {};
		}
		return this._data;
	};
	
	MajiangSystemManager.data = function(dirKey)
	{
		const data = this.loadData();
		if(!data[dirKey])
		{
			data[dirKey] = {};
		}
		return data[dirKey];
	};
	
	MajiangSystemManager.setData = function(dirKey,setData)
	{
		const data = this.loadData();
		if(!data[dirKey])
		{
			data[dirKey] = {};
		}
		data[dirKey] = setData;
	};
	
	MajiangSystemManager.clear = function(dirKey)
	{
		const data = this.loadData();
		
		data[dirKey] = {};
	}
	
	if(!$dataMajiangSystem.params.limited)
	{
		const _Game_System_initialize = Game_System.prototype.initialize;
		Game_System.prototype.initialize = function()
		{
			_Game_System_initialize.apply(this,arguments);
			this.majiangDataInitialize();
		};
		
		Game_System.prototype.majiangDataInitialize = function()
		{
			this._majiangData = {};
		};
		
		Game_System.prototype.majiangData = function()
		{
			return this._majiangData;
		};
	}
	
	
	
	
	
	class Game_MajiangSystem
	{
		constructor()
		{
			this.clear();
			this.config = {};
			this.setGamerule();
			this.setParameterData();
			this.setupShuzi();
			this.clearStack();
			this._prevScene = null;
			this._terminationFunc = [];
			this._inBattle = false;
		}
		clear()
		{
			
			this._error = [];
			this._actorId = [];
			this._gpPosition = null;
			this.condition = {};
			this._samma = false;
			this._duo = false;
			this._numBattlers = 4;
			this._emptyPositions = [];
			this.clearTempActorData();
		}
		
		setGamerule()
		{
			this.gamerule = {};
			for(const key in $dataMajiangSystem.gamerule)
			{
				Object.defineProperty(this.gamerule, key , {get : () => this.queryGamerule(key)});
   			}
		}
		
		queryGamerule(key)
		{
			const data = this.queryGamerule2(key);
			return data % 10;
		}
		
		queryGamerule2(key)
		{
			return (
				MajiangSystemManager.data("tempGamerule")[key]
				?? MajiangSystemManager.data("gamerule")[key]
				?? $dataMajiangSystem.gamerule[key]
			);
		}
		gameruleSelectDisabled(key)
		{
			return (MajiangSystemManager.data("tempGamerule")[key] >= 20);
		}
		gameruleOperable(key)
		{
			const data =  MajiangSystemManager.data("gamerule")[key] ?? $dataMajiangSystem.gamerule[key];
			return (data >= 10);
		}
		loadSystemData(key)
		{
			return MajiangSystemManager.data(key);
		}
		
		setParameterData()
		{
			const dirKeys = ["settings","scoreSettings","scoreSettingsSamma","duoSettings","yakuData","audioData","imgData"];
			for(const dirKey of dirKeys)
			{
				this[dirKey] = {};
				for(const key in $dataMajiangSystem[dirKey])
				{
					Object.defineProperty(this[dirKey], key , {get : () => this.queryParameter(dirKey,key)});
   				}
   			}
		}
		
		queryParameter(dirKey,key)
		{
			const system = MajiangSystemManager.data(dirKey);
			const origin = $dataMajiangSystem[dirKey];
			const variableId = system[key + "_variable"] ?? origin[key + "_variable"];
			if(variableId)
			{
				return $gameVariables.value(variableId);
			}
			const switchId = system[key + "_switch"] ?? origin[key + "_switch"];
			if(switchId)
			{
				return $gameSwitches.value(switchId);
			}
			
			return system[key] ?? origin[key];
		}
		
		setConfig(key,value)
		{
			this.loadSystemData("config")[key] = value;
			this.refreshConfig();
		}
		
		refreshConfig()
		{
			const system = this.loadSystemData("config");
			for(const key of Object.keys(system))
			{
				if(!this.config.hasOwnProperty(key))
				{
					Object.defineProperty(this.config, key , {get : () => {return this.loadSystemData("config")[key]}});
				}
			}
			
		}
		
		inBattle()
		{
			return this._inBattle;
		}
		
		parseNominateBattler(string)
		{
			if(isNaN(string))
			{
				const data = JSON.parse(string || "{}");
				switch(data.method)
				{
					case "actorId" : return [Number(data.actorId)];
					case "table" : 
						const table = $dataMajiangSystem.battlerTable.find(t => t.name === data.table);
						if(table)
						{
							return table.actors;
						}
						else
						{
							this.addError("table",data.table);
							return [0];
						}
					case "variable" : return [$gameVariables.value(Number(data.variable))];
					case "party" : return [$gameParty.members()[Number(data.party)]?.actorId() || 0];
					case "randomParty" : return $gameParty.members().map(b => b.actorId());
					case "empty" : return [0];
				}
			}
			return [Number(string)] || [0];
		}
		
		lotActor(data)
		{
			const ret = [];
			for(const battlers of data)
			{
				let actors = battlers.filter(a => !ret.includes(a));
				if(actors.length === 0)
				{
					actors = battlers;
				}
				ret.push(actors[Math.randomInt(actors.length)]);
			}
			
			return ret;
		}
		
		checkActorId(actorArray)
		{
			let emptyCount = 0;
			for(let i = 0; i < 4 ; i++)
			{
				let actorId = actorArray[i];
				
				if(actorId > 0 && !$dataMajiangBattlers.find(b => {return [0,actorId].includes(b.actorId)}))
				{
					this.addError("actor",actorId);
				}
				if(!actorId) 
				{
					emptyCount++;
				}
			}
			if(emptyCount > 2)
			{
				this.addError("empty");
			}
			this.setBattlerNum(emptyCount);
		}
		
		setBattlerNum(emptyCount)
		{
			if(emptyCount === 1)
			{
				this._numBattlers = 3;
				this._samma = true;
			}
			else if(emptyCount === 2)
			{
				this._numBattlers = 2;
				this._duo = true;
			}
		}
		
		
		
		
		numBattlers()
		{
			return this._numBattlers;
		}
		
		samma()
		{
			return this._samma;
		}
		duo()
		{
			return this._duo;
		}
		
		setEmptyPositions(positions)
		{
			this._emptyPositions = positions;
		}
		checkPosition(position)
		{
			return !this._emptyPositions.includes(position);
		}
		
		emptyPositions()
		{
			return this._emptyPositions;
		}
		
		gpPosition(position)
		{
			if(this._gpPosition)
			{
				return this._gpPosition[position];
			}
			return position;
		}
		parseBattlers(args)
		{
			const ret = [];
			for(const position of ["zijia","shimojia","duimian","kamijia"])
			{
				ret.push(this.parseNominateBattler(args[position]));
			}
			return this.lotActor(ret);
		}
		
		
		setCondition(zijia,shimojia,duimian,kamijia,randomPosition,dealerPosition,match,abstention)
		{
			this.clear();
			this._actorId.push(zijia);
			this._actorId.push(shimojia);
			this._actorId.push(duimian);
			this._actorId.push(kamijia);
			
			this.checkActorId(this._actorId);
			
			for(let i = 0; i < 4 ; i++)
			{
				this.setResult("actor_" + i , this._actorId[i])
			}
			
			if(this.duo())
			{
				this.setDuoPosition();
			}
			else if(randomPosition)
			{
				this.randomPosition();
			}
			
			
			this.setEmpty();
			
			
			
			this.condition.dealerPosition = dealerPosition;
			
			
			this.condition.match = match;
			if(this.condition.match === -1)
			{
				this.condition.match = this.gamerule.match;
			}
			
			this.condition.abstention = abstention;
		}
		
		randomPosition()
		{
			const ret = [];
			let temp = [0,1,2,3];
			ret.push(temp.shift());
			for(let i = 0; i < 3 ; i++ )
			{
				ret.push(temp.splice(Math.randomInt(temp.length),1)[0]);
			}
			this._gpPosition = ret;
			
			this._actorId = ret.map(v => this._actorId[v]);
		}
		setDuoPosition()
		{
			const opponentId = this._actorId.find(function(id,i)
			{
				return (i !== 0 && id !== 0);
			});
			const gpIndex = this._actorId.indexOf(opponentId);
			if(gpIndex !== 2)
			{
				this._gpPosition = [0,-1,gpIndex,-1];
				
				this._actorId[1] = 0;
				this._actorId[3] = 0;
				this._actorId[2] = opponentId;
			}
			
		}
		setEmpty()
		{
			const empty = [];
			for(let i = 0; i < 4 ; i++ )
			{
				if(this._actorId[i] === 0)
				{
					empty.push(i);
					if(i === 0)
					{
						this.addError("emptyZijia");
					}
				}
			}
			this.setEmptyPositions(empty);
			
		}
		
		actorId()
		{
			return this._actorId;
		}
		
		
		shuzi(value)
		{
			return this._shuzi.output(value);
		}
		
		start()
		{
			this.refreshConfig();
			this.clearTempResult();
			this.clearResultVariable();
			this._inBattle = true;
		}
		
		clearTempResult()
		{
			this._tempResult = {};
			
			this._tempYakuResult = {};
			
			for(const key in $dataMajiangSystem.duijuResult)
			{
				this._tempResult[key] = 0;
			}
			for(const key in $dataMajiangSystem.yakuData)
			{
				this._tempYakuResult[key] = 0;
			}
		}
		
		clearResultVariable()
		{
			for(const key in $dataMajiangSystem.duijuResult)
			{
				const varId = $dataMajiangSystem.duijuResult[key];
				if(varId)
				{
					$gameVariables.setValue(varId,0);
				}
			}
		}
		clearYakuResultVariable()
		{
			for(const key in $dataMajiangSystem.yakuData)
			{
				const varId = $dataMajiangSystem.yakuData[key].countVariable;
				if(varId)
				{
					$gameVariables.setValue(varId,0);
				}
			}
		}
		
		addResult(key,value = 1)
		{
			this.setResult(key,this._tempResult[key] + value);
		}
		setResult(key,value)
		{
			this._tempResult[key] = value;
		}
		addYakuResult(key,value = 1)
		{
			this._tempYakuResult[key] += value;
		}
		engraveResult()
		{
			for(const key in $dataMajiangSystem.duijuResult)
			{
				const varId = $dataMajiangSystem.duijuResult[key];
				if(varId)
				{
					const value = this._tempResult[key];
					$gameVariables.setValue(varId,value);
				}
			}
			
			for(const key in $dataMajiangSystem.yakuData)
			{
				const varId = $dataMajiangSystem.yakuData[key].countVariable;
				if(varId)
				{
					const value = this._tempYakuResult[key] + $gameVariables.value(varId);
					$gameVariables.setValue(varId,value);
				}
			}
		}
		terminate()
		{
			this.clearTempResult();
			this.clear();
			this.clearStack();
			this._inBattle = false;
		}
		clearStack()
		{
			this._stack = [];
		}
		
		stack()
		{
			return this._stack;
		}
		pushStack(args)
		{
			const stack = {};
			stack.peipai = [];
			stack.zimo = [];
			stack.reserve = [];
			for(let i = 0; i < 4 ; i++)
			{
				stack.peipai[i] = this.parseStackPaizi(args["peipai_" + i],13);
				stack.reserve.push(...stack.peipai[i]);
				
				stack.zimo[i] = this.parseStackPaizi(args["zimo_" + i],27);
				stack.reserve.push(...stack.zimo[i]);
			}
			stack.echoDora = this.parseStackPaizi(args.echoDora,5);
			stack.echoUradora = this.parseStackPaizi(args.echoUradora,5);
			stack.reserve.push(...stack.echoDora,stack.echoUradora);
			stack.reserve = stack.reserve.filter(v => v && v >= 1 && v <= 37);
			
			this._stack.push(stack);
		}
		
		loadStack()
		{
			return this._stack.shift();
		}
		
		parseStackPaizi(string,num)
		{
			const ret = [];
			const argsPaizi = string.split(",");
			for(let i = 0; i < num; i++)
			{
				ret[i] = (argsPaizi[i]) ? Number(argsPaizi[i]) : 0;
			}
			return ret;
		}
		
		addError(type,value)
		{
			this._error.push({"type": type , "value" : value});
		}
		
		makeErrorText()
		{
			let text = "エラー 麻雀を開始できません";
			for(const error of this._error)
			{
				text += "\n";
				const errorText = this.errorText(error.type);
				text += errorText.format(error.value);
			}
			return text;
		}
		
		errorText(type)
		{
			switch(type)
			{
				case "actor" :
					return "次のIDのアクターの雀士データが見つかりません [ %1 ]";
				break;
				case "table" : 
					return "次の名前の雀士リストが見つかりません [ %1 ]";
				break;
				case "empty" :
					return "空席の数が多すぎます";
				break;
				case "emptyZijia" :
					return "自家が空席です";
				break;
			}
			return "";
		}
		
		gotError()
		{
			return (this._error.length !== 0);
		}
		echoError()
		{
			const text = this.makeErrorText();
			$gameMessage.add(text);
			this.terminate();
		}
		echo(...args)
		{
			
			let text = ""
			args.forEach(function(t,i)
			{
				if(i !== 0)
				{
					text += "\n";
				}
				text += t;
			});
			console.log(text);
		}
		loadMajiangPai()
		{
			const img = (this.inBattle()) ? this.imgData.majiangpai : $dataMajiangSystem.imgData.majiangpai;
			return ImageManager.loadSystem(img);
		}
		adoptQiduiziHele()
		{
			return (this.yakuData.qiduizi.adopt 
			|| this.settings.adoptQiduizi);
		}
		adoptGuoshiHele()
		{
			return (this.yakuData.guoshiwushuang.adopt 
				|| this.yakuData.chunzhengGuoshi.adopt);
		}
		setPrevScene(prevScene)
		{
			this._prevScene = prevScene;
		}
		prevScene()
		{
			return this._prevScene;
		}
		
		clearPrevScene()
		{
			this._prevScene = null;
		}
		
		
		pushTerminationFunc(func)
		{
			this._terminationFunc.push(func);
		}
		
		executeTerminationFunc(abstention)
		{
			while(this._terminationFunc.length > 0)
			{
				const func = this._terminationFunc.shift();
				func(abstention);
			}
		}
		actorData(actorId)
		{
			if(!actorId)
			{
				return null;
			}
			if($gameActors._data[actorId] || $dataMajiangSystem.params.actorInstantiation)
			{
				return $gameActors.actor(actorId);
			}
			if(!this._tempActorData[actorId])
			{
				this._tempActorData[actorId] = new Game_Actor(actorId);
			}
			return this._tempActorData[actorId];
		}
		clearTempActorData()
		{
			this._tempActorData = [];
		}
		setupShuzi()
		{
			const shuzi = new Shuzi();
			
			const text = $dataMajiangSystem.text;
			const shuziHanzi = [];
			for(let i = 0; i < 10; i++)
			{
				shuziHanzi.push(text["shuzi_" + i]);
			}
			shuzi.setShuzi(shuziHanzi);
			shuzi.setRadix(text.shuzi_mille,text.shuzi_centum,text.shuzi_decem)
			
			const keta = ["" ,
				text.shuzi_wan,
				text.shuzi_yi,
				text.shuzi_zhao,
				"京","垓","𥝱","穣","溝","澗","正","載","極","恒河沙","阿僧祇","那由他","不可思議","無量大数"
			];
			
			shuzi.setKeta(keta);
			
			this._shuzi = shuzi;
		}
	}
	
	
	
	class Shuzi
	{	
		setShuzi(shuziArray)
		{
			this._shuzi = shuziArray;
		}
		setRadix(mille,centum,decem)
		{
			this._radix = {mille,centum,decem};
		}
		
		setKeta(keta)
		{
			this._keta = keta;
		}
		output(value)
		{
			if(value === 0 || !["number","bigint","string"].includes(typeof value))
			{
				return this._shuzi[0];
			}
			if(value > Number.MAX_SAFE_INTEGER)
			{
				value = BigInt(value);
			}
			
			
			const stValue = value + "";
			const stValueAr = stValue.split("");
			const stVLen = (4 - (stValueAr.length % 4))  % 4;
			
			for(let i = 0; i <  stVLen ;i++)
			{
				stValueAr.unshift("0");
			}
			const milleAr = [];
			while(stValueAr.length)
			{
				milleAr.push(stValueAr.splice(0,4));
			}
			
			
			const milleVAr = milleAr.map(c => this.milleValue(c)) ;
			
			
			return this.manValue(milleVAr);
		}
		manValue(milleVAr)
		{
			const keta = this._keta;
			const ketaLength = milleVAr.length;
			let ret = "";
			
			milleVAr.forEach(function(mille,ketaIndex)
			{
				let milRet = "";
				for(let i = 0; i < 4 ; i ++)
				{
					milRet += mille[i];
				}
				if(milRet !== "")
				{
					ret += milRet + keta[ketaLength - ketaIndex - 1];
				}
			},this);
			return ret;
		}
		milleValue(valAry)
		{
			return valAry.map(function(sv,i)
			{
				const v = Number(sv);
				let ret = "";
				if(v > 1 || (i === 3 && v > 0))
				{
					ret += this._shuzi[v]; 
				}
				
				if(v > 0 && i !== 3)
				{
					ret += this._radix[["mille","centum","decem"][i]];
				}
				return ret;
				
			},this);
		}
	}
	
	
	
	$gameMajiangSystem = new Game_MajiangSystem();
	
	
	
	
	PluginManager.registerCommand(P_name,"startMajiang",args =>  
	{
		
		const battlers = $gameMajiangSystem.parseBattlers(args);
		if($gameMajiangSystem.gotError())
		{
			$gameMajiangSystem.echoError();
			return ;
		}
		
		const randomPosition = (args.randomPosition === "true");
		
		const dealerPosition = Number(args.dealerPosition);
		
		const match = Number(args.match);
		
		const abstention = (args.abstention === "true");
		
		$gameMajiangSystem.start();
		
		$gameMajiangSystem.setCondition(...battlers,randomPosition,dealerPosition,match,abstention);
		
		if($gameMajiangSystem.gotError())
		{
			$gameMajiangSystem.echoError();
		}
		else
		{
			MajiangManager.start();
			SceneManager.push(Scene_MajiangBattle);
		}
	});
	
	PluginManager.registerCommand(P_name,"options",args =>  
	{
		SceneManager.push(Scene_MajiangOptions);
	});
	
	
	PluginManager.registerCommand(P_name,"setYakuData",args =>  
	{
		const name = args.name;
		const data = PF_parseYakuData(args.data,name);
		MajiangSystemManager.data("yakuData")[name] = data;
	});
	
	PluginManager.registerCommand(P_name,"clearYakuData",args =>  
	{
		MajiangSystemManager.clear("yakuData");
	});
	
	
	
	PluginManager.registerCommand(P_name,"setGamerule",args =>  
	{
		const oldCommand = (!args.subject);
		if(oldCommand)
		{
			MajiangSystemManager.setData("gamerule",PF_parseObject(args.gamerule));
			return ;
		}
		const subjectData = args.subject.split("_");
		const subject = subjectData[0];
		const valueType = subjectData[1];
		
		if(args.clear === "true")
		{
			MajiangSystemManager.data("gamerule")("gamerule")[subject] = void 0;
			MajiangSystemManager.data("gamerule")("tempGamerule")[subject] = void 0;
			return ;
		}
		const value = args["value_" + valueType];
		const key = (value >= 20) ? "tempGamerule" : "gamerule";
		MajiangSystemManager.data(key)[subject] = value;
	});
	
	PluginManager.registerCommand(P_name,"clearGamerule",args =>  
	{
		const subject = Number(args.subject)
		
		if(subject === 1)
		{
			MajiangSystemManager.clear("gamerule");
		}
		else if (subject === 2)
		{
			
			MajiangSystemManager.clear("tempGamerule");
		}
		else
		{
			MajiangSystemManager.clear("gamerule");
			MajiangSystemManager.clear("tempGamerule");
		}
	});
	
	
	PluginManager.registerCommand(P_name,"setScoreSettings",args =>  
	{
		MajiangSystemManager.setData("scoreSettings",PF_parseObject(args.scoreSettings));
	});
	
	PluginManager.registerCommand(P_name,"clearScoreSettings",args =>  
	{
		MajiangSystemManager.clear("scoreSettings");
	});
	
	PluginManager.registerCommand(P_name,"setScoreSettingsSamma",args =>  
	{
		MajiangSystemManager.setData("scoreSettingsSamma",PF_parseObject(args.scoreSettingsSamma));
	});
	
	PluginManager.registerCommand(P_name,"clearScoreSettingsSamma",args =>  
	{
		MajiangSystemManager.clear("scoreSettingsSamma");
	});
	
	PluginManager.registerCommand(P_name,"setDuoSettings",args =>  
	{
		MajiangSystemManager.setData("duoSettings",PF_parseObject(args.duoSettings));
	});
	
	PluginManager.registerCommand(P_name,"clearDuoSettings",args =>  
	{
		MajiangSystemManager.clear("duoSettings");
	});
	
	PluginManager.registerCommand(P_name,"setSettings",args =>  
	{
		MajiangSystemManager.setData("settings",PF_parseObject(args.settings));
	});
	
	PluginManager.registerCommand(P_name,"clearSettings",args =>  
	{
		MajiangSystemManager.clear("settings");
	});
	
	
	
	PluginManager.registerCommand(P_name,"setAudioData",args =>  
	{
		const subject = args.subject;
		const kind = $dataMajiangSystem.audioData[subject].kind;
		
		const data = (args.clear === "true") ? void 0 : PF_parseAudio(args[kind]);
		MajiangSystemManager.data("audioData")[subject] = data;
		
	});
	
	PluginManager.registerCommand(P_name,"clearAudioData",args =>  
	{
		MajiangSystemManager.clear("audioData");
	});
	
	
	
	PluginManager.registerCommand(P_name,"setImgData",args =>  
	{
		MajiangSystemManager.setData("imgData",JSON.parse(args.imgData || "{}"));
		$gameMajiangSystem.loadMajiangPai();
	});
	
	PluginManager.registerCommand(P_name,"clearImgData",args =>  
	{
		MajiangSystemManager.clear("imgData");
	});
	
	PluginManager.registerCommand(P_name,"clearHeleCount",args =>  
	{
		$gameMajiangSystem.clearYakuResultVariable();
	});
	
	PluginManager.registerCommand(P_name,"pushStack",args =>  
	{
		$gameMajiangSystem.pushStack(args);
	});
	
	PluginManager.registerCommand(P_name,"clearStack",args =>  
	{
		$gameMajiangSystem.clearStack();
	});
	
	PluginManager.registerCommand(P_name,"debug",args =>  
	{
		
		$dataMajiangSystem.temp.echoConsole = JSON.parse(args.echoConsole || "[]").map(v => Number(v));
		
		$dataMajiangSystem.temp.entrust = (args.entrust === "true");
		$dataMajiangSystem.temp.tehaiOpen = (args.tehaiOpen === "true");
		
		
	});
	
	
	

})();









