//=============================================================================
// 第1版 - 初版
// 第2版 - 麻雀牌画像の呼び出し先を変更
// 第7版 - 麻雀イベント用に牌レイヤーの処理を改変
// 第8版 - 牌列描画処理に最大行数の設定を追加
//          麻雀牌スプライトの表示方式を変更
// 第9版2刷 - ドラ牌の強調表示処理を変更
// 第11版 - 背景画像を中央に配置するように変更
// 
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 麻雀 (スプライト)
 * @author 
 * @base AP1S_MajiangCore
 * @orderAfter AP1S_MajiangCore
 *
 * @help
 * 
 * ミニゲーム 麻雀
 * 
 * 詳細な使用方法は 同梱の説明書をご覧ください
 * 
 * 
 */



function Sprite_MajiangPai() 
{
   	this.initialize(...arguments);
}
	
Sprite_MajiangPai.prototype = Object.create(Sprite.prototype);
Sprite_MajiangPai.prototype.constructor = Sprite_MajiangPai;

function Sprite_MajiangPai() 
{
   	this.initialize(...arguments);
}
	
Sprite_MajiangLizhibo.prototype = Object.create(Sprite.prototype);
Sprite_MajiangLizhibo.prototype.constructor = Sprite_MajiangLizhibo;

function Sprite_MajiangLizhibo() 
{
   	this.initialize(...arguments);
}


function Spriteset_MajiangPaizi() 
{
   	this.initialize(...arguments);
}
	
Spriteset_MajiangPaizi.prototype = Object.create(Sprite.prototype);
Spriteset_MajiangPaizi.prototype.constructor = Spriteset_MajiangPaizi;


function Spriteset_MajiangPaiLayer() 
{
   	this.initialize(...arguments);
}
	
Spriteset_MajiangPaiLayer.prototype = Object.create(Spriteset_Base.prototype);
Spriteset_MajiangPaiLayer.prototype.constructor = Spriteset_MajiangPaiLayer;




(function() 
{
	"use strict";
	
	
	
	
	
	
	Sprite_MajiangPai.prototype.initialize = function(pai,x,y,direction,paiHeight) 
	{
    	Sprite.prototype.initialize.call(this);
    	//this.initMembers();
    	this._pai = pai;
    	this.loadBitmap();
    	this.setup(pai,x,y,direction,paiHeight);
    	this._selectionEffectCount = 0;
    	
    	this._animationSprites = [];
    	
    	
	};	
	
	
	
		
	
	Sprite_MajiangPai.prototype.destroy = function() 
	{
    	Sprite.prototype.destroy.call(this);
    	
	};
	
	Sprite_MajiangPai.prototype.update = function() 
	{
		Sprite.prototype.update.call(this);
    	if (this._pai)
    	{
    		if(this._pai.requestResetSelectionEffect())
    		{
    			this.resetBlendColor();
    			this._selectionEffectCount = 0;
    			this._pai.setRequestResetSelectionEffect(false);
	    	}
    	    this.updateSelectionEffect();
    	    
    	}
    	else
    	{
    	    this.bitmap = null;
    	}
	};
		
	
	
	
	
	
	Sprite_MajiangPai.prototype.loadBitmap = function() 
	{
	    this.bitmap = $gameMajiangSystem.loadMajiangPai();
	};
	
	Sprite_MajiangPai.prototype.setup = function(pai,x,y,direction,paiHeight)
	{
		this.anchor.x = 0.5;
		this.anchor.y = 0.5;
		switch(direction)
		{
			case 2 : 
				this.rotation += (180 * (Math.PI / 180));
			break;
			case 1 : 
				this.rotation += (270 * (Math.PI / 180));
			break;
			case 3 : 
				this.rotation += (90 * (Math.PI / 180));
			break;
		}
		//this.anchor.x = 1;
		
		const pw = $dataMajiangSystem.imagePaiWidth;
    	const ph = $dataMajiangSystem.imagePaiHeight;
    	const sxsy = this.calcSxsy(pai);
    	const sx = sxsy[0] * pw;
    	const sy = sxsy[1] * ph;
    	
    	this.setFrame(sx,sy,pw,ph);
    	this.x = x;
    	this.y = y;
    	
    	const dw = paiHeight * 0.75; //(xiao) ? $dataMajiangSystem.tajiaPaiWidth : $dataMajiangSystem.paiWidth;
    	const dh = paiHeight //(xiao) ? $dataMajiangSystem.tajiaPaiHeight : $dataMajiangSystem.paiHeight;
    	this.scale.x = dw / pw;
    	this.scale.y = dh / ph;
    	
    	
    	if(pai.horizontal())
		{
    		const rotationValue = (pai.horizontal() === "right") ? 90 : 270;
    		
    		this.rotation += (rotationValue * (Math.PI / 180));
	    }
		
	    this.visible = pai.visible();
		
	    this.resetBlendColor();
	};
	
	Sprite_MajiangPai.prototype.calcSxsy = function(pai) 
	{
    	
    	if(pai.isHidden())
    	{
    		return [7,3];
    	}
    	else if (pai.isTajiaHidden())
    	{
    		return [8,3];
	    }
    	else
    	{
    		const value = pai.isAkadora() ? 10 : pai.value();
    		return [value - 1 , pai.type()];
    	}
    	
	};
	
	Sprite_MajiangPai.prototype.baseBlendColor = function()
	{
		const pai = this._pai;
		if(pai.isEnabled())
	    {
	    	if(pai.doraEffect())
	    	{
	    		return $dataMajiangSystem.params.doraColor;
	    	}
	    	else
	    	{
	    		return [0, 0, 0, 0];
	    	}
		}
		else
		{
			return [0, 0, 0, 64];
		}
	};
	
	Sprite_MajiangPai.prototype.resetBlendColor = function() 
	{
		this.setBlendColor(this.baseBlendColor());
	};
	
	
	
	Sprite_MajiangPai.prototype.updateSelectionEffect = function() 
	{
		//this._selectionEffectCount = (this._selectionEffectCount + 1) % 60;
		
		
    	//const target = this.mainSprite();
    	if (this._pai.isSelected())
    	{
    		this._selectionEffectCount++;
        	const count = this._selectionEffectCount;
        	if (count % 30 < 15) 
        	{
        	    this.setBlendColor([255, 255, 255, 192]);
        	}
        	else 
        	{
        		
        	    this.resetBlendColor();
        	}
    	} 
    	else if (this._selectionEffectCount > 0) 
    	{
    		this._selectionEffectCount = 0;
			this.resetBlendColor();
    	    
    	}
    	
	};
	
	Sprite_MajiangPai.prototype.checkCharacter = function(pai) 
	{
	    return (this._pai === pai)
	};
		
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//------------------------------
	
	Sprite_MajiangLizhibo.prototype.initialize = function(x,y,position) 
	{
    	Sprite.prototype.initialize.call(this);
    	this._position = position;
    	this.loadBitmap();
    	this.visible = false;
    	this.setup(x,y,position);
    	
    	
	};	
	
	Sprite_MajiangLizhibo.prototype.loadBitmap = function() 
	{
	    this.bitmap = $gameMajiangSystem.loadMajiangPai();
	};
	
	Sprite_MajiangLizhibo.prototype.setup = function(x,y,direction) 
	{
	
		this.anchor.x = 0.5;
		this.anchor.y = 0.5;
		
		switch(direction)
		{
			case 2 : 
				this.rotation += (180 * (Math.PI / 180));
			break;
			case 1 : 
				this.rotation += (270 * (Math.PI / 180));
			break;
			case 3 : 
				this.rotation += (90 * (Math.PI / 180));
			break;
		}
		const pw = $dataMajiangSystem.imagePaiWidth * 4;
    	const ph = $dataMajiangSystem.imagePaiWidth / 2;
    	const sx = 0;
    	const sy = $dataMajiangSystem.imagePaiHeight * 4;
			
		this.setFrame(sx,sy,pw,ph);
    	this.x = x;
    	this.y = y;
    	
    	const dw =  $dataMajiangSystem.lizhiboWidth;
    	const dh =  $dataMajiangSystem.lizhiboHeight;
    	this.scale.x = dw / pw;
    	this.scale.y = dh / ph;
    	
	
	};
	
	Sprite_MajiangLizhibo.prototype.setVisible = function()
	{
		this.visible = ($gameMajiangBattlers.battler(this._position).isLizhi());
		
	};
	
	
	//------------------------------
	
	
	Spriteset_MajiangPaizi.prototype.initialize = function(rect,direction = 0 , paiHeight) 
	{
		//Spriteset_Base.prototype.initialize.call(this);
		Sprite.prototype.initialize.call(this);
		this.createBaseSprite();
    	
    	
    	
    	this._rect = rect;
    	
    	this._paiHeight = paiHeight || $dataMajiangSystem.tajiaPaiHeight ;
    	this._paiWidth = this._paiHeight * 0.75 ;
		
    	
		//this.createBackground();
		this._maxCols = Infinity;
		
		this._baseSprite.x = rect.x;
    	this._baseSprite.y = rect.y;
    	this._baseSprite.width = rect.width;
    	this._baseSprite.heith = rect.height;
    	
    	//this.createEffectsContainer();
    	
    	//this._baseSprite.bitmap = ImageManager.loadSystem("GameOver");
    	//this._baseSprite.setFrame(rect.x,rect.y,rect.width,rect.height);
    	
    	
		this._direction = direction;
		this._paiArea = [];
    	this._paiSprites = [];
	};
	
	Spriteset_MajiangPaizi.prototype.createBaseSprite = function()
	{
		this._baseSprite = new Sprite();
    	/*this._blackScreen = new ScreenSprite();
    	this._blackScreen.opacity = 255;*/
    	this.addChild(this._baseSprite);
    	//this._baseSprite.addChild(this._blackScreen);
	};
	/*
	Spriteset_MajiangPaizi.prototype.loadSystemImages = function() 
	{
    	Spriteset_Base.prototype.loadSystemImages.call(this);
    	ImageManager.loadSystem($gameMajiangSystem.imgData.majiangpai);
	};
	*/
	Spriteset_MajiangPaizi.prototype.clear = function() 
	{
		
	};
	
	Spriteset_MajiangPaizi.prototype.setMaxCols = function(maxCols)
	{
		this._maxCols = maxCols;
	};
	Spriteset_MajiangPaizi.prototype.setMaxRows = function(maxRows)
	{
		this._maxRows = maxRows;
	};
	
	Spriteset_MajiangPaizi.prototype.destroy = function()
	{
		Sprite.prototype.destroy.apply(this,arguments);
	};
	
	Spriteset_MajiangPaizi.prototype.destroyPaizi = function()
	{
		
		for(const sprite of this._paiSprites)
    	{
    		this._baseSprite.removeChild(sprite);
    		sprite.destroy();
    	}
    	this._paiSprites = [];
	};
	
	
	
	Spriteset_MajiangPaizi.prototype.refresh = function() 
	{
		this.destroyPaizi();
		
		this.drawAllPai();
	};
	
	Spriteset_MajiangPaizi.prototype.createBackground = function() 
	{
    	
    
	};
	
	Spriteset_MajiangPaizi.prototype.paizi = function() 
	{
    	return this._paiSprites;
    
	};
	
	
	
	Spriteset_MajiangPaizi.prototype.drawPai = function(pai,x,y ,direction) 
	{
		
		const paiSprite = new Sprite_MajiangPai(pai,x,y,direction,this._paiHeight);
		
		this._paiSprites.push(paiSprite);
		
		this._baseSprite.addChild(paiSprite);
	};
	
	Spriteset_MajiangPaizi.prototype.createJiangPaiState = function()
	{
		const jiangPaiState = {};
		const dx = this._paiWidth / 2;
		const dy = this._paiHeight / 2;
		jiangPaiState.col = 0;
		jiangPaiState.row = 1;
		jiangPaiState.x = dx;
		jiangPaiState.y = dy;
		
		jiangPaiState.startX = dx;
		jiangPaiState.startY = dy;
		
		return jiangPaiState;
	};
	
	Spriteset_MajiangPaizi.prototype.flushJiangPaiState = function(jiangPaiState,horizontal,maxCols,maxRows)
	{
		
		
		jiangPaiState.x += horizontal ? this._paiHeight : this._paiWidth;
		
		jiangPaiState.col++;
		const col = jiangPaiState.col;
		const row = jiangPaiState.row;
		if(col >= maxCols && row < maxRows)
		{
			jiangPaiState.y += this._paiHeight;
			jiangPaiState.x = jiangPaiState.startX;
			jiangPaiState.col = 0;
			jiangPaiState.row++;
		}
	};
	
	Spriteset_MajiangPaizi.prototype.realState = function(jx,jy,x,y,width,height,direction)
	{
		let rx = 0;
		let ry = 0;
		switch(direction)
		{
			case 2 : 
				rx = width - jx;
				ry = height - jy;
			break;
			case 1 : 
				rx = jy;
				ry = height - jx ;
			break;
			case 3 : 
				rx = (width - jy);
				ry = jx ;
			break;
			default : 
				rx = jx;
				ry = jy
			break;
		}
		return {"x" :x + rx , "y": y + ry};
	};
	
	Spriteset_MajiangPaizi.prototype.createNewPaizi = function (x,y,paizi,maxCols = Infinity,maxRows = Infinity)
	{
		
		const width = this._rect.width;
		const height = this._rect.height;
		
		this._paiArea.push({"x" : x , "y": y , "width" : width , "height" : height, "paizi" : paizi , "maxCols" : maxCols , "maxRows" : maxRows});
		//this.refresh();
	};
	
	Spriteset_MajiangPaizi.prototype.drawAllPai = function()
	{
		for(const paiState of this._paiArea)
		{
			const jiangPaiState = this.createJiangPaiState(paiState.x,paiState.y);
			
			
			for(const pai of paiState.paizi)
			{
				let jx = jiangPaiState.x;
				let jy = jiangPaiState.y;
				const horizontal = pai.horizontal();
				
				const position = pai.position();
				if(horizontal)
				{
					const horizontalOffset = (this._paiHeight - this._paiWidth ) / 2;
					jx += horizontalOffset;
					
					if(position !== "lizhi")
					{
						jy += (position === "jiagangTop") ? -horizontalOffset * 5 : horizontalOffset; 
					}
				}
				else if(pai.needSpacing())
				{
					jx += this.paiSpacing();
				}
				const direction = this._direction;
				const realState = this.realState(jx,jy,paiState.x , paiState.y , paiState.width, paiState.height,direction);
				this.drawPai(pai,realState.x , realState.y, direction);
				if(position !== "jiagangBottom")
				{
					this.flushJiangPaiState(jiangPaiState,horizontal,paiState.maxCols,paiState.maxRows);
				}
			}
		}
	};
	Spriteset_MajiangPaizi.prototype.addPaizi = function (paizi)
	{
		const maxCols = this._maxCols;
		const maxRows = this._maxRows;
		this._paiArea = [];
		this.createNewPaizi(0,0,paizi,maxCols,maxRows);
		this.refresh();
	};
	
	Spriteset_MajiangPaizi.prototype.addFulu = function(fuluArray)
	{
		this.createFuluState(fuluArray);
		
		this.refresh();
	};
	
	Spriteset_MajiangPaizi.prototype.echoTehai = function(tehai,fuluArray)
	{
		
		
		const y = this.calcY();
		
		this.createNewPaizi(0,y,tehai,14);
		
		
		
		let x = (tehai.length) * this._paiWidth;
		
		x += (this.paiSpacing() * 2);
		
		
		
		const fuluArray2 = [...fuluArray].reverse();
		
		for(const fulu of fuluArray2)
		{
			
			
			const realState = this.realState(x,y ,0,0, 0, 0,this._direction);
			
			const paizi = fulu.echoFulu();
			
			
			this.createNewPaizi(realState.x,realState.y,paizi,4);
			
			x+= this.calcWidth(fulu);
			
			x+= this.paiSpacing();
		}
		
		this.refresh();
		
	};
	
	
	
	Spriteset_MajiangPaizi.prototype.paiSpacing = function()
	{
		return $dataMajiangSystem.paiSpacing;
	};
	Spriteset_MajiangPaizi.prototype.calcWidth = function(fulu)
	{
		const paiW = this._paiWidth;
		const paiH = this._paiHeight;
		const fuluType = fulu.fuluType()
		if(fuluType === "angang")
		{
			return paiW * 4
		}
		else
		{
			const hs = (fuluType == "daminggang") ? 3 : 2;
			
			return (paiW * hs) + paiH;
		}
	}
	Spriteset_MajiangPaizi.prototype.calcY = function(fulu)
	{
		const paiW = this._paiWidth;
		const paiH = this._paiHeight;
		
		return (paiW * 2) - paiH;
		
	}
	
	Spriteset_MajiangPaizi.prototype.createFuluState = function(fuluArray)
	{
		let x = ([1,3].includes(this._direction)) ? this._rect.height : this._rect.width;
		
		const y = this.calcY();
		for(const fulu of fuluArray)
		{
			const fuluWidth = this.calcWidth(fulu);
			x -= fuluWidth;
			const realState = this.realState(x,y ,0,0, 0, 0,this._direction);
			
			const paizi = fulu.echoFulu();
			
			
			this.createNewPaizi(realState.x,realState.y,paizi,4);
			
			x-= this.paiSpacing();
		}
	};
		
	
	
	
	
	
	
	//------------------------------
	
	
	
	
	Spriteset_MajiangPaiLayer.prototype.initialize = function() 
	{
		Spriteset_Base.prototype.initialize.call(this);
		
		//Sprite.prototype.initialize.call(this);
		this.x = 0;
		this.y = 0;
		this.setFrame(0, 0, Graphics.width, Graphics.height);
		//this._animationSprites = [];
		this._paiziSprites = [];
		
    	
    	//this.createPictures();
		//this.createBackground();
	};
	
	Spriteset_MajiangPaiLayer.prototype.createBattleField = function() 
	{
    	const width = Graphics.boxWidth;
    	const height = Graphics.boxHeight;
    	const x = (Graphics.width - width) / 2;
    	const y = (Graphics.height - height) / 2;
    	this._battleField = new Sprite();
    	this._battleField.setFrame(0, 0, width, height);
    	this._battleField.x = x;
    	this._battleField.y = y;
    	this._baseSprite.addChild(this._battleField);
    	this._effectsContainer = this._battleField;
	};
	
	Spriteset_MajiangPaiLayer.prototype.createLowerLayer = function() 
	{
   		Spriteset_Base.prototype.createLowerLayer.call(this);
   		
    	this.createBackground();
    	this.createBattleField();
	};
	
	Spriteset_MajiangPaiLayer.prototype.createBackground = function() 
	{
		this._backgroundSprite = new Sprite();
		const backgroundImg = $gameMajiangSystem.imgData.majiangBackground;
		if(backgroundImg)
		{
			this._backgroundSprite.bitmap = ImageManager.loadPicture(backgroundImg);
			this._backgroundSprite.x = Graphics.width / 2;
			this._backgroundSprite.y = Graphics.height / 2;
			this._backgroundSprite.anchor.x = 0.5;
			this._backgroundSprite.anchor.y = 0.5;
		}
		else
		{
			this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
			const filterSetting = $dataMajiangSystem.params.backGroundFilter;
			if(filterSetting !== 0)
			{
				if(filterSetting == 2)
				{
					this._backgroundFilter = new PIXI.filters.BlurFilter();
    				this._backgroundSprite.filters = [this._backgroundFilter];
    			}
    			this._backgroundSprite.opacity = 192;
    		}
		}
		this._baseSprite.addChild(this._backgroundSprite);
	};
	
	
	
	Spriteset_MajiangPaiLayer.prototype.addSprite = function(sprite) 
	{
		this._battleField.addChild(sprite);
		if(sprite.paizi)
		{
			this._paiziSprites.push(sprite);
		}
	};
	
	Spriteset_MajiangPaiLayer.prototype.isBusy = function() 
	{
    	return this.isAnimationPlaying() ;
	};
		
	Spriteset_MajiangPaiLayer.prototype.findTargetSprite = function(target)
	{
		for(const sprite of this._paiziSprites)
		{
			const pai = sprite.paizi().find( p => p.checkCharacter(target));
			if(pai)
			{
				return pai;
			}
		}
	};
			
	Spriteset_MajiangPaiLayer.prototype.update = function() 
	{
    	Sprite.prototype.update.call(this);
    	this.updateBaseFilters();
    	this.updateOverallFilters();
    	//this.updatePosition();
    	this.updateAnimations();
	};

	
	
	
	
	

})();









