// SwapAB.js Ver.1.0.0
// MIT License (C) 2023 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ
* @plugindesc AボタンとBボタンの役割を入れ替えるオプションを導入します。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/500069497.html
* @help 
* [更新履歴]
* 2023/07/18：Ver.1.0.0　公開。
*
* @param optionName
* @text オプション名
* @default ABボタン入れ替え
*
* @param defaultValue
* @text 初期値
* @type boolean
* @default false
*
*/

'use strict';
{
	const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
	const parameters = PluginManager.parameters(pluginName);
	const defaultValue = parameters.defaultValue === "true"
	const ok = "ok";
	const cancel = "cancel";

	//-----------------------------------------------------------------------------
	// ConfigManager

	ConfigManager.swapAB = defaultValue;

	const _ConfigManager_makeData = ConfigManager.makeData;
	ConfigManager.makeData = function() {
		const config = _ConfigManager_makeData.call(this);
		config.swapAB = this.swapAB;
		return config;
	};

	const _ConfigManager_applyData = ConfigManager.applyData;
	ConfigManager.applyData = function(config) {
		_ConfigManager_applyData.call(this, config);
		this.swapAB = this.readFlag(config, "swapAB", defaultValue);
	};

	//-----------------------------------------------------------------------------
	// Input

	Input.swapAB = function() {
		const mapper = this.gamepadMapper;
		const preState = this._previousState;
		const curState = this._currentState;
		const index1 = findButtonId(ok);
		const index2 = findButtonId(cancel);
		if ([index1, index2].every(id => id > -1)) {
			[mapper[index1], mapper[index2]] = [mapper[index2], mapper[index1]];
			[preState[ok], preState[cancel]] = [preState[cancel], preState[ok]];
			[curState[ok], curState[cancel]] = [curState[cancel], curState[ok]];
		}
	};
	
	function findButtonId(symbol) {
		const mapper = Input.gamepadMapper;
		for (const id in mapper) {
			if (mapper[id] === symbol) {
				return id;
			}
		}
		return -1
	};

	//-----------------------------------------------------------------------------
	// Scene_Boot

	const _Scene_Boot_start = Scene_Boot.prototype.start;
	Scene_Boot.prototype.start = function() {
		_Scene_Boot_start.call(this);
		if (ConfigManager.swapAB) {
			Input.swapAB();
		}
	};

	//-----------------------------------------------------------------------------
	// Scene_Options

	const _Scene_Options_initialize = Scene_Options.prototype.initialize;
	Scene_Options.prototype.initialize = function() {
		_Scene_Options_initialize.call(this);
		this._swapAB = ConfigManager.swapAB;
	};

	const _Scene_Options_maxCommands = Scene_Options.prototype.maxCommands;
	Scene_Options.prototype.maxCommands = function() {
		return _Scene_Options_maxCommands.call(this) + 1;
	};

	const _Scene_Options_terminate = Scene_Options.prototype.terminate;
	Scene_Options.prototype.terminate = function() {
		_Scene_Options_terminate.call(this);
		if (this._swapAB !== ConfigManager.swapAB) {
			Input.swapAB();
		}
	};

	//-----------------------------------------------------------------------------
	// Window_Options

	const _Window_Options_addGeneralOptions = Window_Options.prototype.addGeneralOptions;
	Window_Options.prototype.addGeneralOptions = function() {
		_Window_Options_addGeneralOptions.call(this);
		this.addCommand(parameters.optionName, "swapAB");
	};
}