declare var $dataActors: RMMZData.Actor[];
declare var $dataClasses: RMMZData.Class[];
declare var $dataSkills: RMMZData.Item[];
declare var $dataItems: RMMZData.Item[];
declare var $dataWeapons: RMMZData.Weapon[];
declare var $dataArmors: RMMZData.Armor[];
declare var $dataEnemies: RMMZData.Enemy[];
declare var $dataTroops: RMMZData.Troop[];
declare var $dataStates: RMMZData.State[];
declare var $dataAnimations: RMMZData.Animation[];
declare var $dataTilesets: RMMZData.Tileset[];
declare var $dataCommonEvents: RMMZData.CommonEvent[];
declare var $dataSystem: RMMZData.System;
declare var $dataMapInfos: RMMZData.MapInfo;
declare var $dataMap: RMMZData.Map;
declare var $gameTemp: Game_Temp;
declare var $gameSystem: Game_System;
declare var $gameScreen: Game_Screen;
declare var $gameTimer: Game_Timer;
declare var $gameMessage: Game_Message;
declare var $gameSwitches: Game_Switches;
declare var $gameVariables: Game_Variables;
declare var $gameSelfSwitches: Game_SelfSwitches;
declare var $gameActors: Game_Actors;
declare var $gameParty: Game_Party;
declare var $gameTroop: Game_Troop;
declare var $gameMap: Game_Map;
declare var $gamePlayer: Game_Player;
declare var $testEvent: RMMZData.EventCommand[] | null;
declare class DataManager {
    constructor();
    static _globalInfo: ISaveInfo[] | null;
    static _errors: any[];
    static _databaseFiles: {
        name: string;
        src: string;
    }[];
    static loadGlobalInfo(): void;
    static removeInvalidGlobalInfo(): void;
    static saveGlobalInfo(): void;
    static isGlobalInfoLoaded(): boolean;
    static loadDatabase(): void;
    static loadDataFile(name: string, src: string): void;
    static onXhrLoad(xhr: XMLHttpRequest, name: string | number, src: any, url: string): void;
    static onXhrError(name: any, src: any, url: string): void;
    static isDatabaseLoaded(): boolean;
    static loadMapData(mapId: string | number): void;
    static makeEmptyMap(): void;
    static isMapLoaded(): boolean;
    static onLoad(object: any): void;
    static isMapObject(object: any): boolean;
    static extractArrayMetadata(array: ({
        note: string;
        meta?: MetaDataType;
    })[]): void;
    static extractMetadata(data: {
        note: string;
        meta?: MetaDataType;
    }): void;
    static checkError(): void;
    static isBattleTest(): any;
    static isEventTest(): any;
    static isSkill(item: ItemObject | null): boolean | null;
    static isItem(item: ItemObject | null): boolean | null;
    static isWeapon(item: ItemObject | null): boolean | null;
    static isArmor(item: ItemObject | null): boolean | null;
    static createGameObjects(): void;
    static setupNewGame(): void;
    static setupBattleTest(): void;
    static setupEventTest(): void;
    static isAnySavefileExists(): boolean;
    static latestSavefileId(): number;
    static earliestSavefileId(): number;
    static emptySavefileId(): number;
    static loadAllSavefileImages(): void;
    static loadSavefileImages(info: any): void;
    static maxSavefiles(): number;
    static savefileInfo(savefileId: number): ISaveInfo | null;
    static savefileExists(savefileId: number): any;
    static saveGame(savefileId: number): Promise<number>;
    static loadGame(savefileId: number): Promise<number>;
    static makeSavename(savefileId: number): string;
    static selectSavefileForNewGame(): void;
    static makeSavefileInfo(): any;
    static makeSaveContents(): any;
    static extractSaveContents(contents: any): void;
    static correctDataErrors(): void;
}
interface ISaveInfo {
    characters: [string, number][];
    playtime: number;
}
